/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data.sort;

import com.sas.graphics.data.sort.SortChangeEvent;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.data.sort.SortContextListener;
import javax.swing.event.EventListenerList;

public class MutableSortContext
extends SortContext {
    private EventListenerList listeners = new EventListenerList();

    MutableSortContext(Object model, String[] sortVariables, int order) {
        super(model);
        this.setSort(order, sortVariables);
    }

    public void addSortContextListener(SortContextListener scl) {
        this.listeners.add(SortContextListener.class, scl);
    }

    public void removeSortContextListener(SortContextListener scl) {
        this.listeners.remove(SortContextListener.class, scl);
    }

    private void fireSortChangedEvent(SortChangeEvent sce) {
        SortContextListener[] arr = (SortContextListener[])this.listeners.getListeners(SortContextListener.class);
        if (arr == null) {
            return;
        }
        for (int i = 0; i < arr.length; ++i) {
            arr[i].sortChanged(sce);
        }
    }

    public boolean setSortOrder(int order) {
        if (order == this.sortDirection) {
            return true;
        }
        boolean rc = this.setSort(order, this.variables);
        this.fireSortChangedEvent(new SortChangeEvent(this));
        return rc;
    }

    public boolean setSortVariable(String sortVar) {
        return this.setSortVariables(new String[]{sortVar});
    }

    public boolean setSortVariables(String[] sortVars) {
        boolean rc = this.setSort(this.sortDirection, sortVars);
        this.fireSortChangedEvent(new SortChangeEvent(this));
        return rc;
    }

    public boolean setSort(int order, String var) {
        return this.setSort(order, new String[]{var});
    }
}

