/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data.sort;

import com.sas.graphics.data.sort.SortContext;
import java.util.Enumeration;
import java.util.Hashtable;

class ContextStoreNode {
    Object data = null;
    SortContext ascending = null;
    SortContext descending = null;
    SortContext dataOrder = null;
    Hashtable children = null;

    public ContextStoreNode(Object data) {
        this.data = data;
    }

    public void dispose() {
        if (this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                ContextStoreNode object = (ContextStoreNode)e.nextElement();
                object.dispose();
            }
            this.children.clear();
            this.children = null;
        }
        if (this.ascending != null) {
            this.ascending.dispose();
        }
        this.ascending = null;
        if (this.descending != null) {
            this.descending.dispose();
        }
        this.descending = null;
        if (this.dataOrder != null) {
            this.dataOrder.dispose();
        }
        this.dataOrder = null;
    }

    public ContextStoreNode getChild(Object data) {
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if (this.children.containsKey(data)) {
            return (ContextStoreNode)this.children.get(data);
        }
        ContextStoreNode rc = new ContextStoreNode(data);
        this.children.put(data, rc);
        return rc;
    }

    public SortContext getSortContext(int direction) {
        SortContext rc = null;
        switch (direction) {
            case 1: {
                rc = this.ascending;
                break;
            }
            case 0: {
                rc = this.dataOrder;
                break;
            }
            case -1: {
                rc = this.descending;
            }
        }
        return rc;
    }

    public void setSortContext(int direction, SortContext sort) {
        switch (direction) {
            case 1: {
                this.ascending = sort;
                break;
            }
            case 0: {
                this.dataOrder = sort;
                break;
            }
            case -1: {
                this.descending = sort;
            }
        }
    }
}

