/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.util.RangeInfoModel;
import java.awt.Color;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Vector;

public class MovingWindowDataFilter
implements DataFilterReadInterface,
DataFilterInfoInterface,
DataFilterListenerInterface {
    private Object data = null;
    private DataFilterReadInterface dataFilter = null;
    private DataFilterInfoInterface infoFilter = null;
    private Vector<DataFilterListenerInterface> listeners = null;
    private int windowSize = 100;
    private int windowStart = 0;
    private int windowEnd = 0;
    private int numberObservations = 0;
    private RangeInfoModel rangeInfoModel = null;
    private Hashtable<Object, Object[]> uniqueValues = null;
    private int numberObsInModel = 0;
    private boolean lockWindow = false;

    @Override
    public boolean addDataFilterListener(Object listener) {
        if (listener == null) {
            return false;
        }
        if (this.listeners == null) {
            this.listeners = new Vector(5);
        }
        if (listener instanceof DataFilterListenerInterface && !this.listeners.contains(listener)) {
            this.listeners.add((DataFilterListenerInterface)listener);
        }
        return true;
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        return false;
    }

    @Override
    public boolean areSelectionsLocal() {
        return false;
    }

    @Override
    public Object getAdapter(Class type) {
        return null;
    }

    @Override
    public Object getExactVariableId(Object id) {
        if (this.dataFilter != null) {
            return this.dataFilter.getExactVariableId(id);
        }
        return null;
    }

    @Override
    public Object getFormat(Object variableId, Class returnType) {
        if (this.dataFilter != null) {
            return this.dataFilter.getFormat(variableId, returnType);
        }
        return null;
    }

    @Override
    public String getFormattedValue(Object variableId, long iobs, Object format) {
        if (this.dataFilter != null) {
            return this.dataFilter.getFormattedValue(variableId, this.mapObs(iobs), format);
        }
        return null;
    }

    @Override
    public String getFormattedValue(Object variableId, long iobs, SortContext sort, Object format) {
        if (this.dataFilter != null) {
            return this.dataFilter.getFormattedValue(variableId, this.getSortedIndex(this.mapObs(iobs), sort), format);
        }
        return null;
    }

    @Override
    public String getFormattedValue(Object variableId, Object value, Object format) {
        if (this.dataFilter != null) {
            return this.dataFilter.getFormattedValue(variableId, value, format);
        }
        return null;
    }

    @Override
    public int getNumberObservations(int idx) {
        return this.numberObservations;
    }

    @Override
    public int getNumberObservations(Object id) {
        return this.numberObservations;
    }

    @Override
    public int getNumberVariables() {
        if (this.dataFilter != null) {
            this.dataFilter.getNumberVariables();
        }
        return 0;
    }

    @Override
    public double getNumericValue(int idx, long iobs, SortContext sort) {
        if (this.dataFilter != null) {
            return this.dataFilter.getNumericValue(idx, this.getSortedIndex(this.mapObs(iobs), sort));
        }
        return 0.0;
    }

    @Override
    public double getNumericValue(int idx, long iobs) {
        if (this.dataFilter != null) {
            return this.dataFilter.getNumericValue(idx, (long)this.mapObs(iobs));
        }
        return 0.0;
    }

    @Override
    public double getNumericValue(Object variableId, long iobs, SortContext sort) {
        if (this.dataFilter != null) {
            return this.dataFilter.getNumericValue(variableId, this.getSortedIndex(this.mapObs(iobs), sort));
        }
        return 0.0;
    }

    @Override
    public double getNumericValue(Object variableId, long iobs) {
        if (this.dataFilter != null) {
            return this.dataFilter.getNumericValue(variableId, (long)this.mapObs(iobs));
        }
        return 0.0;
    }

    @Override
    public Color getObservationColor(long iobs, SortContext sort) {
        return null;
    }

    @Override
    public Color getObservationColor(long iobs) {
        return null;
    }

    @Override
    public int getObservationNumber(int index) {
        return index;
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues, SortContext sort) {
        return 0;
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues) {
        return 0;
    }

    @Override
    public Object[] getRowValues(long iobs, SortContext sort) {
        return null;
    }

    @Override
    public Object[] getRowValues(long iobs) {
        return null;
    }

    @Override
    public SelectionIterator getSelections() {
        return null;
    }

    @Override
    public Object getSource() {
        return this.data;
    }

    @Override
    public Object getSubsetList() {
        return null;
    }

    @Override
    public Object getValue(int idx, long iobs, SortContext sort) {
        if (this.dataFilter != null) {
            return this.dataFilter.getValue(idx, this.getSortedIndex(this.mapObs(iobs), sort));
        }
        return null;
    }

    @Override
    public Object getValue(int idx, long iobs) {
        if (this.dataFilter != null) {
            return this.dataFilter.getValue(idx, (long)this.mapObs(iobs));
        }
        return null;
    }

    @Override
    public Object getValue(Object variableId, long iobs, SortContext sort) {
        if (this.dataFilter != null) {
            return this.dataFilter.getValue(variableId, this.getSortedIndex(this.mapObs(iobs), sort));
        }
        return null;
    }

    @Override
    public Object getValue(Object variableId, long iobs) {
        if (this.dataFilter != null) {
            return this.dataFilter.getValue(variableId, (long)this.mapObs(iobs));
        }
        return null;
    }

    @Override
    public Class getVariableClass(int idx) {
        if (this.dataFilter != null) {
            return this.dataFilter.getVariableClass(idx);
        }
        return null;
    }

    @Override
    public Class getVariableClass(Object id) {
        if (this.dataFilter != null) {
            return this.dataFilter.getVariableClass(id);
        }
        return null;
    }

    @Override
    public Object getVariableDescription(int idx) {
        if (this.dataFilter != null) {
            return this.dataFilter.getVariableDescription(idx);
        }
        return null;
    }

    @Override
    public Object getVariableDescription(Object id) {
        if (this.dataFilter != null) {
            return this.dataFilter.getVariableDescription(id);
        }
        return null;
    }

    @Override
    public Object getVariableId(int idx) {
        if (this.dataFilter != null) {
            return this.dataFilter.getVariableId(idx);
        }
        return null;
    }

    @Override
    public int getVariableIndex(Object id) {
        if (this.dataFilter != null) {
            return this.dataFilter.getVariableIndex(id);
        }
        return 0;
    }

    @Override
    public String getWhereClause() {
        return null;
    }

    @Override
    public boolean isGraphed(long iobs, SortContext sort) {
        return this.dataFilter.isGraphed(this.getSortedIndex(this.mapObs(iobs), sort));
    }

    @Override
    public boolean isGraphed(long iobs) {
        return this.dataFilter.isGraphed(this.mapObs(iobs));
    }

    @Override
    public boolean isGraphedLocal() {
        return false;
    }

    @Override
    public boolean isIndexInCurrentSubset(int index) {
        return false;
    }

    @Override
    public boolean isMissing(int idx, Object value) {
        if (this.dataFilter != null) {
            return this.dataFilter.isMissing(idx, value);
        }
        return false;
    }

    @Override
    public boolean isMissing(Object id, Object value) {
        if (this.dataFilter != null) {
            return this.dataFilter.isMissing(id, value);
        }
        return false;
    }

    @Override
    public boolean isNumericVariable(int idx) {
        if (this.dataFilter != null) {
            return this.dataFilter.isNumericVariable(idx);
        }
        return false;
    }

    @Override
    public boolean isNumericVariable(Object id) {
        if (this.dataFilter != null) {
            return this.dataFilter.isNumericVariable(id);
        }
        return false;
    }

    @Override
    public boolean isSelected(long iobs, SortContext sort) {
        return this.dataFilter.isSelected(this.getSortedIndex(this.mapObs(iobs), sort));
    }

    @Override
    public boolean isSelected(long iobs) {
        return this.dataFilter.isSelected(this.mapObs(iobs));
    }

    @Override
    public boolean removeDataFilterListener(Object listener) {
        if (listener instanceof DataFilterListenerInterface && this.listeners != null) {
            return this.listeners.remove((DataFilterListenerInterface)listener);
        }
        return false;
    }

    @Override
    public boolean removeSource() {
        if (this.data != null) {
            this.data = null;
            this.dataFilter.removeDataFilterListener(this);
            this.dataFilter.removeSource();
            this.dataFilter = null;
        }
        return false;
    }

    @Override
    public void sendEvent(Object event) {
    }

    @Override
    public void setAllGraphed(boolean graph) {
    }

    @Override
    public void setGraphed(long iobs, boolean graphed) {
    }

    @Override
    public void setGraphed(long iobs, SortContext sort, boolean graphed) {
    }

    @Override
    public void setGraphed(Object list, boolean graphed, IOBSInterface operator) {
    }

    @Override
    public void setGraphed(Object list, boolean graphed) {
    }

    @Override
    public void setGraphed(Object list, SortContext sort, boolean graphed, IOBSInterface operator) {
    }

    @Override
    public void setGraphed(Object list, SortContext sort, boolean graphed) {
    }

    @Override
    public void setGraphed(String[] variables, DataRange[] boundingBox, boolean graphed, boolean useFormat) {
    }

    @Override
    public void setGraphed(String[] variables, DataRange[] ranges, boolean[] graphed, boolean[] useFormat, boolean extendCurrentGraphedState, boolean setOrClearAll) {
    }

    @Override
    public void setGraphedLocal(boolean local) {
    }

    @Override
    public boolean setObservationColor(long iobs, Color c) {
        return false;
    }

    @Override
    public boolean setObservationColor(long iobs, SortContext sort, Color c) {
        return false;
    }

    @Override
    public void setObservationColor(Object list, Color c, IOBSInterface operator) {
    }

    @Override
    public void setObservationColor(Object list, Color c) {
    }

    @Override
    public void setObservationColor(Object list, SortContext sort, Color c, IOBSInterface operator) {
    }

    @Override
    public void setObservationColor(Object list, SortContext sort, Color c) {
    }

    @Override
    public void setSelected(long iobs, boolean selected) {
    }

    @Override
    public void setSelected(long iobs, SortContext sort, boolean selected) {
    }

    @Override
    public void setSelected(Object list, boolean selected, IOBSInterface operator) {
    }

    @Override
    public void setSelected(Object list, boolean selected) {
    }

    @Override
    public void setSelected(Object list, SortContext sort, boolean selected, IOBSInterface operator) {
    }

    @Override
    public void setSelected(Object list, SortContext sort, boolean selected) {
    }

    @Override
    public void setSelected(String[] variables, DataRange[] boundingBox, boolean selected, boolean useFormat) {
    }

    @Override
    public void setSelected(String[] variables, DataRange[] boundingBox, boolean selected) {
    }

    @Override
    public void setSelectionsLocal(boolean local) {
    }

    @Override
    public boolean setSource(Object source, Locale localeIn) {
        DataFilterReadInterface dfri;
        if (source != null && (dfri = FilterFactory.getDataSourceFilter(source)) != null) {
            this.dataFilter = dfri;
            this.dataFilter.addDataFilterListener(this);
            this.data = source;
            if (this.dataFilter instanceof DataFilterInfoInterface) {
                this.infoFilter = (DataFilterInfoInterface)((Object)this.dataFilter);
            }
            this.rangeInfoModel = new RangeInfoModel(this);
            this.uniqueValues = new Hashtable();
            this.computeWindow(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean setSource(Object source) {
        return this.setSource(source, Locale.getDefault());
    }

    @Override
    public boolean setSubsetList(Object list) {
        return false;
    }

    @Override
    public void unselectAll() {
    }

    @Override
    public boolean verifyVariable(Object id) {
        if (this.dataFilter != null) {
            return this.dataFilter.verifyVariable(id);
        }
        return false;
    }

    private boolean verifyVariable(int idx) {
        return this.dataFilter != null && this.dataFilter.verifyVariable(this.dataFilter.getVariableId(idx));
    }

    private boolean verifyObs(long obs) {
        return this.dataFilter != null && obs < (long)this.numberObservations;
    }

    private int mapObs(long obs) {
        int nObs = this.dataFilter.getNumberObservations(-1);
        if (this.verifyObs(obs) && nObs > 0) {
            return ((int)obs + this.windowStart) % nObs;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeWindow(DvrDataFilterEvent evt) {
        boolean obsChanged;
        if (this.dataFilter == null) {
            return;
        }
        int nobs = this.dataFilter.getNumberObservations(-1);
        boolean bl = obsChanged = nobs != this.numberObsInModel;
        if (obsChanged) {
            this.numberObsInModel = nobs;
        }
        Hashtable<Object, Object[]> hashtable = this.uniqueValues;
        synchronized (hashtable) {
            if (evt == null || obsChanged) {
                if (nobs < this.windowSize) {
                    this.numberObservations = nobs;
                    this.windowStart = 0;
                    this.windowEnd = nobs;
                } else {
                    this.numberObservations = this.windowSize;
                    this.windowStart = nobs - this.windowSize;
                    this.windowEnd = nobs;
                }
            } else if (nobs < this.windowSize) {
                this.numberObservations = nobs;
                this.windowStart = 0;
                this.windowEnd = nobs;
            } else if (evt.obsEndIndex > this.windowSize) {
                this.numberObservations = this.windowSize;
                this.windowStart = evt.obsStartIndex - this.windowSize;
                this.windowEnd = evt.obsStartIndex;
            } else {
                this.numberObservations = this.windowSize;
                this.windowStart = nobs - evt.obsStartIndex + 1;
                this.windowEnd = evt.obsStartIndex;
            }
            this.uniqueValues.clear();
        }
    }

    private void fireEvent(DvrDataFilterEvent evt) {
        if (this.listeners != null) {
            DvrDataFilterEvent e = new DvrDataFilterEvent();
            e.source = this;
            if (evt != null) {
                e.isAdjusting = evt.isAdjusting;
                e.type = evt.type;
            } else {
                e.isAdjusting = false;
                e.type = 3;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                DataFilterListenerInterface l = this.listeners.get(i);
                l.dataFilterChanged(e);
            }
        }
    }

    @Override
    public Object getMaximumValue(Object variableId, boolean useSubset) {
        if (this.dataFilter != null && this.dataFilter.isNumericVariable(variableId)) {
            return this.rangeInfoModel.getMaximum(variableId);
        }
        return null;
    }

    @Override
    public Object getMaximumValue(Object variableId) {
        return this.getMaximumValue(variableId, false);
    }

    @Override
    public Object getMinimumValue(Object variableId, boolean useSubset) {
        if (this.dataFilter != null && this.dataFilter.isNumericVariable(variableId)) {
            return this.rangeInfoModel.getMinimum(variableId);
        }
        return null;
    }

    @Override
    public Object getMinimumValue(Object variableId) {
        return this.getMinimumValue(variableId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getUniqueValues(Object variableId, boolean useSubset, int maxSize) {
        Hashtable<Object, Object[]> hashtable = this.uniqueValues;
        synchronized (hashtable) {
            if (!this.uniqueValues.containsKey(variableId)) {
                this.uniqueValues.put(variableId, this.buildUniqueValueList(variableId));
            }
            return this.uniqueValues.get(variableId);
        }
    }

    @Override
    public Object[] getUniqueValues(Object variableId, boolean useSubset) {
        return this.getUniqueValues(variableId, useSubset, Integer.MAX_VALUE);
    }

    @Override
    public boolean isMaximumValueValid(Object variableId) {
        if (this.infoFilter != null) {
            return this.infoFilter.isMaximumValueValid(variableId);
        }
        return false;
    }

    @Override
    public boolean isMinimumValueValid(Object variableId) {
        if (this.infoFilter != null) {
            return this.infoFilter.isMinimumValueValid(variableId);
        }
        return false;
    }

    @Override
    public boolean rerunStatistics() {
        if (this.infoFilter != null) {
            return this.infoFilter.rerunStatistics();
        }
        return false;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 1: 
            case 3: {
                this.updateWindow(evt);
            }
        }
    }

    private void updateWindow(DvrDataFilterEvent evt) {
        if (this.lockWindow) {
            return;
        }
        this.rangeInfoModel.invalidate();
        this.computeWindow(evt);
        this.fireEvent(evt);
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        if (this.windowSize != windowSize) {
            this.windowSize = windowSize;
            this.updateWindow(null);
        }
    }

    protected long getSortedIndex(long iobs, SortContext sort) {
        if (sort == null) {
            return iobs;
        }
        if (sort.getSource() != this.getSource()) {
            return iobs;
        }
        return sort.getSortedIndex((int)iobs, this);
    }

    private Object[] buildUniqueValueList(Object variableId) {
        if (variableId == null) {
            return null;
        }
        LinkedHashMap<String, String> uv = new LinkedHashMap<String, String>();
        int nobs = this.getNumberObservations(-1);
        for (int i = 0; i < nobs; ++i) {
            String fv = this.getFormattedValue(variableId, i, (Object)null);
            if (uv.containsKey(fv)) continue;
            uv.put(fv, fv);
        }
        return uv.keySet().toArray(new Object[uv.size()]);
    }

    public void lockMovingWindow() {
        this.lockWindow = true;
    }

    public void releaseMovingWindowLock() {
        this.lockWindow = false;
    }
}

