/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;

public class GTKMeanCalculatorVariable
extends NumericVariable {
    NumericVariable response;
    NumericVariable frequency;
    GTKMeanCalculatorConnection connection = new GTKMeanCalculatorConnection();

    public void connectFrom(NumericVariable resp, NumericVariable freq) {
        this.response = resp;
        this.frequency = freq;
        this.connection.connectFrom(resp.value, freq.value);
        this.connectFrom();
    }

    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.response.getValueCount());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.response.getName());
            this.setLabel(this.response.getLabel());
        }
        super.connectFrom();
        super.connectFrom();
        if (this.response.getFormat() != null) {
            this.setFormat(this.response.getFormat());
        }
    }

    protected int getRawValueCount() {
        return this.response.getValueCount();
    }

    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    public boolean isRawValueMissing(int index) {
        return this.response.isRawValueMissing(index) || this.frequency.isRawValueMissing(index);
    }

    private class GTKMeanCalculatorConnection
    implements NumericPipe {
        private NumericPipe responseConnection;
        private NumericPipe freqConnection;

        public void disconnect() {
            this.responseConnection = null;
            this.freqConnection = null;
        }

        public void connectFrom(NumericPipe resp, NumericPipe freq) {
            this.responseConnection = resp;
            this.freqConnection = freq;
        }

        public double getValue(int index) throws MissingValueException {
            double r = this.responseConnection.getValue(index);
            double f = this.freqConnection.getValue(index);
            if (f > 0.0) {
                return r / f;
            }
            MissingValueException mv = MissingValueException.getDefaultMissingValueExeption();
            mv.setMissingValue(MissingValues.Dot);
            throw mv;
        }

        public void init(AInitAction initAction) {
            this.responseConnection.init(initAction);
            this.freqConnection.init(initAction);
        }

        public void reset(AResetAction resetAction) {
            this.responseConnection.reset(resetAction);
            this.freqConnection.reset(resetAction);
        }

        public Formatter getFormatter() {
            return null;
        }
    }
}

