/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Variable;
import com.sas.text.SASFormat;
import java.text.Format;

abstract class GTKDataFilterConnection
implements Pipe,
DataFilterListenerInterface {
    protected DataFilterReadInterface data;
    protected int variableIndex;
    protected int valueCount = 0;
    private String variableName = "";
    private GTKFormat format;
    private Variable variable;

    public void init(AInitAction initAction) {
        initAction.setValueCount(this.valueCount);
    }

    public void reset(AResetAction resetAction) {
    }

    public Formatter getFormatter() {
        return null;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public GTKFormat getFormat() {
        return this.format;
    }

    public GTKDataFilterConnection(Variable variable) {
        this.variable = variable;
    }

    public void connectFrom(DataFilterReadInterface data, int variableIndex) {
        if (data == null) {
            throw new RuntimeException("Attempt to connect a null data source.");
        }
        this.data = data;
        this.data.addDataFilterListener(this);
        this.variableIndex = variableIndex;
        this.variableName = data.getVariableId(variableIndex).toString();
        Format f = (Format)data.getFormat(this.variableName, SASFormat.class);
        this.format = new GTKFormat(f);
        this.saveValueCount();
    }

    public void connectFrom(DataFilterReadInterface data, String columnName) {
        this.connectFrom(data, data.getVariableIndex(columnName));
    }

    public void disconnect() {
        this.data = null;
        this.variableIndex = -1;
        this.valueCount = 0;
    }

    private void saveValueCount() {
        this.valueCount = this.data != null ? this.data.getNumberObservations(-1) : 0;
    }

    public void setModified() {
        this.saveValueCount();
    }

    public boolean isMissing(Object value) {
        return this.data.isMissing(this.variableIndex, value);
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.type == 9 || evt.type == 2 || evt.type == 8 || evt.type == 7) {
            return;
        }
        this.setModified();
    }
}

