/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.DefaultStatistics;
import com.sas.graphics.util.ods.data.DataVariableInterface;
import com.sas.text.SASFormat;

public class FilterDataVariable
implements DataVariableInterface {
    protected DataFilterReadInterface data = null;
    protected Object varId = null;
    protected DefaultStatistics stats = null;

    public FilterDataVariable() {
    }

    public FilterDataVariable(DataFilterReadInterface df, Object id) {
        this();
        this.data = df;
        this.varId = id;
        if (this.data != null) {
            this.stats = new DefaultStatistics(this.data);
        }
    }

    @Override
    public String GetName() {
        if (this.varId != null) {
            return this.varId.toString();
        }
        return null;
    }

    @Override
    public boolean SetName(String newName) {
        return false;
    }

    @Override
    public String GetDescription() {
        if (this.data != null && this.varId != null) {
            Object description = this.data.getVariableDescription(this.varId);
            if (description != null) {
                return description.toString();
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean SetDescription(String newDesc) {
        return false;
    }

    @Override
    public int GetNumberMissing() {
        if (this.stats != null && this.varId != null) {
            Object numMissing = this.stats.getStatistic("NMISS", this.varId);
            if (numMissing != null && numMissing instanceof Number) {
                return ((Number)numMissing).intValue();
            }
            return 0;
        }
        return 0;
    }

    @Override
    public Class GetObjectClass() {
        if (this.data != null && this.varId != null) {
            return this.data.getVariableClass(this.varId);
        }
        return null;
    }

    @Override
    public int GetNumberValues() {
        if (this.data != null && this.varId != null) {
            return this.data.getNumberObservations(this.varId);
        }
        return 0;
    }

    @Override
    public Object GetValue(int idx) {
        if (this.data != null && this.varId != null) {
            return this.data.getValue(this.varId, (long)idx);
        }
        return null;
    }

    @Override
    public boolean SetValue(int idx, Object newValue) {
        return false;
    }

    @Override
    public Object GetMinimumValue() {
        if (this.stats != null && this.varId != null) {
            return this.stats.getStatistic("MIN", this.varId);
        }
        return null;
    }

    @Override
    public Object GetMaximumValue() {
        if (this.stats != null && this.varId != null) {
            return this.stats.getStatistic("MAX", this.varId);
        }
        return null;
    }

    @Override
    public boolean DeleteValue(int idx) {
        return false;
    }

    @Override
    public String GetFormat() {
        if (this.data != null && this.varId != null) {
            return (String)this.data.getFormat(this.varId, String.class);
        }
        return null;
    }

    @Override
    public boolean SetFormat(String name) {
        return false;
    }

    @Override
    public String GetFormattedValue(Object rawValue) {
        if (this.data != null && this.varId != null && rawValue != null) {
            SASFormat format = (SASFormat)this.data.getFormat(this.varId, SASFormat.class);
            if (format != null) {
                return format.format(rawValue);
            }
            return rawValue.toString();
        }
        return rawValue.toString();
    }

    @Override
    public boolean UpdateData(Object dataIn) {
        return false;
    }
}

