/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataFilterUpdateInterface;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class Filter2TableModel
implements DataFilterListenerInterface,
TableModel {
    protected DataFilterReadInterface filter;
    protected Vector listeners;
    protected boolean useVariableDescription;
    protected boolean tableEditable = true;

    public Filter2TableModel(DataFilterReadInterface filterIn) {
        this.filter = filterIn;
        this.listeners = new Vector();
        this.setUseVariableDescription(true);
    }

    public Filter2TableModel() {
        this(null);
    }

    protected void sendTableModelEvents(TableModelEvent te) {
        int n;
        TableModelListener tml = null;
        if (this.listeners == null || (n = this.listeners.size()) <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            tml = (TableModelListener)this.listeners.elementAt(i);
            if (tml == null) continue;
            tml.tableChanged(te);
        }
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt == null) {
            return;
        }
        int evtType = evt.type;
        switch (evtType) {
            case 1: 
            case 6: {
                this.sendTableModelEvents(new TableModelEvent(this));
                break;
            }
            case 4: 
            case 5: {
                this.sendTableModelEvents(new TableModelEvent(this, -1));
                break;
            }
            case 3: {
                int firstVarIdx = evt.varStartIndex;
                int lastVarIdx = evt.varEndIndex;
                int firstObs = evt.obsStartIndex;
                int lastObs = evt.obsEndIndex;
                for (int i = firstVarIdx; i <= lastVarIdx; ++i) {
                    this.sendTableModelEvents(new TableModelEvent(this, firstObs, lastObs, i));
                }
                break;
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.filter == null || this.listeners == null || l == null) {
            return;
        }
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.addElement(l);
        if (this.listeners.size() == 1) {
            this.filter.addDataFilterListener(this);
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getVariableClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        if (this.filter == null) {
            return 0;
        }
        return this.filter.getNumberVariables();
    }

    @Override
    public String getColumnName(int columnIndex) {
        Object o = null;
        if (this.filter == null) {
            return null;
        }
        if (this.useVariableDescription ? (o = this.filter.getVariableDescription(columnIndex)) == null : (o = this.filter.getVariableId(columnIndex)) == null) {
            return null;
        }
        return o.toString();
    }

    @Override
    public int getRowCount() {
        if (this.filter == null) {
            return 0;
        }
        return this.filter.getNumberObservations(null);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getValue(columnIndex, (long)rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.tableEditable) {
            return false;
        }
        if (this.filter == null) {
            return false;
        }
        if (this.filter instanceof DataFilterUpdateInterface) {
            return ((DataFilterUpdateInterface)this.filter).isModelUpdatable(columnIndex, rowIndex);
        }
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.filter == null || this.listeners == null || l == null) {
            return;
        }
        int idx = this.listeners.indexOf(l);
        if (idx < 0) {
            return;
        }
        this.listeners.removeElementAt(idx);
        if (this.listeners.size() <= 0) {
            this.filter.removeDataFilterListener(this);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isCellEditable(rowIndex, columnIndex)) {
            return;
        }
        ((DataFilterUpdateInterface)this.filter).setValue(columnIndex, (long)rowIndex, aValue);
    }

    public DataFilterReadInterface getFilter() {
        return this.filter;
    }

    public boolean isVariableDescriptionUsed() {
        return this.useVariableDescription;
    }

    public void setUseVariableDescription(boolean useVariableDescription) {
        this.useVariableDescription = useVariableDescription;
    }

    protected boolean isTableEditable() {
        return this.tableEditable;
    }

    public void setTableEditable(boolean tableEditable) {
        this.tableEditable = tableEditable;
    }
}

