/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.DynamicIntArray;
import java.awt.Color;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.event.EventListenerList;

public class DataFilterSelectionFilter
implements DataFilterReadInterface,
DataFilterListenerInterface {
    private DataFilterReadInterface baseFilter = null;
    private EventListenerList dataFilterListeners = new EventListenerList();
    private DynamicIntArray indexList = null;

    public DataFilterSelectionFilter(DataFilterReadInterface filter) {
        this.baseFilter = filter;
        this.initDataStructures();
    }

    private void initDataStructures() {
        if (this.baseFilter == null) {
            this.indexList = null;
            return;
        }
        this.baseFilter.removeDataFilterListener(this);
        this.indexList = new DynamicIntArray();
        for (int i = 0; i < this.baseFilter.getNumberObservations(-1); ++i) {
            if (!this.baseFilter.isSelected(i)) continue;
            this.indexList.add(i);
        }
        this.baseFilter.addDataFilterListener(this);
    }

    private int mapIndex(long index) {
        return this.indexList.get((int)index);
    }

    @Override
    public Object getSource() {
        return this;
    }

    @Override
    public boolean setSource(Object source) {
        if (!(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.baseFilter = (DataFilterReadInterface)source;
        this.initDataStructures();
        return true;
    }

    @Override
    public boolean setSource(Object source, Locale localeIn) {
        return this.setSource(source);
    }

    @Override
    public boolean removeSource() {
        this.baseFilter = null;
        this.initDataStructures();
        return true;
    }

    @Override
    public int getNumberVariables() {
        return this.baseFilter.getNumberVariables();
    }

    @Override
    public boolean verifyVariable(Object id) {
        return this.baseFilter.verifyVariable(id);
    }

    @Override
    public Object getVariableId(int idx) {
        return this.baseFilter.getVariableId(idx);
    }

    @Override
    public int getVariableIndex(Object id) {
        return this.baseFilter.getVariableIndex(id);
    }

    @Override
    public Object getExactVariableId(Object id) {
        return this.baseFilter.getExactVariableId(id);
    }

    @Override
    public Object getVariableDescription(Object id) {
        return this.baseFilter.getVariableDescription(id);
    }

    @Override
    public Object getVariableDescription(int idx) {
        return this.baseFilter.getVariableDescription(idx);
    }

    @Override
    public Class getVariableClass(Object id) {
        return this.baseFilter.getVariableClass(id);
    }

    @Override
    public Class getVariableClass(int idx) {
        return this.baseFilter.getVariableClass(idx);
    }

    @Override
    public int getNumberObservations(Object id) {
        return this.getNumberObservations(-1);
    }

    @Override
    public int getNumberObservations(int idx) {
        return this.indexList.getNumberElements();
    }

    @Override
    public boolean isMissing(Object id, Object value) {
        return this.baseFilter.isMissing(id, value);
    }

    @Override
    public boolean isMissing(int idx, Object value) {
        return this.baseFilter.isMissing(idx, value);
    }

    @Override
    public Object getValue(Object variableId, long iobs) {
        return this.baseFilter.getValue(variableId, (long)this.mapIndex(iobs));
    }

    @Override
    public Object getValue(Object variableId, long iobs, SortContext sort) {
        return this.getValue(variableId, iobs);
    }

    @Override
    public Object getValue(int idx, long iobs) {
        return this.baseFilter.getValue(idx, (long)this.mapIndex(iobs));
    }

    @Override
    public Object getValue(int idx, long iobs, SortContext sort) {
        return this.getValue(idx, iobs);
    }

    @Override
    public boolean isNumericVariable(Object id) {
        return this.baseFilter.isNumericVariable(id);
    }

    @Override
    public boolean isNumericVariable(int idx) {
        return this.baseFilter.isNumericVariable(idx);
    }

    @Override
    public double getNumericValue(Object variableId, long iobs) {
        return this.baseFilter.getNumericValue(variableId, (long)this.mapIndex(iobs));
    }

    @Override
    public double getNumericValue(Object variableId, long iobs, SortContext sort) {
        return this.getNumericValue(variableId, iobs);
    }

    @Override
    public double getNumericValue(int idx, long iobs) {
        return this.baseFilter.getNumericValue(idx, (long)this.mapIndex(iobs));
    }

    @Override
    public double getNumericValue(int idx, long iobs, SortContext sort) {
        return this.getNumericValue(idx, iobs);
    }

    @Override
    public Object[] getRowValues(long iobs) {
        return this.baseFilter.getRowValues(this.mapIndex(iobs));
    }

    @Override
    public Object[] getRowValues(long iobs, SortContext sort) {
        return this.getRowValues(iobs);
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues, SortContext sort) {
        return this.getRowValues(iobs, outValues);
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues) {
        return this.baseFilter.getRowValues((long)this.mapIndex(iobs), outValues);
    }

    @Override
    public Object getFormat(Object variableId, Class returnType) {
        return this.baseFilter.getFormat(variableId, returnType);
    }

    @Override
    public String getFormattedValue(Object variableId, Object value, Object format) {
        return this.baseFilter.getFormattedValue(variableId, value, format);
    }

    @Override
    public String getFormattedValue(Object variableId, long iobs, SortContext sort, Object format) {
        return this.getFormattedValue(variableId, iobs, format);
    }

    @Override
    public String getFormattedValue(Object variableId, long iobs, Object format) {
        return this.baseFilter.getFormattedValue(variableId, this.mapIndex(iobs), format);
    }

    @Override
    public void unselectAll() {
    }

    @Override
    public boolean isSelected(long iobs) {
        return false;
    }

    @Override
    public boolean isSelected(long iobs, SortContext sort) {
        return false;
    }

    @Override
    public void setSelected(long iobs, boolean selected) {
    }

    @Override
    public void setSelected(long iobs, SortContext sort, boolean selected) {
    }

    @Override
    public void setSelected(Object list, boolean selected) {
    }

    @Override
    public void setSelected(Object list, boolean selected, IOBSInterface operator) {
    }

    @Override
    public void setSelected(Object list, SortContext sort, boolean selected) {
    }

    @Override
    public void setSelected(Object list, SortContext sort, boolean selected, IOBSInterface operator) {
    }

    @Override
    public boolean isGraphed(long iobs) {
        return this.baseFilter.isGraphed(this.mapIndex(iobs));
    }

    @Override
    public boolean isGraphed(long iobs, SortContext sort) {
        return this.baseFilter.isGraphed(iobs);
    }

    @Override
    public void setGraphed(long iobs, boolean graphed) {
        this.baseFilter.setGraphed(this.mapIndex(iobs), graphed);
    }

    @Override
    public void setGraphed(long iobs, SortContext sort, boolean graphed) {
    }

    @Override
    public void setGraphed(Object list, boolean graphed) {
    }

    @Override
    public void setGraphed(Object list, SortContext sort, boolean graphed) {
    }

    @Override
    public void setGraphed(Object list, boolean graphed, IOBSInterface operator) {
    }

    @Override
    public void setGraphed(Object list, SortContext sort, boolean graphed, IOBSInterface operator) {
    }

    @Override
    public void setAllGraphed(boolean graph) {
    }

    @Override
    public boolean addDataFilterListener(Object listener) {
        if (!(listener instanceof DataFilterListenerInterface)) {
            return false;
        }
        this.dataFilterListeners.add(DataFilterListenerInterface.class, (DataFilterListenerInterface)listener);
        return true;
    }

    @Override
    public boolean removeDataFilterListener(Object listener) {
        if (!(listener instanceof DataFilterListenerInterface)) {
            return false;
        }
        this.dataFilterListeners.remove(DataFilterListenerInterface.class, (DataFilterListenerInterface)listener);
        return true;
    }

    @Override
    public void sendEvent(Object event) {
    }

    @Override
    public Object getSubsetList() {
        return null;
    }

    @Override
    public boolean setSubsetList(Object list) {
        return false;
    }

    @Override
    public int getObservationNumber(int index) {
        return 0;
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        return false;
    }

    @Override
    public String getWhereClause() {
        return null;
    }

    @Override
    public Color getObservationColor(long iobs) {
        return null;
    }

    @Override
    public Color getObservationColor(long iobs, SortContext sort) {
        return null;
    }

    @Override
    public boolean setObservationColor(long iobs, Color c) {
        return false;
    }

    @Override
    public void setObservationColor(Object list, SortContext sort, Color c) {
    }

    @Override
    public void setObservationColor(Object list, Color c) {
    }

    @Override
    public void setObservationColor(Object list, SortContext sort, Color c, IOBSInterface operator) {
    }

    @Override
    public void setObservationColor(Object list, Color c, IOBSInterface operator) {
    }

    @Override
    public boolean setObservationColor(long iobs, SortContext sort, Color c) {
        return false;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.type == 2) {
            if (this.baseFilter == null) {
                return;
            }
            int[] arr = (int[])evt.oldValue;
            if (arr == null) {
                this.indexList.removeAll();
            } else {
                int numInList = arr.length;
                if (evt.newValue != null && evt.newValue instanceof Number) {
                    numInList = ((Number)evt.newValue).intValue();
                }
                if (numInList > arr.length) {
                    numInList = arr.length;
                }
                for (int i = 0; i < numInList; ++i) {
                    this.initDataStructures();
                }
            }
        } else if (!evt.isAdjusting) {
            this.initDataStructures();
        }
        evt.type = 3;
        this.sendDataEvent(evt);
    }

    private void sendDataEvent(DvrDataFilterEvent event) {
        EventListener[] list = this.dataFilterListeners.getListeners(DataFilterListenerInterface.class);
        for (int i = 0; i < list.length; ++i) {
            ((DataFilterListenerInterface)list[i]).dataFilterChanged(event);
        }
    }

    @Override
    public boolean isIndexInCurrentSubset(int index) {
        return false;
    }

    @Override
    public void setSelected(String[] variables, DataRange[] boundingBox, boolean selected, boolean useFormat) {
    }

    @Override
    public void setGraphed(String[] variables, DataRange[] boundingBox, boolean graphed, boolean useFormat) {
    }

    @Override
    public void setSelected(String[] variables, DataRange[] boundingBox, boolean selected) {
    }

    @Override
    public void setGraphed(String[] variables, DataRange[] ranges, boolean[] graphed, boolean[] useFormat, boolean extendCurrentGraphedState, boolean setOrClearAll) {
    }

    @Override
    public SelectionIterator getSelections() {
        return null;
    }

    @Override
    public Object getAdapter(Class type) {
        return null;
    }

    @Override
    public boolean areSelectionsLocal() {
        return false;
    }

    @Override
    public void setSelectionsLocal(boolean local) {
    }

    @Override
    public boolean isGraphedLocal() {
        return false;
    }

    @Override
    public void setGraphedLocal(boolean local) {
    }
}

