/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.heatmap;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.CustomBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.silk.interfaces.HeatmapElementPropertyInterface;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToLogarithmicMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.Rectangle;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.legend.LegendItem;
import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class HeatmapParmObject
implements HeatmapElementPropertyInterface {
    protected Channel channel;
    protected NetworkRoot root;
    protected NetworkRoot rootSelected;
    protected Rectangle chicklet;
    protected Rectangle chickletSelected;
    protected Variable xVariable;
    protected Variable yVariable;
    protected Variable colorVariable;
    protected Variable xVariableSelected;
    protected Variable yVariableSelected;
    protected Variable colorVariableSelected;
    protected NumericVectorVariable xBinPositionVariable;
    protected NumericVectorVariable xBinPositionVariableSelected;
    protected NumericVectorVariable yBinPositionVariable;
    protected NumericVectorVariable yBinPositionVariableSelected;
    protected NumericVectorVariable xBinLengthVariable;
    protected NumericVectorVariable xBinLengthVariableSelected;
    protected NumericVectorVariable yBinLengthVariable;
    protected NumericVectorVariable yBinLengthVariableSelected;
    protected VariableProcessor selectionProcessor;
    protected NumericMapper xPositionMapper;
    protected NumericMapper yPositionMapper;
    protected ColorMapper colorMapper;
    protected NumericMapper xPositionMapperSelected;
    protected NumericMapper yPositionMapperSelected;
    protected ColorMapper colorMapperSelected;
    protected Color[] rampColors;
    protected double[] rampValues;
    protected boolean reconnectRequired = false;
    protected FillAttrs fillAttrs = new FillAttrs();
    protected LineAttrs outlineAttrs = new LineAttrs();
    protected boolean xBinAxis = true;
    protected boolean xEndLabels = false;
    protected int xValuesType = 333661;
    protected double[] xBinBoundaries = null;
    protected double xBinSize = 0.0;
    protected boolean yBinAxis = true;
    protected boolean yEndLabels = false;
    protected int yValuesType = 333661;
    protected double[] yBinBoundaries = null;
    protected double yBinSize = 0.0;
    protected double xStep = Double.NaN;
    protected double yStep = Double.NaN;
    protected double xGap = 0.0;
    protected double yGap = 0.0;
    protected boolean showChickletOutlines = false;
    protected Color missingColor = null;
    protected boolean logX = false;
    protected boolean logY = false;
    private double discreteChickletXWidth = 0.0;
    private double discreteChickletYWidth = 0.0;

    public HeatmapParmObject() {
        this.chicklet = new Rectangle();
        this.chicklet.set2D(true);
        this.chicklet.selectEnabled.setValue(true);
        this.chicklet.selectDetailEnabled.setValue(true);
        this.chickletSelected = new Rectangle();
        this.chickletSelected.set2D(true);
        this.chickletSelected.selectEnabled.setValue(false);
        this.chickletSelected.selectDetailEnabled.setValue(true);
        this.selectionProcessor = new VariableProcessor();
    }

    public void setChannel(Channel aChannel) {
        if (aChannel == null) {
            return;
        }
        this.channel = aChannel;
        this.createNetwork();
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected void createNetwork() {
        this.root = new NetworkRoot(this.channel);
        this.root.addElement((Element)this.chicklet);
        this.rootSelected = new NetworkRoot(this.channel);
        this.rootSelected.addElement((Element)this.chickletSelected);
    }

    public void select() {
        if (this.root == null) {
            return;
        }
        this.root.draw(this.root.getChannel(), true);
    }

    public void draw() {
        if (!this.allRequiredVariablesAreValid()) {
            return;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.root.draw();
        this.channel.glPopAttrib();
    }

    public void drawSelected() {
        if (!this.allRequiredVariablesAreValid()) {
            return;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.rootSelected.draw();
        this.channel.glPopAttrib();
    }

    public Vector<SelectResult> getSelected(java.awt.Rectangle r) {
        if (!this.allRequiredVariablesAreValid()) {
            return null;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        Vector selectedObservations = this.root.select(r.x, r.y, r.width, r.height, true, true);
        this.channel.glPopAttrib();
        return selectedObservations;
    }

    public void setSelected(int[] selectedObservationsArray) {
        if (selectedObservationsArray == null || selectedObservationsArray.length == 0) {
            this.selectionProcessor.clearSubsetByObservation();
        } else {
            this.selectionProcessor.setSubsetByObservation(selectedObservationsArray, selectedObservationsArray.length);
        }
    }

    public Object[] getTickmarkValuesForDimension(byte dimension) {
        Object[] tickmarkValues = null;
        switch (dimension) {
            case 1: {
                tickmarkValues = this.getUniqueTickmarkValuesFromCustomBins(this.xBinBoundaries, this.xEndLabels);
                if (tickmarkValues != null) {
                    return tickmarkValues;
                }
                if (!(this.xVariable instanceof NumericVariable)) break;
                return this.getEquallySpacedTickmarkValues((NumericVariable)this.xVariable, this.xValuesType, this.xStep, this.xEndLabels);
            }
            case 2: {
                tickmarkValues = this.getUniqueTickmarkValuesFromCustomBins(this.yBinBoundaries, this.yEndLabels);
                if (tickmarkValues != null) {
                    return tickmarkValues;
                }
                if (!(this.yVariable instanceof NumericVariable)) break;
                return this.getEquallySpacedTickmarkValues((NumericVariable)this.yVariable, this.yValuesType, this.yStep, this.yEndLabels);
            }
        }
        return null;
    }

    protected Object[] getUniqueTickmarkValuesFromCustomBins(double[] boundaries, boolean showEndLabels) {
        if (boundaries == null || boundaries.length <= 1) {
            return null;
        }
        Object[] tickmarkValues = null;
        if (showEndLabels) {
            tickmarkValues = new Object[boundaries.length];
            for (int i = tickmarkValues.length - 1; i >= 0; --i) {
                tickmarkValues[i] = new Double(boundaries[i]);
            }
        } else {
            tickmarkValues = new Object[boundaries.length - 1];
            int tickmarkNumber = 0;
            int boundaryIndex = 0;
            while (tickmarkNumber < tickmarkValues.length) {
                tickmarkValues[tickmarkNumber] = new Double((boundaries[boundaryIndex + 1] + boundaries[boundaryIndex]) / 2.0);
                ++tickmarkNumber;
                ++boundaryIndex;
            }
        }
        return tickmarkValues;
    }

    protected Object[] getEquallySpacedTickmarkValues(NumericVariable variable, int valuesType, double step, boolean showEndLabels) {
        Vector<Double> tickmarkValues;
        block15: {
            block14: {
                double[] values = variable.newValueArray();
                int numberOfValues = values.length;
                tickmarkValues = new Vector<Double>();
                if (step == 0.0 && numberOfValues == 1) {
                    tickmarkValues.add(values[0]);
                    return tickmarkValues.toArray();
                }
                if (!showEndLabels) break block14;
                switch (valuesType) {
                    case 333662: {
                        for (int i = 0; i < numberOfValues; ++i) {
                            tickmarkValues.add(new Double(values[i]));
                            tickmarkValues.add(new Double(values[i] + step));
                        }
                        break block15;
                    }
                    case 333663: {
                        for (int i = 0; i < numberOfValues; ++i) {
                            tickmarkValues.add(new Double(values[i] - step));
                            tickmarkValues.add(new Double(values[i]));
                        }
                        break block15;
                    }
                    case 333661: {
                        double halfStep = step / 2.0;
                        for (int i = 0; i < numberOfValues; ++i) {
                            tickmarkValues.add(new Double(values[i] - halfStep));
                            tickmarkValues.add(new Double(values[i] + halfStep));
                        }
                        break;
                    }
                }
                break block15;
            }
            double tickmarkValue = variable.getMin();
            double maxTickmarkValue = variable.getMax();
            switch (valuesType) {
                case 333662: {
                    tickmarkValue += step / 2.0;
                    maxTickmarkValue += step;
                    break;
                }
                case 333663: {
                    tickmarkValue -= step / 2.0;
                    break;
                }
            }
            tickmarkValues = new Vector((int)Math.floor((maxTickmarkValue - tickmarkValue) / step + 1.0));
            while (tickmarkValue <= maxTickmarkValue) {
                tickmarkValues.add(new Double(tickmarkValue));
                tickmarkValue += step;
            }
        }
        return tickmarkValues.toArray();
    }

    public Variable getXVariable() {
        return this.xVariable;
    }

    public void setXVariable(Variable variable) {
        this.xVariable = variable;
        this.xStep = this.xBinSize > 0.0 ? this.xBinSize : (this.xVariable instanceof NumericVariable ? this.computeStep((NumericVariable)this.xVariable) : Double.NaN);
        this.setReconnectRequired(true);
    }

    public Variable getYVariable() {
        return this.yVariable;
    }

    public void setYVariable(Variable variable) {
        this.yVariable = variable;
        this.yStep = this.yBinSize > 0.0 ? this.yBinSize : (this.yVariable instanceof NumericVariable ? this.computeStep((NumericVariable)this.yVariable) : Double.NaN);
        this.setReconnectRequired(true);
    }

    public Variable getColorVariable() {
        return this.colorVariable;
    }

    public void setColorVariable(Variable variable) {
        this.colorVariable = variable;
        this.setReconnectRequired(true);
    }

    public boolean isReconnectRequired() {
        return this.reconnectRequired;
    }

    public void setReconnectRequired(boolean flag) {
        this.reconnectRequired = flag;
    }

    public boolean allRequiredVariablesAreValid() {
        return this.root != null && this.rootSelected != null && this.channel != null && this.xVariable != null && this.yVariable != null && this.colorVariable != null && this.xVariable.isConnected() && this.yVariable.isConnected() && this.colorVariable.isConnected();
    }

    public boolean connectNetwork(NumericMap xmap, NumericMap ymap, ColorMap colormap, RangeAttrMapper rangeAttrMapper, DiscreteAttrMapper discreteAttrMapper, Probe probe) {
        if (!this.allRequiredVariablesAreValid()) {
            return false;
        }
        this.root.removeElement((Element)this.chicklet);
        this.rootSelected.removeElement((Element)this.chickletSelected);
        boolean rc = false;
        rc = this.connectSelectedVariables();
        rc = this.connectMappers(xmap, ymap, colormap, rangeAttrMapper, discreteAttrMapper);
        if (probe != null) {
            this.chicklet.setUserData((Object)probe);
        }
        this.chicklet.edgeColor.setValue(this.getOutlineAttrs().getColor());
        this.chicklet.edgeWidth.setValue(this.getOutlineAttrs().getWidth());
        this.chicklet.edgePattern.setValue(this.getOutlineAttrs().getLinePattern());
        this.chicklet.fillOn.setValue(true);
        this.chicklet.edgeOn.setValue(this.showChickletOutlines);
        boolean bl = this.reconnectRequired = !rc;
        if (this.reconnectRequired) {
            return false;
        }
        this.chickletSelected.fillOn.setValue(false);
        this.chickletSelected.edgeOn.setValue(true);
        this.chickletSelected.edgeColor.setValue(this.getOutlineAttrs().getColor());
        this.chickletSelected.edgeWidth.setValue(3);
        this.root.addElement((Element)this.chicklet);
        this.rootSelected.addElement((Element)this.chickletSelected);
        return rc;
    }

    protected boolean connectMappers(NumericMap xmap, NumericMap ymap, ColorMap colormap, RangeAttrMapper rangeAttrMapper, DiscreteAttrMapper discreteAttrMapper) {
        if (xmap instanceof ContinuousRangeToLogarithmicMap) {
            this.logX = true;
        }
        if (ymap instanceof ContinuousRangeToLogarithmicMap) {
            this.logY = true;
        }
        boolean rc = false;
        rc = this.connectXPositionMapper(xmap);
        rc &= this.connectYPositionMapper(ymap);
        rc &= this.connectColorMapper(colormap, rangeAttrMapper, discreteAttrMapper);
        if (!this.logX) {
            rc &= this.connectLengthVariable(this.xBinLengthVariable, this.xBinLengthVariableSelected, this.xPositionMapper, this.xStep, this.xGap, this.chicklet.sizeX, this.chickletSelected.sizeX, this.discreteChickletXWidth);
        }
        if (!this.logY) {
            rc &= this.connectLengthVariable(this.yBinLengthVariable, this.yBinLengthVariableSelected, this.yPositionMapper, this.yStep, this.yGap, this.chicklet.sizeY, this.chickletSelected.sizeY, this.discreteChickletYWidth);
        }
        return rc;
    }

    protected boolean connectSelectedVariables() {
        this.selectionProcessor.removeAllVariables();
        if (this.xVariable instanceof StringVariable) {
            this.xVariableSelected = new StringVariable();
            this.xVariableSelected.connectFrom((StringVariable)this.xVariable);
        } else {
            this.xVariableSelected = new NumericVariable();
            this.xVariableSelected.connectFrom((NumericVariable)this.xVariable);
        }
        this.xVariableSelected.setFormat(this.xVariable.getFormat());
        this.selectionProcessor.addVariable(this.xVariableSelected);
        if (this.yVariable instanceof StringVariable) {
            this.yVariableSelected = new StringVariable();
            this.yVariableSelected.connectFrom((StringVariable)this.yVariable);
        } else {
            this.yVariableSelected = new NumericVariable();
            this.yVariableSelected.connectFrom((NumericVariable)this.yVariable);
        }
        this.yVariableSelected.setFormat(this.yVariable.getFormat());
        this.selectionProcessor.addVariable(this.yVariableSelected);
        return true;
    }

    protected boolean connectXPositionMapper(NumericMap xmap) {
        if (xmap == null) {
            return false;
        }
        Calculator middle = null;
        Calculator length = null;
        if (xmap instanceof StringToNumericMap) {
            StringToNumericMap stnmap = (StringToNumericMap)xmap;
            if (this.xPositionMapper == null || !(this.xPositionMapper instanceof StringToNumericMapper)) {
                this.xPositionMapper = new StringToNumericMapper();
            }
            StringToNumericMapper stnmapper = (StringToNumericMapper)this.xPositionMapper;
            stnmapper.setMap(stnmap);
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.xVariable.formattedValue);
            if (this.xPositionMapperSelected == null || !(this.xPositionMapperSelected instanceof StringToNumericMapper)) {
                this.xPositionMapperSelected = new StringToNumericMapper();
            }
            StringToNumericMapper stnmapperSelected = (StringToNumericMapper)this.xPositionMapperSelected;
            stnmapperSelected.setMap(stnmap);
            stnmapperSelected.input.disconnect();
            stnmapperSelected.input.connectFrom(this.xVariableSelected.formattedValue);
        } else if (xmap instanceof StringToNumberMap) {
            StringToNumberMap stnmap = (StringToNumberMap)xmap;
            if (this.xPositionMapper == null || !(this.xPositionMapper instanceof StringToNumberMapper)) {
                this.xPositionMapper = new StringToNumberMapper();
            }
            StringToNumberMapper stnmapper = (StringToNumberMapper)this.xPositionMapper;
            stnmapper.setMap(stnmap);
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.xVariable.formattedValue);
            if (this.xPositionMapperSelected == null || !(this.xPositionMapperSelected instanceof StringToNumberMapper)) {
                this.xPositionMapperSelected = new StringToNumberMapper();
            }
            StringToNumberMapper stnmapperSelected = (StringToNumberMapper)this.xPositionMapperSelected;
            stnmapperSelected.setMap(stnmap);
            stnmapperSelected.input.disconnect();
            stnmapperSelected.input.connectFrom(this.xVariableSelected.formattedValue);
        } else if (xmap instanceof ContinuousRangeToNumericMap) {
            ContinuousRangeToNumericMap crtnMap = (ContinuousRangeToNumericMap)xmap;
            if (this.xPositionMapper == null || !(this.xPositionMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xPositionMapper = new ContinuousRangeToNumericMapper();
            }
            ContinuousRangeToNumericMapper crtnMapper = (ContinuousRangeToNumericMapper)this.xPositionMapper;
            crtnMapper.setMap(crtnMap);
            crtnMapper.input.disconnect();
            if (this.xPositionMapperSelected == null || !(this.xPositionMapperSelected instanceof ContinuousRangeToNumericMapper)) {
                this.xPositionMapperSelected = new ContinuousRangeToNumericMapper();
            }
            ContinuousRangeToNumericMapper crtnMapperSelected = (ContinuousRangeToNumericMapper)this.xPositionMapperSelected;
            crtnMapperSelected.setMap(crtnMap);
            crtnMapperSelected.input.disconnect();
            if (this.xBinBoundaries != null) {
                if (this.xBinLengthVariable == null) {
                    this.xBinPositionVariable = new NumericVectorVariable();
                    this.xBinPositionVariableSelected = new NumericVectorVariable();
                    this.xBinLengthVariable = new NumericVectorVariable();
                    this.xBinLengthVariableSelected = new NumericVectorVariable();
                }
                if (this.computeBinPositionAndLengthVariables((NumericVariable)this.xVariable, this.xBinPositionVariable, this.xBinLengthVariable, this.xBinBoundaries, this.xGap, this.xPositionMapper)) {
                    this.xBinPositionVariableSelected.connectFrom(this.xBinPositionVariable.value);
                    this.xBinLengthVariableSelected.connectFrom(this.xBinLengthVariable.value);
                    crtnMapper.input.connectFrom(this.xBinPositionVariable.value);
                    crtnMapperSelected.input.connectFrom(this.xBinPositionVariableSelected.value);
                    this.selectionProcessor.removeVariable(this.xVariableSelected);
                    this.selectionProcessor.addVariable((Variable)this.xBinPositionVariableSelected);
                }
            } else {
                this.connectBinPositionVariableToMapperUsingCalculator(crtnMapper, (NumericVariable)this.xVariable, this.xValuesType, this.xStep);
                this.connectBinPositionVariableToMapperUsingCalculator(crtnMapperSelected, (NumericVariable)this.xVariableSelected, this.xValuesType, this.xStep);
            }
            if (this.logX) {
                ContinuousRangeToNumericMapper leftMapper = new ContinuousRangeToNumericMapper();
                leftMapper.setMap(crtnMap);
                ContinuousRangeToNumericMapper rightMapper = new ContinuousRangeToNumericMapper();
                rightMapper.setMap(crtnMap);
                if (this.xBinBoundaries != null) {
                    this.connectBinBoundary(leftMapper, rightMapper, (NumericVariable)this.xVariable, this.xBinBoundaries);
                } else {
                    this.connectBinBoundary(leftMapper, rightMapper, (NumericVariable)this.xVariable, this.xValuesType, this.xStep);
                }
                middle = new Calculator("(inA+inB)/2");
                middle.inA.connectFrom((NumericPipe)leftMapper);
                middle.inB.connectFrom((NumericPipe)rightMapper);
                length = new Calculator("inB - inA");
                length.inA.connectFrom((NumericPipe)leftMapper);
                length.inB.connectFrom((NumericPipe)rightMapper);
            }
        }
        if (this.logX) {
            this.chicklet.coordX.connectFrom(middle);
            this.chickletSelected.coordX.connectFrom(middle);
            this.chicklet.sizeX.connectFrom(length);
            this.chickletSelected.sizeX.connectFrom(length);
        } else {
            this.chicklet.coordX.connectFrom(this.xPositionMapper.value);
            this.chickletSelected.coordX.connectFrom(this.xPositionMapperSelected.value);
        }
        return true;
    }

    protected boolean connectYPositionMapper(NumericMap ymap) {
        if (ymap == null) {
            return false;
        }
        Calculator middle = null;
        Calculator length = null;
        if (ymap instanceof StringToNumericMap) {
            StringToNumericMap stnmap = (StringToNumericMap)ymap;
            if (this.yPositionMapper == null || !(this.yPositionMapper instanceof StringToNumericMapper)) {
                this.yPositionMapper = new StringToNumericMapper();
            }
            StringToNumericMapper stnmapper = (StringToNumericMapper)this.yPositionMapper;
            stnmapper.setMap(stnmap);
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.yVariable.formattedValue);
            if (this.yPositionMapperSelected == null || !(this.yPositionMapperSelected instanceof StringToNumericMapper)) {
                this.yPositionMapperSelected = new StringToNumericMapper();
            }
            StringToNumericMapper stnmapperSelected = (StringToNumericMapper)this.yPositionMapperSelected;
            stnmapperSelected.setMap(stnmap);
            stnmapperSelected.input.disconnect();
            stnmapperSelected.input.connectFrom(this.yVariableSelected.formattedValue);
        } else if (ymap instanceof StringToNumberMap) {
            StringToNumberMap stnmap = (StringToNumberMap)ymap;
            if (this.yPositionMapper == null || !(this.yPositionMapper instanceof StringToNumberMapper)) {
                this.yPositionMapper = new StringToNumberMapper();
            }
            StringToNumberMapper stnmapper = (StringToNumberMapper)this.yPositionMapper;
            stnmapper.setMap(stnmap);
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.yVariable.formattedValue);
            if (this.yPositionMapperSelected == null || !(this.yPositionMapperSelected instanceof StringToNumberMapper)) {
                this.yPositionMapperSelected = new StringToNumberMapper();
            }
            StringToNumberMapper stnmapperSelected = (StringToNumberMapper)this.yPositionMapperSelected;
            stnmapperSelected.setMap(stnmap);
            stnmapperSelected.input.disconnect();
            stnmapperSelected.input.connectFrom(this.yVariableSelected.formattedValue);
        } else if (ymap instanceof ContinuousRangeToNumericMap) {
            ContinuousRangeToNumericMap crtnMap = (ContinuousRangeToNumericMap)ymap;
            if (this.yPositionMapper == null || !(this.yPositionMapper instanceof ContinuousRangeToNumericMapper)) {
                this.yPositionMapper = new ContinuousRangeToNumericMapper();
            }
            ContinuousRangeToNumericMapper crtnMapper = (ContinuousRangeToNumericMapper)this.yPositionMapper;
            crtnMapper.setMap(crtnMap);
            crtnMapper.input.disconnect();
            if (this.yPositionMapperSelected == null || !(this.yPositionMapperSelected instanceof ContinuousRangeToNumericMapper)) {
                this.yPositionMapperSelected = new ContinuousRangeToNumericMapper();
            }
            ContinuousRangeToNumericMapper crtnMapperSelected = (ContinuousRangeToNumericMapper)this.yPositionMapperSelected;
            crtnMapperSelected.setMap(crtnMap);
            crtnMapperSelected.input.disconnect();
            if (this.yBinBoundaries != null) {
                if (this.yBinLengthVariable == null) {
                    this.yBinPositionVariable = new NumericVectorVariable();
                    this.yBinPositionVariableSelected = new NumericVectorVariable();
                    this.yBinLengthVariable = new NumericVectorVariable();
                    this.yBinLengthVariableSelected = new NumericVectorVariable();
                }
                if (this.computeBinPositionAndLengthVariables((NumericVariable)this.yVariable, this.yBinPositionVariable, this.yBinLengthVariable, this.yBinBoundaries, this.yGap, this.yPositionMapper)) {
                    this.yBinPositionVariableSelected.connectFrom(this.yBinPositionVariable.value);
                    this.yBinLengthVariableSelected.connectFrom(this.yBinPositionVariable.value);
                    crtnMapper.input.connectFrom(this.yBinPositionVariable.value);
                    crtnMapperSelected.input.connectFrom(this.yBinPositionVariableSelected.value);
                    this.selectionProcessor.removeVariable(this.yVariableSelected);
                    this.selectionProcessor.addVariable((Variable)this.yBinPositionVariableSelected);
                }
            } else {
                this.connectBinPositionVariableToMapperUsingCalculator(crtnMapper, (NumericVariable)this.yVariable, this.yValuesType, this.yStep);
                this.connectBinPositionVariableToMapperUsingCalculator(crtnMapperSelected, (NumericVariable)this.yVariableSelected, this.yValuesType, this.yStep);
            }
            if (this.logY) {
                ContinuousRangeToNumericMapper bottomMapper = new ContinuousRangeToNumericMapper();
                bottomMapper.setMap(crtnMap);
                ContinuousRangeToNumericMapper topMapper = new ContinuousRangeToNumericMapper();
                topMapper.setMap(crtnMap);
                if (this.yBinBoundaries != null) {
                    this.connectBinBoundary(bottomMapper, topMapper, (NumericVariable)this.yVariable, this.yBinBoundaries);
                } else {
                    this.connectBinBoundary(bottomMapper, topMapper, (NumericVariable)this.yVariable, this.yValuesType, this.yStep);
                }
                middle = new Calculator("(inA+inB)/2");
                middle.inA.connectFrom((NumericPipe)bottomMapper);
                middle.inB.connectFrom((NumericPipe)topMapper);
                length = new Calculator("inB - inA");
                length.inA.connectFrom((NumericPipe)bottomMapper);
                length.inB.connectFrom((NumericPipe)topMapper);
            }
        }
        if (this.logY) {
            this.chicklet.coordY.connectFrom(middle);
            this.chickletSelected.coordY.connectFrom(middle);
            this.chicklet.sizeY.connectFrom(length);
            this.chickletSelected.sizeY.connectFrom(length);
        } else {
            this.chicklet.coordY.connectFrom(this.yPositionMapper.value);
            this.chickletSelected.coordY.connectFrom(this.yPositionMapperSelected.value);
        }
        return true;
    }

    protected void connectBinPositionVariableToMapperUsingCalculator(ContinuousRangeToNumericMapper crtnMapper, NumericVariable variable, int variableValuesType, double step) {
        switch (variableValuesType) {
            default: {
                crtnMapper.input.connectFrom(variable.value);
                break;
            }
            case 333662: {
                Calculator midpoint = new Calculator("inA+inB/2");
                midpoint.inA.connectFrom(variable.value);
                midpoint.inB.setValue(step);
                crtnMapper.input.connectFrom((NumericPipe)midpoint);
                break;
            }
            case 333663: {
                Calculator midpoint = new Calculator("inA-inB/2");
                midpoint.inA.connectFrom(variable.value);
                midpoint.inB.setValue(step);
                crtnMapper.input.connectFrom((NumericPipe)midpoint);
            }
        }
    }

    protected void connectBinBoundary(ContinuousRangeToNumericMapper lowerMapper, ContinuousRangeToNumericMapper upperMapper, NumericVariable variable, int variableValuesType, double step) {
        switch (variableValuesType) {
            default: {
                Calculator lower = new Calculator("inA-inB/2");
                lower.inA.connectFrom(variable.value);
                lower.inB.setValue(step);
                lowerMapper.input.connectFrom((NumericPipe)lower);
                Calculator upper = new Calculator("inA+inB/2");
                upper.inA.connectFrom(variable.value);
                upper.inB.setValue(step);
                upperMapper.input.connectFrom((NumericPipe)upper);
                break;
            }
            case 333662: {
                lowerMapper.input.connectFrom(variable.value);
                Calculator upper = new Calculator("inA+inB");
                upper.inA.connectFrom(variable.value);
                upper.inB.setValue(step);
                upperMapper.input.connectFrom((NumericPipe)upper);
                break;
            }
            case 333663: {
                Calculator lower = new Calculator("inA-inB");
                lower.inA.connectFrom(variable.value);
                lower.inB.setValue(step);
                lowerMapper.input.connectFrom((NumericPipe)lower);
                upperMapper.input.connectFrom(variable.value);
            }
        }
    }

    protected void connectBinBoundary(ContinuousRangeToNumericMapper lowerMapper, ContinuousRangeToNumericMapper upperMapper, NumericVariable numericVariable, double[] binBoundaries) {
        int numberOfValues = numericVariable.getValueCount();
        double[] lowerpoint = new double[numberOfValues];
        double[] upperpoint = new double[numberOfValues];
        for (int i = 0; i < numberOfValues; ++i) {
            double val = Double.NaN;
            try {
                val = numericVariable.value.getValue(i);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            int binIndex = this.getBinIndex(binBoundaries, val);
            lowerpoint[i] = this.getLowerPoint(binBoundaries, binIndex);
            upperpoint[i] = this.getUpperPoint(binBoundaries, binIndex);
        }
        NumericVectorVariable binLowerPositionVariable = new NumericVectorVariable();
        NumericVectorVariable binUpperPositionVariable = new NumericVectorVariable();
        binLowerPositionVariable.connectFrom(lowerpoint);
        binUpperPositionVariable.connectFrom(upperpoint);
        lowerMapper.input.connectFrom(binLowerPositionVariable.value);
        upperMapper.input.connectFrom(binUpperPositionVariable.value);
    }

    protected boolean computeBinPositionAndLengthVariables(NumericVariable numericVariable, NumericVectorVariable binPositionVariable, NumericVectorVariable binLengthVariable, double[] binBoundaries, double axisGap, NumericMapper mapper) {
        if (binPositionVariable == null || binLengthVariable == null || binBoundaries == null || binBoundaries.length < 1) {
            return false;
        }
        binPositionVariable.disconnect();
        binLengthVariable.disconnect();
        double[] midpoint = new double[numericVariable.getValueCount()];
        double[] binLength = new double[numericVariable.getValueCount()];
        int numberOfValues = numericVariable.getValueCount();
        ContinuousRangeToNumericMapper m = (ContinuousRangeToNumericMapper)mapper;
        double mapperMultiplier = (m.getOutputMax() - m.getOutputMin()) / (m.getInputMax() - m.getInputMin());
        for (int i = 0; i < numberOfValues; ++i) {
            double val = Double.NaN;
            try {
                val = numericVariable.value.getValue(i);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            int binIndex = this.getBinIndex(binBoundaries, val);
            midpoint[i] = this.getMidPoint(binBoundaries, binIndex);
            binLength[i] = this.getBinSize(binBoundaries, binIndex) * mapperMultiplier - 2.0 * axisGap;
        }
        binPositionVariable.connectFrom(midpoint);
        binLengthVariable.connectFrom(binLength);
        return true;
    }

    private double getBinSize(double[] boundaries, int binIndex) {
        if (boundaries == null || binIndex < 0 || binIndex >= boundaries.length - 1) {
            return Double.NaN;
        }
        return boundaries[binIndex + 1] - boundaries[binIndex];
    }

    private double getMidPoint(double[] boundaries, int binIndex) {
        if (boundaries == null || binIndex < 0 || binIndex >= boundaries.length) {
            return Double.NaN;
        }
        return (boundaries[binIndex] + boundaries[binIndex + 1]) / 2.0;
    }

    private double getLowerPoint(double[] boundaries, int binIndex) {
        if (boundaries == null || binIndex < 0 || binIndex >= boundaries.length) {
            return Double.NaN;
        }
        return boundaries[binIndex];
    }

    private double getUpperPoint(double[] boundaries, int binIndex) {
        if (boundaries == null || binIndex < 0 || binIndex >= boundaries.length) {
            return Double.NaN;
        }
        return boundaries[binIndex + 1];
    }

    private int getBinIndex(double[] boundaries, double value) {
        if (boundaries == null) {
            return -1;
        }
        if (boundaries.length < 2) {
            return 0;
        }
        for (int i = 0; i < boundaries.length - 1; ++i) {
            if (!(boundaries[i] <= value) || !(value < boundaries[i + 1])) continue;
            return i;
        }
        if (boundaries[boundaries.length - 1] == value) {
            return boundaries.length - 2;
        }
        return -1;
    }

    public boolean connectColorMapper(ColorMap colormap, RangeAttrMapper rangeAttrMapper, DiscreteAttrMapper discreteAttrMapper) {
        if (colormap == null) {
            return false;
        }
        if (colormap instanceof StringToColorMap) {
            StringToColorMap stcmap = (StringToColorMap)colormap;
            if (this.colorMapper == null || !(this.colorMapper instanceof StringToColorMapper)) {
                this.colorMapper = new StringToColorMapper();
            }
            StringToColorMapper stcmapper = (StringToColorMapper)this.colorMapper;
            stcmapper.input.disconnect();
            stcmapper.input.connectFrom(this.colorVariable.formattedValue);
            stcmapper.setMap(stcmap);
            if (discreteAttrMapper != null) {
                discreteAttrMapper.variable = this.colorVariable.formattedValue;
                discreteAttrMapper.fillColorMapper = stcmapper;
                discreteAttrMapper.lineColorMapper = stcmapper;
                this.chicklet.color.connectFrom(discreteAttrMapper.fillColor);
            } else {
                this.chicklet.color.connectFrom(stcmapper.value);
            }
        } else if (rangeAttrMapper != null && colormap instanceof ContinuousRangeToColorMap) {
            rangeAttrMapper.variable = ((NumericVariable)this.colorVariable).value;
            this.chicklet.color.connectFrom(rangeAttrMapper.color);
        } else if (colormap instanceof ContinuousRangeToColorMap) {
            ContinuousRangeToColorMap crtcmap = (ContinuousRangeToColorMap)colormap;
            if (this.missingColor != null) {
                crtcmap.setReplaceMissingValues(true);
                crtcmap.setMissingReplacement(this.missingColor);
            }
            if (this.colorMapper == null || !(this.colorMapper instanceof ContinuousRangeToColorMapper)) {
                this.colorMapper = new ContinuousRangeToColorMapper();
            }
            ContinuousRangeToColorMapper crtcmapper = (ContinuousRangeToColorMapper)this.colorMapper;
            crtcmapper.input.disconnect();
            crtcmapper.input.connectFrom(((NumericVariable)this.colorVariable).value);
            crtcmapper.setMap(crtcmap);
            this.chicklet.color.connectFrom(crtcmapper.value);
        }
        return true;
    }

    protected boolean connectLengthVariable(NumericVectorVariable lengthVariable, NumericVectorVariable lengthVariableSelected, NumericMapper axisMapper, double axisStep, double axisGap, NumericProperty chickletAxisLength, NumericProperty chickletAxisLengthSelected, double discreteChickletWidth) {
        if (axisMapper instanceof StringToNumericMapper) {
            StringToNumericMapper m = (StringToNumericMapper)axisMapper;
            if (m.getUniqueValueCount() >= 1) {
                double chickletWidthTemp = Math.abs(m.getStrideValue());
                if (chickletWidthTemp > 2.0 * axisGap) {
                    chickletWidthTemp -= 2.0 * axisGap;
                }
                chickletAxisLength.setValue(chickletWidthTemp);
                chickletAxisLengthSelected.setValue(chickletWidthTemp);
            }
        } else if (axisMapper instanceof StringToNumberMapper) {
            double chickletWidthTemp = discreteChickletWidth;
            if (chickletWidthTemp > 2.0 * axisGap) {
                chickletWidthTemp -= 2.0 * axisGap;
            }
            chickletAxisLength.setValue(chickletWidthTemp);
            chickletAxisLengthSelected.setValue(chickletWidthTemp);
        } else if (axisMapper instanceof ContinuousRangeToNumericMapper) {
            ContinuousRangeToNumericMapper m = (ContinuousRangeToNumericMapper)axisMapper;
            if (lengthVariable != null) {
                lengthVariableSelected.connectFrom(lengthVariable.value);
                this.selectionProcessor.addVariable((Variable)lengthVariableSelected);
                chickletAxisLength.connectFrom(lengthVariable.value);
                chickletAxisLengthSelected.connectFrom(lengthVariableSelected.value);
            } else {
                double chickletWidthTemp;
                double step = axisStep;
                if (step == 0.0) {
                    step = 1.0;
                }
                chickletAxisLength.setValue(chickletWidthTemp -= (chickletWidthTemp = Math.abs((m.getOutputMax() - m.getOutputMin()) / ((m.getInputMax() - m.getInputMin()) / step))) > 2.0 * axisGap ? 2.0 * axisGap : 0.0);
                chickletAxisLengthSelected.setValue(chickletWidthTemp);
            }
        }
        return true;
    }

    private double computeStep(NumericVariable var) {
        Object o;
        NumericVariable v = new NumericVariable();
        v.connectFrom(var);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)v);
        vp.setSort((Variable)v, 1);
        double step = Double.POSITIVE_INFINITY;
        double prev = Double.NaN;
        int numberOfValues = v.getValueCount();
        for (int start = 0; start < numberOfValues && (!((o = Variable.getValue((Variable)v, (int)start, (boolean)false)) instanceof Number) || Double.isNaN(prev = ((Number)o).doubleValue())); ++start) {
        }
        for (int i = start + 1; i < numberOfValues; ++i) {
            double val1;
            Object o2 = Variable.getValue((Variable)v, (int)i, (boolean)false);
            if (!(o2 instanceof Number) || Double.isNaN(val1 = ((Number)o2).doubleValue()) || prev == val1) continue;
            step = Math.min(step, val1 - prev);
            prev = val1;
        }
        vp.removeAllVariables();
        vp = null;
        if (step == Double.POSITIVE_INFINITY) {
            step = 0.0;
        }
        return step;
    }

    public DataRange adjustRange(DataRange range, byte dim) {
        DataRange adjustedRange = null;
        switch (dim) {
            case 1: {
                adjustedRange = this.adjustRange(range, this.xValuesType, this.xBinAxis, this.xEndLabels, this.xStep, this.xBinBoundaries);
                break;
            }
            case 2: {
                adjustedRange = this.adjustRange(range, this.yValuesType, this.yBinAxis, this.yEndLabels, this.yStep, this.yBinBoundaries);
                break;
            }
            default: {
                adjustedRange = range;
            }
        }
        return adjustedRange;
    }

    protected DataRange adjustRange(DataRange range, int values, boolean binAxis, boolean endLabels, double step, double[] boundaries) {
        if (range == null || !(range instanceof ContinuousRange)) {
            return range;
        }
        DataRange adjustedRange = null;
        double min = ((ContinuousRange)range).getMin();
        double max = ((ContinuousRange)range).getMax();
        if (boundaries != null && boundaries.length > 1) {
            if (binAxis) {
                CustomBinnedRange cbr = new CustomBinnedRange(boundaries);
                cbr.setEndLabels(endLabels);
                adjustedRange = cbr;
            } else {
                adjustedRange = new ContinuousRange(boundaries[0], boundaries[boundaries.length - 1]);
            }
        } else if (binAxis) {
            SimpleBinnedRange sbr = new SimpleBinnedRange();
            sbr.setEndLabels(endLabels);
            sbr.setBinSize(step);
            switch (values) {
                default: {
                    sbr.setFirstMidpoint(min);
                    sbr.setLastMidpoint(max);
                    break;
                }
                case 333662: {
                    sbr.setFirstMidpoint(min + step / 2.0);
                    sbr.setLastMidpoint(max + step / 2.0);
                    break;
                }
                case 333663: {
                    sbr.setFirstMidpoint(min - step / 2.0);
                    sbr.setLastMidpoint(max - step / 2.0);
                }
            }
            adjustedRange = sbr;
        } else {
            switch (values) {
                default: {
                    min -= step / 2.0;
                    max += step / 2.0;
                    break;
                }
                case 333662: {
                    max += step;
                    break;
                }
                case 333663: {
                    min -= step;
                }
            }
            adjustedRange = new ContinuousRange(min, max);
        }
        if (binAxis) {
            ContinuousRange cr = new ContinuousRange(adjustedRange);
            adjustedRange.setDual(cr);
        }
        return adjustedRange;
    }

    public FillAttrs getFillAttrs() {
        return this.fillAttrs;
    }

    public void setFillAttrs(FillAttrs fillAttrs) {
        this.fillAttrs = fillAttrs;
    }

    public LineAttrs getOutlineAttrs() {
        return this.outlineAttrs;
    }

    public void setOutlineAttrs(LineAttrs outlineAttrs) {
        this.outlineAttrs = outlineAttrs;
    }

    public boolean isXBinAxis() {
        return this.xBinAxis;
    }

    public void setXBinAxis(boolean binAxis) {
        this.xBinAxis = binAxis;
    }

    public boolean isXEndLabels() {
        return this.xEndLabels;
    }

    public void setXEndLabels(boolean endLabels) {
        this.xEndLabels = endLabels;
    }

    public int getXValues() {
        return this.xValuesType;
    }

    public void setXValues(int values) {
        this.xValuesType = values;
    }

    public boolean isYBinAxis() {
        return this.yBinAxis;
    }

    public void setYBinAxis(boolean binAxis) {
        this.yBinAxis = binAxis;
    }

    public boolean isYEndLabels() {
        return this.yEndLabels;
    }

    public void setYEndLabels(boolean endLabels) {
        this.yEndLabels = endLabels;
    }

    public int getYValues() {
        return this.yValuesType;
    }

    public void setYValues(int values) {
        this.yValuesType = values;
    }

    public double getXGap() {
        return this.xGap;
    }

    public void setXGap(double gap) {
        this.xGap = gap;
    }

    public boolean showOutline() {
        return this.showChickletOutlines;
    }

    public void setShowOutline(boolean b) {
        this.showChickletOutlines = b;
    }

    public double getYGap() {
        return this.yGap;
    }

    public void setYGap(double gap) {
        this.yGap = gap;
    }

    public void setDisplayMode(String mode) {
        if (mode.length() == 0) {
            return;
        }
        if (mode.equalsIgnoreCase("standard")) {
            this.showChickletOutlines = false;
        } else if (mode.equalsIgnoreCase("all")) {
            this.showChickletOutlines = true;
        } else {
            this.showChickletOutlines = false;
            StringTokenizer st = new StringTokenizer(mode);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!"Outline".equalsIgnoreCase(token)) continue;
                this.showChickletOutlines = true;
            }
        }
    }

    public double[] getXBoundaries() {
        return this.xBinBoundaries;
    }

    public void setXBoundaries(double[] boundaries) {
        this.xBinBoundaries = boundaries;
    }

    public double[] getYBoundaries() {
        return this.yBinBoundaries;
    }

    public void setYBoundaries(double[] boundaries) {
        this.yBinBoundaries = boundaries;
    }

    public double getXStep() {
        return this.xStep;
    }

    public void setXStep(double step) {
        this.xStep = step;
    }

    public double getYStep() {
        return this.yStep;
    }

    public void setYStep(double step) {
        this.yStep = step;
    }

    public LegendItem[] getLegendItems(StringVariable scVar, int attrType, DiscreteAttrMapper discreteAttrMapper, HashMap colorMap) {
        Vector<LegendItem> legendItems = new Vector<LegendItem>();
        if (this.colorVariable instanceof StringVectorVariable) {
            if (discreteAttrMapper != null) {
                discreteAttrMapper.variable = scVar.formattedValue;
            }
            if (scVar != null) {
                for (int i = 0; i < scVar.getUniqueValueCount(); ++i) {
                    try {
                        Color col;
                        int idx = scVar.getFirstOccurringValueIndex(i);
                        String value = scVar.formattedValue.getValue(idx);
                        LegendItem item = new LegendItem(3, value);
                        Color c = (Color)colorMap.get(value);
                        if (discreteAttrMapper != null && (col = discreteAttrMapper.fillColor.getValue(idx)) != null) {
                            c = col;
                        }
                        item.getSymbolAttrs().setColor(c);
                        if (this.showChickletOutlines) {
                            item.setSecondarySymbolAttrs((ColorAttr)this.outlineAttrs);
                        }
                        legendItems.add(item);
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            }
        }
        if (legendItems.size() > 0) {
            return legendItems.toArray(new LegendItem[legendItems.size()]);
        }
        return null;
    }

    public void setDiscreteChickletXWidth(double discreteChickletXWidth) {
        this.discreteChickletXWidth = discreteChickletXWidth;
    }

    public void setDiscreteChickletYWidth(double discreteChickletYWidth) {
        this.discreteChickletYWidth = discreteChickletYWidth;
    }

    public Color getMissingColor() {
        return this.missingColor;
    }

    public void setMissingColor(Color missingColor) {
        this.missingColor = missingColor;
    }

    public double getXBinSize() {
        return this.xBinSize;
    }

    public void setXBinSize(double xBinSize) {
        this.xBinSize = xBinSize;
    }

    public double getYBinSize() {
        return this.yBinSize;
    }

    public void setYBinSize(double yBinSize) {
        this.yBinSize = yBinSize;
    }
}

