/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.dendrogram;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DendrogramTreeNode
implements MutableTreeNode {
    private DendrogramTreeNode parent = null;
    private Vector children;
    private Object id;
    private String label;
    private double height;
    private double weight = Double.NaN;
    private int[] sortedIndex;
    private int[] reverseSortedIndex;
    private int numberOfClusters = 0;

    public DendrogramTreeNode() {
        this.children = new Vector();
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (child instanceof DendrogramTreeNode) {
            this.children.insertElementAt(child, index);
        }
    }

    @Override
    public void remove(int index) {
        this.remove((DendrogramTreeNode)this.children.elementAt(index));
    }

    @Override
    public void remove(MutableTreeNode node) {
        if (this.children.contains(node)) {
            DendrogramTreeNode gtn = (DendrogramTreeNode)node;
            this.children.remove(gtn);
            gtn.setParent(null);
        }
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setUserObject(Object object) {
    }

    public Enumeration children() {
        return this.children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.elementAt(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(MutableTreeNode parent) {
        if (parent instanceof DendrogramTreeNode) {
            this.parent = (DendrogramTreeNode)parent;
        }
    }

    public void addChild(DendrogramTreeNode child) {
        if (child != null) {
            this.children.add(child);
            child.setParent(this);
        }
    }

    public void removeChild(DendrogramTreeNode child) {
        this.children.remove(child);
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public DendrogramTreeNode[] getLeafOrder() {
        if (this.isLeaf()) {
            return new DendrogramTreeNode[]{this};
        }
        Vector<DendrogramTreeNode> leaves = new Vector<DendrogramTreeNode>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            DendrogramTreeNode child = (DendrogramTreeNode)this.getSortedChildAt(i);
            if (child.isLeaf()) {
                leaves.add(child);
                continue;
            }
            DendrogramTreeNode[] lo = child.getLeafOrder();
            if (lo == null || lo.length <= 0) continue;
            for (int j = 0; j < lo.length; ++j) {
                leaves.add(lo[j]);
            }
        }
        DendrogramTreeNode[] leafOrder = new DendrogramTreeNode[leaves.size()];
        for (int i = 0; i < leaves.size(); ++i) {
            leafOrder[i] = (DendrogramTreeNode)leaves.elementAt(i);
        }
        return leafOrder;
    }

    public void sort(int order) {
        int i;
        if (this.isLeaf()) {
            return;
        }
        for (i = 0; i < this.getChildCount(); ++i) {
            ((DendrogramTreeNode)this.getChildAt(i)).sort(order);
        }
        this.initSortIndices();
        switch (order) {
            case 0: {
                break;
            }
            case -1: 
            case 1: {
                for (i = 0; i < this.getChildCount() - 1; ++i) {
                    for (int j = 0; j < this.getChildCount() - (i + 1); ++j) {
                        this.checkAndSwap(j, j + 1, order, this.sortedIndex);
                    }
                }
                for (i = 0; i < this.getChildCount(); ++i) {
                    this.reverseSortedIndex[this.sortedIndex[i]] = i;
                }
                break;
            }
        }
    }

    private void checkAndSwap(int index1, int index2, int order, int[] sortedIndex) {
        DendrogramTreeNode gtn1 = (DendrogramTreeNode)this.getChildAt(index1);
        DendrogramTreeNode gtn2 = (DendrogramTreeNode)this.getChildAt(index2);
        switch (order) {
            case 1: {
                if (this.compare(gtn1.getWeight(), gtn2.getWeight()) <= 0) break;
                this.swap(index1, index2, sortedIndex);
                break;
            }
            case -1: {
                if (this.compare(gtn1.getWeight(), gtn2.getWeight()) >= 0) break;
                this.swap(index1, index2, sortedIndex);
            }
        }
    }

    private int compare(double v1, double v2) {
        if (Double.isNaN(v1)) {
            return -1;
        }
        if (Double.isNaN(v2)) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        if (v1 > v2) {
            return 1;
        }
        return 0;
    }

    private void swap(int index1, int index2, int[] sortedIndex) {
        int temp = sortedIndex[index1];
        sortedIndex[index1] = sortedIndex[index2];
        sortedIndex[index2] = temp;
    }

    private void initSortIndices() {
        if (this.sortedIndex == null || this.sortedIndex.length != this.getChildCount()) {
            this.sortedIndex = new int[this.getChildCount()];
        }
        if (this.reverseSortedIndex == null || this.reverseSortedIndex.length != this.getChildCount()) {
            this.reverseSortedIndex = new int[this.getChildCount()];
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.sortedIndex[i] = this.reverseSortedIndex[i] = i;
        }
    }

    public TreeNode getSortedChildAt(int childIndex) {
        if (this.sortedIndex == null) {
            return this.getChildAt(childIndex);
        }
        return (TreeNode)this.children.elementAt(this.sortedIndex[childIndex]);
    }

    public int getSortedIndex(TreeNode node) {
        int index = this.getIndex(node);
        return this.sortedIndex[index];
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void computePosition(LinkedHashMap nodePositionMap, LinkedHashMap nodeChildrenPositionMap) {
        if (!this.isLeaf()) {
            double minPos = Double.POSITIVE_INFINITY;
            double maxPos = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.getChildCount(); ++i) {
                DendrogramTreeNode child = (DendrogramTreeNode)this.getChildAt(i);
                child.computePosition(nodePositionMap, nodeChildrenPositionMap);
                double childPos = ((Number)nodePositionMap.get(child.getId())).doubleValue();
                minPos = Math.min(minPos, childPos);
                maxPos = Math.max(maxPos, childPos);
            }
            double position = (minPos + maxPos) / 2.0;
            nodePositionMap.put(this.getId(), new Double(position));
            nodeChildrenPositionMap.put(this.getId(), new double[]{minPos, maxPos});
        }
    }

    public Vector getCutClustersByHeight(double cutHeight, Vector clusters, boolean increasingHeight) {
        if (clusters == null) {
            clusters = new Vector<DendrogramTreeNode>();
        }
        if (increasingHeight) {
            if (this.getHeight() <= cutHeight) {
                clusters.add(this);
            } else {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ((DendrogramTreeNode)this.getChildAt(i)).getCutClustersByHeight(cutHeight, clusters, increasingHeight);
                }
            }
        } else if (this.getHeight() >= cutHeight) {
            clusters.add(this);
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ((DendrogramTreeNode)this.getChildAt(i)).getCutClustersByHeight(cutHeight, clusters, increasingHeight);
            }
        }
        return clusters;
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public void setNumberOfClusters(int numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
    }
}

