/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.bubble;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Ellipse;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.legend.LegendItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class BubbleObject {
    private Variable xVar;
    private Variable yVar;
    private NumericVariable sizeVar;
    private Variable colorVar;
    private Variable dataLabelVar;
    private NumericVariable indexVar;
    protected NumericMapper xMapper;
    protected NumericMapper yMapper;
    protected ContinuousRangeToNumericMapper sizeXMapper;
    protected ContinuousRangeToNumericMapper sizeYMapper;
    protected ColorMapper colorMapper;
    protected ColorMapper outlineColorMapper;
    protected ColorMapper fillPatternColorMapper;
    protected StringToNumberMapper fillPatternMapper;
    protected StringToNumberMapper fillPatternWidthMapper;
    private Channel channel;
    private NetworkRoot root;
    private Ellipse ellipse = null;
    private RasterLabel dataLabel = null;
    private boolean relativeScale = true;
    private FillAttrs fillAttrs = new FillAttrs();
    private LineAttrs outlineAttrs = new LineAttrs();
    private FillPatternAttrs fillPatternAttrs = new FillPatternAttrs();
    private TextAttrs dataLabelAttrs = new TextAttrs();
    private boolean reconnectRequired = false;
    private boolean filled = true;
    private boolean outlined = true;
    private boolean fillPatterned = false;
    private double minBubbleSize = 7.0;
    private double maxBubbleSize = 21.0;
    private int dataLabelPosition = 3;
    public static final int TOP_LEFT = 1;
    public static final int TOP = 2;
    public static final int TOP_RIGHT = 3;
    public static final int LEFT = 4;
    public static final int CENTER = 5;
    public static final int RIGHT = 6;
    public static final int BOTTOM_LEFT = 7;
    public static final int BOTTOM = 8;
    public static final int BOTTOM_RIGHT = 9;
    private static Graphics dummyGraphics = new BufferedImage(1, 1, 1).getGraphics();
    private NumericVariable selectionVar = null;
    private boolean overrideFillColor = false;
    private boolean overrideOutlineColor = false;
    private boolean overrideOutlinePattern = false;
    private boolean overrideFillPattern = false;
    private boolean overrideFillPatternColor = false;
    private boolean overrideDataLabelColor = false;
    private Image skin;
    private Image[] pixelBenderImages;
    private Image[] legendPixelBenderImages;
    private int skinType;
    private float DPIScaleFactor = 1.0f;
    public static final int SCALE_AREA = 1;
    public static final int SCALE_RADIUS = 2;
    private int scale = 1;
    private double sizeMin = 0.0;
    private double sizeMax = 0.0;
    protected double stippleScaleFactor = 1.0;
    public static int SPLIT_JUSTIFY_AUTO = 0;
    public static int SPLIT_JUSTIFY_CENTER = 1;
    public static int SPLIT_JUSTIFY_LEFT = 2;
    public static int SPLIT_JUSTIFY_RIGHT = 3;
    private int dataLabelSplitJustify = SPLIT_JUSTIFY_AUTO;
    private boolean dataLabelSplit = false;
    private char[] dataLabelSplitChar = new char[]{' '};
    private boolean dataLabelSplitCharDrop = true;
    private StringVector splitDataLabelPipe;
    private NumericVector splitDataLabelWidth;
    private double splitDataLabelMaximumHeight;
    public static final int RELATIVE_SCALE_TYPE_LINEAR = 1;
    public static final int RELATIVE_SCALE_TYPE_PROPORTIONAL = 2;
    private int relativeScaleType = 1;
    private double sizeThresholdMax = Double.NaN;

    public BubbleObject() {
        this.ellipse = new Ellipse();
        this.ellipse.selectEnabled.setValue(true);
        this.ellipse.selectDetailEnabled.setValue(true);
        this.dataLabel = new RasterLabel();
    }

    public void setChannel(Channel aChannel) {
        if (aChannel == null) {
            return;
        }
        this.channel = aChannel;
        this.createNetwork();
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected void createNetwork() {
        this.root = new NetworkRoot(this.channel);
    }

    public NetworkRoot getNetworkRoot() {
        return this.root;
    }

    public Ellipse getEllipseElement() {
        return this.ellipse;
    }

    public void select() {
        if (this.root == null) {
            return;
        }
        this.root.draw(this.root.getChannel(), true);
    }

    public void draw() {
        if (!this.allRequiredVariablesAreValid()) {
            return;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.ellipse.highlightOn.setValue(false);
        this.root.draw();
        this.channel.glPopAttrib();
    }

    public void drawSelections() {
        if (!this.allRequiredVariablesAreValid()) {
            return;
        }
        if (this.selectionVar == null || !this.selectionVar.isConnected()) {
            return;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.ellipse.highlightOn.connectFrom(this.selectionVar.value);
        this.ellipse.setHighlightWidth(2);
        this.ellipse.setHighlightOnly(true);
        this.root.draw();
        this.ellipse.setHighlightOnly(false);
        this.channel.glPopAttrib();
    }

    private boolean allRequiredVariablesAreValid() {
        return this.root != null && this.channel != null && this.xVar != null && this.xVar.isConnected() && this.yVar != null && this.yVar.isConnected() && this.sizeVar != null && this.sizeVar.isConnected();
    }

    public void setFillPatternMapper(StringToNumberMapper mapper) {
        this.fillPatternMapper = mapper;
    }

    public void setFillPatternWidthMapper(StringToNumberMapper mapper) {
        this.fillPatternWidthMapper = mapper;
    }

    public void setFillPatternColorMapper(ColorMapper mapper) {
        this.fillPatternColorMapper = mapper;
    }

    public boolean connectNetwork(NumericMap xmap, NumericMap ymap, ColorMap fillColorMap, ColorMap outlineColorMap, ColorMap dataLabelColorMap, RangeAttrMapper rangeAttrMapper, DiscreteAttrMapper discreteAttrMapper, HashMap lineStyleMap, Probe probe) {
        if (!this.allRequiredVariablesAreValid()) {
            return false;
        }
        this.root.removeAllElements();
        boolean rc = this.connectXMapper(xmap);
        rc &= this.connectYMapper(ymap);
        if (!(rc &= this.connectSizeMappers(xmap, ymap))) {
            return false;
        }
        if (fillColorMap != null || outlineColorMap != null) {
            rc = this.connectColorMapper(fillColorMap, outlineColorMap, rangeAttrMapper, discreteAttrMapper);
        } else {
            this.colorMapper = null;
            this.outlineColorMapper = null;
        }
        if (probe != null) {
            this.ellipse.setUserData((Object)probe);
        }
        if (this.filled) {
            this.ellipse.fillOn.setValue(this.filled);
            if (fillColorMap == null) {
                Color c = this.getFillAttrs().getColor();
                if (this.fillAttrs.getTransparency() != -1.0) {
                    c = this.adjustTransparency(this.getFillAttrs().getColor(), this.getFillAttrs().getTransparency());
                }
                this.ellipse.color.setValue(c);
            }
            this.ellipse.edgeOn.setValue(this.outlined);
            if (this.overrideOutlineColor || this.colorVar instanceof NumericVariable || outlineColorMap == null) {
                this.ellipse.edgeColor.setValue(this.outlineAttrs.getColor());
            }
            if (discreteAttrMapper != null && discreteAttrMapper.lineThickness.containsKey("outline")) {
                this.ellipse.lineWidth.connectFrom((IntegerPipe)discreteAttrMapper.lineThickness.get("outline"));
            } else {
                this.ellipse.lineWidth.setValue((double)this.getOutlineAttrs().getWidth());
            }
            this.ellipse.stipplePattern.setValue((double)this.getOutlineAttrs().getStipplePattern());
            this.ellipse.stippleFactor.setValue((double)this.getOutlineAttrs().getStippleFactor());
        } else {
            this.ellipse.fillOn.setValue(this.filled);
            if (outlineColorMap == null) {
                this.ellipse.edgeColor.setValue(this.getOutlineAttrs().getColor());
            }
            this.ellipse.edgeOn.setValue(this.outlined);
            if (discreteAttrMapper != null && discreteAttrMapper.lineThickness.containsKey("outline")) {
                this.ellipse.lineWidth.connectFrom((IntegerPipe)discreteAttrMapper.lineThickness.get("outline"));
            } else {
                this.ellipse.lineWidth.setValue((double)this.getOutlineAttrs().getWidth());
            }
            if (this.overrideOutlineColor && !(this.colorVar instanceof NumericVariable)) {
                this.ellipse.edgeColor.setValue(this.outlineAttrs.getColor());
            }
            if (!this.overrideOutlinePattern) {
                if (lineStyleMap != null) {
                    NumericVector nv = new NumericVector();
                    for (int i = 0; i < this.colorVar.getValueCount(); ++i) {
                        LineAttrs la = new LineAttrs();
                        la.setLinePattern(((Integer)lineStyleMap.get(Variable.getValue((Variable)this.colorVar, (int)i, (boolean)true))).intValue());
                        int lp = this.getOutlineAttrs().getStipplePattern();
                        if (la != null) {
                            lp = la.getStipplePattern();
                        }
                        nv.addValue((double)lp);
                    }
                    this.ellipse.stipplePattern.connectFrom((NumericPipe)nv);
                } else {
                    this.ellipse.stipplePattern.setValue((double)this.getOutlineAttrs().getStipplePattern());
                }
                this.ellipse.stippleFactor.setValue((double)this.getOutlineAttrs().getStippleFactor());
            } else {
                if (discreteAttrMapper != null && discreteAttrMapper.lineThickness.containsKey("outline")) {
                    this.ellipse.lineWidth.connectFrom((IntegerPipe)discreteAttrMapper.lineThickness.get("outline"));
                } else {
                    this.ellipse.lineWidth.setValue((double)this.getOutlineAttrs().getWidth());
                }
                this.ellipse.stipplePattern.setValue((double)this.getOutlineAttrs().getStipplePattern());
                this.ellipse.stippleFactor.setValue((double)this.getOutlineAttrs().getStippleFactor());
            }
        }
        if (this.fillPatterned) {
            NumericProperty fillPatternWidth = new NumericProperty();
            IntegerProperty fillPattern = new IntegerProperty();
            if (this.fillPatternMapper != null && !this.overrideFillPattern) {
                fillPattern.connectFrom((NumericPipe)this.fillPatternMapper);
                fillPatternWidth.connectFrom((NumericPipe)this.fillPatternWidthMapper);
            } else {
                int p = this.fillPatternAttrs.getPattern();
                fillPattern.setValue(this.getGLFillPattern(p));
                fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)p));
            }
            ColorProperty fillPatternColor = new ColorProperty();
            if (this.fillPatternColorMapper != null && !this.overrideFillPatternColor) {
                if (this.fillPatternColorMapper instanceof ContinuousRangeToColorMapper) {
                    if (rangeAttrMapper != null) {
                        fillPatternColor.connectFrom(rangeAttrMapper.color);
                    } else {
                        fillPatternColor.connectFrom((ColorPipe)((ContinuousRangeToColorMapper)this.fillPatternColorMapper));
                    }
                } else if (discreteAttrMapper != null) {
                    fillPatternColor.connectFrom((ColorPipe)discreteAttrMapper.lineColor);
                } else {
                    fillPatternColor.connectFrom((ColorPipe)((StringToColorMapper)this.fillPatternColorMapper));
                }
            } else {
                fillPatternColor.setValue(this.adjustTransparency(this.fillPatternAttrs.getColor(), this.fillPatternAttrs.getTransparency()));
            }
            this.ellipse.fillPatternOn.setValue(this.fillPatterned);
            this.ellipse.fillPatternType.connectFrom((IntegerPipe)fillPattern);
            this.ellipse.fillPatternWidth.connectFrom((NumericPipe)fillPatternWidth);
            this.ellipse.fillPatternColor.connectFrom((ColorPipe)fillPatternColor);
            this.ellipse.fillPatternScaleFactor.setValue((double)this.DPIScaleFactor);
        }
        this.ellipse.setStippleScaleFactor(this.stippleScaleFactor);
        this.ellipse.transform.translateX.connectFrom(this.xMapper.value);
        this.ellipse.transform.translateY.connectFrom(this.yMapper.value);
        this.ellipse.transform.scaleX.connectFrom((NumericPipe)this.sizeXMapper);
        this.ellipse.transform.scaleY.connectFrom((NumericPipe)this.sizeYMapper);
        boolean bl = this.reconnectRequired = !rc;
        if (this.reconnectRequired) {
            return false;
        }
        if (this.skin != null) {
            this.ellipse.setSkin(this.skin);
        }
        this.ellipse.setSkinType(this.skinType);
        this.ellipse.setDPIScaleFactor(this.DPIScaleFactor);
        this.ellipse.setPixelBenderImages(this.pixelBenderImages);
        this.root.addElement((Element)this.ellipse);
        if (this.dataLabelVar != null) {
            this.connectDataLabel(xmap, ymap, dataLabelColorMap, rangeAttrMapper, discreteAttrMapper);
            this.root.addElement((Element)this.dataLabel);
        }
        return true;
    }

    private int getGLFillPattern(int pattern) {
        int type = FillPatternAttrs.getPatternType((int)pattern);
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 0: {
                return -1;
            }
        }
        return -1;
    }

    private void connectDataLabel(NumericMap xMap, NumericMap yMap, ColorMap dataLabelColorMap, RangeAttrMapper rangeAttrMapper, DiscreteAttrMapper discreteAttrMapper) {
        Calculator xPos = null;
        Calculator yPos = null;
        switch (this.dataLabelPosition) {
            case 1: {
                xPos = new Calculator("inA-inB");
                yPos = new Calculator("inA+inB");
                xPos.inA.connectFrom((NumericPipe)this.xMapper);
                xPos.inB.connectFrom((NumericPipe)this.sizeXMapper);
                yPos.inA.connectFrom((NumericPipe)this.yMapper);
                yPos.inB.connectFrom((NumericPipe)this.sizeYMapper);
                this.dataLabel.horizontalJustification.setValue(2);
                this.dataLabel.verticalJustification.setValue(1);
                break;
            }
            case 2: {
                xPos = new Calculator("inA+inB");
                yPos = new Calculator("inA+inB");
                xPos.inA.connectFrom((NumericPipe)this.xMapper);
                xPos.inB.setValue(0.0);
                yPos.inA.connectFrom((NumericPipe)this.yMapper);
                yPos.inB.connectFrom((NumericPipe)this.sizeYMapper);
                this.dataLabel.horizontalJustification.setValue(1);
                this.dataLabel.verticalJustification.setValue(3);
                break;
            }
            case 3: {
                xPos = new Calculator("inA+inB");
                yPos = new Calculator("inA+inB");
                xPos.inA.connectFrom((NumericPipe)this.xMapper);
                xPos.inB.connectFrom((NumericPipe)this.sizeXMapper);
                yPos.inA.connectFrom((NumericPipe)this.yMapper);
                yPos.inB.connectFrom((NumericPipe)this.sizeYMapper);
                this.dataLabel.horizontalJustification.setValue(0);
                this.dataLabel.verticalJustification.setValue(1);
                break;
            }
            case 7: {
                xPos = new Calculator("inA-inB");
                yPos = new Calculator("inA-inB");
                xPos.inA.connectFrom((NumericPipe)this.xMapper);
                xPos.inB.connectFrom((NumericPipe)this.sizeXMapper);
                yPos.inA.connectFrom((NumericPipe)this.yMapper);
                yPos.inB.connectFrom((NumericPipe)this.sizeYMapper);
                this.dataLabel.horizontalJustification.setValue(2);
                this.dataLabel.verticalJustification.setValue(1);
                break;
            }
            case 8: {
                xPos = new Calculator("inA+inB");
                yPos = new Calculator("inA-inB");
                xPos.inA.connectFrom((NumericPipe)this.xMapper);
                xPos.inB.setValue(0.0);
                yPos.inA.connectFrom((NumericPipe)this.yMapper);
                yPos.inB.connectFrom((NumericPipe)this.sizeYMapper);
                this.dataLabel.horizontalJustification.setValue(1);
                this.dataLabel.verticalJustification.setValue(0);
                break;
            }
            case 9: {
                xPos = new Calculator("inA+inB");
                yPos = new Calculator("inA-inB");
                xPos.inA.connectFrom((NumericPipe)this.xMapper);
                xPos.inB.connectFrom((NumericPipe)this.sizeXMapper);
                yPos.inA.connectFrom((NumericPipe)this.yMapper);
                yPos.inB.connectFrom((NumericPipe)this.sizeYMapper);
                this.dataLabel.horizontalJustification.setValue(0);
                this.dataLabel.verticalJustification.setValue(1);
                break;
            }
            case 4: {
                xPos = new Calculator("inA-inB");
                yPos = new Calculator("inA+inB");
                xPos.inA.connectFrom((NumericPipe)this.xMapper);
                xPos.inB.connectFrom((NumericPipe)this.sizeXMapper);
                yPos.inA.connectFrom((NumericPipe)this.yMapper);
                yPos.inB.setValue(0.0);
                this.dataLabel.horizontalJustification.setValue(2);
                this.dataLabel.verticalJustification.setValue(1);
                break;
            }
            case 6: {
                xPos = new Calculator("inA+inB");
                yPos = new Calculator("inA+inB");
                xPos.inA.connectFrom((NumericPipe)this.xMapper);
                xPos.inB.connectFrom((NumericPipe)this.sizeXMapper);
                yPos.inA.connectFrom((NumericPipe)this.yMapper);
                yPos.inB.setValue(0.0);
                this.dataLabel.horizontalJustification.setValue(0);
                this.dataLabel.verticalJustification.setValue(1);
                break;
            }
            default: {
                xPos = new Calculator("inA+inB");
                yPos = new Calculator("inA+inB");
                xPos.inA.connectFrom((NumericPipe)this.xMapper);
                xPos.inB.setValue(0.0);
                yPos.inA.connectFrom((NumericPipe)this.yMapper);
                yPos.inB.setValue(0.0);
                this.dataLabel.horizontalJustification.setValue(1);
                this.dataLabel.verticalJustification.setValue(1);
            }
        }
        if (this.dataLabelSplit && this.dataLabelSplitJustify != SPLIT_JUSTIFY_AUTO) {
            this.dataLabel.horizontalJustification.setValue(this.getDataLabelHJustification());
            this.dataLabel.coordX.connectFrom(this.makeDataLabelXOffset((NumericPipe)xPos));
        } else {
            this.dataLabel.coordX.connectFrom((NumericPipe)xPos);
        }
        this.dataLabel.coordY.connectFrom((NumericPipe)yPos);
        StringVectorVariable labelVar = new StringVectorVariable();
        StringVector labels = new StringVector();
        for (int i = 0; i < this.dataLabelVar.getValueCount(); ++i) {
            labels.addValue(((String)Variable.getValue((Variable)this.dataLabelVar, (int)i, (boolean)true)).trim());
        }
        if (this.dataLabelSplit) {
            labelVar.connectFrom((StringPipe)this.splitDataLabelPipe);
        } else {
            labelVar.connectFrom((StringPipe)labels);
        }
        this.dataLabel.string.connectFrom(labelVar.value);
        if (this.dataLabelAttrs.getFont() != null) {
            this.dataLabel.setFont(this.dataLabelAttrs.getFont());
        }
        ColorPipe dataLabelColor = null;
        if (dataLabelColorMap instanceof StringToColorMap) {
            StringToColorMap dl_stcmap = (StringToColorMap)dataLabelColorMap;
            if (dataLabelColorMap != null) {
                StringToColorMapper dl_stcmapper = new StringToColorMapper();
                dl_stcmapper.input.disconnect();
                dl_stcmapper.input.connectFrom(((StringVariable)this.colorVar).formattedValue);
                dl_stcmapper.setMap(dl_stcmap);
                if (discreteAttrMapper != null) {
                    discreteAttrMapper.variable = this.colorVar.formattedValue;
                    discreteAttrMapper.lineColorMapper = dl_stcmapper;
                    dataLabelColor = discreteAttrMapper.lineColor;
                } else {
                    dataLabelColor = dl_stcmapper.value;
                }
            }
        } else if (rangeAttrMapper != null && dataLabelColorMap instanceof ContinuousRangeToColorMap) {
            rangeAttrMapper.variable = ((NumericVariable)this.colorVar).value;
            dataLabelColor = rangeAttrMapper.color;
        } else if (dataLabelColorMap instanceof ContinuousRangeToColorMap) {
            ContinuousRangeToColorMap crtcmap = (ContinuousRangeToColorMap)dataLabelColorMap;
            ContinuousRangeToColorMapper crtcmapper = new ContinuousRangeToColorMapper();
            crtcmapper.input.disconnect();
            crtcmapper.input.connectFrom(((NumericVariable)this.colorVar).value);
            crtcmapper.setMap(crtcmap);
            dataLabelColor = crtcmapper.value;
        }
        if (this.overrideDataLabelColor) {
            this.dataLabel.color.setValue(this.dataLabelAttrs.getColor());
        } else if (rangeAttrMapper != null) {
            this.dataLabel.color.connectFrom(rangeAttrMapper.color);
        } else if (discreteAttrMapper != null) {
            this.dataLabel.color.connectFrom((ColorPipe)discreteAttrMapper.lineColor);
        } else if (dataLabelColor != null) {
            this.dataLabel.color.connectFrom(dataLabelColor);
        } else {
            this.dataLabel.color.setValue(this.dataLabelAttrs.getColor());
        }
    }

    private NumericPipe makeDataLabelXOffset(NumericPipe x) {
        NumericPipe offset = x;
        switch (this.dataLabelPosition) {
            case 2: 
            case 5: 
            case 8: {
                if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_CENTER) break;
                if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_LEFT) {
                    offset = new Calculator("inA-inB/2");
                } else if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_RIGHT) {
                    offset = new Calculator("inA+inB/2");
                }
                ((Calculator)offset).inA.connectFrom(x);
                ((Calculator)offset).inB.connectFrom((NumericPipe)this.splitDataLabelWidth);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_RIGHT) break;
                if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_LEFT) {
                    offset = new Calculator("inA-inB");
                } else if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_CENTER) {
                    offset = new Calculator("inA-inB/2");
                }
                ((Calculator)offset).inA.connectFrom(x);
                ((Calculator)offset).inB.connectFrom((NumericPipe)this.splitDataLabelWidth);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_LEFT) break;
                if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_RIGHT) {
                    offset = new Calculator("inA+inB");
                } else if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_CENTER) {
                    offset = new Calculator("inA+inB/2");
                }
                ((Calculator)offset).inA.connectFrom(x);
                ((Calculator)offset).inB.connectFrom((NumericPipe)this.splitDataLabelWidth);
            }
        }
        return offset;
    }

    private int getDataLabelHJustification() {
        if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_LEFT) {
            return 0;
        }
        if (this.dataLabelSplitJustify == SPLIT_JUSTIFY_RIGHT) {
            return 2;
        }
        return 1;
    }

    private boolean connectXMapper(NumericMap xmap) {
        if (xmap == null) {
            return false;
        }
        if (xmap instanceof StringToNumericMap) {
            if (this.xMapper == null || !(this.xMapper instanceof StringToNumericMapper)) {
                this.xMapper = new StringToNumericMapper();
            }
            StringToNumericMapper stnmapper = (StringToNumericMapper)this.xMapper;
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.xVar.formattedValue);
            stnmapper.setMap((StringToNumericMap)xmap);
            this.relativeScale = true;
        } else if (xmap instanceof StringToNumberMap) {
            if (this.xMapper == null || !(this.xMapper instanceof StringToNumberMapper)) {
                this.xMapper = new StringToNumberMapper();
            }
            StringToNumberMapper stnmapper = (StringToNumberMapper)this.xMapper;
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.xVar.formattedValue);
            stnmapper.setMap((StringToNumberMap)xmap);
            this.relativeScale = true;
        } else if (xmap instanceof ContinuousRangeToNumericMap && this.xVar instanceof NumericVariable) {
            if (this.xMapper == null || !(this.xMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xMapper = new ContinuousRangeToNumericMapper();
            }
            ContinuousRangeToNumericMapper crtnMapper = (ContinuousRangeToNumericMapper)this.xMapper;
            crtnMapper.input.disconnect();
            crtnMapper.input.connectFrom(((NumericVariable)this.xVar).value);
            crtnMapper.setMap((ContinuousRangeToNumericMap)xmap);
        } else {
            return false;
        }
        return true;
    }

    private boolean connectYMapper(NumericMap ymap) {
        if (ymap == null) {
            return false;
        }
        if (ymap instanceof StringToNumericMap) {
            if (this.yMapper == null || !(this.yMapper instanceof StringToNumericMapper)) {
                this.yMapper = new StringToNumericMapper();
            }
            StringToNumericMapper stnmapper = (StringToNumericMapper)this.yMapper;
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.yVar.formattedValue);
            stnmapper.setMap((StringToNumericMap)ymap);
            this.relativeScale = true;
        } else if (ymap instanceof StringToNumberMap) {
            if (this.yMapper == null || !(this.yMapper instanceof StringToNumberMapper)) {
                this.yMapper = new StringToNumberMapper();
            }
            StringToNumberMapper stnmapper = (StringToNumberMapper)this.yMapper;
            stnmapper.input.disconnect();
            stnmapper.input.connectFrom(this.yVar.formattedValue);
            stnmapper.setMap((StringToNumberMap)ymap);
            this.relativeScale = true;
        } else if (ymap instanceof ContinuousRangeToNumericMap) {
            if (this.yMapper == null || !(this.yMapper instanceof ContinuousRangeToNumericMapper)) {
                this.yMapper = new ContinuousRangeToNumericMapper();
            }
            ContinuousRangeToNumericMapper crtnMapper = (ContinuousRangeToNumericMapper)this.yMapper;
            crtnMapper.input.disconnect();
            crtnMapper.input.connectFrom(((NumericVariable)this.yVar).value);
            crtnMapper.setMap((ContinuousRangeToNumericMap)ymap);
        }
        return true;
    }

    private boolean connectSizeMappers(NumericMap xMap, NumericMap yMap) {
        AreaNumericMap anm;
        if (xMap == null || yMap == null) {
            return false;
        }
        if (this.sizeXMapper == null) {
            this.sizeXMapper = new ContinuousRangeToNumericMapper();
        }
        this.sizeXMapper.input.disconnect();
        if (this.scale == 1 && this.relativeScale) {
            anm = new AreaNumericMap();
            anm.setScaleType(this.relativeScaleType);
            this.sizeXMapper.setMap((ContinuousRangeToNumericMap)anm);
        }
        this.sizeXMapper.input.connectFrom(this.sizeVar.value);
        if (this.sizeYMapper == null) {
            this.sizeYMapper = new ContinuousRangeToNumericMapper();
        }
        this.sizeYMapper.input.disconnect();
        if (this.scale == 1 && this.relativeScale) {
            anm = new AreaNumericMap();
            anm.setScaleType(this.relativeScaleType);
            this.sizeYMapper.setMap((ContinuousRangeToNumericMap)anm);
        }
        this.sizeYMapper.input.connectFrom(this.sizeVar.value);
        if (!this.relativeScale && xMap instanceof ContinuousRangeToNumericMap && yMap instanceof ContinuousRangeToNumericMap) {
            ContinuousRangeToNumericMap xm = (ContinuousRangeToNumericMap)xMap;
            double xUnitToPixels = (xm.getOutputMax() - xm.getOutputMin()) / (xm.getInputMax() - xm.getInputMin());
            this.sizeXMapper.setOutputMin(this.sizeMin * xUnitToPixels);
            this.sizeXMapper.setOutputMax(this.sizeMax * xUnitToPixels);
            ContinuousRangeToNumericMap ym = (ContinuousRangeToNumericMap)yMap;
            double yUnitToPixels = (ym.getOutputMax() - ym.getOutputMin()) / (ym.getInputMax() - ym.getInputMin());
            this.sizeYMapper.setOutputMin(this.sizeMin * yUnitToPixels);
            this.sizeYMapper.setOutputMax(this.sizeMax * yUnitToPixels);
        } else {
            this.sizeXMapper.setOutputMin(this.minBubbleSize);
            this.sizeXMapper.setOutputMax(this.maxBubbleSize);
            this.sizeYMapper.setOutputMin(this.minBubbleSize);
            this.sizeYMapper.setOutputMax(this.maxBubbleSize);
        }
        if (this.relativeScale) {
            double sm = Double.isNaN(this.sizeThresholdMax) ? this.sizeMax : this.sizeThresholdMax;
            this.sizeXMapper.setInputMax(sm);
            this.sizeYMapper.setInputMax(sm);
        } else {
            this.sizeXMapper.setInputMax(this.sizeMax);
            this.sizeYMapper.setInputMax(this.sizeMax);
        }
        this.sizeXMapper.setInputMin(this.sizeMin);
        this.sizeYMapper.setInputMin(this.sizeMin);
        this.ellipse.xRadius.setValue(1.0);
        this.ellipse.yRadius.setValue(1.0);
        return true;
    }

    private boolean connectColorMapper(ColorMap fillColorMap, ColorMap lineColorMap, RangeAttrMapper rangeAttrMapper, DiscreteAttrMapper discreteAttrMapper) {
        if (fillColorMap == null && lineColorMap == null) {
            return false;
        }
        if (fillColorMap instanceof StringToColorMap || lineColorMap instanceof StringToColorMap) {
            StringToColorMap fill_stcmap = (StringToColorMap)fillColorMap;
            StringToColorMap outline_stcmap = (StringToColorMap)lineColorMap;
            if (fillColorMap != null) {
                if (this.colorMapper == null || !(this.colorMapper instanceof StringToColorMapper)) {
                    this.colorMapper = new StringToColorMapper();
                }
                StringToColorMapper fill_stcmapper = (StringToColorMapper)this.colorMapper;
                fill_stcmapper.input.disconnect();
                fill_stcmapper.input.connectFrom(((StringVariable)this.colorVar).formattedValue);
                fill_stcmapper.setMap(fill_stcmap);
                if (discreteAttrMapper != null) {
                    discreteAttrMapper.variable = this.colorVar.formattedValue;
                    discreteAttrMapper.fillColorMapper = fill_stcmapper;
                    this.ellipse.color.connectFrom(discreteAttrMapper.fillColor);
                } else {
                    this.ellipse.color.connectFrom(fill_stcmapper.value);
                }
            }
            if (lineColorMap != null) {
                if (this.outlineColorMapper == null || !(this.outlineColorMapper instanceof StringToColorMapper)) {
                    this.outlineColorMapper = new StringToColorMapper();
                }
                StringToColorMapper outline_stcmapper = (StringToColorMapper)this.outlineColorMapper;
                outline_stcmapper.input.disconnect();
                outline_stcmapper.input.connectFrom(((StringVariable)this.colorVar).formattedValue);
                outline_stcmapper.setMap(outline_stcmap);
                if (discreteAttrMapper != null) {
                    discreteAttrMapper.variable = this.colorVar.formattedValue;
                    discreteAttrMapper.lineColorMapper = outline_stcmapper;
                    this.ellipse.edgeColor.connectFrom((ColorPipe)discreteAttrMapper.lineColor);
                } else {
                    this.ellipse.edgeColor.connectFrom(outline_stcmapper.value);
                }
            }
            if (this.overrideFillColor) {
                Color c = this.getFillAttrs().getColor();
                if (this.fillAttrs.getTransparency() != -1.0) {
                    c = this.adjustTransparency(this.getFillAttrs().getColor(), this.getFillAttrs().getTransparency());
                }
                this.ellipse.color.setValue(c);
            }
        } else if (rangeAttrMapper != null && fillColorMap instanceof ContinuousRangeToColorMap) {
            rangeAttrMapper.variable = ((NumericVariable)this.colorVar).value;
            this.ellipse.color.connectFrom(rangeAttrMapper.color);
        } else if (rangeAttrMapper != null && lineColorMap instanceof ContinuousRangeToColorMap) {
            rangeAttrMapper.variable = ((NumericVariable)this.colorVar).value;
            this.ellipse.edgeColor.connectFrom(rangeAttrMapper.color);
        } else if (fillColorMap instanceof ContinuousRangeToColorMap) {
            ContinuousRangeToColorMap crtcmap = (ContinuousRangeToColorMap)fillColorMap;
            if (this.colorMapper == null || !(this.colorMapper instanceof ContinuousRangeToColorMapper)) {
                this.colorMapper = new ContinuousRangeToColorMapper();
            }
            ContinuousRangeToColorMapper crtcmapper = (ContinuousRangeToColorMapper)this.colorMapper;
            crtcmapper.input.disconnect();
            crtcmapper.input.connectFrom(((NumericVariable)this.colorVar).value);
            crtcmapper.setMap(crtcmap);
            this.ellipse.color.connectFrom(crtcmapper.value);
        } else if (lineColorMap instanceof ContinuousRangeToColorMap) {
            ContinuousRangeToColorMap crtcmap = (ContinuousRangeToColorMap)lineColorMap;
            if (this.colorMapper == null || !(this.colorMapper instanceof ContinuousRangeToColorMapper)) {
                this.colorMapper = new ContinuousRangeToColorMapper();
            }
            ContinuousRangeToColorMapper crtcmapper = (ContinuousRangeToColorMapper)this.colorMapper;
            crtcmapper.input.disconnect();
            crtcmapper.input.connectFrom(((NumericVariable)this.colorVar).value);
            crtcmapper.setMap(crtcmap);
            this.ellipse.edgeColor.connectFrom(crtcmapper.value);
        }
        return true;
    }

    public void setDisplayMode(String mode) {
        if (mode.length() == 0) {
            return;
        }
        if (mode.equalsIgnoreCase("standard")) {
            this.outlined = true;
        } else if (mode.equalsIgnoreCase("all")) {
            this.outlined = true;
            this.fillPatterned = true;
        } else {
            this.outlined = false;
            this.filled = false;
            this.fillPatterned = false;
            StringTokenizer st = new StringTokenizer(mode);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("Outline".equalsIgnoreCase(token)) {
                    this.outlined = true;
                    continue;
                }
                if ("Fill".equalsIgnoreCase(token)) {
                    this.filled = true;
                    continue;
                }
                if (!"FillPattern".equalsIgnoreCase(token)) continue;
                this.fillPatterned = true;
            }
        }
    }

    public Variable getXVar() {
        return this.xVar;
    }

    public void setXVar(Variable var) {
        this.xVar = var;
    }

    public Variable getYVar() {
        return this.yVar;
    }

    public void setYVar(Variable var) {
        this.yVar = var;
    }

    public NumericVariable getSizeVar() {
        return this.sizeVar;
    }

    public void setSizeVar(NumericVariable sizeVar) {
        this.sizeVar = sizeVar;
    }

    public Variable getColorVar() {
        return this.colorVar;
    }

    public void setColorVar(Variable colorVar) {
        this.colorVar = colorVar;
    }

    public Variable getDataLabelVar() {
        return this.dataLabelVar;
    }

    public void setDataLabelVar(Variable dataLabelVar) {
        this.dataLabelVar = dataLabelVar;
    }

    public boolean isRelativeScale() {
        return this.relativeScale;
    }

    public void setRelativeScale(boolean relativeScale) {
        this.relativeScale = relativeScale;
    }

    public FillAttrs getFillAttrs() {
        return this.fillAttrs;
    }

    public void setFillAttrs(FillAttrs fillAttrs) {
        this.fillAttrs = fillAttrs;
    }

    public LineAttrs getOutlineAttrs() {
        return this.outlineAttrs;
    }

    public void setOutlineAttrs(LineAttrs outlineAttrs) {
        this.outlineAttrs = outlineAttrs;
    }

    public FillPatternAttrs getFillPatternAttrs() {
        return this.fillPatternAttrs;
    }

    public void setFillPatternAttrs(FillPatternAttrs fillPatternAttrs) {
        this.fillPatternAttrs = fillPatternAttrs;
    }

    public double getMinBubbleSize() {
        return this.minBubbleSize;
    }

    public void setMinBubbleSize(double minBubbleSize) {
        this.minBubbleSize = minBubbleSize;
    }

    public double getMaxBubbleSize() {
        return this.maxBubbleSize;
    }

    public void setMaxBubbleSize(double maxBubbleSize) {
        this.maxBubbleSize = maxBubbleSize;
    }

    public DataRange adjustRange(DataRange range, byte dim) {
        if (!(range instanceof ContinuousRange)) {
            return range;
        }
        ContinuousRange cr = (ContinuousRange)range;
        if (this.relativeScale || this.sizeVar == null) {
            return range;
        }
        DataRange adjustedRange = null;
        switch (dim) {
            case 1: 
            case 2: {
                adjustedRange = new ContinuousRange(cr.getMin() - this.sizeVar.getMax(), cr.getMax() + this.sizeVar.getMax());
                break;
            }
            default: {
                adjustedRange = range;
            }
        }
        return adjustedRange;
    }

    public Insets getPreferredInnerMargin() {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (this.relativeScale) {
            top = bottom = (int)this.maxBubbleSize + 5;
            right = bottom;
            left = bottom;
        }
        if (this.dataLabelVar != null) {
            Font dataLabelFont = this.dataLabelAttrs.getFont();
            if (dataLabelFont == null) {
                dataLabelFont = this.dataLabel.getFont();
            }
            FontMetrics fm = BubbleObject.getFontMetrics(dataLabelFont);
            int maxLabelWidth = this.computeMaxLabelWidth(fm);
            int maxLabelHeight = this.dataLabelSplit ? (int)Math.ceil(this.splitDataLabelMaximumHeight) : fm.getHeight();
            switch (this.dataLabelPosition) {
                case 1: {
                    left += maxLabelWidth;
                    top += maxLabelHeight;
                    break;
                }
                case 2: {
                    left += maxLabelWidth / 2;
                    right += maxLabelWidth / 2;
                    top += maxLabelHeight;
                    break;
                }
                case 3: {
                    right += maxLabelWidth;
                    top += maxLabelHeight;
                    break;
                }
                case 7: {
                    left += maxLabelWidth;
                    bottom += maxLabelHeight;
                    break;
                }
                case 8: {
                    left += maxLabelWidth / 2;
                    right += maxLabelWidth / 2;
                    bottom += maxLabelHeight;
                    break;
                }
                case 9: {
                    right += maxLabelWidth;
                    bottom += maxLabelHeight;
                    break;
                }
                case 4: {
                    left += maxLabelWidth;
                    top += maxLabelHeight / 2;
                    bottom += maxLabelHeight / 2;
                    break;
                }
                case 5: {
                    left += maxLabelWidth / 2;
                    right += maxLabelWidth / 2;
                    top += maxLabelHeight / 2;
                    bottom += maxLabelHeight / 2;
                    break;
                }
                case 6: {
                    right += maxLabelWidth;
                    top += maxLabelHeight / 2;
                    bottom += maxLabelHeight / 2;
                }
            }
        }
        return new Insets(top, left, bottom, right);
    }

    private int computeMaxLabelWidth(FontMetrics fm) {
        if (this.dataLabelVar == null) {
            return 0;
        }
        int maxWidth = 0;
        for (int i = 0; i < this.dataLabelVar.getValueCount(); ++i) {
            try {
                if (this.dataLabelSplit) {
                    maxWidth = Math.max(maxWidth, (int)Math.ceil(this.splitDataLabelWidth.getValue(i)));
                    continue;
                }
                maxWidth = Math.max(maxWidth, fm.stringWidth((String)Variable.getValue((Variable)this.dataLabelVar, (int)i, (boolean)true)));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return maxWidth;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setOutlined(boolean outlined) {
        this.outlined = outlined;
    }

    public boolean isOutlined() {
        return this.outlined;
    }

    public void setFillPatterned(boolean patterned) {
        this.fillPatterned = patterned;
    }

    public boolean isFillPatterned() {
        return this.fillPatterned;
    }

    public int getDataLabelPosition() {
        return this.dataLabelPosition;
    }

    public void setDataLabelPosition(int dataLabelPosition) {
        this.dataLabelPosition = dataLabelPosition;
    }

    public TextAttrs getDataLabelAttrs() {
        return this.dataLabelAttrs;
    }

    public void setDataLabelAttrs(TextAttrs dataLabelAttrs) {
        this.dataLabelAttrs = dataLabelAttrs;
    }

    public static FontMetrics getFontMetrics(Font font) {
        Graphics2D g2d = (Graphics2D)dummyGraphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (font == null) {
            return dummyGraphics.getFontMetrics();
        }
        return dummyGraphics.getFontMetrics(font);
    }

    public NumericVariable getIndexVar() {
        return this.indexVar;
    }

    public void setIndexVar(NumericVariable indexVar) {
        this.indexVar = indexVar;
    }

    public LegendItem getOverlayLegendItem(String legendLabel) {
        LegendItem item = null;
        if (this.isFilled() || this.isFillPatterned()) {
            LineAttrs la = new LineAttrs();
            la.setLinePattern(this.outlineAttrs.getLinePattern());
            la.setWidth(this.outlineAttrs.getWidth());
            la.setColor(this.isOutlined() ? this.outlineAttrs.getColor() : null);
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.fillAttrs.getColor());
            if (this.fillAttrs.getTransparency() != -1.0) {
                fa.setTransparency(this.fillAttrs.getTransparency());
            }
            fa.setColor(this.isFilled() ? this.adjustTransparency(fa.getColor(), fa.getTransparency()) : null);
            item = new LegendItem((ColorAttr)fa, (ColorAttr)la, legendLabel, null, this.skin, this.skinType, this.legendPixelBenderImages);
            item.setFillType(2);
            if (this.fillPatterned) {
                FillPatternAttrs fpAttrs = new FillPatternAttrs();
                fpAttrs.setPattern(this.fillPatternAttrs.getPattern());
                fpAttrs.setColor(this.adjustTransparency(this.fillPatternAttrs.getColor(), this.fillPatternAttrs.getTransparency()));
                item.setFillPatternAttrs(fpAttrs);
            }
        } else if (!this.isFilled() && this.isOutlined()) {
            item = new LegendItem(2, legendLabel);
            item.setSymbolAttrs((ColorAttr)this.getOutlineAttrs());
        }
        return item;
    }

    public LegendItem[] getLegendItems(StringVariable scVar, int attrType, DiscreteAttrMapper discreteAttrMapper, StringToColorMap fillColorMap, StringToColorMap outlineColorMap, HashMap lineStyles, double fillTransparency, double outlineTransparency) {
        return this.getLegendItems(scVar, attrType, discreteAttrMapper, fillColorMap, outlineColorMap, lineStyles, null, null, fillTransparency, outlineTransparency);
    }

    public LegendItem[] getLegendItems(StringVariable scVar, int attrType, DiscreteAttrMapper discreteAttrMapper, StringToColorMap fillColorMap, StringToColorMap outlineColorMap, HashMap lineStyles, StringToColorMap fillPatternColorMap, HashMap fillPatterns, double fillTransparency, double outlineTransparency) {
        Vector<LegendItem> legendItems = new Vector<LegendItem>();
        if (this.colorVar instanceof StringVariable) {
            if (discreteAttrMapper != null) {
                discreteAttrMapper.variable = this.colorVar.formattedValue;
            }
            if (0 == attrType) {
                attrType = this.isFilled() || this.isFillPatterned() ? 11 : 10;
            }
            switch (attrType) {
                case 7: 
                case 11: {
                    if (!this.isFilled() && !this.isFillPatterned() || scVar == null) break;
                    for (int i = 0; i < scVar.getUniqueValueCount(); ++i) {
                        try {
                            Color col;
                            Color col2;
                            Color c;
                            int idx = scVar.getFirstOccurringValueIndex(i);
                            String value = scVar.formattedValue.getValue(idx);
                            FillAttrs fa = new FillAttrs();
                            if (this.isFilled()) {
                                c = fillColorMap.getValue(value);
                                double tr = fillTransparency;
                                if (discreteAttrMapper != null) {
                                    col2 = discreteAttrMapper.getFillColor(value);
                                    if (col2 != null) {
                                        c = col2;
                                    }
                                    if (!discreteAttrMapper.isUseFillTransparency()) {
                                        tr = discreteAttrMapper.getFillTransparency(value);
                                    }
                                }
                                c = this.adjustTransparency(c, tr);
                                fa.setColor(c);
                                if (this.overrideFillColor && !(this.colorVar instanceof NumericVariable)) {
                                    c = this.getFillAttrs().getColor();
                                    if (this.fillAttrs.getTransparency() != -1.0) {
                                        c = this.adjustTransparency(this.getFillAttrs().getColor(), this.getFillAttrs().getTransparency());
                                    }
                                    fa.setColor(c);
                                }
                            } else {
                                fa.setColor(null);
                            }
                            c = outlineColorMap.getValue(value);
                            if (discreteAttrMapper != null && (col = discreteAttrMapper.getLineColor(value)) != null) {
                                c = col;
                            }
                            if (this.overrideOutlineColor) {
                                c = this.outlineAttrs.getColor();
                            }
                            LineAttrs la = new LineAttrs();
                            la.setLinePattern(this.outlineAttrs.getLinePattern());
                            la.setWidth(this.outlineAttrs.getWidth());
                            c = this.adjustTransparency(c, outlineTransparency);
                            la.setColor(this.isOutlined() ? c : null);
                            LegendItem item = new LegendItem((ColorAttr)fa, (ColorAttr)la, value, null, this.skin, this.skinType, this.legendPixelBenderImages);
                            item.setFillType(2);
                            if (this.isFillPatterned()) {
                                c = fillPatternColorMap.getValue(value);
                                if (discreteAttrMapper != null && (col2 = discreteAttrMapper.getLineColor(value)) != null) {
                                    c = col2;
                                }
                                if (this.overrideFillPatternColor) {
                                    c = this.fillPatternAttrs.getColor();
                                }
                                double transparency = this.fillPatternAttrs.getTransparency() >= 0.0 ? this.fillPatternAttrs.getTransparency() : outlineTransparency;
                                c = this.adjustTransparency(c, transparency);
                                int fp = this.overrideFillPattern ? this.fillPatternAttrs.getPattern() : ((Integer)fillPatterns.get(value)).intValue();
                                FillPatternAttrs fpAttrs = new FillPatternAttrs();
                                fpAttrs.setPattern(fp);
                                fpAttrs.setColor(c);
                                item.setFillPatternAttrs(fpAttrs);
                            }
                            legendItems.add(item);
                            continue;
                        }
                        catch (MissingValueException idx) {
                            // empty catch block
                        }
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 10: {
                    if (this.isFilled() || !this.isOutlined() || scVar == null) break;
                    for (int i = 0; i < scVar.getUniqueValueCount(); ++i) {
                        try {
                            Color col;
                            int idx = scVar.getFirstOccurringValueIndex(i);
                            String value = scVar.formattedValue.getValue(idx);
                            LineAttrs la = new LineAttrs();
                            la.setLinePattern(((Integer)lineStyles.get(value)).intValue());
                            Color c = outlineColorMap.getValue(value);
                            if (discreteAttrMapper != null && (col = discreteAttrMapper.getLineColor(value)) != null) {
                                c = col;
                            }
                            c = this.adjustTransparency(c, outlineTransparency);
                            la.setColor(c);
                            LegendItem item = new LegendItem(2, value);
                            if (this.overrideOutlinePattern) {
                                la.setLinePattern(this.getOutlineAttrs().getLinePattern());
                                la.setStipplePattern(this.getOutlineAttrs().getStipplePattern());
                                la.setStippleFactor(this.getOutlineAttrs().getStippleFactor());
                            }
                            if (this.overrideOutlineColor) {
                                la.setColor(this.getOutlineAttrs().getColor());
                            }
                            if (discreteAttrMapper != null && discreteAttrMapper.lineThickness.containsKey("outline")) {
                                int lt = discreteAttrMapper.getLineThickness(value);
                                if (lt < 0) {
                                    lt = this.outlineAttrs.getWidth();
                                }
                                la.setWidth(lt);
                            } else {
                                la.setWidth(this.outlineAttrs.getWidth());
                            }
                            item.setSymbolAttrs((ColorAttr)la);
                            legendItems.add(item);
                            continue;
                        }
                        catch (MissingValueException missingValueException) {
                            // empty catch block
                        }
                    }
                    break;
                }
            }
        }
        if (legendItems.size() > 0) {
            return legendItems.toArray(new LegendItem[legendItems.size()]);
        }
        return null;
    }

    public NumericVariable getSelectionVar() {
        return this.selectionVar;
    }

    public void setSelectionVar(NumericVariable selectionVar) {
        this.selectionVar = selectionVar;
    }

    protected Color adjustTransparency(Color color, double transparency) {
        if (transparency >= 0.0) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * (1.0 - transparency)));
        }
        return color;
    }

    public boolean isFillColorOverride() {
        return this.overrideFillColor;
    }

    public void setFillColorOverride(boolean overrideFillColor) {
        this.overrideFillColor = overrideFillColor;
    }

    public boolean isOutlineColorOverride() {
        return this.overrideOutlineColor;
    }

    public void setOutlineColorOverride(boolean overrideOutlineColor) {
        this.overrideOutlineColor = overrideOutlineColor;
    }

    public boolean isOutlinePatternOverride() {
        return this.overrideOutlinePattern;
    }

    public void setOutlinePatternOverride(boolean overrideOutlinePattern) {
        this.overrideOutlinePattern = overrideOutlinePattern;
    }

    public boolean isFillPatternOverride() {
        return this.overrideFillPattern;
    }

    public void setFillPatternOverride(boolean overrideFillPattern) {
        this.overrideFillPattern = overrideFillPattern;
    }

    public boolean isFillPatternColorOverride() {
        return this.overrideFillPatternColor;
    }

    public void setFillPatternColorOverride(boolean overrideFillPatternColor) {
        this.overrideFillPatternColor = overrideFillPatternColor;
    }

    public void setDataLabelColorOverrride(boolean overrideDataLabelColor) {
        this.overrideDataLabelColor = overrideDataLabelColor;
    }

    public void setSkin(Image img) {
        this.skin = img;
    }

    public Image getSkin() {
        return this.skin;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public void setPixelBenderImages(Image[] imgs) {
        this.pixelBenderImages = imgs;
    }

    public void setLegendPixelBenderImages(Image[] imgs) {
        this.legendPixelBenderImages = imgs;
    }

    public Image[] getLegendPixelBenderImages() {
        return this.legendPixelBenderImages;
    }

    public void setDPIScaleFactor(float fac) {
        this.DPIScaleFactor = fac;
    }

    public double getSizeMin() {
        return this.sizeMin;
    }

    public void setSizeMin(double sizeMin) {
        this.sizeMin = sizeMin;
    }

    public double getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(double sizeMax) {
        this.sizeMax = sizeMax;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setStippleScaleFactor(double fac) {
        this.stippleScaleFactor = fac;
    }

    public double getStippleScaleFactor() {
        return this.stippleScaleFactor;
    }

    public void setDataLabelSplit(boolean split) {
        this.dataLabelSplit = split;
    }

    public boolean isDataLabelSplit() {
        return this.dataLabelSplit;
    }

    public void setDataLabelSplitChar(char[] schars) {
        this.dataLabelSplitChar = schars;
    }

    public char[] getDataLabelSplitChar() {
        return this.dataLabelSplitChar;
    }

    public void setDataLabelSplitCharDrop(boolean b) {
        this.dataLabelSplitCharDrop = b;
    }

    public boolean isDataLabelSplitCharDrop() {
        return this.dataLabelSplitCharDrop;
    }

    public void setDataLabelSplitJustify(int justify) {
        this.dataLabelSplitJustify = justify;
    }

    public int getDataLabelSplitJustify() {
        return this.dataLabelSplitJustify;
    }

    public void setSplitDataLabel(StringVector pipe) {
        this.splitDataLabelPipe = pipe;
    }

    public void setSplitDataLabelWidth(NumericVector pipe) {
        this.splitDataLabelWidth = pipe;
    }

    public void setSplitDataLabelMaximumHeight(double h) {
        this.splitDataLabelMaximumHeight = h;
    }

    public void setRelativeScaleType(int relativeScaleType) {
        this.relativeScaleType = relativeScaleType;
    }

    public void setSizeThresholdMax(double sizeThresholdMax) {
        this.sizeThresholdMax = sizeThresholdMax;
    }

    private class AreaNumericMap
    extends ContinuousRangeToNumericMap {
        int scaleType = 1;

        private AreaNumericMap() {
        }

        public double getValue(double input) {
            switch (this.scaleType) {
                case 2: {
                    return this.getProportionalScaledValue(input);
                }
            }
            return this.getLinearScaledValue(input);
        }

        private double getLinearScaledValue(double input) {
            double mappedValue;
            double denominator = this.inMax - this.inMin;
            if (denominator == 0.0) {
                switch (this.zeroRangeOutput) {
                    default: {
                        mappedValue = this.outMin;
                        break;
                    }
                    case 1: {
                        mappedValue = this.outMax;
                        break;
                    }
                    case 2: {
                        mappedValue = 0.5 * (this.outMin + this.outMax);
                        break;
                    }
                }
            } else {
                if (denominator < 0.0) {
                    return this.outMax;
                }
                double areaMin = this.outMin * this.outMin;
                double areaMax = this.outMax * this.outMax;
                double normalizedValue = (input - this.inMin) / denominator;
                mappedValue = Math.sqrt(areaMin + (areaMax - areaMin) * normalizedValue);
                if (mappedValue > this.outMax) {
                    mappedValue = this.outMax;
                }
            }
            return mappedValue + this.margin;
        }

        private double getProportionalScaledValue(double input) {
            double mappedValue;
            double denominator = this.inMax;
            if (denominator == 0.0) {
                switch (this.zeroRangeOutput) {
                    default: {
                        mappedValue = this.outMin;
                        break;
                    }
                    case 1: {
                        mappedValue = this.outMax;
                        break;
                    }
                    case 2: {
                        mappedValue = 0.5 * (this.outMin + this.outMax);
                        break;
                    }
                }
            } else {
                double areaMin = 0.0;
                double areaMax = this.outMax * this.outMax;
                double minThreshold = this.outMin;
                double maxThreshold = this.outMax;
                double normalizedValue = input / denominator;
                mappedValue = Math.sqrt(areaMin + (areaMax - areaMin) * normalizedValue);
                if (Double.isNaN(mappedValue) || mappedValue < minThreshold) {
                    mappedValue = minThreshold;
                }
                if (mappedValue > maxThreshold) {
                    mappedValue = maxThreshold;
                }
            }
            return mappedValue + this.margin;
        }

        public void setScaleType(int scaleType) {
            this.scaleType = scaleType;
        }
    }
}

