/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.range;

import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.CustomBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;

public class SimpleBinnedRange
extends BinnedRange {
    private double binSize;
    private double firstMidpoint;
    private double lastMidpoint;
    private boolean endLabels = true;
    private boolean updateDual = false;

    public SimpleBinnedRange() {
        this.valid = false;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SimpleBinnedRange)) {
            return false;
        }
        SimpleBinnedRange sbr = (SimpleBinnedRange)o;
        if (!this.equalDR(sbr)) {
            return false;
        }
        if (this.binSize != sbr.binSize) {
            return false;
        }
        if (this.firstMidpoint != sbr.firstMidpoint) {
            return false;
        }
        if (this.lastMidpoint != sbr.lastMidpoint) {
            return false;
        }
        return this.endLabels == sbr.endLabels;
    }

    public SimpleBinnedRange(double size, double first, double last) {
        this.binSize = size;
        this.firstMidpoint = first;
        this.lastMidpoint = last;
    }

    public SimpleBinnedRange(DataRange src) {
        this.copyDR(src);
        if (src instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)src;
            this.lastMidpoint = this.firstMidpoint = (cr.getMin() + cr.getMax()) / 2.0;
            this.binSize = cr.getMax() - cr.getMin();
        } else if (src instanceof DiscreteRange) {
            this.valid = false;
        } else if (src instanceof SimpleBinnedRange) {
            SimpleBinnedRange sbr = (SimpleBinnedRange)src;
            this.firstMidpoint = sbr.firstMidpoint;
            this.lastMidpoint = sbr.lastMidpoint;
            this.binSize = sbr.binSize;
            this.endLabels = sbr.endLabels;
            this.updateDual = sbr.updateDual;
        } else if (src instanceof CustomBinnedRange) {
            CustomBinnedRange cbr = (CustomBinnedRange)src;
            this.lastMidpoint = this.firstMidpoint = (cbr.getMin() + cbr.getMax()) / 2.0;
            this.binSize = cbr.getMax() - cbr.getMin();
        }
    }

    @Override
    public boolean isEndLabels() {
        return this.endLabels;
    }

    @Override
    public void setEndLabels(boolean b) {
        this.endLabels = b;
    }

    @Override
    public Object cloneRange() {
        return new SimpleBinnedRange(this);
    }

    @Override
    public boolean union(DataRange range) {
        if (range instanceof ContinuousRange) {
            int add;
            ContinuousRange cr = (ContinuousRange)range;
            double min = cr.getMin();
            double max = cr.getMax();
            double dist = this.firstMidpoint - this.binSize / 2.0 - min;
            if (dist > 0.0) {
                add = (int)Math.ceil(dist / this.binSize);
                this.firstMidpoint -= (double)add * this.binSize;
            }
            if ((dist = max - (this.lastMidpoint + this.binSize / 2.0)) > 0.0) {
                add = (int)Math.ceil(dist / this.binSize);
                this.lastMidpoint += (double)add * this.binSize;
            }
            this.dual = new ContinuousRange(this);
            if (this.updateDual) {
                ((ContinuousRange)this.dual).setMin(min);
                ((ContinuousRange)this.dual).setMax(max);
            }
        } else if (range instanceof SimpleBinnedRange) {
            SimpleBinnedRange sbr = (SimpleBinnedRange)range;
            if (!this.isMergeableBinnedRange(sbr)) {
                return false;
            }
            this.firstMidpoint = Math.min(this.firstMidpoint, sbr.firstMidpoint);
            this.lastMidpoint = Math.max(this.lastMidpoint, sbr.lastMidpoint);
            this.dual = new ContinuousRange(this);
        } else if (range instanceof CustomBinnedRange) {
            int add;
            CustomBinnedRange cbr = (CustomBinnedRange)range;
            double min = cbr.getMin();
            double max = cbr.getMax();
            double dist = this.firstMidpoint - this.binSize / 2.0 - min;
            if (dist > 0.0) {
                add = (int)Math.ceil(dist / this.binSize);
                this.firstMidpoint -= (double)add * this.binSize;
            }
            if ((dist = max - (this.lastMidpoint + this.binSize / 2.0)) > 0.0) {
                add = (int)Math.ceil(dist / this.binSize);
                this.lastMidpoint += (double)add * this.binSize;
            }
            this.dual = new ContinuousRange(this);
        }
        return true;
    }

    public boolean isMergeableBinnedRange(SimpleBinnedRange r) {
        if (this.binSize != r.binSize) {
            return false;
        }
        double dist = Math.abs(this.firstMidpoint - r.firstMidpoint);
        return dist / this.binSize == (double)((int)(dist / this.binSize));
    }

    @Override
    public boolean contains(DataPoint point) {
        return false;
    }

    @Override
    public String toString() {
        String out = "{";
        int num = (int)((this.lastMidpoint - this.firstMidpoint) / this.binSize) + 1;
        boolean abbrev = num > 3;
        boolean dots = false;
        boolean bin = false;
        for (int i = 0; i < num; ++i) {
            if (abbrev && i > 0 && i < num - 1) {
                if (dots) continue;
                dots = true;
                out = out + ", ...";
                continue;
            }
            double mid = this.firstMidpoint + (double)i * this.binSize;
            if (i != 0) {
                out = out + ", ";
            }
            out = out + (mid - this.binSize / 2.0) + "-" + (mid + this.binSize / 2.0);
        }
        out = out + "}";
        if (this.dual != null) {
            out = out + " = " + this.dual;
        }
        return out;
    }

    public double getBinSize() {
        return this.binSize;
    }

    public void setBinSize(double aBinSize) {
        this.binSize = aBinSize;
    }

    public double getFirstMidpoint() {
        return this.firstMidpoint;
    }

    public void setFirstMidpoint(double aFirstMidpoint) {
        this.firstMidpoint = aFirstMidpoint;
    }

    public double getLastMidpoint() {
        return this.lastMidpoint;
    }

    public void setLastMidpoint(double aLastMidpoint) {
        this.lastMidpoint = aLastMidpoint;
    }

    @Override
    public double getMin() {
        return this.firstMidpoint - this.binSize / 2.0;
    }

    @Override
    public double getMax() {
        return this.lastMidpoint + this.binSize / 2.0;
    }

    public int getNumBins() {
        double factor = (this.lastMidpoint - this.firstMidpoint) / this.binSize;
        return (int)Math.round(factor) + 1;
    }

    @Override
    public void updateDual(boolean update) {
        this.updateDual = update;
    }

    @Override
    public boolean isUpdateDual() {
        return this.updateDual;
    }
}

