/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.range;

import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListenerList;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.StubRange;
import java.util.Vector;

public class RangeMerger
implements RangeChangeListener,
DataRangeInterface,
RangeChangeInterface {
    private byte dimension = 0;
    private boolean enabled = true;
    private Vector inputList = new Vector();
    private DataRange merged;
    private RangeChangeListenerList rcList = new RangeChangeListenerList();

    public void removeAllInputRanges() {
        this.inputList.clear();
    }

    @Override
    public void rangeChanged(RangeChangedEvent e) {
        DataRange range = e.getRange();
        if (e.getDimension() != this.dimension) {
            return;
        }
        if (e.getType() == 1) {
            this.inputList.addElement(range);
        } else if (e.getType() == 2) {
            this.inputList.removeElement(range);
        } else if (e.getType() == 3) {
            int index = this.inputList.indexOf(range);
            this.inputList.removeElement(range);
            if (index >= 0) {
                this.inputList.insertElementAt(e.getNewRange(), index);
            } else {
                this.inputList.addElement(e.getNewRange());
            }
        }
        if (!this.enabled) {
            return;
        }
        this.merge();
    }

    public void addInputRangeToFirst(DataRange range) {
        if (range == null) {
            return;
        }
        this.inputList.insertElementAt(range, 0);
        this.merge();
    }

    public void addInputRange(DataRange range) {
        ContinuousRange cr;
        if (range == null) {
            return;
        }
        if (range instanceof ContinuousRange && (cr = (ContinuousRange)range).getMin() > cr.getMax()) {
            return;
        }
        this.inputList.addElement(range);
        this.merge();
    }

    public void removeInputRange(DataRange range) {
        if (range == null || !this.inputList.contains(range)) {
            return;
        }
        while (this.inputList.contains(range)) {
            this.inputList.removeElement(range);
        }
        this.merge();
    }

    public void replaceInputRange(DataRange oldRange, DataRange newRange) {
        if (oldRange != null && this.inputList != null) {
            for (int i = 0; i < this.inputList.size(); ++i) {
                if (this.inputList.elementAt(i) != oldRange) continue;
                this.inputList.removeElementAt(i);
                break;
            }
        }
        this.addInputRange(newRange);
    }

    public void updateInputRange(DataRange range) {
        if (range == null) {
            return;
        }
        for (int i = 0; i < this.inputList.size(); ++i) {
            ContinuousRange cr;
            DataRange dr = (DataRange)this.inputList.get(i);
            if (range instanceof ContinuousRange) {
                cr = (ContinuousRange)range;
                if (dr instanceof DiscreteRange) continue;
                if (dr instanceof BinnedRange) {
                    ((BinnedRange)dr).updateDual(true);
                    dr = (ContinuousRange)((BinnedRange)dr).getDual();
                }
                ((ContinuousRange)dr).setMin(cr.getMin());
                ((ContinuousRange)dr).setMax(cr.getMax());
                continue;
            }
            if (range instanceof BinnedRange) {
                cr = (ContinuousRange)((BinnedRange)range).getDual();
                if (dr instanceof DiscreteRange) continue;
                if (dr instanceof BinnedRange) {
                    ((BinnedRange)dr).updateDual(true);
                    dr = (ContinuousRange)((BinnedRange)dr).getDual();
                }
                ((ContinuousRange)dr).setMin(cr.getMin());
                ((ContinuousRange)dr).setMax(cr.getMax());
                continue;
            }
            if (!(range instanceof DiscreteRange) || !(dr instanceof DiscreteRange)) continue;
            ((DiscreteRange)dr).setValues(((DiscreteRange)range).getValues());
        }
        this.merge();
    }

    public boolean merge() {
        if (this.merged instanceof StubRange) {
            return true;
        }
        DataRange oldRange = this.merged;
        DataRange newRange = null;
        boolean ok = true;
        if (this.inputList.size() > 0) {
            for (int i = 0; i < this.inputList.size(); ++i) {
                SimpleBinnedRange nsbr;
                SimpleBinnedRange sbr;
                DataRange in = (DataRange)this.inputList.elementAt(i);
                if (in instanceof StubRange) {
                    if (newRange != null) continue;
                    newRange = in;
                    continue;
                }
                if (newRange == null) {
                    newRange = (DataRange)in.cloneRange();
                    continue;
                }
                if (newRange instanceof SimpleBinnedRange && in instanceof SimpleBinnedRange && !(sbr = (SimpleBinnedRange)newRange).isMergeableBinnedRange(nsbr = (SimpleBinnedRange)in)) {
                    sbr.setEndLabels(true);
                    newRange = new ContinuousRange(sbr);
                    nsbr.setEndLabels(true);
                    in = new ContinuousRange(nsbr);
                }
                ok = newRange.union(in) && ok;
            }
        }
        if (newRange != null && newRange.equals(oldRange)) {
            newRange = oldRange;
        }
        this.merged = newRange;
        if (this.rcList.count() > 0) {
            RangeChangedEvent rce = null;
            if (oldRange == null && newRange != null) {
                rce = new RangeChangedEvent(this, 1, newRange, this.dimension);
            } else if (oldRange != null && newRange == null) {
                rce = new RangeChangedEvent(this, 2, oldRange, this.dimension);
            } else if (oldRange != newRange) {
                rce = new RangeChangedEvent(this, 3, oldRange, this.dimension, newRange);
            }
            if (rce != null) {
                this.rcList.rangeChanged(rce);
            }
        }
        return ok;
    }

    public DataRange getOutputRange() {
        return this.merged;
    }

    @Override
    public void removeRangeChangeListener(RangeChangeListener l) {
        this.rcList.remove(l);
    }

    @Override
    public void addRangeChangeListener(RangeChangeListener l) {
        this.rcList.add(l);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (dimension == this.dimension) {
            return this.merged;
        }
        return null;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(byte aDimension) {
        this.dimension = aDimension;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean aEnabled) {
        boolean oldE = this.enabled;
        this.enabled = aEnabled;
        if (this.enabled && !oldE) {
            this.merge();
        }
    }
}

