/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.range;

import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class OrdinalRange
extends DiscreteRange {
    private Map lhm = null;
    private boolean changedToDiscrete = false;
    private boolean dataOrder = true;

    public Map getMap() {
        return this.lhm;
    }

    public OrdinalRange(OrdinalRange src) {
        this.copyDR(src);
        this.lhm = src.getMap() instanceof LinkedHashMap ? new LinkedHashMap(src.getMap()) : new TreeMap(src.getMap());
        this.setValues((Vector)src.getValues().clone());
        this.changedToDiscrete = src.changedToDiscrete;
        this.dataOrder = src.dataOrder;
    }

    public OrdinalRange(Object[] v, Object[] v1) {
        this(v, v1, null, false);
    }

    public OrdinalRange(Object[] v, Object[] v1, String missingReplacement) {
        this(v, v1, missingReplacement, true);
    }

    public OrdinalRange(Object[] v, Object[] v1, String missingReplacement, boolean dataOrder) {
        this.dataOrder = dataOrder;
        this.lhm = new LinkedHashMap();
        int n = v.length;
        for (int i = 0; i < n; ++i) {
            if (v[i] != null && v1[i] != null) {
                this.lhm.put(v1[i], v[i]);
                continue;
            }
            if (missingReplacement == null) continue;
            this.lhm.put(new Double(-1.7976931348623157E308), missingReplacement);
        }
        if (dataOrder) {
            Vector values = new Vector(n);
            Iterator iter = this.lhm.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry;
                Map.Entry e = entry = iter.next();
                Object keyObj = e.getKey();
                Object valObj = e.getValue();
                values.addElement(e.getValue());
            }
            super.setValues(values);
        } else {
            this.sortValues();
        }
    }

    @Override
    public boolean union(DataRange range) {
        if (range instanceof OrdinalRange && !this.changedToDiscrete) {
            OrdinalRange or = (OrdinalRange)range;
            Iterator iter = or.lhm.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry;
                Map.Entry e = entry = iter.next();
                Object keyObj = e.getKey();
                Object valObj = e.getValue();
                if (this.lhm.containsValue(valObj)) continue;
                this.lhm.put(e.getKey(), e.getValue());
            }
            Vector values = new Vector(this.lhm.size());
            iter = this.lhm.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry;
                Map.Entry e = entry = iter.next();
                Object keyObj = e.getKey();
                Object valObj = e.getValue();
                values.addElement(e.getValue());
            }
            super.setValues(values);
            return true;
        }
        if (range instanceof DiscreteRange) {
            if (!this.dataOrder) {
                this.sortValues();
            }
            DiscreteRange dr = (DiscreteRange)range;
            Vector vc = (Vector)dr.getValues().clone();
            int n = vc.size();
            Vector values = this.getValues();
            for (int i = 0; i < n; ++i) {
                Object o = vc.elementAt(i);
                if (values.contains(o)) continue;
                values.addElement(o);
            }
            this.changedToDiscrete = true;
            return true;
        }
        return false;
    }

    @Override
    public Object cloneRange() {
        return new OrdinalRange(this);
    }

    public void sortValues() {
        Object o;
        int i;
        if (this.lhm instanceof TreeMap) {
            return;
        }
        this.lhm = new TreeMap(this.lhm);
        Vector<Object> values = new Vector<Object>(this.lhm.size());
        Iterator iter = this.lhm.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry;
            Map.Entry e = entry = iter.next();
            Object keyObj = e.getKey();
            Object valObj = e.getValue();
            if (this.valuesAtStart.contains(valObj) || this.valuesAtEnd.contains(valObj)) continue;
            values.addElement(e.getValue());
        }
        Enumeration vse = this.valuesAtStart.elements();
        while (vse.hasMoreElements()) {
            this.valuesAtStart.add(vse.nextElement());
        }
        Enumeration vee = this.valuesAtEnd.elements();
        while (vee.hasMoreElements()) {
            this.valuesAtEnd.add(vee.nextElement());
        }
        for (i = this.valuesAtStart.size() - 1; i >= 0; --i) {
            o = this.valuesAtStart.get(i);
            if (values.contains(o)) {
                values.remove(o);
            }
            values.insertElementAt(o, 0);
        }
        for (i = 0; i < this.valuesAtEnd.size(); ++i) {
            o = this.valuesAtEnd.get(i);
            if (values.contains(o)) {
                values.remove(o);
            }
            values.add(o);
        }
        super.setValues(values);
    }

    public boolean isChangedToDiscrete() {
        return this.changedToDiscrete;
    }

    public void setDataOrder(boolean b) {
        this.dataOrder = b;
    }

    public boolean isDataOrder() {
        return this.dataOrder;
    }
}

