/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.range;

import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.text.SASFormat;

public abstract class DataRange {
    protected String label;
    protected int sortOrder;
    protected boolean valid = true;
    protected DataRange dual;
    protected SASFormat format;
    private SASFormat columnFormat = null;

    public abstract boolean union(DataRange var1);

    public abstract Object cloneRange();

    public abstract boolean contains(DataPoint var1);

    public abstract String toString();

    public abstract boolean equals(Object var1);

    protected boolean equalDR(DataRange range) {
        if (this.label == null && range.label != null) {
            return false;
        }
        if (this.label != null && !this.label.equals(range.label)) {
            return false;
        }
        if (this.sortOrder != range.sortOrder) {
            return false;
        }
        if (this.valid != range.valid) {
            return false;
        }
        if (this.format == null && range.format != null) {
            return false;
        }
        if (this.format != null && !this.format.equals(range.format)) {
            return false;
        }
        if (this.dual == null && range.dual != null) {
            return false;
        }
        return this.dual == null || this.dual.equals(range.dual);
    }

    protected void copyDR(DataRange src) {
        this.label = src.label;
        this.sortOrder = src.sortOrder;
        this.valid = src.valid;
        this.dual = src.dual != null ? (DataRange)src.dual.cloneRange() : null;
        this.format = src.format;
        this.columnFormat = src.columnFormat;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
    }

    public DataRange getDual() {
        return this.dual;
    }

    public void setDual(DataRange aDual) {
        this.dual = aDual;
    }

    public SASFormat getFormat() {
        return this.format;
    }

    public void setFormat(SASFormat aFormat) {
        this.format = aFormat;
    }

    public static boolean isCompatible(DataRange dr1, DataRange dr2) {
        if (dr1 == null || dr2 == null) {
            return true;
        }
        return (!(dr1 instanceof DiscreteRange) || dr2 instanceof DiscreteRange) && (!(dr2 instanceof DiscreteRange) || dr1 instanceof DiscreteRange);
    }

    public void setColumnFormat(SASFormat f) {
        this.columnFormat = f;
    }

    public SASFormat getColumnFormat() {
        return this.columnFormat;
    }
}

