/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.grid;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellAlignmentInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface2;
import com.sas.graphics.applets.statgraph.sgchart.grid.CompoundHeader;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface2;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.OLAPHeader;
import com.sas.graphics.applets.statgraph.sgchart.grid.OuterPadBorder;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisConstants;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeMerger;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public class TrellisPlot
extends JComponent
implements TrellisConstants,
AdjustmentListener,
RangeChangeListener,
MarginListener,
CellAlignmentInterface {
    protected RangeMerger[] rowsRM;
    protected RangeMerger[] rowsRM2;
    protected RangeMerger[] colsRM;
    protected RangeMerger[] colsRM2;
    protected RangeMerger xAllRM;
    protected RangeMerger x2AllRM;
    protected RangeMerger yAllRM;
    protected RangeMerger y2AllRM;
    protected JScrollBar rowScrollBar;
    protected int rowScrollBarPolicy = 1;
    protected JScrollBar columnScrollBar;
    protected int columnScrollBarPolicy = 1;
    protected boolean layoutDisabled = false;
    protected boolean uniformXRange = false;
    protected boolean uniformX2Range = false;
    protected boolean uniformYRange = false;
    protected boolean uniformY2Range = false;
    boolean inLayout = false;
    boolean finalLayout = false;
    boolean marginChanged = false;
    protected int autoAlignStrategy = 0;
    protected String[] preferredLocations = new String[]{"TOPLEFT", "TOPRIGHT", "BOTTOMLEFT", "BOTTOMRIGHT", "TOP", "RIGHT", "BOTTOM", "LEFT", "CENTER"};
    protected boolean fracHAlign = false;
    protected boolean fracVAlign = false;
    private boolean opaque;

    public boolean isUniformYRange() {
        return this.uniformYRange;
    }

    public void setUniformYRange(boolean uyr) {
        this.uniformYRange = uyr;
    }

    public boolean isUniformY2Range() {
        return this.uniformY2Range;
    }

    public void setUniformY2Range(boolean uyr) {
        this.uniformY2Range = uyr;
    }

    public boolean isUniformXRange() {
        return this.uniformXRange;
    }

    public void setUniformXRange(boolean uxr) {
        this.uniformXRange = uxr;
    }

    public boolean isUniformX2Range() {
        return this.uniformX2Range;
    }

    public void setUniformX2Range(boolean uxr) {
        this.uniformX2Range = uxr;
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (layout != null && layout instanceof TrellisLayout) {
            super.setLayout(layout);
            TrellisLayout trellisLayout = (TrellisLayout)layout;
            if (this.columnScrollBar != null) {
                trellisLayout.addColumnScrollBar(this.columnScrollBar);
            }
            if (this.rowScrollBar != null) {
                trellisLayout.addRowScrollBar(this.rowScrollBar);
            }
        } else {
            String s = "layout of TrellisPlot must be a TrellisLayout";
            throw new ClassCastException(s);
        }
    }

    private void verifyLayout() {
        if (this.getLayout() == null || !(this.getLayout() instanceof TrellisLayout)) {
            String s = "layout of TrellisPlot must be a TrellisLayout";
            throw new ClassCastException(s);
        }
    }

    private boolean isRowContainsPlot(int row) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        for (int col = 0; col < layout.getGridColumns(); ++col) {
            if (!this.isCellContainsPlot(row, col)) continue;
            return true;
        }
        return false;
    }

    private boolean isColumnContainsPlot(int col) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        for (int row = 0; row < layout.getGridRows(); ++row) {
            if (!this.isCellContainsPlot(row, col)) continue;
            return true;
        }
        return false;
    }

    private boolean isCellContainsPlot(int row, int col) {
        return this.getCellItem(row, col) != null && this.getCellItem(row, col) instanceof CellItemInterface;
    }

    public Component getCellItem(int row, int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        return layout.getCell(row, col).getItem();
    }

    public void addCellItem(int row, int col, Component cellItem) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        if (cellItem == null) {
            return;
        }
        this.add(cellItem);
        layout.getCell(row, col).addItem(cellItem);
    }

    public void removeCellItem(int row, int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        Component cellItem = layout.getCell(row, col).getItem();
        if (cellItem == null) {
            return;
        }
        this.remove(cellItem);
        layout.getCell(row, col).removeItem();
    }

    public Component getCellHeader(int row, int col, int index) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        if (index < 0) {
            throw new IllegalArgumentException("invalid header index " + index);
        }
        return layout.getCell(row, col).getHeader(index);
    }

    public void addCellHeader(int row, int col, int index, JComponent comp) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        if (index < 0) {
            throw new IllegalArgumentException("invalid header index " + index);
        }
        this.add(comp);
        layout.getCell(row, col).addHeader(index, comp);
    }

    public void removeCellHeader(int row, int col, int index) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        if (index < 0) {
            throw new IllegalArgumentException("invalid header index " + index);
        }
        if (index >= layout.getCell(row, col).getNumHeaders()) {
            return;
        }
        Component comp = layout.getCell(row, col).getHeader(index);
        if (comp == null) {
            return;
        }
        this.remove(comp);
        layout.getCell(row, col).removeHeader(index);
    }

    public Component getCellAxis(int row, int col, int position) {
        switch (position) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid cell axis position");
            }
        }
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        return layout.getCell(row, col).getAxis(position);
    }

    public void addCellAxis(int row, int col, int position, JComponent axis) {
        switch (position) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid cell axis position");
            }
        }
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        if (axis == null) {
            return;
        }
        this.add(axis);
        layout.getCell(row, col).addAxis(position, axis);
    }

    public void removeCellAxis(int row, int col, int position) {
        switch (position) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid cell axis position");
            }
        }
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        Component axis = layout.getCell(row, col).getAxis(position);
        if (axis == null) {
            return;
        }
        this.remove(axis);
        layout.getCell(row, col).removeAxis(position);
    }

    public Component getRowHeader(int row) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        return layout.getRowHeader(row);
    }

    public void addRowHeader(int row, Component comp) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        this.add(comp);
        layout.addRowHeader(row, comp);
    }

    public void removeRowHeader(int row) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        Component comp = layout.getRowHeader(row);
        if (comp == null) {
            return;
        }
        this.remove(comp);
        layout.removeRowHeader(row);
    }

    public Component getRowHeader2(int row) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        return layout.getRowHeader2(row);
    }

    public void addRowHeader2(int row, Component comp) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        this.add(comp);
        layout.addRowHeader2(row, comp);
    }

    public void removeRowHeader2(int row) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        Component comp = layout.getRowHeader(row);
        if (comp == null) {
            return;
        }
        this.remove(comp);
        layout.removeRowHeader2(row);
    }

    public Component getColumnHeader(int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        return layout.getColumnHeader(col);
    }

    public void addColumnHeader(int col, Component comp) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        this.add(comp);
        layout.addColumnHeader(col, comp);
    }

    public void removeColumnHeader(int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        Component comp = layout.getColumnHeader(col);
        if (comp == null) {
            return;
        }
        this.remove(comp);
        layout.removeColumnHeader(col);
    }

    public Component getColumnHeader2(int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        return layout.getColumnHeader2(col);
    }

    public void addColumnHeader2(int col, Component comp) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        this.add(comp);
        layout.addColumnHeader2(col, comp);
    }

    public void removeColumnHeader2(int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        Component comp = layout.getColumnHeader(col);
        if (comp == null) {
            return;
        }
        this.remove(comp);
        layout.removeColumnHeader2(col);
    }

    public Component getRowAxis(int row, boolean primary) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        return layout.getRowAxis(row, primary);
    }

    public void addRowAxis(int row, Component axis, boolean primary) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (axis == null) {
            return;
        }
        this.add(axis);
        layout.addRowAxis(row, axis, primary);
    }

    public void removeRowAxis(int row, boolean primary) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        Component axis = layout.getRowAxis(row, primary);
        if (axis == null) {
            return;
        }
        this.remove(axis);
        layout.removeRowAxis(row, primary);
    }

    public Component getColumnAxis(int col, boolean primary) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        return layout.getColumnAxis(col, primary);
    }

    public void addColumnAxis(int col, Component axis, boolean primary) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        if (axis == null) {
            return;
        }
        this.add(axis);
        layout.addColumnAxis(col, axis, primary);
    }

    public void removeColumnAxis(int col, boolean primary) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        Component axis = layout.getColumnAxis(col, primary);
        if (axis == null) {
            return;
        }
        this.remove(axis);
        layout.removeColumnAxis(col, primary);
    }

    public void removeCell(int row, int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        this.removeCellAxis(row, col, 1);
        this.removeCellAxis(row, col, 2);
        this.removeCellAxis(row, col, 3);
        this.removeCellAxis(row, col, 4);
        this.removeCellItem(row, col);
        for (int i = 0; i < layout.getCell(row, col).getNumHeaders(); ++i) {
            this.removeCellHeader(row, col, i);
        }
    }

    public void addRow() {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.addRow(layout.getGridRows());
        layout.resetVisibleRows();
    }

    public void insertRow(int row) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        layout.addRow(row);
        layout.resetVisibleRows();
    }

    public void removeRow(int row) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        this.disableLayout();
        this.removeRowAxis(row, true);
        this.removeRowAxis(row, false);
        this.removeRowHeader(row);
        for (int col = 0; col < layout.getGridColumns(); ++col) {
            this.removeCell(row, col);
        }
        layout.removeRow(row);
        layout.resetVisibleRows();
        this.enableLayout();
    }

    public void addColumn() {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.addColumn(layout.getGridColumns());
        layout.resetVisibleColumns();
    }

    public void insertColumn(int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        layout.addColumn(col);
        layout.resetVisibleColumns();
    }

    public void removeColumn(int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        this.disableLayout();
        this.removeColumnAxis(col, true);
        this.removeColumnAxis(col, false);
        this.removeColumnHeader(col);
        for (int row = 0; row < layout.getGridRows(); ++row) {
            this.removeCell(row, col);
        }
        layout.removeColumn(col);
        layout.resetVisibleColumns();
        this.enableLayout();
    }

    public ArrayList getGridBorderAnnotation(int position) {
        switch (position) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid grid border annotation position");
            }
        }
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getGridBorderAnnotation(position);
    }

    public void addGridBorderAnnotation(Component comp, int position) {
        switch (position) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid grid border annotation position");
            }
        }
        this.verifyLayout();
        this.add(comp);
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.addGridBorderAnnotation(comp, position);
    }

    public void removeGridBorderAnnotation(int position) {
        switch (position) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid grid border annotation position");
            }
        }
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        ArrayList comps = layout.getGridBorderAnnotation(position);
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.size(); ++i) {
            this.remove((Component)comps.get(i));
        }
        layout.removeGridBorderAnnotation(position);
    }

    public ArrayList getTitles() {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.titles;
    }

    public void addTitle(Component comp, int position) {
        this.verifyLayout();
        this.add(comp);
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.addTitle(comp, position);
    }

    public void addTitle(Component comp) {
        this.verifyLayout();
        this.add(comp);
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.addTitle(comp);
    }

    public void removeTitle(Component comp) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        this.remove(comp);
        layout.removeTitle(comp);
    }

    public ArrayList getFootnotes() {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.footnotes;
    }

    public void addFootnote(Component comp, int position) {
        this.verifyLayout();
        this.add(comp);
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.addFootnote(comp, position);
    }

    public void addFootnote(Component comp) {
        this.verifyLayout();
        this.add(comp);
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.addFootnote(comp);
    }

    public void removeFootnote(Component comp) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        this.remove(comp);
        layout.removeFootnote(comp);
    }

    public void addGlobalLegend(JComponent comp, String align) {
        this.verifyLayout();
        this.add(comp);
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.addGlobalLegend(comp, align);
    }

    public void removeGlobalLegend(JComponent comp) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        this.remove(comp);
        layout.removeGlobalLegend(comp);
    }

    public JScrollBar getRowScrollBar() {
        return this.rowScrollBar;
    }

    public JScrollBar getColumnScrollBar() {
        return this.columnScrollBar;
    }

    public int getRowScrollBarPolicy() {
        return this.rowScrollBarPolicy;
    }

    public void setRowScrollBarPolicy(int policy) {
        LayoutManager layout = this.getLayout();
        switch (policy) {
            case 0: {
                this.rowScrollBarPolicy = policy;
                if (this.rowScrollBar == null) {
                    this.rowScrollBar = new JScrollBar(1);
                }
                if (!this.isAncestorOf(this.rowScrollBar)) {
                    this.add(this.rowScrollBar);
                }
                if (layout instanceof TrellisLayout) {
                    TrellisLayout trellisLayout = (TrellisLayout)layout;
                    trellisLayout.addRowScrollBar(this.rowScrollBar);
                }
                this.rowScrollBar.removeAdjustmentListener(this);
                this.rowScrollBar.addAdjustmentListener(this);
                this.invalidate();
                this.validate();
                break;
            }
            case 1: {
                this.rowScrollBarPolicy = policy;
                if (this.rowScrollBar == null) break;
                this.remove(this.rowScrollBar);
                if (layout instanceof TrellisLayout) {
                    TrellisLayout trellisLayout = (TrellisLayout)layout;
                    trellisLayout.removeRowScrollBar();
                }
                this.rowScrollBar.removeAdjustmentListener(this);
                this.rowScrollBar = null;
                this.invalidate();
                this.validate();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid rowScrollBarPolicy");
            }
        }
    }

    public int getColumnScrollBarPolicy() {
        return this.columnScrollBarPolicy;
    }

    public void setColumnScrollBarPolicy(int policy) {
        LayoutManager layout = this.getLayout();
        switch (policy) {
            case 0: {
                this.columnScrollBarPolicy = policy;
                if (this.columnScrollBar == null) {
                    this.columnScrollBar = new JScrollBar(0);
                }
                if (!this.isAncestorOf(this.columnScrollBar)) {
                    this.add(this.columnScrollBar);
                }
                if (layout instanceof TrellisLayout) {
                    TrellisLayout trellisLayout = (TrellisLayout)layout;
                    trellisLayout.addColumnScrollBar(this.columnScrollBar);
                }
                this.columnScrollBar.removeAdjustmentListener(this);
                this.columnScrollBar.addAdjustmentListener(this);
                this.invalidate();
                this.validate();
                break;
            }
            case 1: {
                this.columnScrollBarPolicy = policy;
                if (this.columnScrollBar == null) break;
                this.remove(this.columnScrollBar);
                if (layout instanceof TrellisLayout) {
                    TrellisLayout trellisLayout = (TrellisLayout)layout;
                    trellisLayout.removeColumnScrollBar();
                }
                this.columnScrollBar.removeAdjustmentListener(this);
                this.columnScrollBar = null;
                this.invalidate();
                this.validate();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid columnScrollBarPolicy");
            }
        }
    }

    public boolean isFinalLayout() {
        return this.finalLayout;
    }

    protected boolean isLayoutDisabled() {
        return this.layoutDisabled;
    }

    public void disableLayout() {
        this.layoutDisabled = true;
    }

    public void enableLayout() {
        this.layoutDisabled = false;
        this.invalidate();
        this.validate();
    }

    @Override
    public void paintComponent(Graphics g) {
        TrellisLayout layout;
        if (this.opaque) {
            g.setColor(this.getBackground());
            Border border = this.getBorder();
            while (border instanceof CompoundBorder) {
                Border outer = ((CompoundBorder)border).getOutsideBorder();
                if (outer == null) continue;
                border = outer;
            }
            if (border instanceof OuterPadBorder) {
                Insets pad = border.getBorderInsets(this);
                g.fillRect(pad.left, pad.top, this.getSize().width - pad.left - pad.right, this.getSize().height - pad.top - pad.bottom);
            } else {
                g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            }
        }
        if ((layout = (TrellisLayout)this.getLayout()) != null) {
            layout.preDraw(g);
        }
        super.paintComponent(g);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (layout != null) {
            layout.postDraw(g);
        }
    }

    public void installRowRangeListeners() {
        this.installRowRangeListeners(false, true, true);
    }

    public void installRowRangeListeners(boolean twoScales, boolean primaryUnion, boolean secondaryUnion) {
        if (twoScales) {
            this.installTwoScalesYRangeListeners(primaryUnion, secondaryUnion);
        } else {
            this.installYRangeListeners();
        }
    }

    protected void installYRangeListeners() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (this.uniformYRange) {
            DataRange merged;
            CellItemInterface item;
            int c;
            int r;
            this.yAllRM = new RangeMerger();
            byte dim = 2;
            this.yAllRM.setDimension(dim);
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    DataRangeInterface dri = item.getRangeSource(dim, 0);
                    if (dri != null) {
                        this.yAllRM.addInputRange(dri.getDataRange(dim));
                        dri.addRangeChangeListener(this.yAllRM);
                    }
                    if ((dri = item.getRangeSource(dim, 1)) == null) continue;
                    this.yAllRM.addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.yAllRM);
                }
            }
            DataRange outputRange = merged = this.yAllRM.getOutputRange();
            for (r = 0; r < layout.getGridRows(); ++r) {
                GridAxisInterface axis;
                if (layout.isUseRowColAxes() && this.isRowContainsPlot(r)) {
                    axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) != null) {
                        axis.setRange(outputRange);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface)((Object)this.getCellAxis(r, 0, 2));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, layout.getGridColumns() - 1, 4))) != null) {
                        axis.setRange(outputRange);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isRowContainsPlot(r)) {
                    axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                    if (axis != null) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) != null) {
                        axis.setRange(outputRange);
                    }
                }
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    item.setRange(dim, 0, outputRange);
                    item.setRange(dim, 1, outputRange);
                }
            }
            this.yAllRM.addRangeChangeListener(this);
        } else if (layout.getGridColumns() > 0) {
            this.rowsRM = new RangeMerger[layout.getGridRows()];
            byte dim = 2;
            for (int r = 0; r < layout.getGridRows(); ++r) {
                GridAxisInterface axis;
                DataRange merged;
                CellItemInterface item;
                int c;
                this.rowsRM[r] = new RangeMerger();
                this.rowsRM[r].setDimension(dim);
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    DataRangeInterface dri = item.getRangeSource(dim, 0);
                    if (dri != null) {
                        this.rowsRM[r].addInputRange(dri.getDataRange(dim));
                        dri.addRangeChangeListener(this.rowsRM[r]);
                    }
                    if ((dri = item.getRangeSource(dim, 1)) == null) continue;
                    this.rowsRM[r].addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.rowsRM[r]);
                }
                DataRange outputRange = merged = this.rowsRM[r].getOutputRange();
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) != null) {
                        axis.setRange(outputRange);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface)((Object)this.getCellAxis(r, 0, 2));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, layout.getGridColumns() - 1, 4))) != null) {
                        axis.setRange(outputRange);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isRowContainsPlot(r)) {
                    axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                    if (axis != null) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) != null) {
                        axis.setRange(outputRange);
                    }
                }
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    item.setRange(dim, 0, outputRange);
                    item.setRange(dim, 1, outputRange);
                }
                this.rowsRM[r].addRangeChangeListener(this);
            }
        }
    }

    protected void installTwoScalesYRangeListeners(boolean primaryUnion, boolean secondaryUnion) {
        GridAxisInterface2 axis;
        DataRange outputRange;
        DataRange merged;
        CellItemInterface2 item;
        DataRangeInterface dri;
        int c;
        int r;
        byte dim;
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (this.uniformYRange && primaryUnion) {
            this.yAllRM = new RangeMerger();
            dim = 2;
            this.yAllRM.setDimension(dim);
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c) || (dri = (item = (CellItemInterface2)((Object)this.getCellItem(r, c))).getRangeSource(dim, true)) == null) continue;
                    this.yAllRM.addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.yAllRM);
                }
            }
            outputRange = merged = this.yAllRM.getOutputRange();
            for (r = 0; r < layout.getGridRows(); ++r) {
                if (layout.isUseRowColAxes() && this.isRowContainsPlot(r)) {
                    axis = (GridAxisInterface2)((Object)this.getRowAxis(r, true));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface2)((Object)this.getCellAxis(r, 0, 2));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isRowContainsPlot(r)) {
                    axis = (GridAxisInterface2)((Object)this.getRowAxis(r, true));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface2)((Object)this.getRowAxis(r, false))) != null && axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                }
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface2)((Object)this.getCellItem(r, c));
                    item.setRange(dim, true, outputRange);
                }
            }
            this.yAllRM.addRangeChangeListener(this);
        } else if (primaryUnion && layout.getGridColumns() > 0) {
            this.rowsRM = new RangeMerger[layout.getGridRows()];
            dim = 2;
            for (r = 0; r < layout.getGridRows(); ++r) {
                this.rowsRM[r] = new RangeMerger();
                this.rowsRM[r].setDimension(dim);
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c) || (dri = (item = (CellItemInterface2)((Object)this.getCellItem(r, c))).getRangeSource(dim, true)) == null) continue;
                    this.rowsRM[r].addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.rowsRM[r]);
                }
                outputRange = merged = this.rowsRM[r].getOutputRange();
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface2)((Object)this.getRowAxis(r, true));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface2)((Object)this.getCellAxis(r, 0, 2));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isRowContainsPlot(r)) {
                    axis = (GridAxisInterface2)((Object)this.getRowAxis(r, true));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface2)((Object)this.getRowAxis(r, false))) != null && axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                }
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface2)((Object)this.getCellItem(r, c));
                    item.setRange(dim, true, outputRange);
                }
                this.rowsRM[r].addRangeChangeListener(this);
            }
        }
        if (this.uniformY2Range && secondaryUnion) {
            this.y2AllRM = new RangeMerger();
            dim = 2;
            this.y2AllRM.setDimension(dim);
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c) || (dri = (item = (CellItemInterface2)((Object)this.getCellItem(r, c))).getRangeSource(dim, false)) == null) continue;
                    this.y2AllRM.addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.y2AllRM);
                }
            }
            outputRange = merged = this.y2AllRM.getOutputRange();
            for (r = 0; r < layout.getGridRows(); ++r) {
                if (layout.isUseRowColAxes() && this.isRowContainsPlot(r)) {
                    axis = (GridAxisInterface2)((Object)this.getRowAxis(r, false));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface2)((Object)this.getCellAxis(r, layout.getGridColumns() - 1, 4));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isRowContainsPlot(r)) {
                    axis = (GridAxisInterface2)((Object)this.getRowAxis(r, false));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface2)((Object)this.getRowAxis(r, true))) != null && axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                }
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface2)((Object)this.getCellItem(r, c));
                    item.setRange(dim, false, outputRange);
                }
            }
            this.y2AllRM.addRangeChangeListener(this);
        } else if (secondaryUnion && layout.getGridColumns() > 0) {
            this.rowsRM2 = new RangeMerger[layout.getGridRows()];
            dim = 2;
            for (r = 0; r < layout.getGridRows(); ++r) {
                this.rowsRM2[r] = new RangeMerger();
                this.rowsRM2[r].setDimension(dim);
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c) || (dri = (item = (CellItemInterface2)((Object)this.getCellItem(r, c))).getRangeSource(dim, false)) == null) continue;
                    this.rowsRM2[r].addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.rowsRM2[r]);
                }
                outputRange = merged = this.rowsRM2[r].getOutputRange();
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface2)((Object)this.getRowAxis(r, false));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface2)((Object)this.getCellAxis(r, layout.getGridColumns() - 1, 4));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isRowContainsPlot(r)) {
                    axis = (GridAxisInterface2)((Object)this.getRowAxis(r, false));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface2)((Object)this.getRowAxis(r, true))) != null && axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                }
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface2)((Object)this.getCellItem(r, c));
                    item.setRange(dim, false, outputRange);
                }
                this.rowsRM2[r].addRangeChangeListener(this);
            }
        }
    }

    public void installColumnRangeListeners() {
        this.installColumnRangeListeners(false, true, true);
    }

    public void installColumnRangeListeners(boolean twoScales, boolean primaryUnion, boolean secondaryUnion) {
        if (twoScales) {
            this.installTwoScalesXRangeListeners(primaryUnion, secondaryUnion);
        } else {
            this.installXRangeListeners();
        }
    }

    protected void installXRangeListeners() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (this.uniformXRange) {
            DataRange merged;
            CellItemInterface item;
            int c;
            int r;
            this.xAllRM = new RangeMerger();
            byte dim = 1;
            this.xAllRM.setDimension(dim);
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    DataRangeInterface dri = item.getRangeSource(dim, 0);
                    if (dri != null) {
                        this.xAllRM.addInputRange(dri.getDataRange(dim));
                        dri.addRangeChangeListener(this.xAllRM);
                    }
                    if ((dri = item.getRangeSource(dim, 1)) == null) continue;
                    this.xAllRM.addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.xAllRM);
                }
            }
            DataRange outputRange = merged = this.xAllRM.getOutputRange();
            for (c = 0; c < layout.getGridColumns(); ++c) {
                GridAxisInterface axis;
                if (layout.isUseRowColAxes() && this.isColumnContainsPlot(c)) {
                    axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true))) != null) {
                        axis.setRange(outputRange);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface)((Object)this.getCellAxis(0, c, 1));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(layout.getGridRows() - 1, c, 3))) != null) {
                        axis.setRange(outputRange);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isColumnContainsPlot(c)) {
                    axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false));
                    if (axis != null) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true))) != null) {
                        axis.setRange(outputRange);
                    }
                }
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    item.setRange(dim, 0, outputRange);
                    item.setRange(dim, 1, outputRange);
                }
            }
            this.xAllRM.addRangeChangeListener(this);
        } else if (layout.getGridRows() > 0) {
            this.colsRM = new RangeMerger[layout.getGridColumns()];
            byte dim = 1;
            for (int c = 0; c < layout.getGridColumns(); ++c) {
                GridAxisInterface axis;
                DataRange merged;
                CellItemInterface item;
                int r;
                this.colsRM[c] = new RangeMerger();
                this.colsRM[c].setDimension(dim);
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    DataRangeInterface dri = item.getRangeSource(dim, 0);
                    if (dri != null) {
                        this.colsRM[c].addInputRange(dri.getDataRange(dim));
                        dri.addRangeChangeListener(this.colsRM[c]);
                    }
                    if ((dri = item.getRangeSource(dim, 1)) == null) continue;
                    this.colsRM[c].addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.colsRM[c]);
                }
                DataRange outputRange = merged = this.colsRM[c].getOutputRange();
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true))) != null) {
                        axis.setRange(outputRange);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface)((Object)this.getCellAxis(0, c, 1));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(layout.getGridRows() - 1, c, 3))) != null) {
                        axis.setRange(outputRange);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isColumnContainsPlot(c)) {
                    axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false));
                    if (axis != null) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true))) != null) {
                        axis.setRange(outputRange);
                    }
                }
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    item.setRange(dim, 0, outputRange);
                    item.setRange(dim, 1, outputRange);
                }
                this.colsRM[c].addRangeChangeListener(this);
            }
        }
    }

    protected void installTwoScalesXRangeListeners(boolean primaryUnion, boolean secondaryUnion) {
        GridAxisInterface2 axis;
        DataRange outputRange;
        DataRange merged;
        CellItemInterface2 item;
        DataRangeInterface dri;
        int c;
        int r;
        byte dim;
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (this.uniformXRange && primaryUnion) {
            this.xAllRM = new RangeMerger();
            dim = 1;
            this.xAllRM.setDimension(dim);
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c) || (dri = (item = (CellItemInterface2)((Object)this.getCellItem(r, c))).getRangeSource(dim, true)) == null) continue;
                    this.xAllRM.addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.xAllRM);
                }
            }
            outputRange = merged = this.xAllRM.getOutputRange();
            for (c = 0; c < layout.getGridColumns(); ++c) {
                if (layout.isUseRowColAxes() && this.isColumnContainsPlot(c)) {
                    axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, true));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface2)((Object)this.getCellAxis(layout.getGridRows() - 1, c, 3));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isColumnContainsPlot(c)) {
                    axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, true));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, false))) != null && axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                }
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface2)((Object)this.getCellItem(r, c));
                    item.setRange(dim, true, outputRange);
                }
            }
            this.xAllRM.addRangeChangeListener(this);
        } else if (primaryUnion && layout.getGridRows() > 0) {
            this.colsRM = new RangeMerger[layout.getGridColumns()];
            dim = 1;
            for (c = 0; c < layout.getGridColumns(); ++c) {
                this.colsRM[c] = new RangeMerger();
                this.colsRM[c].setDimension(dim);
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c) || (dri = (item = (CellItemInterface2)((Object)this.getCellItem(r, c))).getRangeSource(dim, true)) == null) continue;
                    this.colsRM[c].addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.colsRM[c]);
                }
                outputRange = merged = this.colsRM[c].getOutputRange();
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, true));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface2)((Object)this.getCellAxis(layout.getGridRows() - 1, c, 3));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isColumnContainsPlot(c)) {
                    axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, true));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, false))) != null && axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                }
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface2)((Object)this.getCellItem(r, c));
                    item.setRange(dim, true, outputRange);
                }
                this.colsRM[c].addRangeChangeListener(this);
            }
        }
        if (this.uniformX2Range && secondaryUnion) {
            this.x2AllRM = new RangeMerger();
            dim = 1;
            this.x2AllRM.setDimension(dim);
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c) || (dri = (item = (CellItemInterface2)((Object)this.getCellItem(r, c))).getRangeSource(dim, false)) == null) continue;
                    this.x2AllRM.addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.x2AllRM);
                }
            }
            outputRange = merged = this.x2AllRM.getOutputRange();
            for (c = 0; c < layout.getGridColumns(); ++c) {
                if (layout.isUseRowColAxes() && this.isColumnContainsPlot(c)) {
                    axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, false));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface2)((Object)this.getCellAxis(0, c, 1));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isColumnContainsPlot(c)) {
                    axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, false));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, true))) != null && axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                }
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface2)((Object)this.getCellItem(r, c));
                    item.setRange(dim, false, outputRange);
                }
            }
            this.x2AllRM.addRangeChangeListener(this);
        } else if (secondaryUnion && layout.getGridRows() > 0) {
            this.colsRM2 = new RangeMerger[layout.getGridColumns()];
            dim = 1;
            for (c = 0; c < layout.getGridColumns(); ++c) {
                this.colsRM2[c] = new RangeMerger();
                this.colsRM2[c].setDimension(dim);
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c) || (dri = (item = (CellItemInterface2)((Object)this.getCellItem(r, c))).getRangeSource(dim, false)) == null) continue;
                    this.colsRM2[c].addInputRange(dri.getDataRange(dim));
                    dri.addRangeChangeListener(this.colsRM2[c]);
                }
                outputRange = merged = this.colsRM2[c].getOutputRange();
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, false));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                } else {
                    axis = (GridAxisInterface2)((Object)this.getCellAxis(0, c, 1));
                    if (axis != null) {
                        axis.setRange(merged);
                        outputRange = axis.getOutputRange();
                    }
                }
                if (layout.isUseRowColAxes() && this.isColumnContainsPlot(c)) {
                    axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, false));
                    if (axis != null && !axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                    if ((axis = (GridAxisInterface2)((Object)this.getColumnAxis(c, true))) != null && axis.isMirror()) {
                        axis.setRange(outputRange);
                    }
                }
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface2)((Object)this.getCellItem(r, c));
                    item.setRange(dim, false, outputRange);
                }
                this.colsRM2[c].addRangeChangeListener(this);
            }
        }
    }

    public void installRangeListeners() {
        this.installRowRangeListeners();
        this.installColumnRangeListeners();
    }

    public void installRangeListeners(boolean twoScales, boolean primaryUnion, boolean secondaryUnion) {
        this.installRowRangeListeners(twoScales, primaryUnion, secondaryUnion);
        this.installColumnRangeListeners(twoScales, primaryUnion, secondaryUnion);
    }

    public void uninstallRangeListeners() {
        this.uninstallRowRangeListeners();
        this.uninstallColumnRangeListeners();
    }

    public void uninstallRowRangeListeners() {
        DataRangeInterface dri;
        CellItemInterface item;
        int c;
        int r;
        byte dim;
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (this.rowsRM != null) {
            dim = 2;
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c) || (item = (CellItemInterface)((Object)this.getCellItem(r, c))) == null || (dri = item.getRangeSource(dim, 0)) == null) continue;
                    this.rowsRM[r].removeInputRange(dri.getDataRange(dim));
                    dri.removeRangeChangeListener(this.rowsRM[r]);
                }
                this.rowsRM[r].removeRangeChangeListener(this);
            }
        } else if (this.yAllRM != null) {
            dim = 2;
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c) || (item = (CellItemInterface)((Object)this.getCellItem(r, c))) == null || (dri = item.getRangeSource(dim, 0)) == null) continue;
                    this.yAllRM.removeInputRange(dri.getDataRange(dim));
                    dri.removeRangeChangeListener(this.yAllRM);
                }
            }
            this.yAllRM.removeRangeChangeListener(this);
        }
        if (this.rowsRM2 != null) {
            dim = 2;
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    CellItemInterface2 item2;
                    if (!this.isCellContainsPlot(r, c) || (item2 = (CellItemInterface2)((Object)this.getCellItem(r, c))) == null || (dri = item2.getRangeSource(dim, false)) == null) continue;
                    this.rowsRM2[r].removeInputRange(dri.getDataRange(dim));
                    dri.removeRangeChangeListener(this.rowsRM2[r]);
                }
                this.rowsRM2[r].removeRangeChangeListener(this);
            }
        } else if (this.y2AllRM != null) {
            dim = 2;
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    CellItemInterface2 item2;
                    if (!this.isCellContainsPlot(r, c) || (item2 = (CellItemInterface2)((Object)this.getCellItem(r, c))) == null || (dri = item2.getRangeSource(dim, false)) == null) continue;
                    this.y2AllRM.removeInputRange(dri.getDataRange(dim));
                    dri.removeRangeChangeListener(this.y2AllRM);
                }
            }
            this.y2AllRM.removeRangeChangeListener(this);
        }
    }

    public void uninstallColumnRangeListeners() {
        DataRangeInterface dri;
        CellItemInterface item;
        int r;
        int c;
        byte dim;
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (this.colsRM != null) {
            dim = 1;
            for (c = 0; c < layout.getGridColumns(); ++c) {
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c) || (item = (CellItemInterface)((Object)this.getCellItem(r, c))) == null || (dri = item.getRangeSource(dim, 0)) == null) continue;
                    this.colsRM[c].removeInputRange(dri.getDataRange(dim));
                    dri.removeRangeChangeListener(this.colsRM[c]);
                }
                this.colsRM[c].removeRangeChangeListener(this);
            }
        } else if (this.xAllRM != null) {
            dim = 1;
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c) || (item = (CellItemInterface)((Object)this.getCellItem(r, c))) == null || (dri = item.getRangeSource(dim, 0)) == null) continue;
                    this.xAllRM.removeInputRange(dri.getDataRange(dim));
                    dri.removeRangeChangeListener(this.xAllRM);
                }
            }
            this.xAllRM.removeRangeChangeListener(this);
        }
        if (this.colsRM2 != null) {
            dim = 1;
            for (c = 0; c < layout.getGridColumns(); ++c) {
                for (r = 0; r < layout.getGridRows(); ++r) {
                    CellItemInterface2 item2;
                    if (!this.isCellContainsPlot(r, c) || (item2 = (CellItemInterface2)((Object)this.getCellItem(r, c))) == null || (dri = item2.getRangeSource(dim, false)) == null) continue;
                    this.colsRM2[c].removeInputRange(dri.getDataRange(dim));
                    dri.removeRangeChangeListener(this.colsRM2[c]);
                }
                this.colsRM2[c].removeRangeChangeListener(this);
            }
        } else if (this.x2AllRM != null) {
            dim = 1;
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    CellItemInterface2 item2;
                    if (!this.isCellContainsPlot(r, c) || (item2 = (CellItemInterface2)((Object)this.getCellItem(r, c))) == null || (dri = item2.getRangeSource(dim, false)) == null) continue;
                    this.x2AllRM.removeInputRange(dri.getDataRange(dim));
                    dri.removeRangeChangeListener(this.x2AllRM);
                }
            }
            this.x2AllRM.removeRangeChangeListener(this);
        }
    }

    public void installMarginListeners() {
        int c;
        int r;
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        for (r = 0; r < layout.getGridRows(); ++r) {
            for (c = 0; c < layout.getGridColumns(); ++c) {
                CellItemInterface item;
                if (!this.isCellContainsPlot(r, c) || !(item = (CellItemInterface)((Object)this.getCellItem(r, c))).getMarginsAligned()) continue;
                item.addMarginListener(this);
            }
        }
        if (layout.isUseRowColAxes()) {
            GridAxisInterface axis;
            for (r = 0; r < layout.getGridRows(); ++r) {
                axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                if (axis != null) {
                    axis.addMarginListener(this);
                }
                if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) == null) continue;
                axis.addMarginListener(this);
            }
            for (int c2 = 0; c2 < layout.getGridColumns(); ++c2) {
                axis = (GridAxisInterface)((Object)this.getColumnAxis(c2, false));
                if (axis != null) {
                    axis.addMarginListener(this);
                }
                if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c2, true))) == null) continue;
                axis.addMarginListener(this);
            }
        } else {
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    GridAxisInterface axis = (GridAxisInterface)((Object)this.getCellAxis(r, c, 1));
                    if (axis != null) {
                        axis.addMarginListener(this);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, c, 3))) != null) {
                        axis.addMarginListener(this);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, c, 2))) != null) {
                        axis.addMarginListener(this);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, c, 4))) == null) continue;
                    axis.addMarginListener(this);
                }
            }
        }
    }

    public void uninstallMarginListeners() {
        int c;
        int r;
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        for (r = 0; r < layout.getGridRows(); ++r) {
            for (c = 0; c < layout.getGridColumns(); ++c) {
                CellItemInterface item;
                if (!this.isCellContainsPlot(r, c) || !(item = (CellItemInterface)((Object)this.getCellItem(r, c))).getMarginsAligned()) continue;
                item.removeMarginListener(this);
            }
        }
        if (layout.isUseRowColAxes()) {
            GridAxisInterface axis;
            for (r = 0; r < layout.getGridRows(); ++r) {
                axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                if (axis != null) {
                    axis.removeMarginListener(this);
                }
                if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) == null) continue;
                axis.removeMarginListener(this);
            }
            for (int c2 = 0; c2 < layout.getGridColumns(); ++c2) {
                axis = (GridAxisInterface)((Object)this.getColumnAxis(c2, false));
                if (axis != null) {
                    axis.removeMarginListener(this);
                }
                if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c2, true))) == null) continue;
                axis.removeMarginListener(this);
            }
        } else {
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    GridAxisInterface axis = (GridAxisInterface)((Object)this.getCellAxis(r, c, 1));
                    if (axis != null) {
                        axis.removeMarginListener(this);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, c, 3))) != null) {
                        axis.removeMarginListener(this);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, c, 2))) != null) {
                        axis.removeMarginListener(this);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, c, 4))) == null) continue;
                    axis.removeMarginListener(this);
                }
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (!layout.isScrollable()) {
            return;
        }
        JScrollBar sb = (JScrollBar)e.getAdjustable();
        if (sb.getOrientation() == 1) {
            layout.setStartRow(sb.getValue());
        } else {
            layout.setStartColumn(sb.getValue());
        }
        layout.scrollGrid(this);
        this.repaint();
    }

    @Override
    public void marginChanged(MarginChangeEvent mce) {
        if (this.inLayout) {
            this.marginChanged = true;
        } else {
            TrellisLayout layout = (TrellisLayout)this.getLayout();
            layout.invalidateLayout(this);
            this.doLayout();
        }
    }

    @Override
    public void rangeChanged(RangeChangedEvent e) {
        GridAxisInterface axis;
        CellItemInterface item;
        int c;
        DataRange merged;
        int r;
        Object src = e.getSource();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (this.rowsRM != null) {
            for (r = 0; r < layout.getGridRows(); ++r) {
                if (src != this.rowsRM[r]) continue;
                merged = this.rowsRM[r].getOutputRange();
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    item.setRange((byte)2, 0, merged);
                }
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                    if (axis instanceof GridAxisInterface2) {
                        if (axis != null && !((GridAxisInterface2)axis).isMirror()) {
                            axis.setRange(merged);
                        }
                    } else if (axis != null) {
                        axis.setRange(merged);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) instanceof GridAxisInterface2) {
                        if (axis == null || !((GridAxisInterface2)axis).isMirror()) break;
                        axis.setRange(merged);
                        break;
                    }
                    if (axis == null) break;
                    axis.setRange(merged);
                    break;
                }
                axis = (GridAxisInterface)((Object)this.getCellAxis(r, 0, 2));
                if (axis != null) {
                    axis.setRange(merged);
                }
                if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, layout.getGridColumns() - 1, 4))) == null) break;
                axis.setRange(merged);
                break;
            }
        } else if (src == this.yAllRM) {
            merged = this.yAllRM.getOutputRange();
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    item.setRange((byte)2, 0, merged);
                }
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                    if (axis instanceof GridAxisInterface2) {
                        if (axis != null && !((GridAxisInterface2)axis).isMirror()) {
                            axis.setRange(merged);
                        }
                    } else if (axis != null) {
                        axis.setRange(merged);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) instanceof GridAxisInterface2) {
                        if (axis == null || !((GridAxisInterface2)axis).isMirror()) continue;
                        axis.setRange(merged);
                        continue;
                    }
                    if (axis == null) continue;
                    axis.setRange(merged);
                    continue;
                }
                axis = (GridAxisInterface)((Object)this.getCellAxis(r, 0, 2));
                if (axis != null) {
                    axis.setRange(merged);
                }
                if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, layout.getGridColumns() - 1, 4))) == null) continue;
                axis.setRange(merged);
            }
        }
        if (this.rowsRM2 != null) {
            for (r = 0; r < layout.getGridRows(); ++r) {
                if (src != this.rowsRM2[r]) continue;
                merged = this.rowsRM2[r].getOutputRange();
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    ((CellItemInterface2)item).setRange((byte)2, false, merged);
                }
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                    if (axis != null && ((GridAxisInterface2)axis).isMirror()) {
                        axis.setRange(merged);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) == null || ((GridAxisInterface2)axis).isMirror()) break;
                    axis.setRange(merged);
                    break;
                }
                axis = (GridAxisInterface)((Object)this.getCellAxis(r, 0, 2));
                if (axis != null) {
                    axis.setRange(merged);
                }
                if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, layout.getGridColumns() - 1, 4))) == null) break;
                axis.setRange(merged);
                break;
            }
        } else if (src == this.y2AllRM) {
            merged = this.y2AllRM.getOutputRange();
            for (r = 0; r < layout.getGridRows(); ++r) {
                for (c = 0; c < layout.getGridColumns(); ++c) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    ((CellItemInterface2)item).setRange((byte)2, false, merged);
                }
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getRowAxis(r, true));
                    if (axis != null && ((GridAxisInterface2)axis).isMirror()) {
                        axis.setRange(merged);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getRowAxis(r, false))) == null || ((GridAxisInterface2)axis).isMirror()) continue;
                    axis.setRange(merged);
                    continue;
                }
                axis = (GridAxisInterface)((Object)this.getCellAxis(r, 0, 2));
                if (axis != null) {
                    axis.setRange(merged);
                }
                if ((axis = (GridAxisInterface)((Object)this.getCellAxis(r, layout.getGridColumns() - 1, 4))) == null) continue;
                axis.setRange(merged);
            }
        }
        if (this.colsRM != null) {
            for (c = 0; c < layout.getGridColumns(); ++c) {
                if (src != this.colsRM[c]) continue;
                merged = this.colsRM[c].getOutputRange();
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    item.setRange((byte)1, 0, merged);
                }
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false));
                    if (axis instanceof GridAxisInterface2) {
                        if (axis != null && ((GridAxisInterface2)axis).isMirror()) {
                            axis.setRange(merged);
                        }
                    } else if (axis != null) {
                        axis.setRange(merged);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true))) instanceof GridAxisInterface2) {
                        if (axis == null || ((GridAxisInterface2)axis).isMirror()) break;
                        axis.setRange(merged);
                        break;
                    }
                    if (axis == null) break;
                    axis.setRange(merged);
                    break;
                }
                axis = (GridAxisInterface)((Object)this.getCellAxis(0, c, 1));
                if (axis != null) {
                    axis.setRange(merged);
                }
                if ((axis = (GridAxisInterface)((Object)this.getCellAxis(layout.getGridRows() - 1, c, 3))) == null) break;
                axis.setRange(merged);
                break;
            }
        } else if (src == this.xAllRM) {
            merged = this.xAllRM.getOutputRange();
            for (c = 0; c < layout.getGridColumns(); ++c) {
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    item.setRange((byte)1, 0, merged);
                }
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false));
                    if (axis instanceof GridAxisInterface2) {
                        if (axis != null && ((GridAxisInterface2)axis).isMirror()) {
                            axis.setRange(merged);
                        }
                    } else if (axis != null) {
                        axis.setRange(merged);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true))) instanceof GridAxisInterface2) {
                        if (axis == null || ((GridAxisInterface2)axis).isMirror()) continue;
                        axis.setRange(merged);
                        continue;
                    }
                    if (axis == null) continue;
                    axis.setRange(merged);
                    continue;
                }
                axis = (GridAxisInterface)((Object)this.getCellAxis(0, c, 1));
                if (axis != null) {
                    axis.setRange(merged);
                }
                if ((axis = (GridAxisInterface)((Object)this.getCellAxis(layout.getGridRows() - 1, c, 3))) == null) continue;
                axis.setRange(merged);
            }
        }
        if (this.colsRM2 != null) {
            for (c = 0; c < layout.getGridColumns(); ++c) {
                if (src != this.colsRM2[c]) continue;
                merged = this.colsRM2[c].getOutputRange();
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    ((CellItemInterface2)item).setRange((byte)1, false, merged);
                }
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false));
                    if (axis != null && !((GridAxisInterface2)axis).isMirror()) {
                        axis.setRange(merged);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true))) == null || !((GridAxisInterface2)axis).isMirror()) break;
                    axis.setRange(merged);
                    break;
                }
                axis = (GridAxisInterface)((Object)this.getCellAxis(0, c, 1));
                if (axis != null) {
                    axis.setRange(merged);
                }
                if ((axis = (GridAxisInterface)((Object)this.getCellAxis(layout.getGridRows() - 1, c, 3))) == null) break;
                axis.setRange(merged);
                break;
            }
        } else if (src == this.x2AllRM) {
            merged = this.x2AllRM.getOutputRange();
            for (c = 0; c < layout.getGridColumns(); ++c) {
                for (r = 0; r < layout.getGridRows(); ++r) {
                    if (!this.isCellContainsPlot(r, c)) continue;
                    item = (CellItemInterface)((Object)this.getCellItem(r, c));
                    ((CellItemInterface2)item).setRange((byte)1, false, merged);
                }
                if (layout.isUseRowColAxes()) {
                    axis = (GridAxisInterface)((Object)this.getColumnAxis(c, false));
                    if (axis != null && !((GridAxisInterface2)axis).isMirror()) {
                        axis.setRange(merged);
                    }
                    if ((axis = (GridAxisInterface)((Object)this.getColumnAxis(c, true))) == null || !((GridAxisInterface2)axis).isMirror()) continue;
                    axis.setRange(merged);
                    continue;
                }
                axis = (GridAxisInterface)((Object)this.getCellAxis(0, c, 1));
                if (axis != null) {
                    axis.setRange(merged);
                }
                if ((axis = (GridAxisInterface)((Object)this.getCellAxis(layout.getGridRows() - 1, c, 3))) == null) continue;
                axis.setRange(merged);
            }
        }
    }

    public void addColumnScrollBar(int col, Component sbar, int position, boolean ignoreCellMargin) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        if (position != 1 && position != 3) {
            throw new IllegalArgumentException("invalid position " + position);
        }
        if (sbar == null) {
            return;
        }
        this.add(sbar, 0);
        layout.addColumnScrollBar(col, sbar, position, ignoreCellMargin);
    }

    public void addRowScrollBar(int row, Component sbar, int position, boolean ignoreCellMargin) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (position != 2 && position != 4) {
            throw new IllegalArgumentException("invalid position " + position);
        }
        if (sbar == null) {
            return;
        }
        this.add(sbar, 0);
        layout.addRowScrollBar(row, sbar, position, ignoreCellMargin);
    }

    public Component getColumnScrollBar(int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        return layout.getColumnScrollBar(col);
    }

    public Component getRowScrollBar(int row) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        return layout.getRowScrollBar(row);
    }

    public void removeColumnScrollBar(int col) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        Component sbar = layout.getColumnScrollBar(col);
        if (sbar == null) {
            return;
        }
        this.remove(sbar);
        layout.removeColumnScrollBar(col);
    }

    public void removeRowScrollBar(int row) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        Component sbar = layout.getRowScrollBar(row);
        if (sbar == null) {
            return;
        }
        this.remove(sbar);
        layout.removeRowScrollBar(row);
    }

    public void addCornerButton(Component button, int position) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        switch (position) {
            default: {
                throw new IllegalArgumentException("invalid position " + position);
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
        }
        if (button == null) {
            return;
        }
        this.add(button, 0);
        layout.addCornerButton(button, position);
    }

    public Component getCornerButton() {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getCornerButton();
    }

    public void removeCornerButton() {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        Component b = layout.getCornerButton();
        if (b == null) {
            return;
        }
        this.remove(b);
        layout.removeCornerButton();
    }

    public boolean isGridAnnotationFilled(int position) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.isGridAnnotationFilled(position);
    }

    public void setGridAnnotationFilled(boolean filled, int position) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setGridAnnotationFilled(filled, position);
    }

    @Override
    public int getAutoAlignStartegy() {
        return this.autoAlignStrategy;
    }

    @Override
    public void setAutoAlignStrategy(int autoAlignStrategy) {
        this.autoAlignStrategy = autoAlignStrategy;
    }

    @Override
    public String[] getPreferredLocations() {
        return this.preferredLocations;
    }

    @Override
    public void setPreferredLocations(String[] preferredLocations) {
        this.preferredLocations = preferredLocations;
    }

    @Override
    public boolean isFractionalHAlignment() {
        return this.fracHAlign;
    }

    @Override
    public void setFractionalHAlignment(boolean fracHAlign) {
        this.fracHAlign = fracHAlign;
    }

    @Override
    public boolean isFractionalVAlignment() {
        return this.fracVAlign;
    }

    @Override
    public void setFractionalVAlignment(boolean fracVAlign) {
        this.fracVAlign = fracVAlign;
    }

    public boolean isCompoundHeaders() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.isCompoundHeaders();
    }

    public void createRowCompoundHeader() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.createRowCompoundHeader();
    }

    public void createColumnCompoundHeader() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.createColumnCompoundHeader();
    }

    public CompoundHeader getColumnCompoundHeader() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.columnCompoundHeader;
    }

    public CompoundHeader getRowCompoundHeader() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.rowCompoundHeader;
    }

    public void createRowOLAPHeader() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.createRowOLAPHeader();
    }

    public void createColumnOLAPHeader() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.createColumnOLAPHeader();
    }

    public OLAPHeader getColumnOLAPHeader() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.columnOLAPHeader;
    }

    public OLAPHeader getRowOLAPHeader() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.rowOLAPHeader;
    }

    public void addRowOLAPHeaderTitle(Component title, boolean major) {
        if (major) {
            this.getRowOLAPHeader().getMajor().titleComponent = title;
        } else {
            this.getRowOLAPHeader().getMinor().titleComponent = title;
        }
        this.add(title);
    }

    public void addColumnOLAPHeaderTitle(Component title, boolean major) {
        if (major) {
            this.getColumnOLAPHeader().getMajor().titleComponent = title;
        } else {
            this.getColumnOLAPHeader().getMinor().titleComponent = title;
        }
        this.add(title);
    }

    public int getRowOLAPHeaderLevels(boolean major) {
        if (major) {
            return this.getRowOLAPHeader().getMajor().headerLevels;
        }
        return this.getRowOLAPHeader().getMinor().headerLevels;
    }

    public void setRowOLAPHeaderLevels(int levels, boolean major) {
        if (major) {
            this.getRowOLAPHeader().getMajor().headerLevels = levels;
        } else {
            this.getRowOLAPHeader().getMinor().headerLevels = levels;
        }
    }

    public int getColumnOLAPHeaderLevels(boolean major) {
        if (major) {
            return this.getColumnOLAPHeader().getMajor().headerLevels;
        }
        return this.getColumnOLAPHeader().getMinor().headerLevels;
    }

    public void setColumnOLAPHeaderLevels(int levels, boolean major) {
        if (major) {
            this.getColumnOLAPHeader().getMajor().headerLevels = levels;
        } else {
            this.getColumnOLAPHeader().getMinor().headerLevels = levels;
        }
    }

    public Color getRowOLAPHeaderBackground() {
        return this.getRowOLAPHeader().backgroundColor;
    }

    public void setRowOLAPHeaderBackground(Color bc) {
        this.getRowOLAPHeader().backgroundColor = bc;
    }

    public Color getColumnOLAPHeaderBackground() {
        return this.getColumnOLAPHeader().backgroundColor;
    }

    public void setColumnOLAPHeaderBackground(Color bc) {
        this.getColumnOLAPHeader().backgroundColor = bc;
    }

    public void setRowOLAPHeaderTree(DataTreeGroupNode tree, boolean major) {
        if (major) {
            this.getRowOLAPHeader().getMajor().setTree(tree);
        } else {
            this.getRowOLAPHeader().getMinor().setTree(tree);
        }
    }

    public void setColumnOLAPHeaderTree(DataTreeGroupNode tree, boolean major) {
        if (major) {
            this.getColumnOLAPHeader().getMajor().setTree(tree);
        } else {
            this.getColumnOLAPHeader().getMinor().setTree(tree);
        }
    }

    public void setRowOLAPHeaderLeafs(DefaultMutableTreeNode[] leafs, boolean major) {
        if (major) {
            this.getRowOLAPHeader().getMajor().headerLeafs = leafs;
        } else {
            this.getRowOLAPHeader().getMinor().headerLeafs = leafs;
        }
    }

    public void setColumnOLAPHeaderLeafs(DefaultMutableTreeNode[] leafs, boolean major) {
        if (major) {
            this.getColumnOLAPHeader().getMajor().headerLeafs = leafs;
        } else {
            this.getColumnOLAPHeader().getMinor().headerLeafs = leafs;
        }
    }

    public int getRowHeaderLabelPosition() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getRowHeaderLabelPosition();
    }

    public void setRowHeaderLabelPosition(int position) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setRowHeaderLabelPosition(position);
    }

    public int getColumnHeaderLabelPosition() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getColumnHeaderLabelPosition();
    }

    public void setColumnHeaderLabelPosition(int position) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setColumnHeaderLabelPosition(position);
    }

    public void addColumnCompoundHeaderLabel(int level, Component c) {
        this.getColumnCompoundHeader().getHeader(level).setLabel(c);
        this.add(c);
    }

    public void addColumn2CompoundHeaderLabel(int level, Component c) {
        this.getColumnCompoundHeader().getHeader(level).setLabel2(c);
        this.add(c);
    }

    public void addRowCompoundHeaderLabel(int level, Component c) {
        this.getRowCompoundHeader().getHeader(level).setLabel(c);
        this.add(c);
    }

    public void addRow2CompoundHeaderLabel(int level, Component c) {
        this.getRowCompoundHeader().getHeader(level).setLabel2(c);
        this.add(c);
    }

    public void addColumnCompoundHeader(int level, Component c) {
        this.getColumnCompoundHeader().getHeader(level).addHeader(c);
        this.add(c);
    }

    public void addColumn2CompoundHeader(int level, Component c) {
        this.getColumnCompoundHeader().getHeader(level).addHeader2(c);
        this.add(c);
    }

    public void addRowCompoundHeader(int level, Component c) {
        this.getRowCompoundHeader().getHeader(level).addHeader(c);
        this.add(c);
    }

    public void addRow2CompoundHeader(int level, Component c) {
        this.getRowCompoundHeader().getHeader(level).addHeader2(c);
        this.add(c);
    }

    public void addColumnHeaderLabel(Component c) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.columnHeaderLabel = c;
        this.add(c);
    }

    public void addColumn2HeaderLabel(Component c) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.column2HeaderLabel = c;
        this.add(c);
    }

    public void addRowHeaderLabel(Component c) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.rowHeaderLabel = c;
        this.add(c);
    }

    public void addRow2HeaderLabel(Component c) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.row2HeaderLabel = c;
        this.add(c);
    }

    public void setColumnAxisLabelPosition(int position) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setColumnAxisLabelPosition(position);
    }

    public int getColumnAxisLabelPosition() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getColumnAxisLabelPosition();
    }

    public void setColumn2AxisLabelPosition(int position) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setColumn2AxisLabelPosition(position);
    }

    public int getColumn2AxisLabelPosition() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getColumn2AxisLabelPosition();
    }

    public void setRowAxisLabelPosition(int position) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setRowAxisLabelPosition(position);
    }

    public int getRowAxisLabelPosition() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getRowAxisLabelPosition();
    }

    public void setRow2AxisLabelPosition(int position) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setRow2AxisLabelPosition(position);
    }

    public int getRow2AxisLabelPosition() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getRow2AxisLabelPosition();
    }

    public Component[] getRowAxisLabel() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.rowAxisLabel;
    }

    public Component[] getRow2AxisLabel() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.row2AxisLabel;
    }

    public Component getColumnAxisLabel() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.columnAxisLabel;
    }

    public Component getColumn2AxisLabel() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.column2AxisLabel;
    }

    public void addRowAxisLabel(Component[] c) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.rowAxisLabel = c;
        for (int i = 0; i < c.length; ++i) {
            this.add(c[i]);
        }
    }

    public void removeRowAxisLabel() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        Component[] c = layout.rowAxisLabel;
        for (int i = 0; i < c.length; ++i) {
            this.remove(c[i]);
        }
        layout.rowAxisLabel = null;
    }

    public void addRow2AxisLabel(Component[] c) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.row2AxisLabel = c;
        for (int i = 0; i < c.length; ++i) {
            this.add(c[i]);
        }
    }

    public void removeRow2AxisLabel() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        Component[] c = layout.row2AxisLabel;
        for (int i = 0; i < c.length; ++i) {
            this.remove(c[i]);
        }
        layout.row2AxisLabel = null;
    }

    public void addColumnAxisLabel(Component c) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.columnAxisLabel = c;
        this.add(c);
    }

    public void removeColumnAxisLabel() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (layout.columnAxisLabel != null) {
            this.remove(layout.columnAxisLabel);
            layout.columnAxisLabel = null;
        }
    }

    public void addColumn2AxisLabel(Component c) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.column2AxisLabel = c;
        this.add(c);
    }

    public void removeColumn2AxisLabel() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (layout.column2AxisLabel != null) {
            this.remove(layout.column2AxisLabel);
            layout.column2AxisLabel = null;
        }
    }

    public int getGlobalLegendSpacing() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getGlobalLegendSpacing();
    }

    public void setGlobalLegendSpacing(int globalLegendSpacing) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setGlobalLegendSpacing(globalLegendSpacing);
    }

    @Override
    public void setOpaque(boolean o) {
        this.opaque = o;
        super.setOpaque(false);
    }

    public void setColumnAxisHeightPercentage(double percentage) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setColumnAxisHeightPercentage(percentage);
    }

    public double getColumnAxisHeightPercentage() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getColumnAxisHeightPercentage();
    }

    public void setRowAxisWidthPercentage(double percentage) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setRowAxisWidthPercentage(percentage);
    }

    public double getRowAxisWidthPercentage() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getRowAxisWidthPercentage();
    }

    public void setRow2AxisWidthPercentage(double percentage) {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        layout.setRow2AxisWidthPercentage(percentage);
    }

    public double getRow2AxisWidthPercentage() {
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        return layout.getRow2AxisWidthPercentage();
    }

    public void addColumnGridLabel(int col, Component gridLabel, boolean primary) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (col < 0 || col >= layout.getGridColumns()) {
            throw new IllegalArgumentException("invalid column " + col);
        }
        if (gridLabel == null) {
            return;
        }
        this.add(gridLabel, 0);
        layout.addColumnGridLabel(col, gridLabel, primary);
    }

    public void addRowGridLabel(int row, Component gridLabel, boolean primary) {
        this.verifyLayout();
        TrellisLayout layout = (TrellisLayout)this.getLayout();
        if (row < 0 || row >= layout.getGridRows()) {
            throw new IllegalArgumentException("invalid row " + row);
        }
        if (gridLabel == null) {
            return;
        }
        this.add(gridLabel, 0);
        layout.addRowGridLabel(row, gridLabel, primary);
    }
}

