/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.anno;

import com.sas.graphics.anno.AbstractLineAnno;
import com.sas.graphics.anno.Constants;
import com.sas.graphics.anno.PointAndSpace;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;

public class LineAnno
extends AbstractLineAnno {
    protected PointAndSpace p1 = new PointAndSpace(null, null, 1, 1, true, true);
    protected PointAndSpace p2 = new PointAndSpace(null, null, 1, 1, true, true);
    protected int direction = 0;
    protected int shape = 0;
    protected double arrowScale = 1.0;
    protected boolean arrow = false;
    protected Point2D.Double s1D;
    protected Point2D.Double s2D;
    private double dir;
    private Point dirAnchor;
    private FontRenderContext frc = null;
    double adjustX = 0.0;
    double adjustY = 0.0;
    double saveAdjustX = 0.0;
    double saveAdjustY = 0.0;
    Point2D.Double saveS1 = null;
    Point2D.Double saveS2 = null;

    public boolean isArrowHeads() {
        return this.arrow;
    }

    public void setArrowHeads(boolean arrow) {
        this.arrow = arrow;
    }

    public Object getX1() {
        return this.p1.x;
    }

    public void setX1(Object x1) {
        this.p1.x = x1;
    }

    public Object getY1() {
        return this.p1.y;
    }

    public void setY1(Object y1) {
        this.p1.y = y1;
    }

    public int getX1Space() {
        return this.p1.xSpace;
    }

    @Override
    public int getHandleDirection(int handleID) {
        double normalizedRot;
        if (handleID == 9) {
            return 9;
        }
        for (normalizedRot = this.dir; normalizedRot < 0.0; normalizedRot += Math.PI * 2) {
        }
        while (normalizedRot > Math.PI * 2) {
            normalizedRot -= Math.PI * 2;
        }
        int angle = (int)Math.round(normalizedRot * 4.0 / Math.PI);
        if (angle == 0) {
            return 2;
        }
        if (angle == 1) {
            return 8;
        }
        if (angle == 2) {
            return 3;
        }
        if (angle == 3) {
            return 5;
        }
        if (angle == 4) {
            return 1;
        }
        if (angle == 5) {
            return 6;
        }
        if (angle == 6) {
            return 4;
        }
        if (angle == 7) {
            return 7;
        }
        return 0;
    }

    public void setX1Space(int space) {
        this.p1.xSpace = space;
    }

    public int getY1Space() {
        return this.p1.ySpace;
    }

    public void setY1Space(int space) {
        this.p1.ySpace = space;
    }

    public Object getX2() {
        return this.p2.x;
    }

    public void setX2(Object x2) {
        this.p2.x = x2;
    }

    public Object getY2() {
        return this.p2.y;
    }

    public void setY2(Object y2) {
        this.p2.y = y2;
    }

    public int getX2Space() {
        return this.p2.xSpace;
    }

    public void setX2Space(int space) {
        this.p2.xSpace = space;
    }

    public int getY2Space() {
        return this.p2.ySpace;
    }

    public void setY2Space(int space) {
        this.p2.ySpace = space;
    }

    public int getArrowDirection() {
        return this.direction;
    }

    public void setArrowDirection(int direction) {
        this.direction = direction;
    }

    public int getArrowShape() {
        return this.shape;
    }

    public void setArrowShape(int shape) {
        this.shape = shape;
    }

    public double getArrowScale() {
        return this.arrowScale;
    }

    public void setArrowScale(double scale) {
        this.arrowScale = scale;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.subpixelRendering) {
            this.subpixelPaint(g);
            return;
        }
        if (this.p1.x == null || this.p1.y == null || !this.container.isValidContainer()) {
            return;
        }
        this.s1D = this.container.getScreenPoint(this.p1, this.dataDPIScaleFactor);
        this.s2D = this.container.getScreenPoint(this.p2, this.dataDPIScaleFactor);
        if (this.s1D == null || this.s2D == null) {
            return;
        }
        Point s1 = LineAnno.getPoint(this.s1D);
        Point s2 = LineAnno.getPoint(this.s2D);
        boolean bl = this.badData = s1.x == Integer.MIN_VALUE || s1.y == Integer.MIN_VALUE || s2.x == Integer.MIN_VALUE || s2.y == Integer.MIN_VALUE;
        if (this.badData) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        if (this.clip) {
            boolean flag;
            boolean bl2 = flag = Constants.getSpace(this.p1.xSpace) == 2 && Constants.getSpace(this.p1.ySpace) == 2 && Constants.getSpace(this.p2.xSpace) == 2 && Constants.getSpace(this.p2.ySpace) == 2;
            if (flag) {
                Rectangle c = this.container.getDataBoundingBox();
                gc.clip(c);
            }
        }
        gc.setColor(this.lineColor);
        gc.setStroke(new BasicStroke(this.stroke.getLineWidth()));
        this.region.reset();
        if (this.arrow) {
            GeneralPath ar;
            if ((this.direction == 1 || this.direction == 2) && (ar = this.getArrow(s2, s1)) != null) {
                if (this.shape == 2 || this.shape == 3) {
                    gc.fill(ar);
                } else {
                    gc.draw(ar);
                }
                this.region.append(ar, false);
            }
            if ((this.direction == 0 || this.direction == 2) && (ar = this.getArrow(s1, s2)) != null) {
                if (this.shape == 2 || this.shape == 3) {
                    gc.fill(ar);
                } else {
                    gc.draw(ar);
                }
                this.region.append(ar, false);
            }
        }
        gc.setStroke(this.stroke);
        Point[] pp = this.getAdjustedPoints(s1, s2);
        boolean needToClip = false;
        if (this.label != null && this.label.length() > 0) {
            this.as = new AttributedString(this.label);
            if (this.font != null) {
                this.as.addAttribute(TextAttribute.FONT, this.font);
            }
            if (this.textColor != null) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textColor);
            }
            this.frc = gc.getFontRenderContext();
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            this.lbm.setPosition(0);
            TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
            float height = tl.getAscent() + tl.getDescent();
            float width = tl.getVisibleAdvance();
            double d = this.dir = this.textAnchor == 0 || this.textAnchor == 3 || this.textAnchor == 4 ? LineAnno.calculateDir(s1, s2) : 0.0;
            while (this.dir > Math.PI * 2) {
                this.dir -= Math.PI * 2;
            }
            while (this.dir < 0.0) {
                this.dir += Math.PI * 2;
            }
            if (this.dir > 1.5707963267948966 && this.dir <= Math.PI) {
                this.dir += Math.PI;
            } else if (this.dir > Math.PI && this.dir < 4.71238898038469) {
                this.dir -= Math.PI;
            }
            this.textAngle = 0.0;
            boolean hcenter = s1.y == s2.y ? false : (double)Math.abs((s1.x - s2.x) / (s1.y - s2.y)) < 1.0;
            switch (this.textAnchor) {
                default: {
                    this.drawRotatedText(gc, pp[0], pp[1], this.dir, tl, 0.0);
                    needToClip = true;
                    break;
                }
                case 3: {
                    this.drawRotatedText(gc, pp[0], pp[1], this.dir, tl, -0.6 * (double)height);
                    break;
                }
                case 4: {
                    this.drawRotatedText(gc, pp[0], pp[1], this.dir, tl, 0.6 * (double)height);
                    break;
                }
                case 2: {
                    float xo = hcenter ? (float)s2.x - width / 2.0f : (s1.x > s2.x ? (float)s2.x - width - 0.1f * height : (float)s2.x + 0.1f * height);
                    float yo = s1.y > s2.y ? (hcenter ? (float)s2.y - 1.1f * height : (float)s2.y - 0.5f * height) : (hcenter ? (float)s2.y + 0.1f * height : (float)s2.y - 0.5f * height);
                    tl.draw(gc, xo, yo + tl.getAscent());
                    this.textBounds = new Rectangle((int)xo, (int)yo, (int)tl.getVisibleAdvance(), (int)(tl.getAscent() + tl.getDescent()));
                    break;
                }
                case 1: {
                    float xo = hcenter ? (float)s1.x - width / 2.0f : (s1.x > s2.x ? (float)s1.x + 0.1f * height : (float)s1.x - width - 0.1f * height);
                    float yo = s1.y > s2.y ? (hcenter ? (float)s1.y + 0.1f * height : (float)s1.y - 0.5f * height) : (hcenter ? (float)s1.y - 1.1f * height : (float)s1.y - 0.5f * height);
                    tl.draw(gc, xo, yo + tl.getAscent());
                    this.textBounds = new Rectangle((int)xo, (int)yo, (int)tl.getVisibleAdvance(), (int)(tl.getAscent() + tl.getDescent()));
                }
            }
            this.region.append(this.textBounds, false);
        } else {
            this.textBounds = null;
        }
        Shape cp = gc.getClip();
        Polygon poly = new Polygon(new int[]{pp[0].x - 1, pp[0].x + 1, pp[1].x + 1, pp[1].x - 1}, new int[]{pp[0].y - 1, pp[0].y + 1, pp[1].y + 1, pp[1].y - 1}, 4);
        if (needToClip) {
            GeneralPath gp = new GeneralPath(0);
            if (cp == null) {
                gp.append(poly.getBounds(), false);
            } else {
                gp.append(cp, false);
            }
            gp.append(this.textBounds, false);
            gc.setClip(gp);
        }
        this.region.append(poly, false);
        Rectangle2D bounds = this.region.getBounds2D();
        this.boundsD = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        gc.drawLine(pp[0].x, pp[0].y, pp[1].x, pp[1].y);
        gc.dispose();
    }

    public void subpixelPaint(Graphics2D g) {
        if (this.p1.x == null || this.p1.y == null || !this.container.isValidContainer()) {
            return;
        }
        this.s1D = this.container.getScreenPoint(this.p1, this.dataDPIScaleFactor);
        this.s2D = this.container.getScreenPoint(this.p2, this.dataDPIScaleFactor);
        if (this.s1D == null || this.s2D == null) {
            return;
        }
        Point s1 = LineAnno.getPoint(this.s1D);
        Point s2 = LineAnno.getPoint(this.s2D);
        boolean bl = this.badData = s1.x == Integer.MIN_VALUE || s1.y == Integer.MIN_VALUE || s2.x == Integer.MIN_VALUE || s2.y == Integer.MIN_VALUE;
        if (this.badData) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        gc.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        if (this.clip) {
            boolean flag;
            boolean bl2 = flag = Constants.getSpace(this.p1.xSpace) == 2 && Constants.getSpace(this.p1.ySpace) == 2 && Constants.getSpace(this.p2.xSpace) == 2 && Constants.getSpace(this.p2.ySpace) == 2;
            if (flag) {
                Rectangle c = this.container.getDataBoundingBox();
                gc.clip(c);
            }
        }
        gc.setColor(this.lineColor);
        gc.setStroke(new BasicStroke(this.stroke.getLineWidth()));
        this.region.reset();
        if (this.arrow) {
            GeneralPath ar;
            if ((this.direction == 1 || this.direction == 2) && (ar = this.getArrow(this.s2D, this.s1D)) != null) {
                if (this.shape == 2 || this.shape == 3) {
                    gc.fill(ar);
                } else {
                    gc.draw(ar);
                }
                this.region.append(ar, false);
            }
            if ((this.direction == 0 || this.direction == 2) && (ar = this.getArrow(this.s1D, this.s2D)) != null) {
                if (this.shape == 2 || this.shape == 3) {
                    gc.fill(ar);
                } else {
                    gc.draw(ar);
                }
                this.region.append(ar, false);
            }
        }
        gc.setStroke(this.stroke);
        Point2D.Double[] pp = this.getAdjustedPoints(this.s1D, this.s2D);
        boolean needToClip = false;
        if (this.label != null && this.label.length() > 0) {
            this.as = new AttributedString(this.label);
            if (this.font != null) {
                this.as.addAttribute(TextAttribute.FONT, this.font);
            }
            if (this.textColor != null) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textColor);
            }
            this.frc = gc.getFontRenderContext();
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            this.lbm.setPosition(0);
            TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
            float height = tl.getAscent() + tl.getDescent();
            float width = tl.getVisibleAdvance();
            double d = this.dir = this.textAnchor == 0 || this.textAnchor == 3 || this.textAnchor == 4 ? LineAnno.calculateDir(this.s1D, this.s2D) : 0.0;
            while (this.dir > Math.PI * 2) {
                this.dir -= Math.PI * 2;
            }
            while (this.dir < 0.0) {
                this.dir += Math.PI * 2;
            }
            if (this.dir > 1.5707963267948966 && this.dir <= Math.PI) {
                this.dir += Math.PI;
            } else if (this.dir > Math.PI && this.dir < 4.71238898038469) {
                this.dir -= Math.PI;
            }
            this.textAngle = 0.0;
            boolean hcenter = this.s1D.y == this.s2D.y ? false : Math.abs((this.s1D.x - this.s2D.x) / (this.s1D.y - this.s2D.y)) < 1.0;
            switch (this.textAnchor) {
                default: {
                    this.drawRotatedText(gc, pp[0], pp[1], this.dir, tl, 0.0);
                    needToClip = true;
                    break;
                }
                case 3: {
                    this.drawRotatedText(gc, pp[0], pp[1], this.dir, tl, -0.6 * (double)height);
                    break;
                }
                case 4: {
                    this.drawRotatedText(gc, pp[0], pp[1], this.dir, tl, 0.6 * (double)height);
                    break;
                }
                case 2: {
                    float xo = hcenter ? (float)(this.s2D.x - (double)width / 2.0) : (this.s1D.x > this.s2D.x ? (float)(this.s2D.x - (double)width - (double)(0.1f * height)) : (float)(this.s2D.x + (double)(0.1f * height)));
                    float yo = this.s1D.y > this.s2D.y ? (hcenter ? (float)(this.s2D.y - (double)(1.1f * height)) : (float)(this.s2D.y - (double)(0.5f * height))) : (hcenter ? (float)(this.s2D.y + (double)(0.1f * height)) : (float)(this.s2D.y - (double)(0.5f * height)));
                    tl.draw(gc, xo, yo + tl.getAscent());
                    this.textBounds = new Rectangle((int)xo, (int)yo, (int)tl.getVisibleAdvance(), (int)(tl.getAscent() + tl.getDescent()));
                    break;
                }
                case 1: {
                    float xo = hcenter ? (float)(this.s1D.x - (double)width / 2.0) : (this.s1D.x > this.s2D.x ? (float)(this.s1D.x + (double)(0.1f * height)) : (float)(this.s1D.x - (double)width - (double)(0.1f * height)));
                    float yo = this.s1D.y > this.s2D.y ? (hcenter ? (float)(this.s1D.y + (double)(0.1f * height)) : (float)(this.s1D.y - (double)(0.5f * height))) : (hcenter ? (float)(this.s1D.y - (double)(1.1f * height)) : (float)(this.s1D.y - (double)(0.5f * height)));
                    tl.draw(gc, xo, yo + tl.getAscent());
                    this.textBounds = new Rectangle((int)xo, (int)yo, (int)tl.getVisibleAdvance(), (int)(tl.getAscent() + tl.getDescent()));
                }
            }
            this.region.append(this.textBounds, false);
        } else {
            this.textBounds = null;
        }
        Shape cp = gc.getClip();
        GeneralPath poly = new GeneralPath();
        poly.moveTo(pp[0].x - 1.0, pp[0].y - 1.0);
        poly.lineTo(pp[0].x + 1.0, pp[0].y + 1.0);
        poly.lineTo(pp[1].x + 1.0, pp[1].y + 1.0);
        poly.lineTo(pp[1].x - 1.0, pp[1].y - 1.0);
        poly.closePath();
        if (needToClip) {
            GeneralPath gp = new GeneralPath(0);
            if (cp == null) {
                gp.append(poly.getBounds(), false);
            } else {
                gp.append(cp, false);
            }
            gp.append(this.textBounds, false);
            gc.setClip(gp);
        }
        this.region.append(poly, false);
        Rectangle2D bounds = this.region.getBounds2D();
        this.boundsD = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        gc.draw(new Line2D.Double(pp[0].x, pp[0].y, pp[1].x, pp[1].y));
        gc.dispose();
    }

    private void drawRotatedText(Graphics2D gc, Point s1, Point s2, double rot, TextLayout tl, double transY) {
        this.drawRotatedText(gc, new Point2D.Double(s1.x, s1.y), new Point2D.Double(s2.x, s2.y), rot, tl, transY);
    }

    private void drawRotatedText(Graphics2D gc, Point2D.Double s1, Point2D.Double s2, double rot, TextLayout tl, double transY) {
        float height = tl.getAscent() + tl.getDescent();
        float width = tl.getVisibleAdvance();
        AffineTransform at = gc.getTransform();
        float xo = (float)((s1.x + s2.x) / 2.0 - (double)(width / 2.0f));
        float yo = (float)((s1.y + s2.y) / 2.0 - (double)(height / 2.0f));
        this.textAngle = rot;
        gc.rotate(rot, xo + width / 2.0f, yo + height / 2.0f);
        this.dirAnchor = new Point((int)(xo + width / 2.0f), (int)(yo + height / 2.0f));
        if (transY != 0.0) {
            gc.translate(0.0, transY);
            tl.draw(gc, xo, yo + tl.getAscent());
        } else {
            tl.draw(gc, xo, yo + tl.getAscent());
        }
        Rectangle2D.Double rr = new Rectangle2D.Double((double)xo - 0.2 * (double)height, (double)yo - 0.2 * (double)height + transY, (double)width + (double)height * 0.4, (double)height * 1.4);
        this.textBounds = AffineTransform.getRotateInstance(this.textAngle, this.dirAnchor.x, this.dirAnchor.y).createTransformedShape(rr);
        gc.setTransform(at);
    }

    private Point[] getAdjustedPoints(Point p1, Point p2) {
        double x1;
        float al;
        if (!this.arrow || this.shape == 0) {
            return new Point[]{p1, p2};
        }
        float penWidth = this.stroke == null ? 2.0f : this.stroke.getLineWidth();
        float arrowBase = (float)((double)(2.0f * penWidth) * this.arrowScale + 8.0);
        float arrowLength = 1.5f * arrowBase;
        float fx = (float)p1.getX();
        float fy = (float)p1.getY();
        float x = (float)p2.getX();
        float y = (float)p2.getY();
        if (Math.abs(fx - x) + Math.abs(fy - y) < 1.0f) {
            return new Point[]{p1, p2};
        }
        switch (this.shape) {
            case 3: {
                float aw = 2.0f * penWidth + arrowBase;
                al = aw / 4.0f + arrowLength;
                break;
            }
            default: {
                float aw = arrowBase;
                al = arrowLength;
            }
        }
        double rot = Math.PI + LineAnno.calculateDir(p1, p2);
        switch (this.shape) {
            default: {
                x1 = 0.75f * al;
                break;
            }
            case 1: 
            case 2: {
                x1 = al;
            }
        }
        double dx = x1 * Math.cos(rot);
        double dy = x1 * Math.sin(rot);
        if (this.direction == 2) {
            return new Point[]{new Point((int)((double)fx - dx), (int)((double)fy - dy)), new Point((int)((double)x + dx), (int)((double)y + dy))};
        }
        if (this.direction == 1) {
            return new Point[]{new Point((int)((double)fx - dx), (int)((double)fy - dy)), p2};
        }
        return new Point[]{p1, new Point((int)((double)x + dx), (int)((double)y + dy))};
    }

    private Point2D.Double[] getAdjustedPoints(Point2D.Double p1, Point2D.Double p2) {
        double x1;
        float al;
        if (!this.arrow || this.shape == 0) {
            return new Point2D.Double[]{p1, p2};
        }
        float penWidth = this.stroke == null ? 2.0f : this.stroke.getLineWidth();
        float arrowBase = (float)((double)(2.0f * penWidth) * this.arrowScale + 8.0);
        float arrowLength = 1.5f * arrowBase;
        float fx = (float)p1.getX();
        float fy = (float)p1.getY();
        float x = (float)p2.getX();
        float y = (float)p2.getY();
        if (Math.abs(fx - x) + Math.abs(fy - y) < 1.0f) {
            return new Point2D.Double[]{p1, p2};
        }
        switch (this.shape) {
            case 3: {
                float aw = 2.0f * penWidth + arrowBase;
                al = aw / 4.0f + arrowLength;
                break;
            }
            default: {
                float aw = arrowBase;
                al = arrowLength;
            }
        }
        double rot = Math.PI + LineAnno.calculateDir(p1, p2);
        switch (this.shape) {
            default: {
                x1 = 0.75f * al;
                break;
            }
            case 1: 
            case 2: {
                x1 = al;
            }
        }
        double dx = x1 * Math.cos(rot);
        double dy = x1 * Math.sin(rot);
        if (this.direction == 2) {
            return new Point2D.Double[]{new Point2D.Double((double)fx - dx, (double)fy - dy), new Point2D.Double((double)x + dx, (double)y + dy)};
        }
        if (this.direction == 1) {
            return new Point2D.Double[]{new Point2D.Double((double)fx - dx, (double)fy - dy), p2};
        }
        return new Point2D.Double[]{p1, new Point2D.Double((double)x + dx, (double)y + dy)};
    }

    private GeneralPath getArrow(Point p1, Point p2) {
        return this.getArrow(new Point2D.Double(p1.x, p1.y), new Point2D.Double(p2.x, p2.y));
    }

    private GeneralPath getArrow(Point2D.Double p1, Point2D.Double p2) {
        float al;
        float aw;
        float penWidth = this.stroke == null ? 2.0f : this.stroke.getLineWidth();
        float arrowBase = (float)((double)(2.0f * penWidth) * this.arrowScale + 8.0);
        float arrowLength = 1.5f * arrowBase;
        float fx = (float)p1.getX();
        float fy = (float)p1.getY();
        float x = (float)p2.getX();
        float y = (float)p2.getY();
        if (Math.abs(fx - x) + Math.abs(fy - y) < 1.0f) {
            return null;
        }
        switch (this.shape) {
            case 3: {
                aw = 2.0f * penWidth + arrowBase;
                al = aw / 4.0f + arrowLength;
                break;
            }
            default: {
                aw = arrowBase;
                al = arrowLength;
            }
        }
        GeneralPath ar = new GeneralPath(0, 3);
        double rot = Math.PI + LineAnno.calculateDir(p1, p2);
        switch (this.shape) {
            default: {
                ar.moveTo(x, y);
                ar.lineTo(x + al, y - aw / 2.0f);
                ar.lineTo(x + 0.75f * al, y);
                ar.lineTo(x + al, y + aw / 2.0f);
                ar.closePath();
                break;
            }
            case 0: {
                ar.moveTo(x + al, y - aw / 2.0f);
                ar.lineTo(x, y);
                ar.lineTo(x + al, y + aw / 2.0f);
                break;
            }
            case 1: 
            case 2: {
                ar.moveTo(x + al, y - aw / 2.0f);
                ar.lineTo(x, y);
                ar.lineTo(x + al, y + aw / 2.0f);
                ar.closePath();
            }
        }
        AffineTransform r = AffineTransform.getRotateInstance(rot, x, y);
        ar.transform(r);
        return ar;
    }

    static double calculateDir(Point from, Point to) {
        return LineAnno.calculateDir(new Point2D.Double(from.x, from.y), new Point2D.Double(to.x, to.y));
    }

    static double calculateDir(Point2D from, Point2D to) {
        double dx = to.getX() - from.getX();
        double dy = to.getY() - from.getY();
        double ang = 0.0;
        if (dx == 0.0) {
            if (dy > 0.0) {
                ang = 1.5707963267948966;
            } else if (dy < 0.0) {
                ang = -1.5707963267948966;
            }
        } else if (dy == 0.0) {
            if (dx > 0.0) {
                ang = 0.0;
            } else if (dx < 0.0) {
                ang = Math.PI;
            }
        } else {
            ang = dx > 0.0 && dy > 0.0 || dx > 0.0 && dy < 0.0 ? Math.atan(dy / dx) : (dx < 0.0 && dy > 0.0 ? Math.PI - Math.atan(-dy / dx) : Math.PI + Math.atan(dy / dx));
        }
        return ang;
    }

    public boolean isX1Primary() {
        return this.p1.xPrimary;
    }

    public void setX1Primary(boolean primary) {
        this.p1.xPrimary = primary;
    }

    public boolean isY1Primary() {
        return this.p1.yPrimary;
    }

    public void setY1Primary(boolean primary) {
        this.p1.yPrimary = primary;
    }

    public boolean isX2Primary() {
        return this.p2.xPrimary;
    }

    public void setX2Primary(boolean primary) {
        this.p2.xPrimary = primary;
    }

    public boolean isY2Primary() {
        return this.p2.yPrimary;
    }

    public void setY2Primary(boolean primary) {
        this.p2.yPrimary = primary;
    }

    @Override
    public void setDiscreteOffset(double discreteOffset) {
        this.offset = discreteOffset;
        this.p1.xOffset = discreteOffset;
        this.p1.yOffset = discreteOffset;
        this.p2.xOffset = discreteOffset;
        this.p2.yOffset = discreteOffset;
    }

    public void setX1DiscreteOffset(double discreteOffset) {
        this.p1.xOffset = discreteOffset;
    }

    public void setY1DiscreteOffset(double discreteOffset) {
        this.p1.yOffset = discreteOffset;
    }

    public double getX1DiscreteOffset() {
        return this.p1.xOffset;
    }

    public double getY1DiscreteOffset() {
        return this.p1.yOffset;
    }

    public void setX2DiscreteOffset(double discreteOffset) {
        this.p2.xOffset = discreteOffset;
    }

    public void setY2DiscreteOffset(double discreteOffset) {
        this.p2.yOffset = discreteOffset;
    }

    public double getX2DiscreteOffset() {
        return this.p2.xOffset;
    }

    public double getY2DiscreteOffset() {
        return this.p2.yOffset;
    }

    public double getDirection() {
        return this.dir;
    }

    public Point getDirectionAnchor() {
        return this.dirAnchor;
    }

    @Override
    public boolean isInDataSpace() {
        if (!this.isP1InDataSpace()) {
            return false;
        }
        return this.isP2InDataSpace();
    }

    public boolean isP1InDataSpace() {
        return Constants.getSpace(this.p1.xSpace) == 2 && Constants.getSpace(this.p1.ySpace) == 2;
    }

    public boolean isP2InDataSpace() {
        return Constants.getSpace(this.p2.xSpace) == 2 && Constants.getSpace(this.p2.ySpace) == 2;
    }

    public Line2D getLine() {
        if (this.s1D == null) {
            return new Line2D.Double();
        }
        return new Line2D.Double(this.s1D.x, this.s1D.y, this.s2D.x, this.s2D.y);
    }

    @Override
    public Shape[] getHandles() {
        if (this.s1D == null) {
            return new GeneralPath[0];
        }
        Shape[] handles = new Shape[]{new Ellipse2D.Double(this.s1D.x - 4.0, this.s1D.y - 4.0, 8.0, 8.0), new Ellipse2D.Double(this.s2D.x - 4.0, this.s2D.y - 4.0, 8.0, 8.0)};
        return handles;
    }

    @Override
    public void move(int handle, int x, int y, boolean snapToGrid) {
        if (this.s1D == null || this.s2D == null) {
            this.s1D = this.container.getScreenPoint(this.p1, this.dataDPIScaleFactor);
            this.s2D = this.container.getScreenPoint(this.p2, this.dataDPIScaleFactor);
        }
        this.saveAdjustX = this.adjustX;
        this.saveAdjustY = this.adjustY;
        this.saveS1 = this.s1D == null ? null : new Point2D.Double(this.s1D.getX(), this.s1D.getY());
        this.saveS2 = this.s2D == null ? null : new Point2D.Double(this.s2D.getX(), this.s2D.getY());
        switch (handle) {
            case 0: {
                this.s1D.x += (double)x + this.adjustX;
                this.s1D.y += (double)y + this.adjustY;
                if (snapToGrid) {
                    double dist = this.s1D.distance(this.s2D);
                    double angle = Math.toDegrees(Math.atan2(this.s1D.y - this.s2D.y, this.s1D.getX() - this.s2D.getX()));
                    double modangle = Math.round(angle / 15.0) * 15L;
                    double x1 = dist * Math.cos(Math.toRadians(modangle));
                    double y1 = dist * Math.sin(Math.toRadians(modangle));
                    Point2D.Double as = new Point2D.Double(this.s2D.getX() + x1, this.s2D.getY() + y1);
                    this.adjustX = Math.round(this.s1D.getX() - as.getX());
                    this.adjustY = Math.round(this.s1D.getY() - as.getY());
                    this.s1D = as;
                }
                this.container.update(this.p1, this.dataDPIScaleFactor, this.s1D);
                this.s1D = this.container.getScreenPoint(this.p1, this.dataDPIScaleFactor);
                break;
            }
            case 1: {
                this.s2D.x += (double)x + this.adjustX;
                this.s2D.y += (double)y + this.adjustY;
                if (snapToGrid) {
                    double dist = this.s2D.distance(this.s1D);
                    double angle = Math.toDegrees(Math.atan2(this.s2D.getY() - this.s1D.getY(), this.s2D.getX() - this.s1D.getX()));
                    double modangle = Math.round(angle / 15.0) * 15L;
                    double x1 = dist * Math.cos(Math.toRadians(modangle));
                    double y1 = dist * Math.sin(Math.toRadians(modangle));
                    Point2D.Double as = new Point2D.Double(this.s1D.getX() + x1, this.s1D.getY() + y1);
                    this.adjustX = Math.round(this.s2D.getX() - as.getX());
                    this.adjustY = Math.round(this.s2D.getY() - as.getY());
                    this.s2D = as;
                }
                this.container.update(this.p2, this.dataDPIScaleFactor, this.s2D);
                this.s2D = this.container.getScreenPoint(this.p2, this.dataDPIScaleFactor);
                break;
            }
            default: {
                this.s1D.x += (double)x;
                this.s1D.y += (double)y;
                this.container.update(this.p1, this.dataDPIScaleFactor, this.s1D);
                this.s1D = this.container.getScreenPoint(this.p1, this.dataDPIScaleFactor);
                this.s2D.x += (double)x;
                this.s2D.y += (double)y;
                this.container.update(this.p2, this.dataDPIScaleFactor, this.s2D);
                this.s2D = this.container.getScreenPoint(this.p2, this.dataDPIScaleFactor);
                break;
            }
            case 11: {
                this.s1D.x -= (double)x - this.adjustX;
                this.s1D.y -= (double)y - this.adjustY;
                this.s2D.x += (double)x - this.adjustX;
                this.s2D.y += (double)y - this.adjustY;
                if (snapToGrid) {
                    double dist = this.s2D.distance(this.s1D);
                    double angle = Math.toDegrees(Math.atan2(this.s2D.getY() - this.s1D.getY(), this.s2D.getX() - this.s1D.getX()));
                    double modangle = Math.round(angle / 15.0) * 15L;
                    double x1 = dist * Math.cos(Math.toRadians(modangle));
                    double y1 = dist * Math.sin(Math.toRadians(modangle));
                    this.adjustX = Math.round((this.s2D.getX() - this.s1D.getX() - x1) / 2.0);
                    this.adjustY = Math.round((this.s2D.getY() - this.s1D.getY() - y1) / 2.0);
                    this.s1D.x -= this.adjustX;
                    this.s1D.y -= this.adjustY;
                    this.s2D.x += this.adjustX;
                    this.s2D.y += this.adjustY;
                }
                this.container.update(this.p1, this.dataDPIScaleFactor, this.s1D);
                this.container.update(this.p2, this.dataDPIScaleFactor, this.s2D);
            }
        }
    }

    @Override
    public void undoMove() {
        this.adjustX = this.saveAdjustX;
        this.adjustY = this.saveAdjustY;
        if (this.saveS1 != null) {
            this.s1D = this.saveS1;
            this.container.update(this.p1, this.dataDPIScaleFactor, this.s1D);
            this.s1D = this.container.getScreenPoint(this.p1, this.dataDPIScaleFactor);
        }
        if (this.saveS2 != null) {
            this.s2D = this.saveS2;
            this.container.update(this.p2, this.linearScaleFactor, this.s2D);
            this.s2D = this.container.getScreenPoint(this.p2, this.dataDPIScaleFactor);
        }
        this.saveS1 = null;
        this.saveS2 = null;
    }

    @Override
    public void resetAdjusters() {
        this.adjustX = 0.0;
        this.adjustY = 0.0;
    }

    @Override
    public void scaleFromCenter(int x, int y, boolean snapToGrid) {
        double xo = (this.s1D.x + this.s2D.x) / 2.0;
        double yo = (this.s1D.x + this.s2D.x) / 2.0;
        if (snapToGrid) {
            Point2D.Double ns = new Point2D.Double(this.s2D.x + (double)x + this.adjustX, this.s2D.y + (double)y + this.adjustY);
            double dist = ns.distance(xo, yo);
            double angle = Math.toDegrees(Math.atan2(ns.y - yo, ns.x - xo));
            double modangle = Math.round(angle / 15.0) * 15L;
            double x1 = dist * Math.cos(Math.toRadians(modangle));
            double y1 = dist * Math.sin(Math.toRadians(modangle));
            this.s2D = new Point2D.Double(xo + x1, yo + y1);
            this.adjustX = Math.round(ns.x - this.s1D.x);
            this.adjustY = Math.round(ns.y - this.s1D.y);
            this.s1D = new Point2D.Double(xo - x1, yo - y1);
        } else {
            this.s1D = new Point2D.Double(this.s1D.x - (double)x, this.s1D.y - (double)y);
            this.s2D = new Point2D.Double(this.s2D.x + (double)x, this.s2D.y + (double)y);
        }
        this.container.update(this.p1, this.dataDPIScaleFactor, this.s1D);
        this.container.update(this.p2, this.dataDPIScaleFactor, this.s2D);
    }

    @Override
    public ArrayList<Point2D.Double> getAllScreenPoint2Ds() {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        points.add(this.s1D);
        points.add(this.s2D);
        return points;
    }

    @Override
    public void setAllScreenPoints(ArrayList<Point> points) {
        if (points.size() != 2) {
            return;
        }
        this.s1D = LineAnno.getPoint(points.get(0));
        this.s2D = LineAnno.getPoint(points.get(1));
        this.container.update(this.p1, this.dataDPIScaleFactor, this.s1D);
        this.container.update(this.p2, this.dataDPIScaleFactor, this.s2D);
    }

    @Override
    public ArrayList<Point> getAllScreenPoints() {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(LineAnno.getPoint(this.s1D));
        points.add(LineAnno.getPoint(this.s2D));
        return points;
    }

    @Override
    public void setAllScreenPoint2Ds(ArrayList<Point2D.Double> points) {
        if (points.size() != 2) {
            return;
        }
        this.s1D = points.get(0);
        this.s2D = points.get(1);
        this.container.update(this.p1, this.dataDPIScaleFactor, this.s1D);
        this.container.update(this.p2, this.dataDPIScaleFactor, this.s2D);
    }

    @Override
    public ArrayList<PointAndSpace> getAllPointAndSpacePoints() {
        ArrayList<PointAndSpace> points = new ArrayList<PointAndSpace>();
        points.add(this.p1);
        points.add(this.p2);
        return points;
    }

    @Override
    public void setAllPointAndSpacePoints(ArrayList<PointAndSpace> points) {
        if (points.size() != 2) {
            return;
        }
        this.p1 = points.get(0);
        this.p2 = points.get(1);
    }

    @Override
    public void drawText(Graphics2D gc, int caret, boolean highlight, Color hc) {
        if (this.lbm == null) {
            return;
        }
        Color c = this.getTextColor();
        if (highlight) {
            gc.setColor(hc);
            gc.fill(this.textBounds);
            c = new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
        }
        if (c != null) {
            this.as.addAttribute(TextAttribute.FOREGROUND, c);
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
        }
        this.lbm.setPosition(0);
        TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
        float height = tl.getAscent() + tl.getDescent();
        float width = tl.getVisibleAdvance();
        Point s1 = LineAnno.getPoint(this.s1D);
        Point s2 = LineAnno.getPoint(this.s2D);
        Point[] pp = this.getAdjustedPoints(s1, s2);
        float xo = (float)((pp[0].x + pp[1].x) / 2) - width / 2.0f;
        float yo = (float)((pp[0].y + pp[1].y) / 2) - height / 2.0f;
        AffineTransform at = gc.getTransform();
        boolean hcenter = s1.y == s2.y ? false : (double)Math.abs((s1.x - s2.x) / (s1.y - s2.y)) < 1.0;
        switch (this.textAnchor) {
            default: {
                if (this.dir == 0.0) break;
                gc.rotate(this.dir, xo + width / 2.0f, yo + height / 2.0f);
                break;
            }
            case 3: {
                if (this.dir != 0.0) {
                    gc.rotate(this.dir, xo + width / 2.0f, yo + height / 2.0f);
                }
                gc.translate(0.0, -0.6 * (double)height);
                break;
            }
            case 4: {
                if (this.dir != 0.0) {
                    gc.rotate(this.dir, xo + width / 2.0f, yo + height / 2.0f);
                }
                gc.translate(0.0, 0.6 * (double)height);
                break;
            }
            case 2: {
                xo = hcenter ? (float)s2.x - width / 2.0f : (s1.x > s2.x ? (float)s2.x - width - 0.1f * height : (float)s2.x + 0.1f * height);
                if (s1.y > s2.y) {
                    if (hcenter) {
                        yo = (float)s2.y - 1.1f * height;
                        break;
                    }
                    yo = (float)s2.y - 0.5f * height;
                    break;
                }
                if (hcenter) {
                    yo = (float)s2.y + 0.1f * height;
                    break;
                }
                yo = (float)s2.y - 0.5f * height;
                break;
            }
            case 1: {
                xo = hcenter ? (float)s1.x - width / 2.0f : (s1.x > s2.x ? (float)s1.x + 0.1f * height : (float)s1.x - width - 0.1f * height);
                if (s1.y > s2.y) {
                    if (hcenter) {
                        yo = (float)s1.y + 0.1f * height;
                        break;
                    }
                    yo = (float)s1.y - 0.5f * height;
                    break;
                }
                yo = hcenter ? (float)s1.y - 1.1f * height : (float)s1.y - 0.5f * height;
            }
        }
        if (highlight) {
            tl.draw(gc, xo, yo + tl.getAscent());
        }
        if (caret != -1) {
            this.drawCaret(gc, caret, xo, yo + tl.getAscent(), tl);
        }
        gc.setTransform(at);
        Stroke save = gc.getStroke();
        gc.setColor(Color.LIGHT_GRAY);
        gc.setStroke(textBorder);
        gc.draw(this.textBounds);
        gc.setStroke(save);
    }

    @Override
    public int getCaretPosition(int x, int y) {
        if (!this.textBounds.contains(x, y)) {
            return -1;
        }
        if (this.lbm == null || this.label == null) {
            return -1;
        }
        this.lbm.setPosition(0);
        TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
        float height = tl.getAscent() + tl.getDescent();
        float width = tl.getVisibleAdvance();
        Point s1 = LineAnno.getPoint(this.s1D);
        Point s2 = LineAnno.getPoint(this.s2D);
        Point[] pp = this.getAdjustedPoints(s1, s2);
        float xo = (float)((pp[0].x + pp[1].x) / 2) - width / 2.0f;
        float yo = (float)((pp[0].y + pp[1].y) / 2) - height / 2.0f;
        Point2D p = new Point2D.Double(x, y);
        boolean hcenter = s1.y == s2.y ? false : (double)Math.abs((s1.x - s2.x) / (s1.y - s2.y)) < 1.0;
        switch (this.textAnchor) {
            default: {
                if (this.dir == 0.0) break;
                p = AffineTransform.getRotateInstance(-this.dir, xo + width / 2.0f, yo + height / 2.0f).transform(p, p);
                break;
            }
            case 3: {
                p = AffineTransform.getTranslateInstance(0.0, 0.6 * (double)height).transform(p, p);
                if (this.dir == 0.0) break;
                p = AffineTransform.getRotateInstance(-this.dir, xo + width / 2.0f, yo + height / 2.0f).transform(p, p);
                break;
            }
            case 4: {
                p = AffineTransform.getTranslateInstance(0.0, -0.6 * (double)height).transform(p, p);
                if (this.dir == 0.0) break;
                p = AffineTransform.getRotateInstance(-this.dir, xo + width / 2.0f, yo + height / 2.0f).transform(p, p);
                break;
            }
            case 2: {
                xo = hcenter ? (float)s2.x - width / 2.0f : (s1.x > s2.x ? (float)s2.x - width - 0.1f * height : (float)s2.x + 0.1f * height);
                if (s1.y > s2.y) {
                    if (hcenter) {
                        yo = (float)s2.y - 1.1f * height;
                        break;
                    }
                    yo = (float)s2.y - 0.5f * height;
                    break;
                }
                if (hcenter) {
                    yo = (float)s2.y + 0.1f * height;
                    break;
                }
                yo = (float)s2.y - 0.5f * height;
                break;
            }
            case 1: {
                xo = hcenter ? (float)s1.x - width / 2.0f : (s1.x > s2.x ? (float)s1.x + 0.1f * height : (float)s1.x - width - 0.1f * height);
                if (s1.y > s2.y) {
                    if (hcenter) {
                        yo = (float)s1.y + 0.1f * height;
                        break;
                    }
                    yo = (float)s1.y - 0.5f * height;
                    break;
                }
                yo = hcenter ? (float)s1.y - 1.1f * height : (float)s1.y - 0.5f * height;
            }
        }
        int size = this.label.length();
        if (tl == null) {
            return size;
        }
        TextHitInfo thi = tl.hitTestChar((float)p.getX() - xo, (float)p.getY() - yo);
        int caret = 0;
        if (thi != null) {
            caret = thi.getInsertionIndex();
        }
        if (caret > size) {
            caret = size;
        }
        return caret;
    }

    @Override
    public Shape[] getImageMapRegions() {
        if (this.subpixelRendering) {
            return new Shape[]{LineAnno.makeWideLine(this.s1D, this.s2D, (double)this.getLineStroke().getLineWidth())};
        }
        return new Shape[]{LineAnno.makeWideLine(LineAnno.getPoint(this.s1D), LineAnno.getPoint(this.s2D), (double)this.getLineStroke().getLineWidth())};
    }

    public static GeneralPath makeWideLine(Point s1, Point s2, double lw) {
        double dx = s2.x - s1.x;
        double dy = s2.y - s1.y;
        double dist = Math.sqrt(dx * dx + dy * dy);
        if (dist == 0.0) {
            return null;
        }
        double hlw = lw / 2.0;
        double udx = -dy / dist;
        double udy = dx / dist;
        GeneralPath poly = new GeneralPath();
        poly.moveTo((double)s1.x + hlw * udx, (double)s1.y + hlw * udy);
        poly.lineTo((double)s2.x + hlw * udx, (double)s2.y + hlw * udy);
        poly.lineTo((double)s2.x - hlw * udx, (double)s2.y - hlw * udy);
        poly.lineTo((double)s1.x - hlw * udx, (double)s1.y - hlw * udy);
        poly.lineTo((double)s1.x + hlw * udx, (double)s1.y + hlw * udy);
        return poly;
    }

    public static GeneralPath makeWideLine(Point2D s1, Point2D s2, double lw) {
        double dy;
        double dx = s2.getX() - s1.getX();
        double dist = Math.sqrt(dx * dx + (dy = s2.getY() - s1.getY()) * dy);
        if (dist == 0.0) {
            return null;
        }
        double hlw = lw / 2.0;
        double udx = -dy / dist;
        double udy = dx / dist;
        GeneralPath poly = new GeneralPath();
        poly.moveTo(s1.getX() + hlw * udx, s1.getY() + hlw * udy);
        poly.lineTo(s2.getX() + hlw * udx, s2.getY() + hlw * udy);
        poly.lineTo(s2.getX() - hlw * udx, s2.getY() - hlw * udy);
        poly.lineTo(s1.getX() - hlw * udx, s1.getY() - hlw * udy);
        poly.lineTo(s1.getX() + hlw * udx, s1.getY() + hlw * udy);
        return poly;
    }
}

