/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.anno;

import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.anno.PointAndSpace;
import com.sas.graphics.anno.SizeAndSpace;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class DefaultAnnotationContainer
implements AnnotationContainer {
    protected Container container;
    protected Container graphContainer;

    public DefaultAnnotationContainer(Container container, Container rootContainer) {
        this.container = container;
        this.graphContainer = rootContainer;
    }

    @Override
    public Container getPrimaryContainer() {
        return this.container;
    }

    @Override
    public boolean isValidContainer() {
        return this.container.getWidth() > 0 && this.container.getHeight() > 0;
    }

    @Override
    public Point2D.Double getScreenPoint(PointAndSpace p, double dataDPIScaleFactor) {
        double yd;
        double xs = 0.0;
        double ys = 0.0;
        double xd = p.x instanceof Number ? ((Number)p.x).doubleValue() : -2.147483648E9;
        double d = yd = p.y instanceof Number ? ((Number)p.y).doubleValue() : -2.147483648E9;
        if (xd == -2.147483648E9 || yd == -2.147483648E9) {
            return new Point2D.Double(xd, yd);
        }
        Point origin = this.container != null ? SwingUtilities.convertPoint(this.container, 0, 0, this.graphContainer) : new Point(0, 0);
        switch (p.xSpace) {
            case 1: {
                xs = xd * (double)this.graphContainer.getWidth() / 100.0;
                break;
            }
            default: {
                xs = (double)origin.x + xd * (double)this.container.getWidth() / 100.0;
                break;
            }
            case 0: {
                xs = dataDPIScaleFactor * xd;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                xs = (double)origin.x + dataDPIScaleFactor * xd;
            }
        }
        switch (p.ySpace) {
            case 1: {
                ys = (100.0 - yd) * (double)this.graphContainer.getHeight() / 100.0;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                ys = (double)origin.y + (100.0 - yd) * (double)this.container.getHeight() / 100.0;
                break;
            }
            case 0: {
                ys = (double)this.graphContainer.getHeight() - dataDPIScaleFactor * yd;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                ys = (double)origin.y + ((double)this.container.getHeight() - dataDPIScaleFactor * yd);
            }
        }
        return new Point2D.Double(xs, ys);
    }

    @Override
    public Point2D.Double getScreenSize(SizeAndSpace size, double dataDPIScaleFactor) {
        double xs = 0.0;
        double ys = 0.0;
        if (Double.isNaN(size.width)) {
            xs = 2.147483647E9;
        } else {
            switch (size.widthSpace) {
                case 1: {
                    xs = size.width * (double)this.graphContainer.getWidth() / 100.0;
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: {
                    xs = size.width * (double)this.container.getWidth() / 100.0;
                    break;
                }
                case 0: {
                    xs = dataDPIScaleFactor * size.width;
                }
            }
        }
        if (Double.isNaN(size.height)) {
            ys = 2.147483647E9;
        } else {
            switch (size.heightSpace) {
                case 1: {
                    ys = size.height * (double)this.graphContainer.getHeight() / 100.0;
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: {
                    ys = size.height * (double)this.container.getHeight() / 100.0;
                    break;
                }
                case 0: {
                    ys = dataDPIScaleFactor * size.height;
                }
            }
        }
        return new Point2D.Double(xs, ys);
    }

    public void update(PointAndSpace p, double dataDPIScaleFactor, Point screen) {
        this.update(p, dataDPIScaleFactor, new Point2D.Double(screen.x, screen.y));
    }

    @Override
    public void update(PointAndSpace p, double dataDPIScaleFactor, Point2D.Double screen) {
        switch (p.xSpace) {
            case 1: {
                p.x = new Double(screen.x * 100.0 / (double)this.graphContainer.getWidth());
                break;
            }
            default: {
                p.x = new Double((screen.x - (double)this.container.getX()) * 100.0 / (double)this.container.getWidth());
                break;
            }
            case 0: {
                p.x = new Double(screen.x / dataDPIScaleFactor);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                p.x = new Double((screen.x - (double)this.container.getX()) / dataDPIScaleFactor);
            }
        }
        switch (p.ySpace) {
            case 1: {
                p.y = new Double(100.0 - screen.y * 100.0 / (double)this.graphContainer.getHeight());
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                p.y = new Double(100.0 - (screen.y - (double)this.container.getY()) * 100.0 / (double)this.container.getHeight());
                break;
            }
            case 0: {
                p.y = new Double(((double)this.graphContainer.getHeight() - screen.y) / dataDPIScaleFactor);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                p.y = new Double((double)this.container.getHeight() - (screen.y - (double)this.container.getY()) / dataDPIScaleFactor);
            }
        }
    }

    public void update(SizeAndSpace size, double dataDPIScaleFactor, Dimension newSize) {
        this.update(size, dataDPIScaleFactor, new Point2D.Double(newSize.width, newSize.height));
    }

    @Override
    public void update(SizeAndSpace size, double dataDPIScaleFactor, Point2D.Double newSize) {
        if (newSize.getX() >= 2.147483647E9) {
            size.width = Double.NaN;
        } else {
            switch (size.widthSpace) {
                case 1: {
                    size.width = 100.0 * newSize.getX() / (double)this.graphContainer.getWidth();
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: {
                    size.width = 100.0 * newSize.getX() / (double)this.container.getWidth();
                    break;
                }
                case 0: {
                    size.width = newSize.getX() / dataDPIScaleFactor;
                }
            }
        }
        if (newSize.getY() >= 2.147483647E9) {
            size.height = Double.NaN;
        } else {
            switch (size.heightSpace) {
                case 1: {
                    size.height = newSize.getY() * 100.0 / (double)this.graphContainer.getHeight();
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 8: {
                    size.height = newSize.getY() * 100.0 / (double)this.container.getHeight();
                    break;
                }
                case 0: {
                    size.height = newSize.getY() / dataDPIScaleFactor;
                }
            }
        }
    }

    @Override
    public boolean isDataValueSupported() {
        return false;
    }

    @Override
    public boolean isWallSpaceSupported() {
        return false;
    }

    @Override
    public Rectangle getDataBoundingBox() {
        return null;
    }

    @Override
    public Rectangle getBounds() {
        return this.container.getBounds();
    }

    @Override
    public Rectangle getGraphBounds() {
        return this.graphContainer.getBounds();
    }

    @Override
    public void repaint() {
        this.graphContainer.repaint();
    }
}

