/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.properties.OAGeneralPropertyTab;
import com.sas.olapadmin.properties.OAGenericGeneralPropertyTab;
import com.sas.olapadmin.properties.SharedDimensionCubesTab;
import com.sas.olapadmin.properties.SharedDimensionPropertiesOptionsTab;
import com.sas.olapadmin.properties.SharedDimensionStructurePropertyTab;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.workspace.visuals.CubeView;
import com.sas.wadmin.visuals.JOMANotesTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WorkspaceOMAView;

public class SharedDimensionView
extends WorkspaceOMAView {
    private static WAdminResource bundle = new WAdminResource(CubeView.class);

    public WAPropertyTabGroup createView() {
        super.createView();
        WAPropertyTabGroup tabs = null;
        try {
            SharedDimension dim = (SharedDimension)this.m_metadata;
            OLAPSharedDimension olapDim = null;
            olapDim = new OLAPSharedDimension(dim);
            int errorLevel = olapDim.getErrorLevel();
            if (errorLevel != -1) {
                MessageUtil.displayDetailsMessage((String)bundle.getString("SharedDimension.MetadataChanges.txt"), (int)0, (String)olapDim.getVerifyMessage().toString());
            } else {
                tabs = new WAPropertyTabGroup();
                tabs.addTab(bundle.getString("General.tab.title"), (WAPropertyTab)new OAGeneralPropertyTab((CMetadata)this.m_metadata, true));
                tabs.addTab(bundle.getString("SharedDimensionView.Options.Title.txt"), (WAPropertyTab)new SharedDimensionPropertiesOptionsTab(olapDim));
                tabs.addTab(bundle.getString("SharedDimensionView.Cubes.Title.txt"), (WAPropertyTab)new SharedDimensionCubesTab((CMetadata)this.m_metadata));
                tabs.addTab(bundle.getString("CubeView.Structure.Title.txt"), (WAPropertyTab)new SharedDimensionStructurePropertyTab(olapDim));
                tabs.addTab(bundle.getString("Notes.tab.title"), (WAPropertyTab)new JOMANotesTab(this.m_metadata));
                tabs.addTab(bundle.getString("ExtendedAttributes.tab.title"), (WAPropertyTab)new WAExtAttrPropertyTab((CMetadata)this.m_metadata));
                OAGenericGeneralPropertyTab advTab = new OAGenericGeneralPropertyTab((CMetadata)this.m_metadata);
                advTab.setHelpTopic("prop_shared_advanced");
                tabs.addTab(bundle.getString("Advanced.tab.title"), (WAPropertyTab)advTab);
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        return tabs;
    }
}

