/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.workspace.visuals;

import com.sas.olapadmin.actions.OLAPActionsManager;
import com.sas.olapadmin.workspace.visuals.OLAPFoldersTree;
import com.sas.olapadmin.workspace.visuals.OLAPPublicTypeFilter;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.model.tree.LogicalTreeNodeFactory;
import com.sas.wadmin.model.tree.MetadataTypeEventFilter;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WorkspaceTreeObject;
import com.sas.workspace.models.IMetadataTypeFilter;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.tree.FoldersTreeModel;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNodeFactory;
import com.sas.workspace.models.tree.InventoryTreeModel;
import com.sas.workspace.visuals.tree.FoldersTree;
import com.sas.workspace.visuals.tree.IBaseTree;
import com.sas.workspace.visuals.tree.InventoryTree;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OLAPWorkspaceTreeObject
implements WorkspaceTreeObject {
    protected JTabbedPane m_treesTabbedPane;
    protected boolean m_bActive;
    protected JTree m_treeActive;
    protected cTreeItem[] m_aTrees;
    protected boolean m_bInitialized;
    private static final int FOLDERS_TREE = 0;
    private static final int INVENTORY_TREE = 1;
    private static final int NUMBER_OF_TREES = 2;
    public static final String WarehouseTree = "WarehouseTree";
    public static final String InventoryTree = "InventoryTree";
    protected WAdminResource bundle = new WAdminResource(OLAPWorkspaceTreeObject.class);
    private TransformManager m_transformManager;

    public OLAPWorkspaceTreeObject() {
        this.m_treesTabbedPane = new JTabbedPane(1);
        this.m_treesTabbedPane.addChangeListener(this.createChangeListener());
    }

    protected ChangeListener createChangeListener() {
        return new cChangeListener();
    }

    protected int findInsertIndex(cTreeItem tree) {
        int nPrevTrees = 0;
        int nTrees = this.m_aTrees.length;
        for (int iTree = 0; iTree < nTrees && this.m_aTrees[iTree] != tree; ++iTree) {
            if (!this.m_aTrees[iTree].isVisible()) continue;
            ++nPrevTrees;
        }
        return nPrevTrees;
    }

    public Object findTree(String sName) {
        cTreeItem it = this.findTreeItem(sName);
        if (it != null) {
            return it.getTree();
        }
        return null;
    }

    protected cTreeItem findTreeItem(String sName) {
        int nTrees = this.m_aTrees.length;
        for (int iTree = 0; iTree < nTrees; ++iTree) {
            if (this.m_aTrees[iTree] == null || !this.m_aTrees[iTree].getName().equals(sName)) continue;
            return this.m_aTrees[iTree];
        }
        return null;
    }

    public FoldersTree getFoldersTree() {
        return (FoldersTree)this.findTree(WarehouseTree);
    }

    public JTree getSelectedTree() {
        Component cmpView;
        Component cmpSelected = this.m_treesTabbedPane.getSelectedComponent();
        if (cmpSelected instanceof JScrollPane && (cmpView = ((JScrollPane)cmpSelected).getViewport().getView()) instanceof IBaseTree) {
            return (JTree)cmpView;
        }
        return null;
    }

    public TransformManager getTransformManager() {
        return this.m_transformManager;
    }

    public Component getTreeComponent() {
        return this.m_treesTabbedPane;
    }

    public boolean hasFocus() {
        return true;
    }

    public void initialize() {
        OLAPActionsManager.getInstance();
        this.m_transformManager = TransformManager.createInstance();
        UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
        LogicalTreeNodeFactory nodeFactory = new LogicalTreeNodeFactory();
        OLAPPublicTypeFilter nodeFilter = new OLAPPublicTypeFilter();
        FoldersTreeModel foldersTreeModel = new FoldersTreeModel(userContext);
        foldersTreeModel.setNodeFactory((ITreeNodeFactory)nodeFactory);
        InventoryTreeModel inventoryTreeModel = new InventoryTreeModel(userContext);
        inventoryTreeModel.setNodeFactory((ITreeNodeFactory)nodeFactory);
        inventoryTreeModel.setCategoryFilter((IPublicTypeFilter)nodeFilter);
        MetadataTypeEventFilter eventFilter = new MetadataTypeEventFilter();
        foldersTreeModel.setEventFilter((IMetadataTypeFilter)eventFilter);
        inventoryTreeModel.setEventFilter((IMetadataTypeFilter)eventFilter);
        InventoryTree inventoryTree2 = new InventoryTree((ITreeModel)inventoryTreeModel);
        OLAPFoldersTree foldersTree = new OLAPFoldersTree((ITreeModel)foldersTreeModel);
        this.m_aTrees = new cTreeItem[2];
        this.m_aTrees[0] = new cTreeItem((JTree)((Object)foldersTree), WarehouseTree);
        this.m_aTrees[1] = new cTreeItem((JTree)inventoryTree2, InventoryTree);
        this.m_aTrees[0].initialize(true, true);
        this.m_aTrees[1].initialize(true, true);
        WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        int iPage = fileAppDefaults.getPropertyInt("OLAPWorkspaceTreeObject.SelectedTab", 0);
        int numtabs = this.m_treesTabbedPane.getTabCount();
        if (iPage < 0 || iPage >= numtabs) {
            iPage = 0;
        }
        if (numtabs != 0) {
            this.m_treesTabbedPane.setSelectedIndex(iPage);
        }
        this.m_bInitialized = true;
        Workspace.getWorkspace().clearStatusText();
    }

    public void refresh() {
        JTree tree = this.getSelectedTree();
        if (tree != null && tree instanceof WorkspaceTree) {
            ((WorkspaceTree)tree).refresh();
        }
    }

    public void refreshAll() {
        int nTrees = this.m_aTrees.length;
        for (int iTree = 0; iTree < nTrees; ++iTree) {
            if (!this.m_aTrees[iTree].isVisible()) continue;
            this.m_aTrees[iTree].refresh();
        }
    }

    public void removeAll() {
        this.m_treesTabbedPane.removeAll();
    }

    public void saveState() {
        if (this.m_bInitialized) {
            WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            fileAppDefaults.setPropertyInt("OLAPWorkspaceTreeObject.SelectedTab", this.m_treesTabbedPane.getSelectedIndex());
        }
    }

    public void setVisible(String sTree, boolean bVisible) {
        cTreeItem it = this.findTreeItem(sTree);
        if (it != null) {
            it.setVisible(bVisible);
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        if (this.m_treeActive != null) {
            this.updateTreeUIComponents(this.m_treeActive, bActive);
        }
        this.m_bActive = bActive;
    }

    private void updateTreeUIComponents(JTree tree, boolean bActive) {
        if (tree instanceof WorkspaceTree) {
            ((WorkspaceTree)tree).updateWorkspaceUIComponents(bActive);
        } else if (tree instanceof IBaseTree) {
            ((IBaseTree)tree).updateWorkspaceUIComponents(bActive);
        }
    }

    protected class cChangeListener
    implements ChangeListener {
        protected cChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTree treeActive = OLAPWorkspaceTreeObject.this.m_treeActive;
            if (OLAPWorkspaceTreeObject.this.m_bActive && treeActive != null) {
                OLAPWorkspaceTreeObject.this.updateTreeUIComponents(treeActive, false);
            }
            OLAPWorkspaceTreeObject.this.m_treeActive = treeActive = OLAPWorkspaceTreeObject.this.getSelectedTree();
            if (OLAPWorkspaceTreeObject.this.m_bActive && treeActive != null) {
                OLAPWorkspaceTreeObject.this.updateTreeUIComponents(treeActive, true);
            }
        }
    }

    protected class cTreeItem {
        protected JScrollPane m_scroll;
        protected JTree m_tree;
        protected String m_sName;
        protected boolean m_bVisible;

        public cTreeItem(JTree tree, String sName) {
            if (tree != null) {
                this.m_tree = tree;
                this.m_scroll = new JScrollPane(this.m_tree);
                this.m_scroll.setBorder(null);
            }
            this.m_sName = sName;
        }

        public Component getComponent() {
            return this.m_scroll;
        }

        public JTree getTree() {
            return this.m_tree;
        }

        public String getName() {
            return this.m_sName;
        }

        public boolean isVisible() {
            return this.m_bVisible;
        }

        public void setVisible(boolean bVisible) {
            if (bVisible == this.m_bVisible) {
                if (bVisible) {
                    OLAPWorkspaceTreeObject.this.m_treesTabbedPane.setSelectedComponent(this.m_scroll);
                }
                return;
            }
            if (bVisible) {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    int iTab = OLAPWorkspaceTreeObject.this.findInsertIndex(this);
                    OLAPWorkspaceTreeObject.this.m_treesTabbedPane.insertTab(OLAPWorkspaceTreeObject.this.bundle.getString(this.m_sName + ".Title.txt"), null, this.m_scroll, null, iTab);
                    OLAPWorkspaceTreeObject.this.m_treesTabbedPane.setSelectedComponent(this.m_scroll);
                }
                finally {
                    Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                }
            } else {
                OLAPWorkspaceTreeObject.this.m_treesTabbedPane.remove(this.m_scroll);
            }
            this.m_bVisible = bVisible;
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean("Trees." + this.m_sName + ".Visible", bVisible);
        }

        public void initialize(boolean bVisibleByDefault, boolean bAvailable) {
            Workspace workspace = Workspace.getWorkspace();
            if (bAvailable) {
                this.setVisible(workspace.getAppDefaultsFile().getPropertyBoolean("Trees." + this.m_sName + ".Visible", bVisibleByDefault));
            }
        }

        public void refresh() {
            if (this.m_tree != null && this.m_tree instanceof WorkspaceTree) {
                ((WorkspaceTree)this.m_tree).refresh();
            }
        }
    }
}

