/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.utilities.studio.OLAPFolderTreeModel;
import com.sas.olapadmin.utilities.studio.OLAPInventoryTreeModel;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.CheckoutsTreeModel;
import com.sas.workspace.models.tree.FoldersTreeModel;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.InventoryTreeModel;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import com.sas.workspace.models.tree.TreeNodeComparator;
import com.sas.workspace.visuals.dualselector.SelectorPanel;
import com.sas.workspace.visuals.tree.CheckoutsTree;
import com.sas.workspace.visuals.tree.FoldersTree;
import com.sas.workspace.visuals.tree.IBaseTree;
import com.sas.workspace.visuals.tree.InventoryTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;

public class OLAPTabbedTreePanel
extends JPanel
implements SelectorPanel {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = WAdminResource.getBundle(OLAPTabbedTreePanel.class);
    private UserContextInterface m_userContext;
    private cMultiTreeTabbedPanel m_tabbedPanel;
    private IBaseTree[] m_aTrees;
    private boolean m_bShowColumnSortOption;
    private boolean m_bAllowMultiSelection;
    private boolean multiLanguage;
    private List m_lSelectableParentTypes;
    private cSpecialColumnComparator m_columnComparator;
    private OLAPCube olapCube;
    private OLAPSharedDimension sharedDim;
    private OLAPDimension olapDim;
    private OLAPFolderTree m_foldersTree;
    private OLAPInventoryTree m_inventoryTree;
    private CheckoutsTree m_checkoutsTree;
    private List usedTables;
    private int maxSelection;
    private OLAPFolderTreeModel foldersTreeModel;
    private OLAPInventoryTreeModel inventoryTreeModel;

    public OLAPTabbedTreePanel(UserContextInterface userContext, boolean bShowColumnSortOption, boolean bAllowMultiSelection, boolean inMultiLanguage, int inMaxSelection, AbstractOLAPModel inObject) {
        this.m_userContext = userContext;
        this.m_bShowColumnSortOption = bShowColumnSortOption;
        this.m_bAllowMultiSelection = bAllowMultiSelection;
        this.multiLanguage = inMultiLanguage;
        this.maxSelection = inMaxSelection;
        if (inObject instanceof OLAPCube) {
            this.olapCube = (OLAPCube)inObject;
        } else if (inObject instanceof OLAPSharedDimension) {
            this.sharedDim = (OLAPSharedDimension)inObject;
        } else if (inObject instanceof OLAPDimension) {
            this.olapDim = (OLAPDimension)inObject;
        }
        this.initialize();
    }

    protected void initialize() {
        if (WsAbstractIconFactory.getInstance() == null) {
            try {
                WsAbstractIconFactory iconFactory = new WsAbstractIconFactory(){};
                iconFactory.setServer(this.m_userContext.getAuthServer());
                WsAbstractIconFactory.setInstance((WsAbstractIconFactory)iconFactory);
            }
            catch (ServiceException iconFactory) {
            }
            catch (RemoteException iconFactory) {
                // empty catch block
            }
        }
        int iSelectionMode = this.m_bAllowMultiSelection ? 4 : 1;
        cDefaultFilter defaultFilter = new cDefaultFilter();
        if (this.olapCube != null) {
            this.foldersTreeModel = new OLAPFolderTreeModel(this.m_userContext, (AbstractOLAPModel)this.olapCube, this.multiLanguage);
        } else if (this.sharedDim != null) {
            this.foldersTreeModel = new OLAPFolderTreeModel(this.m_userContext, (AbstractOLAPModel)this.sharedDim, this.multiLanguage);
        } else if (this.olapDim != null) {
            this.foldersTreeModel = new OLAPFolderTreeModel(this.m_userContext, (AbstractOLAPModel)this.olapDim, this.multiLanguage);
        }
        this.foldersTreeModel.setNodeFilter(defaultFilter);
        this.m_foldersTree = new OLAPFolderTree(this.foldersTreeModel);
        this.m_foldersTree.setEditable(false);
        this.m_foldersTree.addFocusListener(new TreeFocusListener());
        this.m_foldersTree.setCellRenderer(new DisableEnableRenderer());
        this.m_foldersTree.setContextMenusEnabled(false);
        this.m_foldersTree.setDraggingEnabled(false);
        this.m_foldersTree.getSelectionModel().setSelectionMode(iSelectionMode);
        if (this.olapCube != null) {
            this.inventoryTreeModel = new OLAPInventoryTreeModel(this.m_userContext, (AbstractOLAPModel)this.olapCube, this.multiLanguage);
        } else if (this.sharedDim != null) {
            this.inventoryTreeModel = new OLAPInventoryTreeModel(this.m_userContext, (AbstractOLAPModel)this.sharedDim, this.multiLanguage);
        } else if (this.olapDim != null) {
            this.inventoryTreeModel = new OLAPInventoryTreeModel(this.m_userContext, (AbstractOLAPModel)this.olapDim, this.multiLanguage);
        }
        this.inventoryTreeModel.setCategoryFilter(defaultFilter);
        this.m_inventoryTree = new OLAPInventoryTree(this.inventoryTreeModel);
        this.m_inventoryTree.setEditable(false);
        this.m_inventoryTree.addFocusListener(new TreeFocusListener());
        this.m_inventoryTree.setCellRenderer(new DisableEnableRenderer());
        this.m_inventoryTree.setContextMenusEnabled(false);
        this.m_inventoryTree.setDraggingEnabled(false);
        this.m_inventoryTree.getSelectionModel().setSelectionMode(iSelectionMode);
        OverrideSuppliedProperties newAction = new OverrideSuppliedProperties();
        this.m_inventoryTree.setUserDefaultAction((Action)((Object)newAction));
        this.m_foldersTree.setUserDefaultAction((Action)((Object)newAction));
        Workspace workspace = Workspace.getWorkspace();
        if (workspace != null && workspace.isChangeManagementOn()) {
            CheckoutsTreeModel checkoutsTreeModel = new CheckoutsTreeModel(this.m_userContext);
            checkoutsTreeModel.setNodeFilter((ISimpleObjectFilter)defaultFilter);
            this.m_checkoutsTree = new CheckoutsTree((ITreeModel)checkoutsTreeModel);
            this.m_checkoutsTree.setContextMenusEnabled(false);
            this.m_checkoutsTree.setDraggingEnabled(false);
            this.m_checkoutsTree.getSelectionModel().setSelectionMode(iSelectionMode);
            this.m_aTrees = new IBaseTree[]{this.m_foldersTree, this.m_inventoryTree, this.m_checkoutsTree};
        } else {
            this.m_aTrees = new IBaseTree[]{this.m_foldersTree, this.m_inventoryTree};
        }
        this.m_tabbedPanel = new cMultiTreeTabbedPanel(this.m_aTrees);
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.m_tabbedPanel), "Center");
        this.m_tabbedPanel.setSelectedTab(this.m_tabbedPanel.getTabAt(1));
        if (this.m_bShowColumnSortOption) {
            JCheckBox ckbSortColumns = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"TabbedTreePanel.SortColumns", (int)5);
            ckbSortColumns.addActionListener(new cSortColumnsListener());
            this.m_columnComparator = new cSpecialColumnComparator();
            this.setTreeModelComparator((Comparator)((Object)this.m_columnComparator));
            this.add((Component)ckbSortColumns, "South");
        }
    }

    public List getUsedTables() {
        if (this.usedTables == null) {
            this.usedTables = new ArrayList();
        }
        return this.usedTables;
    }

    public FoldersTree getFolderTree() {
        return this.m_foldersTree;
    }

    public InventoryTree getInventoryTree() {
        return this.m_inventoryTree;
    }

    public OLAPInventoryTreeModel getModel() {
        return this.inventoryTreeModel;
    }

    public void setNodeFilter(ISimpleObjectFilter filter) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            ((ITreeModel)this.m_aTrees[i].getModel()).setNodeFilter(filter);
        }
    }

    public void setInventoryTypesFilter(IPublicTypeFilter filter) {
        ((OLAPInventoryTreeModel)this.m_inventoryTree.getModel()).setCategoryFilter(filter);
        if (this.m_checkoutsTree != null) {
            ((CheckoutsTreeModel)this.m_checkoutsTree.getModel()).setTopLevelTypeFilter(filter);
        }
    }

    public void setAdditionalHierarchyModel(ISimpleObjectHierarchyModel model) {
        ((FoldersTreeModel)this.m_foldersTree.getModel()).setAdditionalHierarchyModel(model);
        ((InventoryTreeModel)this.m_inventoryTree.getModel()).setHierarchyModel(model);
        if (this.m_checkoutsTree != null) {
            ((CheckoutsTreeModel)this.m_checkoutsTree.getModel()).setHierarchyModel(model);
        }
    }

    public void setSelectableParentTypes(String[] aSelectableParentTypes) {
        this.m_lSelectableParentTypes = Arrays.asList(aSelectableParentTypes);
    }

    public void setSelectedObjects(SimpleObject[] aSelectedObjects) {
        this.m_foldersTree.selectObjects(aSelectedObjects);
        if (this.m_checkoutsTree != null) {
            this.m_checkoutsTree.selectObjects(aSelectedObjects);
        }
    }

    public Object[] getSelectedObjects() {
        if (this.m_lSelectableParentTypes == null || this.m_lSelectableParentTypes.isEmpty()) {
            return this.m_tabbedPanel.getSelectedTree().getSelectedObjects();
        }
        ArrayList<Object> lSelectedObjects = new ArrayList<Object>();
        IDataTreeNode[] nodes = this.m_tabbedPanel.getSelectedTree().getSelectedDataNodes();
        for (int iNode = 0; iNode < nodes.length; ++iNode) {
            IDataTreeNode node = nodes[iNode];
            if (node.getAllowsChildren() && this.m_lSelectableParentTypes.contains(node.getType())) {
                node.expand();
                Enumeration childNodes = node.children();
                while (childNodes.hasMoreElements()) {
                    IDataTreeNode childNode = (IDataTreeNode)childNodes.nextElement();
                    lSelectedObjects.add(childNode.getData());
                }
                continue;
            }
            lSelectedObjects.add(node.getData());
        }
        return lSelectedObjects.toArray();
    }

    public void setTreeModelComparator(Comparator cmp) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            ((ITreeModel)this.m_aTrees[i].getModel()).setNodeComparator(cmp);
        }
    }

    public void setEditable(boolean bEditable) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            ((JTree)this.m_aTrees[i]).setEnabled(bEditable);
        }
    }

    public void setDefaultAction(Action actDefault) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].setUserDefaultAction(actDefault);
        }
    }

    public IBaseTree getSelectedTree() {
        return this.m_tabbedPanel.getSelectedTree();
    }

    public void refreshTrees() {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].refresh();
        }
    }

    public void clearSelection() {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].clearSelection();
        }
    }

    public int getItemCount() {
        return ((JTree)this.getSelectedTree()).getRowCount();
    }

    public int getSelectedItemsCount() {
        return this.getSelectedTree().getSelectedObjects().length;
    }

    public int getLastSelectedIndex() {
        int[] aRows = ((JTree)this.getSelectedTree()).getSelectionRows();
        return aRows.length == 0 ? -1 : aRows[aRows.length - 1];
    }

    public void setSelectedIndex(int index) {
        ((JTree)this.getSelectedTree()).setSelectionRow(index);
    }

    public List getSelectedItems() {
        return new ArrayList<Object>(Arrays.asList(this.getSelectedObjects()));
    }

    public List getAllItems() {
        TreeModel model = this.getSelectedTree().getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        return Collections.list(root.breadthFirstEnumeration());
    }

    public List getAllMoveableItems() {
        return this.getAllItems();
    }

    public void addItems(List newItems) {
        throw new UnsupportedOperationException("Adding items is not supported.");
    }

    public void removeItems(List removeItems) {
        int size = removeItems.size();
        for (int i = 0; i < size; ++i) {
        }
    }

    public boolean containsItem(Object item) {
        String sID;
        if (item instanceof SimpleObject && (sID = ((SimpleObject)item).getID()) != null) {
            ITreeModel model = (ITreeModel)this.getSelectedTree().getModel();
            List lNodes = model.findNodes(sID);
            return lNodes.size() > 0;
        }
        return false;
    }

    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].addSelectionChangedListener(lsnr);
        }
    }

    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].removeSelectionChangedListener(lsnr);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].dispose();
        }
    }

    public MultiLanguageTreeNodeFilter getMultiLanguageTreeNodeFilter() {
        return new MultiLanguageTreeNodeFilter();
    }

    public void setMLS(boolean inMLS) {
        this.multiLanguage = inMLS;
        this.inventoryTreeModel.setMLS(inMLS);
        this.foldersTreeModel.setMLS(inMLS);
    }

    protected class OverrideSuppliedProperties
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        protected OverrideSuppliedProperties() {
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public class OLAPFolderTree
    extends FoldersTree {
        private static final long serialVersionUID = 1L;

        public OLAPFolderTree(ITreeModel model) {
            super(model);
        }

        protected void updateStatusBar() {
        }
    }

    public class OLAPInventoryTree
    extends InventoryTree {
        private static final long serialVersionUID = 1L;

        public OLAPInventoryTree(ITreeModel model) {
            super(model);
        }

        protected void updateStatusBar() {
        }
    }

    public class TreeFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            JTree sourceTree;
            Component obj = e.getComponent();
            if (obj instanceof JTree && (sourceTree = (JTree)obj).getMaxSelectionRow() < 0) {
                sourceTree.setSelectionRow(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class cSortColumnsListener
    implements ActionListener {
        private cSortColumnsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OLAPTabbedTreePanel.this.m_columnComparator.setSortColumns(((JCheckBox)e.getSource()).isSelected());
            OLAPTabbedTreePanel.this.refreshTrees();
        }
    }

    private class cDefaultFilter
    implements IPublicTypeFilter,
    ISimpleObjectFilter {
        private cDefaultFilter() {
        }

        public boolean accept(String publicType) {
            return false;
        }

        public boolean accept(SimpleObject simpleObject) {
            return false;
        }
    }

    private class cMultiTreeTabbedPanel
    extends WATabbedPanel {
        private static final long serialVersionUID = 1L;
        private IBaseTree[] m_aTheTrees;

        public cMultiTreeTabbedPanel(IBaseTree[] aTrees) {
            this.m_aTheTrees = aTrees;
            this.initialize();
        }

        protected void initialize() {
            for (int i = 0; i < this.m_aTheTrees.length; ++i) {
                cTreeTab tab = new cTreeTab(this.m_aTheTrees[i]);
                this.addTab(tab);
            }
        }

        public IBaseTree getSelectedTree() {
            return ((cTreeTab)this.getSelectedTab()).m_tree;
        }

        private class cTreeTab
        extends WAPropertyTab {
            private static final long serialVersionUID = 1L;
            IBaseTree m_tree;

            public cTreeTab(IBaseTree tree) {
                this.m_tree = tree;
                this.setName(this.m_tree.getName());
                this.setLayout(new BorderLayout());
                this.add(new JScrollPane((Component)this.m_tree), "Center");
            }
        }
    }

    private class DisableEnableRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private DisableEnableRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ITreeNode node = (ITreeNode)value;
            this.setText(node.getName());
            this.setIcon(node.getIcon());
            this.setDisabledIcon(node.getIcon());
            if (node instanceof SimpleBrowseObjectTreeNode) {
                SimpleBrowseObjectTreeNode selectedNode = (SimpleBrowseObjectTreeNode)value;
                SimpleBrowseObject browseObject = selectedNode.getSimpleBrowseObject();
                String fqid = browseObject.getID();
                String whatIsThis = browseObject.getPublicType();
                if (whatIsThis.equals("Table") && OLAPTabbedTreePanel.this.maxSelection == -1) {
                    if (!node.isEditable() || OLAPTabbedTreePanel.this.usedTables.contains(fqid)) {
                        this.setEnabled(false);
                    } else {
                        this.setEnabled(true);
                    }
                }
            }
            return this;
        }
    }

    private class cSpecialColumnComparator
    extends TreeNodeComparator {
        private boolean m_bSortColumns = false;

        private cSpecialColumnComparator() {
        }

        public void setSortColumns(boolean bSortColumns) {
            this.m_bSortColumns = bSortColumns;
        }

        public int compare(Object first, Object second) {
            if (!this.m_bSortColumns && first instanceof IDataTreeNode && "Column".equals(((IDataTreeNode)first).getType()) && second instanceof IDataTreeNode && "Column".equals(((IDataTreeNode)second).getType())) {
                return 0;
            }
            return super.compare(first, second);
        }
    }

    private class MultiLanguageTreeNodeFilter
    implements ISimpleObjectFilter {
        private MultiLanguageTreeNodeFilter() {
        }

        public boolean accept(SimpleObject simpleObject) {
            return !"Tree".equals(simpleObject.getMetadataType()) || "Folder".equals(simpleObject.getPublicType());
        }
    }
}

