/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.ChangeOLAPSchemaPanel;
import com.sas.olapadmin.utilities.studio.OLAPSchemaNewButton;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JLabel;

public class OLAPSchemaPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(OLAPSchemaPanel.class);
    private Object[] olapCubes;
    private String infoText;
    private ChangeOLAPSchemaPanel newOlapSchema;
    private OLAPSchema originalSchema;

    public OLAPSchemaPanel(Object[] inputOLAPCubes, String inputInfoText) {
        this.olapCubes = inputOLAPCubes;
        this.setLayout(new GridBagLayout());
        this.infoText = inputInfoText;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cube_change_olap_schema");
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        if (this.infoText != null) {
            JLabel labelDirections = new JLabel(this.infoText);
            this.add(labelDirections, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 5), 0, 0));
        }
        JLabel labelSchemas = new JLabel();
        labelSchemas.setName("cubeOlapschemaLabel");
        VisualUtilities.setLabelTextAndMnemonic(labelSchemas, bundle.getString("OLAPSchema.Label.txt"));
        this.newOlapSchema = new ChangeOLAPSchemaPanel(this.olapCubes);
        this.originalSchema = this.newOlapSchema.getSelectedOLAPSchema();
        labelSchemas.setLabelFor((Component)((Object)this.newOlapSchema));
        this.add(labelSchemas, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)((Object)this.newOlapSchema), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 0, 0));
        OLAPSchemaNewButton button = new OLAPSchemaNewButton(this.newOlapSchema, (AbstractOLAPModel)((OLAPCube)this.olapCubes[0]));
        this.add(button, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
        OLAPSchema newSchema = this.newOlapSchema.getSelectedOLAPSchema();
        if (newSchema != this.originalSchema) {
            ModelUtilities.setDefaultOLAPSchema((OLAPSchema)newSchema);
            OLAPCube olapCube = (OLAPCube)this.olapCubes[0];
            olapCube.setAssociatedOLAPSchema(newSchema);
            try {
                olapCube.updateMetadataOlapSchemaOnly();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
    }

    public boolean validateData() {
        boolean dataOK = false;
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            OLAPSchema newSchema = this.newOlapSchema.getSelectedOLAPSchema();
            if (!newSchema.equals(this.originalSchema)) {
                OLAPCube olapCube = (OLAPCube)this.olapCubes[0];
                try {
                    olapCube.setAssociatedOLAPSchema(newSchema);
                    olapCube.verifyOLAPSchema();
                    String cubeName = olapCube.getName();
                    dataOK = ModelUtilities.isCubeNameUniqueToOLAPSchema((String)cubeName, (OLAPSchema)newSchema);
                    if (!dataOK) {
                        MessageUtil.displayMessage((String)bundle.formatString("OLAPSchema.CubeNameNotUniqueToSchema.fmt.txt", (Object)cubeName));
                    }
                }
                catch (OLAPException e) {
                    olapCube.setAssociatedOLAPSchema(this.originalSchema);
                    dataOK = false;
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            } else {
                dataOK = true;
            }
        }
        return dataOK;
    }
}

