/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.utilities.studio.OLAPAbstractTreeModel;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.ISimpleObjectHierarchyElement;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.impl.SimpleObjectHierarchyModel;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import com.sas.workspace.models.tree.UserFolderTreeNode;
import com.sas.workspace.models.tree.inventory.LibraryElement;
import com.sas.workspace.models.tree.inventory.TableElement;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class OLAPFolderTreeModel
extends OLAPAbstractTreeModel {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = WAdminResource.getBundle(OLAPFolderTreeModel.class);
    protected static final Filter m_browseRootFilter = new Filter();
    protected static final Filter m_browseFolderFilter;
    private boolean multiLanguage;
    private ISimpleObjectHierarchyModel m_hierarchyModel;
    private ISimpleObjectHierarchyModel libraryHierarchyModel;

    public OLAPFolderTreeModel(UserContextInterface userContext, AbstractOLAPModel inObject, boolean inMultiLanguage) {
        super(userContext, null, inObject);
        SimpleBrowseObject rootObj = this.getFoldersRoot();
        if (rootObj != null) {
            cFoldersRootTreeNode foldersRoot = new cFoldersRootTreeNode(rootObj);
            foldersRoot.setUserObject("Folders");
            foldersRoot.setTreeModel(this);
            this.setRoot((TreeNode)((Object)foldersRoot));
        }
        this.libraryHierarchyModel = this.createDefaultHierarchyModel();
        this.multiLanguage = inMultiLanguage;
    }

    public void setAdditionalHierarchyModel(ISimpleObjectHierarchyModel hierarchyModel) {
        this.m_hierarchyModel = hierarchyModel;
    }

    protected ISimpleObjectHierarchyModel createDefaultHierarchyModel() {
        return new cDefaultInventoryHierarchyModel(this.m_server);
    }

    public boolean isValidParent(ITreeNode nodeParent, ITreeNode nodeChild) {
        if (nodeParent instanceof IDataTreeNode && nodeChild instanceof IDataTreeNode) {
            String sNodeParentID = ((IDataTreeNode)nodeParent).getID();
            if (sNodeParentID == null) {
                return false;
            }
            SimpleBrowseObject childObject = (SimpleBrowseObject)((IDataTreeNode)nodeChild).getData();
            List lRealParentIDs = this.getParentIDs(childObject);
            for (String sRealParentID : lRealParentIDs) {
                if (!sNodeParentID.equals(sRealParentID)) continue;
                return true;
            }
        }
        return false;
    }

    public void addChildren(ITreeNode parentNode) {
        ArrayList lChildren;
        block12: {
            lChildren = new ArrayList();
            try {
                if (parentNode == this.getRoot()) {
                    try {
                        this.addChild((ITreeNode)new UserFolderTreeNode(UserFolderType.MYFOLDER, this.getUserContext(), this.getNodeFactory()), parentNode);
                    }
                    catch (Exception ex) {
                        Workspace.getDefaultLogger().debug((Object)("Unable to create \"My Folder\" for user.  Reason: " + ex.getMessage()));
                    }
                    if (parentNode instanceof cFoldersRootTreeNode) {
                        SimpleBrowseObject rootFolder = ((cFoldersRootTreeNode)parentNode).getSimpleBrowseObject();
                        BrowseMetadataInterface browseFolder = this.m_server.browseFolder(rootFolder.getISEntityKey(), (FilterInterface)m_browseRootFilter);
                        lChildren.addAll((List)browseFolder.get("SoftwareTrees"));
                    }
                    break block12;
                }
                if (parentNode.isFolder() && parentNode instanceof SimpleBrowseObjectTreeNode) {
                    ArrayList subListOfChildren = new ArrayList();
                    SimpleBrowseObject folder = ((SimpleBrowseObjectTreeNode)parentNode).getSimpleBrowseObject();
                    BrowseMetadataInterface browseFolder = this.m_server.browseFolder(folder.getISEntityKey(), (FilterInterface)m_browseFolderFilter);
                    lChildren.addAll(browseFolder.getSubfolders());
                    subListOfChildren.addAll(browseFolder.getMembers());
                    if (this.multiLanguage) {
                        List filteredChildren = this.filterMLSTables(this.libraryHierarchyModel);
                        for (int i = subListOfChildren.size() - 1; i >= 0; --i) {
                            BrowseMetadataInterface browseObj = (BrowseMetadataInterface)subListOfChildren.get(i);
                            String objectId = (String)browseObj.get("Id");
                            if (!browseObj.get("MetadataObjectType").equals("PhysicalTable") || filteredChildren.contains(objectId)) continue;
                            subListOfChildren.remove(browseObj);
                        }
                    }
                    lChildren.addAll(subListOfChildren);
                }
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        if (!lChildren.isEmpty()) {
            for (BrowseMetadataInterface browseChild : lChildren) {
                SimpleBrowseObjectImpl simpleObj = new SimpleBrowseObjectImpl(browseChild);
                if (!this.isValidObject((SimpleBrowseObject)simpleObj)) continue;
                ITreeNode childNode = this.createNode(simpleObj);
                this.addChild(childNode, parentNode);
            }
        }
    }

    public void addChild(IDataTreeNode nodeNew) {
        List lParentNodes = this.findParentNodes((SimpleBrowseObject)nodeNew.getData());
        for (ITreeNode nodeParent : lParentNodes) {
            if (!nodeParent.isPopulated()) continue;
            this.addChild((ITreeNode)nodeNew, nodeParent);
        }
    }

    @Override
    public ITreeNode createNode(Object userObject) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)super.createNode(userObject);
        if (!node.getAllowsChildren() && userObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            node.setAllowsChildren(this.m_hierarchyModel.areChildrenAllowed((SimpleObject)userObject));
        }
        return (ITreeNode)node;
    }

    public List findParentNodes(SimpleBrowseObject object) {
        ArrayList lParentNodes = new ArrayList();
        List lParentIDs = this.getParentIDs(object);
        for (String sParentID : lParentIDs) {
            lParentNodes.addAll(this.findNodes(sParentID));
        }
        return lParentNodes;
    }

    private List getParentIDs(SimpleBrowseObject object) {
        ArrayList<Object> lParentIDs = new ArrayList<Object>();
        BrowseMetadataInterface browseObject = object.getBrowseObject();
        List lBrowseParents = browseObject.getParents();
        if (lBrowseParents.isEmpty() && browseObject.isAFolder()) {
            List lSoftwareComponents = (List)browseObject.get("SoftwareComponents");
            if (lSoftwareComponents != null) {
                String sRootID = ((cFoldersRootTreeNode)((Object)this.getRoot())).getID();
                for (BrowseMetadataInterface softComp : lSoftwareComponents) {
                    if (!sRootID.equals(softComp.get("Id"))) continue;
                    lParentIDs.add(sRootID);
                    break;
                }
            }
        } else {
            for (BrowseMetadataInterface browseParent : lBrowseParents) {
                lParentIDs.add(browseParent.get("Id"));
            }
        }
        if (this.m_hierarchyModel != null) {
            SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf((SimpleObject)object);
            for (int i = 0; i < aParents.length; ++i) {
                lParentIDs.add(aParents[i].getID());
            }
        }
        return lParentIDs;
    }

    public void addParentNodes(SimpleObject simpleObj) {
        SimpleBrowseObject simpleBrowseObj = this.getSimpleBrowseObject(simpleObj.getID(), simpleObj.getMetadataType());
        if (simpleBrowseObj == null) {
            return;
        }
        List lParentNodes = this.findParentNodes(simpleBrowseObj);
        if (lParentNodes.isEmpty()) {
            List lParents = simpleBrowseObj.getBrowseObject().getParents();
            if (this.m_hierarchyModel != null) {
                SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf(simpleObj);
                for (int i = 0; i < aParents.length; ++i) {
                    lParents.add(aParents[i].getBrowseObject());
                }
            }
            for (BrowseMetadataInterface browseParent : lParents) {
                SimpleBrowseObjectImpl simpleParent = new SimpleBrowseObjectImpl(browseParent);
                this.addParentNodes((SimpleObject)simpleParent);
            }
            lParentNodes = this.findParentNodes(simpleBrowseObj);
        }
        for (ITreeNode parentNode : lParentNodes) {
            parentNode.expand();
            ArrayList<ITreeNode> lChildren = Collections.list(parentNode.children());
            ITreeNode[] aChildren = lChildren.toArray(new ITreeNode[lChildren.size()]);
            this.fireDecorateIcons(aChildren);
        }
    }

    @Override
    protected SimpleBrowseObject getSimpleBrowseObject(String sFQID, String sType) {
        try {
            Filter filter = new Filter("Id", 0, sFQID);
            filter.setType(sType);
            filter.setOMRTemplate("<Templates><Root Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\"><ParentTree/><SoftwareComponents/><Trees/></Root></Templates>");
            filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x80 | 0x100 | 0x2000);
            List lBrowseObjects = this.m_server.browseSearch((FilterInterface)filter);
            if (!lBrowseObjects.isEmpty()) {
                return new SimpleBrowseObjectImpl((BrowseMetadataInterface)lBrowseObjects.get(0));
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    @Override
    protected boolean doesNodeAllowChildren(IDataTreeNode node) {
        Object dataObject = node.getData();
        if (dataObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            return this.m_hierarchyModel.areChildrenAllowed((SimpleObject)dataObject);
        }
        return super.doesNodeAllowChildren(node);
    }

    private SimpleBrowseObject getFoldersRoot() {
        try {
            RootFolderInterface rootFolder = this.m_server.getRootFolder();
            BrowseMetadataInterface browseBIPService = this.m_server.browseFolder(rootFolder.getEntityKey(), (FilterInterface)m_browseFilter);
            return new SimpleBrowseObjectImpl(browseBIPService);
        }
        catch (ServiceException ex) {
            Filter filter = new Filter();
            filter.setType("SoftwareComponent");
            FilterComponent fc = new FilterComponent("ClassIdentifier", 0, "E5F27790-2149-11D6-8828-AA0004006D06");
            fc.addComponent(new FilterComponent("Name", 0, "BIP Service"));
            fc.setAggregation(0);
            filter.setFilterComponent(fc);
            try {
                if (((MetadataServerInterface)this.m_server).getCountNoSecurity(filter, null) > 0) {
                    MessageUtil.displayMessage((String)bundle.getString("FoldersTreeModel.RootFolderError.txt"), (int)0);
                }
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public void setMLS(boolean inMLS) {
        this.multiLanguage = inMLS;
    }

    static {
        m_browseRootFilter.setOMRTemplate("<Templates><Root Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\"><SoftwareTrees /></Root></Templates>");
        m_browseRootFilter.setOMRFlags(-2147483628);
        m_browseFolderFilter = new Filter();
        m_browseFolderFilter.setOMRTemplate("<Templates><Root Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\"><Members /><SubTrees /></Root></Templates>");
        m_browseFolderFilter.setOMRFlags(-2147483628);
    }

    private class cDefaultInventoryHierarchyModel
    extends SimpleObjectHierarchyModel {
        public cDefaultInventoryHierarchyModel(ServerInterface server) {
            super(server);
            this.addElement((ISimpleObjectHierarchyElement)new LibraryElement(), "Library");
            this.addElement((ISimpleObjectHierarchyElement)new TableElement(false), "Table");
        }
    }

    private class cFoldersRootTreeNode
    extends SimpleBrowseObjectTreeNode {
        private static final long serialVersionUID = 1L;

        public cFoldersRootTreeNode(SimpleBrowseObject browseObject) {
            super(browseObject);
            this.setAllowsChildren(true);
            this.setEditable(false);
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isValidName(String sNewName) {
            throw new UnsupportedOperationException("This node cannot be renamed.");
        }

        public void rename(String sNewName) {
            throw new UnsupportedOperationException("This node cannot be renamed.");
        }

        public boolean delete() {
            throw new UnsupportedOperationException("This node cannot be deleted.");
        }

        public boolean isFolder() {
            return true;
        }

        public void update() {
            this.m_simpleBrowseObject = OLAPFolderTreeModel.this.getFoldersRoot();
        }
    }
}

