/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.changemanagement.CMEvent;
import com.sas.workspace.changemanagement.CMEventListener;
import com.sas.workspace.changemanagement.CMListenerManager;
import com.sas.workspace.models.IMetadataTypeFilter;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.ITreeNodeFactory;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import com.sas.workspace.models.tree.TreeNodeComparator;
import com.sas.workspace.models.tree.UserFolderTreeNode;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class OLAPAbstractTreeModel
extends DefaultTreeModel
implements ITreeModel {
    private static final long serialVersionUID = 1L;
    protected static final Filter m_browseFilter = new Filter();
    private UserContextInterface m_userContext;
    private ITreeNodeFactory m_nodeFactory;
    protected ISimpleObjectFilter m_nodeFilter;
    protected IMetadataTypeFilter m_eventFilter;
    protected Comparator m_comparator;
    protected ServerInterface m_server;
    protected boolean m_bUpdateInProgress;
    private MdFactoryListener m_mdFactoryListener;
    private CMEventListener m_CMEventListener;
    protected OLAPCube olapCube;
    protected OLAPSharedDimension sharedDim;
    protected OLAPDimension olapDim;

    public OLAPAbstractTreeModel(UserContextInterface userContext, ITreeNode root, AbstractOLAPModel inObject) {
        super((TreeNode)root, true);
        this.m_userContext = userContext;
        this.m_nodeFactory = this.createDefaultNodeFactory();
        this.m_nodeFilter = this.createDefaultNodeFilter();
        this.m_comparator = this.createDefaultComparator();
        if (inObject instanceof OLAPCube) {
            this.olapCube = (OLAPCube)inObject;
        } else if (inObject instanceof OLAPSharedDimension) {
            this.sharedDim = (OLAPSharedDimension)inObject;
        } else if (inObject instanceof OLAPDimension) {
            this.olapDim = (OLAPDimension)inObject;
        }
        try {
            if (this.m_userContext != null) {
                this.m_server = this.m_userContext.getAuthServer();
            }
            this.installListeners();
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public UserContextInterface getUserContext() {
        return this.m_userContext;
    }

    protected ITreeNodeFactory createDefaultNodeFactory() {
        return new cDefaultTreeNodeFactory();
    }

    protected ISimpleObjectFilter createDefaultNodeFilter() {
        return new cDefaultTreeNodeFilter();
    }

    protected Comparator createDefaultComparator() {
        return new TreeNodeComparator(0);
    }

    protected MdFactoryListener createMdFactoryListener() {
        return new cMdFactoryListener();
    }

    public void addIconDecoratorListener(ITreeModel.IconDecoratorListener lsnr) {
        this.listenerList.add(ITreeModel.IconDecoratorListener.class, lsnr);
    }

    public List filterMLSTables(ISimpleObjectHierarchyModel hierarchyModel) {
        List filterTables = null;
        try {
            PhysicalTable table;
            SASLibrary libraryObject;
            HashMap<SimpleBrowseObjectImpl, SimpleBrowseObject[]> libraryMap = new HashMap<SimpleBrowseObjectImpl, SimpleBrowseObject[]>();
            String libraryid = null;
            if (this.olapDim != null && (libraryObject = LibraryUtil.getLibrary((DataTable)(table = this.olapDim.getTable().getTable()), null)) != null) {
                libraryid = libraryObject.getId();
            }
            Filter filter = new Filter("PublicType", 0, "Library");
            filter.setType("SASLibrary");
            filter.setOMRTemplate(m_browseFilter.getOMRTemplate());
            filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x80 | 0x100 | 0x2000);
            List libraryObjects = this.m_server.browseSearch((FilterInterface)filter);
            for (BrowseMetadataInterface browseObj : libraryObjects) {
                SimpleBrowseObjectImpl simpleObj = new SimpleBrowseObjectImpl(browseObj);
                if (libraryid != null && (libraryid == null || !simpleObj.getID().equals(libraryid))) continue;
                SimpleBrowseObject[] aChildren = hierarchyModel.getChildrenOf((SimpleObject)simpleObj);
                libraryMap.put(simpleObj, aChildren);
            }
            filterTables = this.filterMLSByLibrary(libraryMap);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
        catch (OLAPException olap) {
            ExceptionHandler.handleException((Exception)((Object)olap));
        }
        return filterTables;
    }

    public List filterMLSByLibrary(Map libraryMap) {
        ArrayList<String> filterTables = new ArrayList<String>();
        try {
            PhysicalTable table;
            SASLibrary libraryObject2;
            String libraryid = null;
            if (this.olapDim != null && (libraryObject2 = LibraryUtil.getLibrary((DataTable)(table = this.olapDim.getTable().getTable()), null)) != null) {
                libraryid = libraryObject2.getId();
            }
            for (SASLibrary libraryObject2 : libraryMap.keySet()) {
                if (libraryid != null && (libraryid == null || !libraryObject2.getID().equals(libraryid))) continue;
                String libraryName = libraryObject2.getName();
                List validTablesByLibname = this.getValidDimensionTables(libraryName, (Object[])libraryMap.get(libraryObject2));
                int size = validTablesByLibname.size();
                for (int t = 0; t < size; ++t) {
                    SimpleBrowseObject simpleObj = (SimpleBrowseObject)validTablesByLibname.get(t);
                    filterTables.add(simpleObj.getID());
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return filterTables;
    }

    List getValidDimensionTables(String libraryName, Object[] dimensionTables) throws OLAPException {
        String locale;
        int tableNameLength;
        String tableName;
        int i;
        LanguageSet languageSet = null;
        if (this.olapCube != null) {
            languageSet = this.olapCube.getLanguageSet();
        } else if (this.sharedDim != null) {
            languageSet = this.sharedDim.getLanguageSet();
        } else if (this.olapDim != null) {
            languageSet = this.olapDim.getOwningCube().getLanguageSet();
        }
        List listOfLanguages = languageSet.getSelectedLocales();
        HashMap<String, SimpleBrowseObject> possibleMemprefs = new HashMap<String, SimpleBrowseObject>();
        HashMap memprefLocalesMap = new HashMap();
        ArrayList<SimpleBrowseObject> possibleValidDimensionTables = new ArrayList<SimpleBrowseObject>();
        for (i = dimensionTables.length - 1; i >= 0; --i) {
            SimpleBrowseObject dimTable = (SimpleBrowseObject)dimensionTables[i];
            if (dimTable == null) continue;
            tableName = dimTable.getName();
            if (libraryName == null) continue;
            tableNameLength = tableName.length();
            StringBuffer nameIndex = new StringBuffer();
            nameIndex.append(libraryName);
            nameIndex.append(tableName);
            if (tableNameLength <= 5) {
                possibleMemprefs.put(nameIndex.toString(), dimTable);
                continue;
            }
            locale = tableName.substring(tableNameLength - 5);
            if (!languageSet.isSelectedLocale(locale)) {
                possibleMemprefs.put(nameIndex.toString(), dimTable);
                continue;
            }
            possibleValidDimensionTables.add(dimTable);
        }
        for (i = possibleValidDimensionTables.size() - 1; i >= 0; --i) {
            SimpleBrowseObject table = (SimpleBrowseObject)possibleValidDimensionTables.get(i);
            tableName = table.getName();
            tableNameLength = tableName.length();
            String memprefName = tableName.substring(0, tableNameLength - 5);
            locale = tableName.substring(tableNameLength - 5);
            StringBuffer nameIndex = new StringBuffer();
            nameIndex.append(libraryName).append(memprefName);
            SimpleBrowseObject mempref = (SimpleBrowseObject)possibleMemprefs.get(nameIndex.toString());
            if (mempref != null) {
                ArrayList memprefLocales = (ArrayList)memprefLocalesMap.get(mempref);
                if (memprefLocales == null) {
                    memprefLocales = new ArrayList();
                    memprefLocalesMap.put(mempref, memprefLocales);
                    memprefLocales.add(listOfLanguages.get(0));
                }
                if (memprefLocales.indexOf(locale) < 0) {
                    memprefLocales.add(locale);
                }
                if (possibleValidDimensionTables.indexOf(mempref) < 0) {
                    possibleValidDimensionTables.add(mempref);
                }
            }
            possibleValidDimensionTables.remove(table);
        }
        for (i = possibleValidDimensionTables.size() - 1; i >= 0; --i) {
            SimpleBrowseObject possibleDimensionTable = (SimpleBrowseObject)possibleValidDimensionTables.get(i);
            List locales = (List)memprefLocalesMap.get(possibleDimensionTable);
            if (locales.size() == listOfLanguages.size()) continue;
            possibleValidDimensionTables.remove(i);
        }
        return possibleValidDimensionTables;
    }

    public void removeIconDecoratorListener(ITreeModel.IconDecoratorListener lsnr) {
        this.listenerList.remove(ITreeModel.IconDecoratorListener.class, lsnr);
    }

    protected void installListeners() throws RemoteException {
        this.m_mdFactoryListener = this.createMdFactoryListener();
        Workspace.getMdFactory().addMdFactoryListener(this.m_mdFactoryListener);
        this.m_CMEventListener = this.createCMEventListener();
        CMListenerManager.getInstance().addChangeListener(this.m_CMEventListener);
    }

    protected void uninstallListeners() throws RemoteException {
        Workspace.getMdFactory().removeMdFactoryListener(this.m_mdFactoryListener);
        CMListenerManager.getInstance().removeChangeListener(this.m_CMEventListener);
    }

    public void dispose() {
        try {
            this.uninstallListeners();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public boolean isUpdateInProgress() {
        return this.m_bUpdateInProgress;
    }

    protected CMEventListener createCMEventListener() {
        return new cCMEventListener();
    }

    public ITreeNodeFactory getNodeFactory() {
        return this.m_nodeFactory;
    }

    public void setNodeFactory(ITreeNodeFactory nodeFactory) {
        this.m_nodeFactory = nodeFactory;
    }

    public ISimpleObjectFilter getNodeFilter() {
        return this.m_nodeFilter;
    }

    public void setNodeFilter(ISimpleObjectFilter nodeFilter) {
        this.m_nodeFilter = nodeFilter;
    }

    public IMetadataTypeFilter getEventFilter() {
        return this.m_eventFilter;
    }

    public void setEventFilter(IMetadataTypeFilter eventFilter) {
        this.m_eventFilter = eventFilter;
    }

    public Comparator getNodeComparator() {
        return this.m_comparator;
    }

    public void setNodeComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
        IDataTreeNode node = (IDataTreeNode)path.getLastPathComponent();
        node.rename((String)value);
        this.nodeChanged((TreeNode)node);
    }

    public boolean isValidObject(SimpleBrowseObject simpleObj) {
        if (simpleObj.isAFolder()) {
            return true;
        }
        return this.m_nodeFilter.accept((SimpleObject)simpleObj);
    }

    public ITreeNode createNode(Object userObject) {
        if (userObject instanceof SimpleObject) {
            SimpleObject simpleObj = (SimpleObject)userObject;
            if (!(simpleObj instanceof SimpleBrowseObject)) {
                simpleObj = this.getSimpleBrowseObject(simpleObj.getID(), simpleObj.getMetadataType());
            }
            return this.m_nodeFactory.createNode((SimpleBrowseObject)simpleObj);
        }
        throw new IllegalArgumentException("Argument must be a SimpleObject.");
    }

    public void addChild(final ITreeNode newNode, final ITreeNode parentNode) {
        if (SwingUtilities.isEventDispatchThread()) {
            int iPosition;
            if (parentNode.isPopulated() && newNode instanceof IDataTreeNode && this.doesDuplicateNodeExistInParent((IDataTreeNode)newNode, parentNode)) {
                return;
            }
            int nChildren = parentNode.getChildCount();
            if (newNode instanceof UserFolderTreeNode) {
                iPosition = 0;
            } else if (parentNode.isSorted()) {
                ITreeNode childNode;
                int iFirst = 0;
                if (iFirst < nChildren) {
                    childNode = (ITreeNode)parentNode.getChildAt(iFirst);
                    while (childNode instanceof UserFolderTreeNode && ++iFirst < nChildren) {
                        childNode = (ITreeNode)parentNode.getChildAt(iFirst);
                    }
                }
                while (iFirst < nChildren) {
                    iPosition = (iFirst + nChildren) / 2;
                    childNode = (ITreeNode)parentNode.getChildAt(iPosition);
                    int iResult = this.m_comparator.compare(childNode, newNode);
                    if (iResult > 0) {
                        nChildren = iPosition;
                        continue;
                    }
                    if (iResult > 0) continue;
                    iFirst = iPosition + 1;
                }
                iPosition = iFirst;
            } else {
                iPosition = nChildren;
            }
            newNode.setTreeModel((ITreeModel)this);
            this.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, iPosition);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OLAPAbstractTreeModel.this.addChild(newNode, parentNode);
                    }
                });
            }
            catch (InterruptedException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
    }

    public void removeChild(final ITreeNode childNode) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.removeNodeFromParent((MutableTreeNode)childNode);
            childNode.dispose();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OLAPAbstractTreeModel.this.removeChild(childNode);
                    }
                });
            }
            catch (InterruptedException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
    }

    public void removeAllChildren(ITreeNode parentNode) {
        int nChildren = this.getChildCount(parentNode);
        for (int iChildren = nChildren - 1; iChildren >= 0; --iChildren) {
            this.removeChild((ITreeNode)parentNode.getChildAt(iChildren));
        }
    }

    public List findNodes(String sFQID) {
        return this.findNodes((DefaultMutableTreeNode)this.getRoot(), sFQID);
    }

    public List findNodes(DefaultMutableTreeNode startingNode, String sFQID) {
        ArrayList<ITreeNode> lNodes = new ArrayList<ITreeNode>();
        Enumeration<TreeNode> enumNodes = startingNode.breadthFirstEnumeration();
        while (enumNodes.hasMoreElements()) {
            ITreeNode nodeCurrent = (ITreeNode)enumNodes.nextElement();
            if (!(nodeCurrent instanceof IDataTreeNode) || !sFQID.equals(((IDataTreeNode)nodeCurrent).getID())) continue;
            lNodes.add(nodeCurrent);
        }
        return lNodes;
    }

    protected void addCreatedObjects(Map objectsMap) {
        ArrayList lNewNodes = new ArrayList();
        Map filteredObjectsMap = this.filterEventObjects(objectsMap);
        for (String sFQID : filteredObjectsMap.keySet()) {
            String sType = (String)filteredObjectsMap.get(sFQID);
            lNewNodes.addAll(this.addNode(sFQID, sType));
        }
        if (!lNewNodes.isEmpty()) {
            ITreeNode[] aNewNodes = new ITreeNode[lNewNodes.size()];
            aNewNodes = lNewNodes.toArray(aNewNodes);
            this.fireDecorateIcons(aNewNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDeletedObjects(String[] aFQIDs) {
        this.m_bUpdateInProgress = true;
        boolean bNodesWereRemoved = false;
        try {
            for (int i = 0; i < aFQIDs.length; ++i) {
                String sFQID = aFQIDs[i];
                List lNodes = this.findNodes(sFQID);
                for (ITreeNode node : lNodes) {
                    this.removeChild(node);
                    bNodesWereRemoved = true;
                }
            }
        }
        finally {
            this.m_bUpdateInProgress = false;
            if (bNodesWereRemoved) {
                this.nodesWereRemoved((TreeNode)this.getRoot(), new int[0], new Object[0]);
            }
        }
    }

    protected void updateModifiedObjects(Map objectsMap) {
        ArrayList<ITreeNode> lModifiedNodes = new ArrayList<ITreeNode>();
        Map filteredObjectsMap = this.filterEventObjects(objectsMap);
        for (String sFQID : filteredObjectsMap.keySet()) {
            List lNodes = this.findNodes(sFQID);
            if (!lNodes.isEmpty()) {
                for (ITreeNode node : lNodes) {
                    if (!(node instanceof IDataTreeNode)) continue;
                    this.updateNode((IDataTreeNode)node);
                    lModifiedNodes.add(node);
                }
                continue;
            }
            String sType = (String)filteredObjectsMap.get(sFQID);
            lModifiedNodes.addAll(this.addNode(sFQID, sType));
        }
        if (!lModifiedNodes.isEmpty()) {
            ITreeNode[] aModifiedNodes = new ITreeNode[lModifiedNodes.size()];
            aModifiedNodes = lModifiedNodes.toArray(aModifiedNodes);
            this.fireDecorateIcons(aModifiedNodes);
        }
    }

    protected Map filterEventObjects(Map objectsMap) {
        if (this.m_eventFilter == null) {
            return objectsMap;
        }
        HashMap filteredObjectsMap = new HashMap(objectsMap);
        Iterator iterEntry = filteredObjectsMap.entrySet().iterator();
        while (iterEntry.hasNext()) {
            Map.Entry entry = iterEntry.next();
            if (this.m_eventFilter.accept((String)entry.getValue())) continue;
            iterEntry.remove();
        }
        return filteredObjectsMap;
    }

    private List addNode(String sFQID, String sType) {
        ArrayList<ITreeNode> lNewNodes = new ArrayList<ITreeNode>();
        SimpleBrowseObject simpleObj = this.getSimpleBrowseObject(sFQID, sType);
        if (simpleObj == null || !this.isValidObject(simpleObj)) {
            return lNewNodes;
        }
        List lParentNodes = this.findParentNodes(simpleObj);
        if (lParentNodes != null) {
            for (ITreeNode parentNode : lParentNodes) {
                if (!parentNode.isPopulated()) continue;
                ITreeNode newNode = this.createNode(simpleObj);
                this.addChild(newNode, parentNode);
                lNewNodes.add(newNode);
            }
        }
        return lNewNodes;
    }

    private boolean doesDuplicateNodeExistInParent(IDataTreeNode childNode, ITreeNode parentNode) {
        String sID = childNode.getID();
        if (sID == null) {
            return false;
        }
        Enumeration children = parentNode.children();
        while (children.hasMoreElements()) {
            ITreeNode nextChildNode = (ITreeNode)children.nextElement();
            if (!(nextChildNode instanceof IDataTreeNode) || !sID.equals(((IDataTreeNode)nextChildNode).getID())) continue;
            return true;
        }
        return false;
    }

    private void updateNode(IDataTreeNode node) {
        String sOldName = node.getName();
        node.update();
        node.setAllowsChildren(this.doesNodeAllowChildren(node));
        ITreeNode nodeParent = (ITreeNode)node.getParent();
        if (!(node.equals(this.getRoot()) || node.getName().equals(sOldName) && this.isValidParent(nodeParent, (ITreeNode)node))) {
            if (nodeParent != null) {
                this.removeNodeFromParent((MutableTreeNode)node);
            }
            this.addChild(node);
        } else {
            this.reload((TreeNode)node);
        }
    }

    protected boolean doesNodeAllowChildren(IDataTreeNode node) {
        return node.isFolder();
    }

    protected void fireDecorateIcons(ITreeNode[] aNodes) {
        EventListener[] aLsnrs = this.listenerList.getListeners(ITreeModel.IconDecoratorListener.class);
        for (int i = 0; i < aLsnrs.length; ++i) {
            ((ITreeModel.IconDecoratorListener)aLsnrs[i]).decorateIcons(aNodes);
        }
    }

    protected SimpleBrowseObject getSimpleBrowseObject(String sFQID, String sType) {
        try {
            Filter filter = new Filter("Id", 0, sFQID);
            filter.setType(sType);
            filter.setOMRTemplate(m_browseFilter.getOMRTemplate());
            filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x80 | 0x100 | 0x2000);
            List lBrowseObjects = this.m_server.browseSearch((FilterInterface)filter);
            if (!lBrowseObjects.isEmpty()) {
                return new SimpleBrowseObjectImpl((BrowseMetadataInterface)lBrowseObjects.get(0));
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    static {
        m_browseFilter.setOMRTemplate("<Templates><Root Name=\"\" PublicType=\"\" ChangeState=\"\" LockedBy=\"\" /></Templates>");
        m_browseFilter.setOMRFlags(-2147483628);
    }

    private class cDefaultTreeNodeFilter
    implements ISimpleObjectFilter {
        private cDefaultTreeNodeFilter() {
        }

        public boolean accept(SimpleObject simpleObject) {
            return !"Tree".equals(simpleObject.getMetadataType()) || "Folder".equals(simpleObject.getPublicType());
        }
    }

    public class cDefaultTreeNodeFactory
    implements ITreeNodeFactory {
        public ITreeNode createNode(SimpleBrowseObject simpleObj) {
            return new SimpleBrowseObjectTreeNode(simpleObj);
        }
    }

    private class cCMEventListener
    implements CMEventListener {
        private cCMEventListener() {
        }

        public void CMObjectsUpdated(CMEvent ev) {
            Map mapObjects = ev.getObjectMapForPrimaryRepository();
            if (mapObjects != null) {
                OLAPAbstractTreeModel.this.updateModifiedObjects(mapObjects);
            }
        }

        public void CMObjectsDeleted(CMEvent ev) {
            String[] aFQIDs = ev.getArrayOfPrimaryIds();
            if (aFQIDs != null) {
                OLAPAbstractTreeModel.this.removeDeletedObjects(aFQIDs);
            }
        }

        public void CMObjectsCreated(CMEvent ev) {
            Map mapObjects = ev.getObjectMapForPrimaryRepository();
            if (mapObjects != null) {
                OLAPAbstractTreeModel.this.addCreatedObjects(mapObjects);
            }
        }
    }

    private class cMdFactoryListener
    implements MdFactoryListener {
        private cMdFactoryListener() {
        }

        public void MdObjectsCreated(MdFactoryEvent e) throws RemoteException {
            Map mapObjects = e.getObjectMap();
            if (mapObjects != null) {
                OLAPAbstractTreeModel.this.addCreatedObjects(mapObjects);
            }
        }

        public void MdObjectsDeleted(MdFactoryEvent e) throws RemoteException {
            String[] aFQIDs = e.getObjectIDs();
            if (aFQIDs != null) {
                OLAPAbstractTreeModel.this.removeDeletedObjects(aFQIDs);
            }
        }

        public void MdObjectsModified(MdFactoryEvent e) throws RemoteException {
            Map mapObjects = e.getObjectMap();
            if (mapObjects != null) {
                OLAPAbstractTreeModel.this.updateModifiedObjects(mapObjects);
            }
        }
    }
}

