/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.swing.visuals.WideComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;

public class DisabledItemComboBox
extends WideComboBox {
    private static final long serialVersionUID = 1L;
    private List disabledValues;
    private boolean isDisabled = false;

    public DisabledItemComboBox() {
        ListCellRenderer r = this.getRenderer();
        this.setRenderer(new DisabledItemListCellRenderer(r));
        UpAction up = new UpAction();
        DownAction down = new DownAction();
        ActionMap amc = this.getActionMap();
        amc.put("myUp", up);
        amc.put("myDown", down);
        InputMap imc = this.getInputMap();
        imc.put(KeyStroke.getKeyStroke(38, 0), "myUp");
        imc.put(KeyStroke.getKeyStroke(40, 0), "myDown");
    }

    public void setDisabledList(List values) {
        this.disabledValues = values;
    }

    public void setPopupVisible(boolean v) {
        if (!v && this.isDisabled) {
            this.isDisabled = false;
        } else {
            super.setPopupVisible(v);
        }
    }

    public void setSelectedIndex(int index) {
        Object item = this.getItemAt(index);
        if (this.disabledValues.contains(item)) {
            this.isDisabled = true;
        } else {
            this.isDisabled = false;
            super.setSelectedIndex(index);
        }
    }

    private final class DisabledItemListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer r;

        private DisabledItemListCellRenderer(ListCellRenderer r) {
            this.r = r;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c;
            boolean isEnabled;
            boolean bl = isEnabled = DisabledItemComboBox.this.disabledValues != null && !DisabledItemComboBox.this.disabledValues.contains(value);
            if (!isEnabled) {
                c = this.r.getListCellRendererComponent(list, value, index, false, false);
                c.setEnabled(false);
            } else {
                c = this.r.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                c.setEnabled(true);
            }
            return c;
        }
    }

    private final class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int si = DisabledItemComboBox.this.getSelectedIndex();
            for (int i = si - 1; i >= 0; --i) {
                Object item = DisabledItemComboBox.this.getItemAt(i);
                if (DisabledItemComboBox.this.disabledValues.contains(item)) continue;
                DisabledItemComboBox.this.setSelectedIndex(i);
                break;
            }
        }
    }

    private final class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int si = DisabledItemComboBox.this.getSelectedIndex();
            for (int i = si + 1; i < DisabledItemComboBox.this.getModel().getSize(); ++i) {
                Object item = DisabledItemComboBox.this.getItemAt(i);
                if (DisabledItemComboBox.this.disabledValues.contains(item)) continue;
                DisabledItemComboBox.this.setSelectedIndex(i);
                break;
            }
        }
    }
}

