/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class ChangeOLAPSchemaPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(ChangeOLAPSchemaPanel.class);
    private WAComboBox schemas;
    private Object[] olapObjects;
    private OLAPCube olapCube;
    private OLAPSharedDimension olapDim;

    public ChangeOLAPSchemaPanel(Object[] inputOLAPObjects) {
        this.olapObjects = inputOLAPObjects;
        AbstractOLAPModel object = (AbstractOLAPModel)this.olapObjects[0];
        if (object instanceof OLAPCube) {
            this.olapCube = (OLAPCube)object;
        } else if (object instanceof OLAPSharedDimension) {
            this.olapDim = (OLAPSharedDimension)object;
        }
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        block9: {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                try {
                    OLAPSchema cubeSchema;
                    if (this.olapCube != null) {
                        this.schemas = ModelUtilities.getOLAPSchemaSelections((MdObjectStore)this.olapCube.getObjectStore());
                        if (!this.olapCube.isNewObject()) {
                            cubeSchema = this.olapCube.getAssociatedOLAPSchema();
                            this.schemas.setSelectedItem((Object)cubeSchema);
                        }
                    } else if (this.olapDim != null) {
                        this.schemas = ModelUtilities.getOLAPSchemaSelections((MdObjectStore)this.olapDim.getObjectStore());
                        if (!this.olapDim.isNewObject()) {
                            cubeSchema = this.olapDim.getAssociatedOLAPSchema();
                            this.schemas.setSelectedItem((Object)cubeSchema);
                        }
                    }
                    break block9;
                }
                catch (OLAPException error) {
                    if (this.schemas == null) {
                        this.schemas = new WAComboBox();
                    }
                    break block9;
                }
            }
            this.schemas = new WAComboBox();
        }
        Dimension size = this.schemas.getPreferredSize();
        size.setSize(200.0, size.getHeight());
        this.schemas.setPreferredSize(size);
        this.schemas.setName("cubeOlapSchemaField");
        this.schemas.setToolTipText(bundle.getString("OLAPSchema.olapschemaToolTip.txt"));
        this.add((Component)this.schemas, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public OLAPSchema getSelectedOLAPSchema() {
        return (OLAPSchema)this.schemas.getSelectedItem();
    }

    public void setEnabled(boolean inputEnable) {
        this.schemas.setEnabled(inputEnable);
    }

    public void setSelectedOLAPSchema(Object selectedObject) {
        this.schemas.setSelectedItem(selectedObject);
    }

    public void addOLAPSchemaToList(Object newObject) {
        this.schemas.addItem(newObject);
    }
}

