/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.MemberTreeCellRenderer;
import com.sas.olapadmin.utilities.MemberTreeNode;
import com.sas.olapadmin.utilities.MemberTreePanel;
import com.sas.olapadmin.utilities.SimpleMemberTreeModel;
import com.sas.olapadmin.utilities.studio.BrowseMemberTreeDialog;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Member;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class BrowseMemberTreePanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(BrowseMemberTreePanel.class);
    private BrowseMemberTreeDialog parent;
    private JTree tree;
    private OLAPCube olapCube;
    private OLAPDimension dimension;
    private OlapServer olapServer;
    private String selectedUniqueName;
    private MemberTreePanel panel;
    private boolean showLeaf;
    private OLAPHierarchy hierarchy;

    public BrowseMemberTreePanel(BrowseMemberTreeDialog dialog, OLAPCube cube, OlapServer server, OLAPDimension lastSelectedDimension, boolean inLeaf) {
        this(dialog, cube, server, lastSelectedDimension, inLeaf, null);
    }

    public BrowseMemberTreePanel(BrowseMemberTreeDialog dialog, OLAPCube cube, OlapServer server, OLAPDimension lastSelectedDimension, boolean inLeaf, OLAPHierarchy hier) {
        this.dimension = lastSelectedDimension;
        this.hierarchy = hier;
        this.olapCube = cube;
        this.olapServer = server;
        this.parent = dialog;
        this.showLeaf = inLeaf;
        this.layoutWidgets();
    }

    public String getSelectedMember() {
        return this.selectedUniqueName;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JLabel treeLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(treeLabel, bundle.getString("BrowseMember.TreeLabel.txt"));
        this.panel = new MemberTreePanel(this.olapCube, this.olapServer, this.showLeaf, false, false, this.dimension, true, this.hierarchy);
        treeLabel.setLabelFor((Component)this.panel);
        this.add(treeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        try {
            this.tree = this.panel.getTreeComponent();
            if (this.olapServer != null && this.olapServer.isConnected()) {
                this.panel.moveDataToView();
            } else {
                SimpleMemberTreeModel simple = new SimpleMemberTreeModel(this.olapCube, this.dimension);
                this.tree.setModel((TreeModel)simple);
                this.tree.setCellRenderer((TreeCellRenderer)new MemberTreeCellRenderer());
                this.tree.setToggleClickCount(1);
                this.tree.addFocusListener(new BrowseTreeFocusAdapter());
            }
            BrowseTreeMouseAdapter mouseListener = new BrowseTreeMouseAdapter();
            this.tree.addMouseListener(mouseListener);
        }
        catch (com.sas.olapadmin.designer.model.OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
    }

    public void populateStore() throws MdException, RemoteException {
        this.setStorePopulated(true);
    }

    public void setSelectedMember(String uniqueName) {
        this.panel.setSelectedMember(uniqueName);
    }

    public boolean validateData() {
        boolean dataOK = false;
        int numSelection = this.tree.getSelectionCount();
        if (numSelection == 1) {
            TreePath selectedPath = this.tree.getSelectionPath();
            TreeNode selectedNode = (TreeNode)selectedPath.getLastPathComponent();
            Object userObject = null;
            if (selectedNode instanceof MemberTreeNode) {
                userObject = ((MemberTreeNode)selectedNode).getUserObject();
            } else if (selectedNode instanceof DefaultMutableTreeNode) {
                userObject = ((DefaultMutableTreeNode)selectedNode).getUserObject();
            }
            if (userObject != null) {
                if (userObject instanceof Member) {
                    dataOK = true;
                    try {
                        this.selectedUniqueName = ((Member)userObject).getUniqueName();
                    }
                    catch (OLAPException e) {
                        MessageUtil.displayMessage((String)bundle.getString("DataSourceTree.ReadError.txt"), (int)0);
                        this.selectedUniqueName = bundle.getString("Tree.Member.UniqueName.txt");
                    }
                } else if (userObject instanceof OLAPHierarchy) {
                    try {
                        dataOK = true;
                        OLAPHierarchy hier = (OLAPHierarchy)userObject;
                        this.selectedUniqueName = hier.getDimension().getUniqueName() + ".[" + hier.getAllMember() + "]";
                    }
                    catch (com.sas.olapadmin.designer.model.OLAPException e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("Tree.MemberMustBeSelected.txt"), (int)0);
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("Tree.MemberMustBeSelected.txt"), (int)0);
            }
        } else {
            MessageUtil.displayMessage((String)bundle.getString("Tree.OnlyOneAllowed.txt"), (int)0);
        }
        return dataOK;
    }

    public class BrowseTreeFocusAdapter
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            if (BrowseMemberTreePanel.this.tree.getMaxSelectionRow() < 0) {
                BrowseMemberTreePanel.this.tree.setSelectionRow(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    protected class BrowseTreeMouseAdapter
    extends MouseAdapter {
        protected BrowseTreeMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getClickCount() == 2 && e.getSource() instanceof JTree && BrowseMemberTreePanel.this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                BrowseMemberTreePanel.this.parent.closeWindow();
            }
        }
    }
}

