/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.ReachThruTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.update.QuickEditDialog;
import com.sas.olapadmin.update.UpdateOptionsTableDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UpdateOptionsPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(UpdateOptionsPanel.class);
    private OLAPCube olapCube;
    private boolean initialized;
    private WATextField currentDrillTable;
    private WATextField newDrillTable;
    public JCheckBox addData;
    private JButton selectDrill;
    private QuickEditDialog parent;
    public String conditionState;
    private PhysicalTable physicalTable;
    private String options;
    private String checkBoxValue;
    private String originalSecurityValue;
    private boolean dtlangsupport;
    private PhysicalTable originalPhysicalTable;
    private String originalOptions;
    private boolean originalDTsupport;

    public UpdateOptionsPanel(OLAPCube inCube, QuickEditDialog quickEditDialog) {
        this.olapCube = inCube;
        this.layoutWidgets();
        this.parent = quickEditDialog;
        this.initialized = false;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cube_options");
    }

    public HashMap getChanges() {
        HashMap<String, Object> list = new HashMap<String, Object>();
        list.put("New DrillTable", this.physicalTable);
        list.put("DrillThruTableOptions", this.options);
        list.put("DrillThruMLSSupport", this.dtlangsupport);
        try {
            if (!this.addData.isSelected()) {
                this.olapCube.setSecuritySubset("YES");
            } else {
                this.olapCube.setSecuritySubset("NO");
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return list;
    }

    public boolean optionsHaveChanged() {
        if (this.addData.isSelected()) {
            this.checkBoxValue = "NO";
        }
        if (!this.addData.isSelected()) {
            this.checkBoxValue = "YES";
        }
        return this.physicalTable != null && !this.physicalTable.equals(this.originalPhysicalTable) || this.physicalTable == null && this.originalPhysicalTable != null || !this.checkBoxValue.equals(this.originalSecurityValue) || this.dtlangsupport != this.originalDTsupport || this.options != null && !this.options.equals(this.originalOptions) || this.options == null && !ModelUtilities.isBlank((String)this.originalOptions);
    }

    public void moveDataToView() {
        try {
            TableSet tableSet = this.olapCube.getTableSet();
            ReachThruTable reachTable = tableSet.getReachThruTable();
            if (reachTable != null) {
                this.currentDrillTable.setText(ModelUtilities.generateTableName((PhysicalTable)reachTable.getTable()));
            } else {
                this.currentDrillTable.setText(bundle.getString("Common.None.txt"));
            }
            if (this.olapCube.getSecuritySubset().equals("NO")) {
                this.addData.setSelected(true);
            } else {
                this.addData.setSelected(false);
            }
            if (!this.initialized) {
                this.initialized = true;
                this.originalSecurityValue = this.olapCube.getSecuritySubset();
                if (reachTable != null) {
                    this.physicalTable = reachTable.getTable();
                    this.options = reachTable.getTableOptions();
                }
                this.originalOptions = this.options;
                this.originalPhysicalTable = this.physicalTable;
                try {
                    LanguageSet languageSet = this.olapCube.getLanguageSet();
                    this.originalDTsupport = this.dtlangsupport = languageSet.isCubeMLSDrillThruSupported();
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(new GridBagLayout());
        sourcePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("UpdateOptions.DrillThrough.header.title")));
        JLabel currentDrillLabel = new JLabel();
        currentDrillLabel.setName("currentdrilllabel");
        this.currentDrillTable = new WATextField(20);
        this.currentDrillTable.setBehavior(2);
        this.currentDrillTable.setName("currentDrillTable");
        currentDrillLabel.setLabelFor((Component)this.currentDrillTable);
        VisualUtilities.setLabelTextAndMnemonic(currentDrillLabel, bundle.getString("UpdateOptions.General.CurrentDrill.control.label"));
        sourcePanel.add((Component)currentDrillLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(25, 5, 5, 5), 0, 0));
        sourcePanel.add((Component)this.currentDrillTable, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(25, 5, 5, 5), 0, 0));
        JLabel newDrillLabel = new JLabel();
        newDrillLabel.setName("newDrilllabel");
        this.newDrillTable = new WATextField();
        this.newDrillTable.setName("newDrillTable");
        newDrillLabel.setLabelFor((Component)this.newDrillTable);
        this.newDrillTable.setEditable(false);
        VisualUtilities.setLabelTextAndMnemonic(newDrillLabel, bundle.getString("UpdateOptions.General.NewDrill.control.label"));
        sourcePanel.add((Component)newDrillLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        sourcePanel.add((Component)this.newDrillTable, new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.selectDrill = new JButton();
        this.selectDrill.setName("UpdateDrilltable");
        this.selectDrill.setToolTipText(bundle.getString("CubeUpdate.General.Select.Drillthrough.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.selectDrill, bundle.getString("CubeUpdate.General.Select.Drillthrough.action.label"));
        this.selectDrill.addActionListener(new BrowseButtonListener());
        sourcePanel.add((Component)this.selectDrill, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel sourcePanel2 = new JPanel();
        sourcePanel2.setLayout(new GridBagLayout());
        this.addData = new JCheckBox();
        this.addData.setName("updateAddData");
        VisualUtilities.setButtonTextAndMnemonic(this.addData, bundle.getString("UpdateOptions.IncludeMember.checkbox.label"));
        sourcePanel2.add((Component)this.addData, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 2, 5, 0), 0, 0));
        this.add(sourcePanel, new GridBagConstraints(0, 0, 3, 3, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(sourcePanel2, new GridBagConstraints(0, 6, 3, 3, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.olapCube.getTableSet().removeFromMetadataListener();
        super.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        try {
            if (!this.addData.isSelected()) {
                this.olapCube.setSecuritySubset("YES");
            } else {
                this.olapCube.setSecuritySubset("NO");
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return true;
    }

    private class BrowseButtonListener
    implements ActionListener {
        private BrowseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                String windowTitle = bundle.getString("CubeUpdate.SelectDrillTable.window.title");
                UpdateOptionsTableDialog browseDialog = new UpdateOptionsTableDialog((Dialog)((Object)UpdateOptionsPanel.this.parent), windowTitle, UpdateOptionsPanel.this.olapCube, UpdateOptionsPanel.this.physicalTable, UpdateOptionsPanel.this.options, UpdateOptionsPanel.this.dtlangsupport);
                browseDialog.setResizable(true);
                browseDialog.setHelpProduct("olapadmin");
                browseDialog.setHelpTopic("select_table_drilltable");
                browseDialog.show();
                if (browseDialog.getReturnValue() == 2) {
                    return;
                }
                UpdateOptionsPanel.this.physicalTable = browseDialog.getTable();
                UpdateOptionsPanel.this.options = browseDialog.getOptions();
                UpdateOptionsPanel.this.dtlangsupport = browseDialog.getMLSDrillThruState();
                try {
                    if (UpdateOptionsPanel.this.physicalTable != null) {
                        String nameOfCurrentTable = UpdateOptionsPanel.this.physicalTable.getName();
                        String nameOfOldTable = UpdateOptionsPanel.this.currentDrillTable.getText();
                        if (nameOfOldTable != null && !nameOfOldTable.equals(nameOfCurrentTable)) {
                            UpdateOptionsPanel.this.newDrillTable.setText(ModelUtilities.generateTableName((PhysicalTable)UpdateOptionsPanel.this.physicalTable));
                        }
                    } else {
                        UpdateOptionsPanel.this.newDrillTable.setText(" ");
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
            }
        }
    }
}

