/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.update.QuickEditDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.BrowseMemberTreeDialog;
import com.sas.util.UsageVersion;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsDialogTableCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class UpdateDefaultMemberPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(UpdateDefaultMemberPanel.class);
    private static String VERSION_WARNING_DEFAULT_MEM = "CubeDesigner.DefaultMember.Version.Number.Warning";
    private OLAPCube olapCube;
    private WsTable table;
    private OlapServer olapServer;
    private QuickEditDialog parentDialog;
    private HashMap originalMembers;
    private HashMap changedMembers;
    private DefaultMemberTableModel tableModel;
    private boolean initialized;

    public UpdateDefaultMemberPanel(OLAPCube inCube, QuickEditDialog quickEditDialog) {
        this.olapCube = inCube;
        this.parentDialog = quickEditDialog;
        this.originalMembers = new HashMap();
        this.changedMembers = new HashMap();
        this.layoutWidgets();
        this.initialized = false;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("default_member");
    }

    public HashMap getChanges() {
        return this.changedMembers;
    }

    public boolean membersHaveChanged() {
        TableCellEditor ce = this.table.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        this.changedMembers.clear();
        int rowCount = this.tableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            List row = this.tableModel.getRowValues(i);
            Object[] rowObjs = row.toArray();
            if (!(rowObjs[3] instanceof AbstractOLAPModel)) continue;
            AbstractOLAPModel olapObj = (AbstractOLAPModel)rowObjs[3];
            String currentValue = (String)rowObjs[2];
            String origValue = (String)this.originalMembers.get(olapObj);
            if (!(currentValue != null && !currentValue.equals(origValue) || currentValue == null && origValue != null)) {
                this.changedMembers.remove(olapObj);
                continue;
            }
            this.changedMembers.put(olapObj, currentValue);
        }
        return !this.changedMembers.isEmpty();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.tableModel = new DefaultMemberTableModel();
        this.table = new WsTable((WsAbstractTableModel)this.tableModel);
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        scrollPane.setPreferredSize(new Dimension(450, 350));
        this.add(scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        super.moveDataToView();
        if (!this.initialized) {
            this.tableModel.moveDataToModel();
            this.initialized = true;
        }
    }

    public void saveSettingsAndCleanUp() {
        try {
            if (this.olapServer != null && this.olapServer.isConnected()) {
                this.olapServer.disconnect();
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    class DefaultMemberTableModel
    extends WsAbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int TOTAL_COLS = 3;
        private static final int TOTAL_HIDDEN_COLS = 1;
        private static final int DIMENSION_NAME = 0;
        private static final int HIERARCHY_NAME = 1;
        private static final int DEFAULT_MEMBER = 2;
        public static final int HIERARCHY_OBJECT = 3;

        public DefaultMemberTableModel() {
            this.createColumnDefinitions();
        }

        private void createColumnDefinitions() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("UpdateDefaultMember.Dimension.header.title"), 100);
            this.m_aColumns[0].setEditable(false);
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("UpdateDefaultMember.Hierarchy.header.title"), 100);
            this.m_aColumns[1].setEditable(false);
            this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("UpdateDefaultMember.DefaultMember.header.title"), 300);
            WsDialogTableCellEditor cellEditor = new WsDialogTableCellEditor();
            cellEditor.setDialog((WsDialogTableCellEditorInterface)new DefaultMemberSelectionDialog());
            cellEditor.setClicksToStart(1);
            cellEditor.setStopEditingOnDialogClose(false);
            this.m_aColumns[2].setCellEditor((TableCellEditor)cellEditor);
            this.m_aColumns[2].setCellRenderer((TableCellRenderer)((Object)new MemberValueCellRenderer()));
            this.m_aColumns[3] = new WsObjectTableColumn();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getHiddenColumnCount() {
            return 1;
        }

        public void moveDataToModel() throws MdException, RemoteException {
            int nRows;
            boolean showVersionWarning;
            UsageVersion version4;
            UsageVersion version = UpdateDefaultMemberPanel.this.olapCube.getVersionNumber();
            if (version.compareMajorMinor(version4 = new UsageVersion(4, 0)) <= 0 && !UpdateDefaultMemberPanel.this.olapCube.isNewObject() && (showVersionWarning = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(VERSION_WARNING_DEFAULT_MEM, false))) {
                Workspace workspace = Workspace.getWorkspace();
                JCheckBox checkbox = new JCheckBox();
                VisualUtilities.setButtonTextAndMnemonic(checkbox, bundle.getString("Common.ShowMessage.checkbox.label"));
                WATextArea description = new WATextArea();
                description.setLineWrap(true);
                description.setBehavior(1);
                description.setWrapStyleWord(true);
                description.setRows(4);
                description.setColumns(35);
                String message = new String(bundle.getString("UpdateDefaultMember.BrowseMember.VersionChange.txt"));
                description.setText(message);
                Object[] allObjects = new Object[]{description, " ", checkbox};
                String titleMessage = bundle.getString("Common.warning.window.title");
                int optionSelected = JOptionPane.showConfirmDialog((Component)workspace, allObjects, titleMessage, -1, 2);
                if (checkbox.isSelected()) {
                    Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(VERSION_WARNING_DEFAULT_MEM, false);
                }
                if (optionSelected == -1) {
                    return;
                }
            }
            if ((nRows = this.m_lData.size()) > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            nRows = 0;
            try {
                OLAPList dims = UpdateDefaultMemberPanel.this.olapCube.getDimensionSet().getCubeDimensions();
                dims.sort();
                for (int dimNum = 0; dimNum < dims.size(); ++dimNum) {
                    OLAPDimension dim = (OLAPDimension)dims.get(dimNum);
                    OLAPList hiers = dim.getHierarchies();
                    hiers.sort();
                    for (int hierNum = 0; hierNum < hiers.size(); ++hierNum) {
                        OLAPHierarchy hier = (OLAPHierarchy)hiers.get(hierNum);
                        ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
                        alRow.add(0, dim.getName());
                        alRow.add(1, hier.getName());
                        String defaultMember = hier.getDefaultMember();
                        if (defaultMember == null) {
                            defaultMember = "";
                        }
                        alRow.add(2, defaultMember);
                        alRow.add(3, (String)hier);
                        UpdateDefaultMemberPanel.this.originalMembers.put(hier, alRow.get(2));
                        this.m_lData.add(alRow);
                    }
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            nRows = this.m_lData.size();
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
            this.m_nRowInstances = nRows;
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }

        public void populateStore() throws MdException, RemoteException {
        }
    }

    private class MemberValueCellRenderer
    extends WsDefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private MemberValueCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean bSelected, boolean bFocused, int row, int column) {
            super.getTableCellRendererComponent(table, value, bSelected, bFocused, row, column);
            if (column > 0) {
                int newrow = ((WsTable)table).convertRowIndexToModel(row);
                List values = UpdateDefaultMemberPanel.this.tableModel.getRowValues(newrow);
                Object obj = values.get(3);
                if (obj instanceof OLAPHierarchy) {
                    OLAPHierarchy olapObj = (OLAPHierarchy)obj;
                    Object orig = null;
                    orig = UpdateDefaultMemberPanel.this.originalMembers.get(olapObj);
                    UpdateDefaultMemberPanel.this.changedMembers.remove(olapObj);
                    this.setToolTipText("");
                    if (orig != null && !orig.equals(value) || orig == null && value != null) {
                        Font font = this.getFont();
                        this.setFont(font.deriveFont(1));
                        if (orig instanceof String && !Utilities.isBlank((String)((String)orig))) {
                            this.setToolTipText((String)orig);
                        }
                        UpdateDefaultMemberPanel.this.changedMembers.put(olapObj, value);
                    }
                }
            }
            JPanel pnl = new JPanel(new BorderLayout());
            pnl.setToolTipText(this.getToolTipText());
            pnl.add((Component)((Object)this), "Center");
            if (table.isCellEditable(row, column)) {
                JButton btn = WsUIUtilities.createBrowseButton();
                btn.setEnabled(true);
                pnl.add((Component)btn, "East");
                pnl.setBackground(table.getBackground());
            } else {
                pnl.setBackground(UIManager.getColor("TextField.disabledBackground"));
            }
            return pnl;
        }
    }

    private class DefaultMemberSelectionDialog
    implements WsDialogTableCellEditorInterface {
        public String showDialog(JTable tbl, int row, int col, String value) {
            String returnValue = value;
            try {
                if (UpdateDefaultMemberPanel.this.olapServer == null) {
                    UpdateDefaultMemberPanel.this.olapServer = new OlapServer((AbstractOLAPModel)UpdateDefaultMemberPanel.this.olapCube);
                }
                if (!UpdateDefaultMemberPanel.this.olapServer.isConnected()) {
                    UpdateDefaultMemberPanel.this.olapServer.connect();
                }
                int newrow = UpdateDefaultMemberPanel.this.table.convertRowIndexToModel(row);
                List values = UpdateDefaultMemberPanel.this.tableModel.getRowValues(newrow);
                Object obj = values.get(3);
                if (obj instanceof OLAPHierarchy) {
                    OLAPHierarchy hier = (OLAPHierarchy)obj;
                    OLAPDimension dim = hier.getDimension();
                    BrowseMemberTreeDialog dlg = new BrowseMemberTreeDialog((Dialog)((Object)UpdateDefaultMemberPanel.this.parentDialog), bundle.getString("UpdateDefaultMember.BrowseMember.window.title"), UpdateDefaultMemberPanel.this.olapCube, UpdateDefaultMemberPanel.this.olapServer, dim, true, hier);
                    dlg.setHelpTopic("default_member_browse");
                    dlg.setResizable(true);
                    if (!ModelUtilities.isBlank((String)value)) {
                        dlg.setSelectedMember(value);
                    }
                    dlg.show();
                    if (dlg.getReturnValue() == 1) {
                        returnValue = dlg.getSelectedMember();
                    }
                }
            }
            catch (OLAPException e) {
                UpdateDefaultMemberPanel.this.olapServer = null;
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            return returnValue;
        }
    }
}

