/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.StructureTreeCellRenderer;
import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDefaultCellEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class UpdateCaptionsPanel
extends WAPropertyTab
implements CellEditorListener {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(UpdateCaptionsPanel.class);
    private OLAPCube olapCube;
    private TreeTable treeTable;
    private UpdateCaptionsTreeTableModel treeTableModel;
    private StructureTreeCellRenderer structureRenderer;
    private HashMap originalCaptions;
    private HashMap originalDesc;
    private HashMap changedCaptions;
    private HashMap changedDesc;
    private boolean initialized;

    public UpdateCaptionsPanel(OLAPCube cube) {
        this.olapCube = cube;
        this.originalCaptions = new HashMap();
        this.originalDesc = new HashMap();
        this.changedCaptions = new HashMap();
        this.changedDesc = new HashMap();
        this.layoutWidgets();
        this.initialized = false;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("captions");
    }

    private void createTreeTableModel() {
        try {
            Object[] cubeRow = new Object[]{this.olapCube, "", this.olapCube.getDesc()};
            this.originalCaptions.put(this.olapCube, cubeRow[1]);
            this.originalDesc.put(this.olapCube, cubeRow[2]);
            TreeTableRow cubetreerow = new TreeTableRow(null, cubeRow);
            Object[] dimFolder = new Object[]{bundle.getString("UpdateCaptionsPanel.Dimensions.txt"), "", ""};
            TreeTableRow dfTreeRow = new TreeTableRow(dimFolder);
            dfTreeRow.setEditable(false);
            cubetreerow.add((MutableTreeNode)dfTreeRow);
            DimensionSet dimSet = this.olapCube.getDimensionSet();
            OLAPList dims = dimSet.getCubeDimensions();
            dims.sort();
            for (int i = 0; i < dims.size(); ++i) {
                OLAPDimension dim = (OLAPDimension)dims.get(i);
                Object[] row = new Object[]{dim, dim.getDesc(), dim.getNotes()};
                this.originalCaptions.put(dim, row[1]);
                this.originalDesc.put(dim, row[2]);
                TreeTableRow dimNode = new TreeTableRow(row);
                dfTreeRow.add((MutableTreeNode)dimNode);
                Object[] hierFolderRow = new Object[]{bundle.getString("UpdateCaptionsPanel.Hierarchies.txt"), "", ""};
                TreeTableRow hfTreeRow = new TreeTableRow(hierFolderRow);
                hfTreeRow.setEditable(false);
                dimNode.add((MutableTreeNode)hfTreeRow);
                OLAPList hierarchies = dim.getHierarchies();
                OLAPList sortedHiers = new OLAPList(OLAPHierarchy.class);
                sortedHiers.addAll((Collection)hierarchies);
                sortedHiers.sort();
                for (int hierNum = 0; hierNum < sortedHiers.size(); ++hierNum) {
                    OLAPHierarchy hier = (OLAPHierarchy)sortedHiers.get(hierNum);
                    Object[] hierRow = new Object[]{hier, hier.getDesc(), hier.getNotes()};
                    this.originalCaptions.put(hier, hierRow[1]);
                    this.originalDesc.put(hier, hierRow[2]);
                    TreeTableRow hierTreeRow = new TreeTableRow(hierRow);
                    hfTreeRow.add((MutableTreeNode)hierTreeRow);
                }
                Object[] levelFolderRow = new Object[]{bundle.getString("UpdateCaptionsPanel.Levels.txt"), "", ""};
                TreeTableRow lfTreeRow = new TreeTableRow(levelFolderRow);
                lfTreeRow.setEditable(false);
                dimNode.add((MutableTreeNode)lfTreeRow);
                OLAPList levels = dim.getLevels();
                OLAPList sortedLevels = new OLAPList(OLAPLevel.class);
                sortedLevels.addAll((Collection)levels);
                sortedLevels.sort();
                for (int levNum = 0; levNum < sortedLevels.size(); ++levNum) {
                    OLAPLevel level = (OLAPLevel)sortedLevels.get(levNum);
                    Object[] levRow = new Object[]{level, level.getDesc(), level.getNotes()};
                    this.originalCaptions.put(level, levRow[1]);
                    this.originalDesc.put(level, levRow[2]);
                    TreeTableRow lTreeRow = new TreeTableRow(levRow);
                    lfTreeRow.add((MutableTreeNode)lTreeRow);
                    OLAPList properties = level.getOLAPProperties();
                    OLAPList sortedProperties = new OLAPList(OLAPMemberProperty.class);
                    sortedProperties.addAll((Collection)properties);
                    sortedProperties.sort();
                    for (int propNum = 0; propNum < sortedProperties.size(); ++propNum) {
                        OLAPMemberProperty property = (OLAPMemberProperty)sortedProperties.get(propNum);
                        Object[] propRow = new Object[]{property, property.getDesc(), property.getNotes()};
                        this.originalCaptions.put(property, propRow[1]);
                        this.originalDesc.put(property, propRow[2]);
                        TreeTableRow pTreeRow = new TreeTableRow(propRow);
                        lTreeRow.add((MutableTreeNode)pTreeRow);
                    }
                }
            }
            Object[] measuresFolder = new Object[]{bundle.getString("UpdateCaptionsPanel.Measures.txt"), "", ""};
            TreeTableRow mfTreeRow = new TreeTableRow(measuresFolder);
            mfTreeRow.setEditable(false);
            cubetreerow.add((MutableTreeNode)mfTreeRow);
            MeasureSet measureSet = this.olapCube.getMeasureSet();
            OLAPList measures = measureSet.getMeasures();
            OLAPList sortedMeasures = new OLAPList(OLAPMeasure.class);
            sortedMeasures.addAll((Collection)measures);
            sortedMeasures.sort();
            for (int measureNum = 0; measureNum < sortedMeasures.size(); ++measureNum) {
                OLAPMeasure measure = (OLAPMeasure)sortedMeasures.get(measureNum);
                Object[] measureRow = new Object[]{measure, measure.getDesc(), measure.getNotes()};
                this.originalCaptions.put(measure, measureRow[1]);
                this.originalDesc.put(measure, measureRow[2]);
                TreeTableRow mTreeRow = new TreeTableRow(measureRow);
                mfTreeRow.add((MutableTreeNode)mTreeRow);
            }
            String[] columns = new String[]{bundle.getString("UpdateCaptionsPanel.Component.header.title"), bundle.getString("UpdateCaptionsPanel.Caption.header.title"), bundle.getString("UpdateCaptionsPanel.Description.header.title")};
            this.treeTableModel = new UpdateCaptionsTreeTableModel(cubetreerow, columns);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public HashMap getChanges() {
        HashMap<String, HashMap> list = new HashMap<String, HashMap>();
        list.put("Captions", this.changedCaptions);
        list.put("Descriptions", this.changedDesc);
        return list;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.createTreeTableModel();
        this.treeTable = new MyTree(this.treeTableModel);
        this.treeTable.setSurrendersFocusOnKeystroke(false);
        this.treeTable.setRowHeight(18);
        this.structureRenderer = new StructureTreeCellRenderer();
        this.treeTable.setTreeCellRenderer((TreeCellRenderer)this.structureRenderer);
        this.treeTable.setCellSelectionEnabled(true);
        this.treeTable.expandRow(0);
        JScrollPane scrollPane = new JScrollPane((Component)this.treeTable);
        scrollPane.setPreferredSize(new Dimension(600, 350));
        this.add(scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        super.moveDataToView();
        if (!this.initialized) {
            this.initialized = true;
            WATextField txtField1 = new WATextField();
            WsDefaultCellEditor editor1 = new WsDefaultCellEditor(txtField1);
            editor1.setClicksToStart(1);
            TableColumn col = this.treeTable.getColumnModel().getColumn(1);
            col.setCellEditor((TableCellEditor)editor1);
            col.setCellRenderer(new CaptionDescriptionCellRenderer());
            editor1.addCellEditorListener((CellEditorListener)this);
            col.setPreferredWidth(150);
            WATextField txtField2 = new WATextField();
            DefaultCellEditor editor2 = new DefaultCellEditor((JTextField)txtField2);
            editor2.setClickCountToStart(1);
            col = this.treeTable.getColumnModel().getColumn(2);
            col.setCellEditor(editor2);
            col.setCellRenderer(new CaptionDescriptionCellRenderer());
            editor2.addCellEditorListener(this);
            col.setPreferredWidth(250);
            col = this.treeTable.getColumnModel().getColumn(0);
            col.setPreferredWidth(175);
            this.treeTable.expandToDepth(4, false);
        }
    }

    public boolean captionsHaveChanged() {
        TableCellEditor ce = this.treeTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        this.changedCaptions.clear();
        this.changedDesc.clear();
        int rowCount = this.treeTableModel.getRowCount(false);
        for (int i = 0; i < rowCount; ++i) {
            TreeTableRow row = this.treeTableModel.getRowAt(i, false);
            Object[] rowObjs = row.getTableRow();
            if (!(rowObjs[0] instanceof AbstractOLAPModel)) continue;
            AbstractOLAPModel olapObj = (AbstractOLAPModel)rowObjs[0];
            String currentValue = (String)rowObjs[1];
            String origValue = (String)this.originalCaptions.get(olapObj);
            if (!(currentValue != null && !currentValue.equals(origValue) || currentValue == null && origValue != null)) {
                this.changedCaptions.remove(olapObj);
            } else {
                this.changedCaptions.put(olapObj, currentValue);
            }
            currentValue = (String)rowObjs[2];
            origValue = (String)this.originalDesc.get(olapObj);
            if (!(currentValue != null && !currentValue.equals(origValue) || currentValue == null && origValue != null)) {
                this.changedDesc.remove(olapObj);
                continue;
            }
            this.changedDesc.put(olapObj, currentValue);
        }
        return !this.changedCaptions.isEmpty() || !this.changedDesc.isEmpty();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        TreeCellRenderer renderer = this.treeTable.getTreeCellRenderer();
        if (!(renderer instanceof StructureTreeCellRenderer)) {
            this.treeTable.setTreeCellRenderer((TreeCellRenderer)this.structureRenderer);
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TreeCellRenderer renderer = this.treeTable.getTreeCellRenderer();
        if (!(renderer instanceof StructureTreeCellRenderer)) {
            this.treeTable.setTreeCellRenderer((TreeCellRenderer)this.structureRenderer);
        }
    }

    class MyTree
    extends TreeTable {
        private static final long serialVersionUID = 1L;

        public MyTree(UpdateCaptionsTreeTableModel treeTableModel) {
            super((TableModel)((Object)treeTableModel));
        }

        public void columnMarginChanged(ChangeEvent e) {
            TableColumn resizingColumn;
            if (this.getTableHeader() != null && (resizingColumn = this.getTableHeader().getResizingColumn()) != null && this.autoResizeMode == 0) {
                resizingColumn.setPreferredWidth(resizingColumn.getWidth());
            }
            this.resizeAndRepaint();
        }
    }

    class UpdateCaptionsTreeTableModel
    extends TreeTableModel {
        private static final long serialVersionUID = 1L;

        public UpdateCaptionsTreeTableModel(TreeTableRow cubetreerow, String[] columns) {
            super((TreeNode)cubetreerow, columns);
        }

        public boolean isCellEditable(int rx, int cx) {
            boolean editOK = true;
            editOK = rx == 0 && cx == 1 ? false : (cx == 0 ? false : super.isCellEditable(rx, cx));
            return editOK;
        }
    }

    class CaptionDescriptionCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        CaptionDescriptionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object o;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column > 0 && (o = table.getValueAt(row, 0)) instanceof AbstractOLAPModel) {
                AbstractOLAPModel olapObj = (AbstractOLAPModel)o;
                Object orig = null;
                if (column == 1) {
                    orig = UpdateCaptionsPanel.this.originalCaptions.get(olapObj);
                    UpdateCaptionsPanel.this.changedCaptions.remove(olapObj);
                } else {
                    orig = UpdateCaptionsPanel.this.originalDesc.get(olapObj);
                    UpdateCaptionsPanel.this.changedDesc.remove(olapObj);
                }
                this.setToolTipText("");
                if (orig != null && !orig.equals(value) || orig == null && value != null) {
                    Font font = this.getFont();
                    this.setFont(font.deriveFont(1));
                    if (orig instanceof String && !Utilities.isBlank((String)((String)orig))) {
                        this.setToolTipText((String)orig);
                    }
                    if (column == 1) {
                        UpdateCaptionsPanel.this.changedCaptions.put(olapObj, value);
                    } else {
                        UpdateCaptionsPanel.this.changedDesc.put(olapObj, value);
                    }
                }
            }
            return this;
        }
    }
}

