/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AddDataModel;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.update.UpdateGeneralAdvancedDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.PhysicalTableSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class SharedDimUpdateDimensionTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(SharedDimUpdateDimensionTab.class);
    private PhysicalTableSelector tree;
    private JRadioButton processMembers;
    private JRadioButton processAll;
    private AddDataModel dataModel;
    private OLAPSharedDimension olapDim;
    private WATextField inp_dimName;
    private JButton advancedOptions;

    public SharedDimUpdateDimensionTab(AddDataModel inputDataModel) {
        super(bundle.getString("SharedDimUpdateDimension.instructions.txt"));
        this.dataModel = inputDataModel;
        this.olapDim = this.dataModel.getOLAPSharedDimension();
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("shared_dim_up_general");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public String createFinishString() {
        StringBuffer finishString = null;
        try {
            finishString = this.dataModel.generateCodeSharedUpdate(false);
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
            return "";
        }
        return finishString.toString();
    }

    protected void initialize() {
        try {
            this.inp_dimName.setText(this.olapDim.getName());
            PhysicalTable sourceTable = this.olapDim.getAddDataTable();
            this.tree.clearTreeSelections();
            this.tree.initializeSelectedTable(sourceTable);
            this.tree.setOptions(this.olapDim.getAddDataTableOptions());
            this.tree.populateStore();
            this.tree.moveDataToView();
            this.processMembers.setSelected(true);
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        catch (MdException mdError) {
            ExceptionHandler.handleException((Exception)((Object)new OLAPException(mdError.getLocalizedMessage(), 12)));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.initialize();
        }
        return true;
    }

    private void _layoutWidgets() {
        JPanel general = new JPanel();
        general.setLayout(new GridBagLayout());
        JLabel label_dimName = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(label_dimName, bundle.getString("DimDesigner.General.dimname.txt"));
        this.inp_dimName = new WATextField(15);
        this.inp_dimName.setBehavior(2);
        label_dimName.setName("DimensionNameLabel");
        this.inp_dimName.setName("DimensionName");
        general.add((Component)label_dimName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        general.add((Component)this.inp_dimName, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(general, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel updateProcess = new JPanel();
        updateProcess.setLayout(new GridBagLayout());
        this.processMembers = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.processMembers, bundle.getString("CubeUpdate.Dimension.NewMembersOnly.radio.label"));
        this.processAll = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.processAll, bundle.getString("CubeUpdate.Dimension.MembersAndMemberProperties.radio.label"));
        updateProcess.setBorder(new TitledBorder(bundle.getString("CubeUpdate.Dimension.UpdateProcess.groupbox.title")));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.processMembers);
        buttonGroup.add(this.processAll);
        this.processMembers.setName("ProcessMembers");
        this.processAll.setName("ProcessAll");
        updateProcess.add((Component)this.processMembers, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        updateProcess.add((Component)this.processAll, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(updateProcess, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        boolean mls = false;
        this.tree = new PhysicalTableSelector((AbstractOLAPModel)this.olapDim, 1, true, true, mls, false, false);
        this.tree.setName("DimensionTablesSelection");
        panel.setBorder(new TitledBorder(bundle.getString("CubeUpdate.Dimension.SelectDimension.groupbox.title")));
        panel.add((Component)((Object)this.tree), new GridBagConstraints(0, 0, 2, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 10), 0, 0));
        this.add(panel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.advancedOptions = new JButton();
        this.advancedOptions.setName("UpdateGlobalOptions");
        this.advancedOptions.setToolTipText(bundle.getString("SharedDimUpdate.General.Advanced.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.advancedOptions, bundle.getString("CubeUpdate.General.Advanced.action.label"));
        this.advancedOptions.addActionListener(new OptionsListener());
        this.add(this.advancedOptions, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.tree.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        PhysicalTable previousTable = null;
        try {
            PhysicalTable updateTable = this.tree.getSelectedTable();
            if (updateTable == null) {
                MessageUtil.displayMessage((String)bundle.getString("CubeUpdate.Dimensions.NoAddTableError.txt"));
                return false;
            }
            previousTable = this.olapDim.getAddDataTable();
            this.olapDim.setAddDataTable(updateTable);
            this.dataModel.setUpdateTable(updateTable);
            this.dataModel.verifyDimensionSource((OLAPDimension)this.olapDim);
            this.olapDim.setAddDataTableOptions(this.tree.getOptions());
            if (this.processMembers.isSelected()) {
                this.olapDim.setUpdateOption("MEMBERS");
            } else if (this.processAll.isSelected()) {
                this.olapDim.setUpdateOption("MEMBERS_AND_PROPERTIES");
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
            try {
                this.olapDim.setAddDataTable(previousTable);
                return false;
            }
            catch (OLAPException olapError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        return true;
    }

    private class OptionsListener
    implements ActionListener {
        private OptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            UpdateGeneralAdvancedDialog optionsDialog = new UpdateGeneralAdvancedDialog(SharedDimUpdateDimensionTab.this.olapDim);
            optionsDialog.show();
        }
    }
}

