/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.update.ReorganizeSharedDimensionLevelsDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.olapadmin.utilities.studio.StructureTreeCellRenderer;
import com.sas.swing.visuals.dualselector.DualTreeSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ReorganizeSharedDimensionLevelsPanel
extends WAPanel
implements ActionListener,
TreeModelListener {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ReorganizeSharedDimensionLevelsPanel.class);
    private OLAPSharedDimension olapDim;
    private JRadioButton all;
    private JRadioButton specific;
    private DefaultTreeModel availableTreeModel;
    private DefaultTreeModel selectedTreeModel;
    private DualTreeSelector levelSelector;
    private ReorganizeSharedDimensionLevelsDialog parent;
    private WsAppServer applicationServer;

    public ReorganizeSharedDimensionLevelsPanel(OLAPSharedDimension dim) {
        this.olapDim = dim;
        this.layoutWidgets();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.all)) {
            this.levelSelector.setEnabled(false);
        } else {
            this.levelSelector.setEnabled(true);
            JTree sourceTree = (JTree)this.levelSelector.getSourceComponent();
            sourceTree.requestFocus();
        }
        this.updateButtonState();
    }

    private void expandAll(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    public StringBuffer getCode() throws OLAPException, RemoteException, MdException {
        StringBuffer code = null;
        List levels = this.getLevels();
        code = levels.isEmpty() ? this.olapDim.generateCodeReorganizeAll() : this.olapDim.generateCodeReorganizeLevels(levels);
        return code;
    }

    public List getLevels() {
        ArrayList<Object> levels = new ArrayList<Object>();
        if (this.specific.isSelected()) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.selectedTreeModel.getRoot();
            for (DefaultMutableTreeNode leaf = root.getFirstLeaf(); leaf != null; leaf = leaf.getNextLeaf()) {
                Object userObject = leaf.getUserObject();
                if (!(userObject instanceof OLAPLevel)) continue;
                levels.add(userObject);
            }
        }
        return levels;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JLabel instructions = new JLabel(bundle.getString("ReorganizePanel.Instructions.txt"));
        this.add(instructions, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 6, 0), 0, 0));
        ButtonGroup group = new ButtonGroup();
        this.all = new JRadioButton();
        group.add(this.all);
        this.all.setSelected(true);
        this.all.addActionListener(this);
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.all, (String)bundle.getString("ReorganizePanel.All.radio.label"));
        this.add(this.all, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.specific = new JRadioButton();
        group.add(this.specific);
        this.specific.setSelected(false);
        this.specific.addActionListener(this);
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.specific, (String)bundle.getString("ReorganizePanel.SpecificLevels.radio.label"));
        this.add(this.specific, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 6, 0), 0, 0));
        this.levelSelector = new DualTreeSelector();
        this.levelSelector.setEnabled(false);
        this.levelSelector.setSourceCellRenderer((TreeCellRenderer)new ReorganizeTreeCellRenderer());
        this.levelSelector.setTargetCellRenderer((TreeCellRenderer)new ReorganizeTreeCellRenderer());
        JLabel label = (JLabel)this.levelSelector.getSourceLabelComponent();
        Utilities.setLabelTextAndMnemonic((JLabel)label, (String)bundle.getString("ReorganizePanel.AvailableTree.control.label"));
        label = (JLabel)this.levelSelector.getTargetLabelComponent();
        Utilities.setLabelTextAndMnemonic((JLabel)label, (String)bundle.getString("ReorganizePanel.SelectedTree.control.label"));
        this.levelSelector.setTargetControlsVisible(false);
        this.levelSelector.setPreferredSize(new Dimension(400, 250));
        this.levelSelector.setDragAndDropEnabled(false);
        this.levelSelector.setSourceRootVisible(false);
        this.levelSelector.setTargetRootVisible(false);
        this.levelSelector.setRemoveEmptyParentNodes(true);
        JTree sourceTree = (JTree)this.levelSelector.getSourceComponent();
        sourceTree.addFocusListener(new TreeFocusListener());
        DefaultMutableTreeNode availableRootNode = new DefaultMutableTreeNode();
        DefaultMutableTreeNode selectedRootNode = new DefaultMutableTreeNode();
        this.availableTreeModel = new DefaultTreeModel(availableRootNode);
        this.levelSelector.setModel((TreeModel)this.availableTreeModel);
        this.selectedTreeModel = new DefaultTreeModel(selectedRootNode);
        this.levelSelector.setTargetModel((TreeModel)this.selectedTreeModel);
        this.selectedTreeModel.addTreeModelListener(this);
        this.add((Component)this.levelSelector, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel info = new JLabel(bundle.getString("ReorganizePanel.info.txt"));
        this.add(info, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToStore() throws MdException, RemoteException {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        WsRunCode wsRunCode = null;
        try {
            if (this.applicationServer != null) {
                wsRunCode = new WsRunCode(this.applicationServer);
                if (!wsRunCode.hasSubmitError) {
                    String message = bundle.getString("ReorganizeProgressIndicator.Message.txt");
                    String title = bundle.getString("ProgressIndicator.window.title");
                    wsRunCode.executeCode(this.getCode(), message, title);
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("ReorganizeDialog.NoServer.txt"));
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        finally {
            if (wsRunCode != null) {
                wsRunCode.term();
                wsRunCode = null;
            }
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.availableTreeModel.getRoot();
        try {
            if (this.olapDim.isUpdateable()) {
                DefaultMutableTreeNode dimensionNode = new DefaultMutableTreeNode(this.olapDim, true);
                this.availableTreeModel.insertNodeInto(dimensionNode, root, root.getChildCount());
                OLAPList dimensionLevels = this.olapDim.getLevels();
                for (int levelNum = 0; levelNum < dimensionLevels.size(); ++levelNum) {
                    OLAPLevel level = (OLAPLevel)dimensionLevels.get(levelNum);
                    DefaultMutableTreeNode levelNode = new DefaultMutableTreeNode(level, true);
                    this.availableTreeModel.insertNodeInto(levelNode, dimensionNode, dimensionNode.getChildCount());
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.availableTreeModel.reload();
        this.updateButtonState();
        this.expandAll((JTree)this.levelSelector.getSourceComponent(), new TreePath(root));
    }

    public void populateStore() throws MdException, RemoteException {
        super.populateStore();
    }

    public void setParentDialog(ReorganizeSharedDimensionLevelsDialog dialog) {
        this.parent = dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateData() {
        boolean dataOk = false;
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            Workspace workspace = Workspace.getWorkspace();
            int optionSelected = MessageUtil.displayMessage((String)bundle.getString("ReorganizeDialog.ConfirmationPrompt.txt"), (String)bundle.getString("ReorganizeDialog.ConfirmationPrompt.window.title"), (int)2, (int)0);
            boolean bl = dataOk = optionSelected == 0;
            if (dataOk) {
                workspace.setCursor(Cursor.getPredefinedCursor(3));
                Object wsRunCode = null;
                try {
                    this.applicationServer = WsRunCode.getServer();
                    if (this.applicationServer == null) {
                        MessageUtil.displayMessage((String)bundle.getString("ReorganizeDialog.NoServer.txt"));
                        dataOk = false;
                    }
                }
                catch (UnsupportedOperationException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage());
                }
                finally {
                    if (wsRunCode != null) {
                        wsRunCode.term();
                        wsRunCode = null;
                    }
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
        return dataOk;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.updateButtonState();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.updateButtonState();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.updateButtonState();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.updateButtonState();
    }

    private void updateButtonState() {
        if (this.parent != null) {
            this.parent.updateButtonState(this.all.isSelected() || this.specific.isSelected() && !this.getLevels().isEmpty());
        }
    }

    public class TreeFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            JTree sourceTree = (JTree)ReorganizeSharedDimensionLevelsPanel.this.levelSelector.getSourceComponent();
            if (sourceTree.getMaxSelectionRow() < 0) {
                sourceTree.setSelectionRow(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class ReorganizeTreeCellRenderer
    extends StructureTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        ReorganizeTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree inTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasTheFocus) {
            super.getTreeCellRendererComponent(inTree, value, sel, expanded, leaf, row, hasTheFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            this.setFont(this.getFont().deriveFont(0));
            if (userObject instanceof OLAPLevel) {
                OLAPLevel level = (OLAPLevel)userObject;
                try {
                    if (level.needsReorganizing()) {
                        this.setText("*" + this.getText());
                        this.setFont(this.getFont().deriveFont(1));
                    } else {
                        this.setFont(this.getFont().deriveFont(0));
                    }
                }
                catch (OLAPException e) {
                    this.setFont(this.getFont().deriveFont(0));
                }
            }
            return this;
        }
    }
}

