/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.update.ReorganizeSharedDimensionLevelsPanel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.ExportCodeDialog;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsButtonsLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ReorganizeSharedDimensionLevelsDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ReorganizeSharedDimensionLevelsDialog.class);
    private OLAPSharedDimension olapDim;
    private JButton exportCode;

    public ReorganizeSharedDimensionLevelsDialog(Frame frmOwner, String title, boolean modal, WAPanel pnlMain, OLAPSharedDimension dim) {
        super(frmOwner, title, modal, pnlMain);
        this.olapDim = dim;
        ((ReorganizeSharedDimensionLevelsPanel)this.m_pnlMain).setParentDialog(this);
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("shared_dim_reorg_levels");
    }

    protected void updateButtonsPanel() {
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        JPanel subPanel1 = new JPanel((LayoutManager)new WsButtonsLayout());
        this.setOKButtonVisible(true);
        this.setCancelButtonVisible(true);
        this.setCloseButtonVisible(false);
        this.setApplyButtonVisible(false);
        this.setHelpButtonVisible(true);
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.m_btnOk, (String)bundle.getString("ReorganizeDialog.SubmitNow.action.label"));
        this.m_btnOk.setToolTipText(bundle.getString("ReorganizeDialog.SubmitNow.tip"));
        subPanel1.add(this.m_btnOk);
        subPanel1.add(this.m_btnCancel);
        subPanel1.add(this.m_btnHelp);
        JPanel subPanel2 = new JPanel((LayoutManager)new WsButtonsLayout());
        this.exportCode = new JButton();
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.exportCode, (String)bundle.getString("ReorganizeDialog.ExportCode.action.label"));
        this.exportCode.addActionListener(new ExportCodeActionListener());
        this.exportCode.setToolTipText(bundle.getString("ReorganizeDialog.ExportCode.tip"));
        subPanel2.add(this.exportCode);
        ((WARootPane)this.getRootPane()).setRealDefaultButton(this.exportCode);
        this.m_pnlButtons.setLayout(new BorderLayout());
        this.m_pnlButtons.add((Component)subPanel2, "West");
        this.m_pnlButtons.add((Component)subPanel1, "East");
        this.addKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
    }

    public void updateButtonState(boolean enabled) {
        this.exportCode.setEnabled(enabled);
        this.m_btnOk.setEnabled(enabled);
    }

    private class ExportCodeActionListener
    implements ActionListener {
        private ExportCodeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                StringBuffer code = ((ReorganizeSharedDimensionLevelsPanel)ReorganizeSharedDimensionLevelsDialog.this.m_pnlMain).getCode();
                String instructions = bundle.getString("ReorganizeDialog.ExportCodeInstructions.txt");
                Vector paths = VisualUtilities.getSaveProcCodePaths();
                ExportCodeDialog savedlg = new ExportCodeDialog(instructions, code, paths);
                savedlg.setHelpProduct("olapadmin");
                savedlg.setHelpTopic("export_code_update");
                savedlg.show();
                if (savedlg.getReturnValue() == 1) {
                    VisualUtilities.setSaveProcCodePaths(paths);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            catch (MdException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
    }
}

