/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AddDataModel;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.DrillTableChangeEvent;
import com.sas.olapadmin.utilities.studio.DrillTableSelectionListener;
import com.sas.olapadmin.utilities.studio.PhysicalTableSelector;
import com.sas.services.ServiceException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JCheckBox;

public class CubeUpdateTablePanel
extends WAPanel
implements DrillTableSelectionListener {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeUpdateTablePanel.class);
    private PhysicalTableSelector tree;
    private PhysicalTable physicalTable;
    private OLAPCube olapCube;
    private AddDataModel dataModel;
    private boolean dataSource;
    private JCheckBox dtLangSupport;

    public CubeUpdateTablePanel(AddDataModel inDataModel, boolean inputDataSource) {
        this.dataModel = inDataModel;
        this.olapCube = this.dataModel.getOLAPCube();
        this.dataSource = inputDataSource;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.initialize();
        }
        return true;
    }

    protected void initialize() {
        try {
            if (this.dataSource) {
                PhysicalTable setUpUpdateTable = this.dataModel.getUpdateTable();
                if (setUpUpdateTable != null) {
                    this.tree.initializeSelectedTable(setUpUpdateTable);
                    this.tree.setOptions(this.dataModel.getUpdateTableOptions());
                }
                this.dtLangSupport.setVisible(false);
                this.dtLangSupport.setEnabled(false);
                this.dtLangSupport.setSelected(false);
                this.tree.setTreatAsDrillThru(false);
            } else {
                PhysicalTable setUpDrillTable = this.dataModel.getDrillTable();
                if (setUpDrillTable != null) {
                    this.tree.initializeSelectedTable(setUpDrillTable);
                    this.tree.setOptions(this.dataModel.getDrillTableOptions());
                }
                this.dtLangSupport.setEnabled(this.dataModel.isMLS());
                this.dtLangSupport.setSelected(this.dataModel.isMLSDrillThruSupported());
                this.tree.setTreatAsDrillThru(true);
                if (this.dataModel.isMLS()) {
                    this.tree.addDrillTableSelectionListener(this);
                }
            }
            this.tree.populateStore();
            this.tree.moveDataToView();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (MdException mdError) {
            ExceptionHandler.handleException((Exception)((Object)new OLAPException(mdError.getLocalizedMessage(), (Throwable)mdError, 12)));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (OLAPException OOError) {
            ExceptionHandler.handleException((Exception)((Object)OOError));
        }
    }

    public PhysicalTable getTable() {
        return this.physicalTable;
    }

    private void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.tree = new PhysicalTableSelector((AbstractOLAPModel)this.olapCube, 1, true, true, false, false, false);
        this.tree.setName("UpdateTableSelection");
        this.add((Component)((Object)this.tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dtLangSupport = new JCheckBox(bundle.getString("CubeUpdate.SelectTable.SupportMLSDrillThrough.checkbox.label"));
        this.add(this.dtLangSupport, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.tree.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        this.physicalTable = this.tree.getSelectedTable();
        if (this.physicalTable == null && this.dataSource) {
            MessageUtil.displayMessage((String)bundle.getString("CubeUpdatePickAtable.txt"), (int)0);
            return false;
        }
        try {
            if (this.dataSource) {
                this.dataModel.setUpdateTable(this.physicalTable);
                this.dataModel.verifySource();
                this.dataModel.setUpdateTableOptions(this.tree.getOptions());
            } else {
                TableSet tableSet;
                List missingTables;
                if (this.dtLangSupport.isSelected() && this.physicalTable != null && !(missingTables = (tableSet = this.olapCube.getTableSet()).checkForLanguageTables(this.physicalTable)).isEmpty()) {
                    String message = bundle.getString("CubeUpdate.SelectTable.ReachThru.MissingLanguages.txt");
                    MessageUtil.displayListMessage((String)message, (List)missingTables, (String)bundle.getString("CubeUpdate.SelectTable.ReachThruConfirm.window.title"), (int)1, (int)-1);
                    return false;
                }
                this.dataModel.setDrillTable(this.physicalTable);
                this.dataModel.setDrillTableOptions(this.tree.getOptions());
                this.dataModel.setMLSDrillThruSupported(this.dtLangSupport.isSelected());
                this.tree.removeDrillTableSelectionListener(this);
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
            try {
                this.dataModel.setUpdateTable(null);
                this.physicalTable = null;
                return false;
            }
            catch (OLAPException OOError) {
                ExceptionHandler.handleException((Exception)((Object)OOError));
                return false;
            }
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        catch (ServiceException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (MdException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return true;
    }

    @Override
    public void drillTableChanged(DrillTableChangeEvent e) {
        this.dtLangSupport.setEnabled(e.getDrillSelectedState());
        if (!e.getDrillSelectedState()) {
            this.dtLangSupport.setSelected(false);
        }
    }
}

