/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AddDataModel;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.ReachThruTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.update.CubeUpdateDesigner;
import com.sas.olapadmin.update.CubeUpdateTableDialog;
import com.sas.olapadmin.update.GeneralAdvancedDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.ChangeOLAPSchemaPanel;
import com.sas.olapadmin.utilities.studio.OLAPSchemaNewButton;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class CubeUpdateGeneralTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeUpdateGeneralTab.class);
    private OLAPCube olapCube;
    private WATextField repositoryFolder;
    private WATextField currentSourceTable;
    private WAComboBox newSourceTable;
    private WATextField currentDrillTable;
    private WATextField newDrillTable;
    private OLAPSchemaNewButton button;
    private Tree folder;
    private JCheckBox addData;
    private JButton browseFolder;
    private JButton selectSource;
    private JButton selectDrill;
    private ChangeOLAPSchemaPanel olapSchema;
    private CubeUpdateDesigner parent;
    private WATextField cubeName;
    public String conditionState;
    private JRadioButton terse;
    private JRadioButton verbose;
    private JRadioButton error;
    private ButtonGroup missingKeys;
    private AddDataModel dataModel;
    private boolean isStar;
    private JButton advancedOptions;
    private Integer originalIndexSortSize;
    private Integer originalConcurrent;
    private Integer originalMaxThreads;
    private String backUpTable;
    private boolean selectedTable;
    private List itemsInCombo;
    private LoadTable inputTable;
    private NewSourceTableListener sourceTableListener;

    public CubeUpdateGeneralTab(AddDataModel inputDataModel) {
        super(bundle.getString("CubeUpdate.General.Instructions.txt"));
        this.dataModel = inputDataModel;
        this.olapCube = this.dataModel.getOLAPCube();
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cube_update_general");
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public String createFinishString() {
        StringBuffer finishString = null;
        try {
            finishString = this.dataModel.generateAddDataCode(false);
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
            return "";
        }
        return finishString.toString();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            try {
                ReachThruTable reachTable;
                this.itemsInCombo = new ArrayList();
                this.parent = (CubeUpdateDesigner)((Object)this.getTopLevelAncestor());
                this.cubeName.setText(this.dataModel.getName());
                this.dataModel.setOLAPSchema(this.olapSchema.getSelectedOLAPSchema());
                this.olapSchema.setSelectedOLAPSchema(this.dataModel.getOLAPSchema());
                TableSet tableSet = this.olapCube.getTableSet();
                this.inputTable = tableSet.getLoadTable();
                if (this.inputTable != null) {
                    this.currentSourceTable.setText(ModelUtilities.generateTableName((PhysicalTable)this.inputTable.getTable()));
                }
                if ((reachTable = tableSet.getReachThruTable()) != null) {
                    this.currentDrillTable.setText(ModelUtilities.generateTableName((PhysicalTable)reachTable.getTable()));
                } else {
                    this.currentDrillTable.setText(bundle.getString("Common.None.txt"));
                }
                this.newSourceTable.addItem((Object)bundle.getString("CubeUpdate.General.NewSourceInitialValue.txt"));
                if (this.isStar) {
                    this.addData.setSelected(true);
                    this.error.setSelected(true);
                }
                String tableName = ModelUtilities.generateTableName((PhysicalTable)this.inputTable.getTable());
                this.parent.addWizardData(tableName, this.inputTable.getTable());
                this.newSourceTable.addItem((Object)tableName);
                this.itemsInCombo.add(tableName);
                this.folder = this.dataModel.getFolder();
                if (this.folder != null) {
                    try {
                        MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                        String pathURL = mdUtil.getObjectPath((MdObjectStore)this.folder.getObjectStore(), (PrimaryType)this.folder, false);
                        this.repositoryFolder.setText(pathURL);
                    }
                    catch (MdException mdError) {
                        ExceptionHandler.handleException((Exception)((Object)mdError));
                    }
                    catch (RemoteException re) {
                        ExceptionHandler.handleException((Exception)re);
                    }
                }
                if (this.dataModel.getTypeOfUpdate() == 0) {
                    this.cubeName.setEditable(false);
                    this.olapSchema.setEnabled(false);
                    this.browseFolder.setEnabled(false);
                    this.button.setEnabled(false);
                } else {
                    this.cubeName.setEnabled(true);
                    this.olapSchema.setEnabled(true);
                    this.repositoryFolder.setEnabled(true);
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        return true;
    }

    protected void layoutWidgets() {
        this.olapCube.getTableSet().addToMetadataListener();
        try {
            if (this.olapCube.getTableSet().isLoadStarSchema()) {
                this.isStar = true;
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        JLabel labelCubeName = new JLabel();
        this.cubeName = new WATextField(32);
        this.cubeName.setMaxCharacters(60);
        this.cubeName.setName("outcubeNameField");
        labelCubeName.setName("outcubeNameLabel");
        VisualUtilities.setLabelTextAndMnemonic(labelCubeName, bundle.getString("CubeUpdate.General.cubename.control.label"));
        JPanel newcubePanel = new JPanel();
        newcubePanel.setLayout(new GridBagLayout());
        newcubePanel.add((Component)labelCubeName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        newcubePanel.add((Component)this.cubeName, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        ArrayList<OLAPCube> cubes = new ArrayList<OLAPCube>();
        cubes.add(this.olapCube);
        this.olapSchema = new ChangeOLAPSchemaPanel(cubes.toArray());
        this.olapSchema.setName("CubeUpdateSchema");
        JLabel olapschemaLabel = new JLabel();
        olapschemaLabel.setName("cubeOlapschemaLabel");
        olapschemaLabel.setLabelFor((Component)((Object)this.olapSchema));
        VisualUtilities.setLabelTextAndMnemonic(olapschemaLabel, bundle.getString("CubeUpdate.General.OLAPSchema.control.label"));
        newcubePanel.add((Component)olapschemaLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        newcubePanel.add((Component)((Object)this.olapSchema), new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.button = new OLAPSchemaNewButton(this.olapSchema, (AbstractOLAPModel)this.olapCube);
        newcubePanel.add((Component)this.button, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        JLabel labelCubeFolder = new JLabel();
        this.repositoryFolder = new WATextField();
        this.repositoryFolder.setBehavior(2);
        this.repositoryFolder.setName("cubeRepositoryFolder");
        labelCubeFolder.setName("cubeRepositoryFolder");
        labelCubeFolder.setLabelFor((Component)this.repositoryFolder);
        VisualUtilities.setLabelTextAndMnemonic(labelCubeFolder, bundle.getString("CubeUpdate.General.Location.control.label"));
        this.browseFolder = new JButton();
        this.browseFolder.setName("newcuberepositoryfolder");
        this.browseFolder.setToolTipText(bundle.getString("CubeUpdate.General.NewLocation.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.browseFolder, bundle.getString("CubeUpdate.General.Select.action.label"));
        this.browseFolder.addActionListener(new SelectFolderButtonsListener());
        newcubePanel.add((Component)labelCubeFolder, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        newcubePanel.add((Component)this.repositoryFolder, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        newcubePanel.add((Component)this.browseFolder, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        newcubePanel.setBorder(new TitledBorder(""));
        this.add(newcubePanel, new GridBagConstraints(0, 0, 3, 3, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(new GridBagLayout());
        JLabel currentDataLabel = new JLabel();
        currentDataLabel.setName("currentdatalabel");
        this.currentSourceTable = new WATextField();
        this.currentSourceTable.setBehavior(2);
        this.currentSourceTable.setName("currentSourceTable");
        currentDataLabel.setLabelFor((Component)this.currentSourceTable);
        VisualUtilities.setLabelTextAndMnemonic(currentDataLabel, bundle.getString("CubeUpdate.General.CurrentSource.control.label"));
        sourcePanel.add((Component)currentDataLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        sourcePanel.add((Component)this.currentSourceTable, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel newDataLabel = new JLabel();
        newDataLabel.setName("newDatalabel");
        this.newSourceTable = new WAComboBox();
        this.newSourceTable.setName("newSourceTable");
        this.sourceTableListener = new NewSourceTableListener();
        this.newSourceTable.addActionListener((ActionListener)this.sourceTableListener);
        newDataLabel.setLabelFor((Component)this.newSourceTable);
        VisualUtilities.setLabelTextAndMnemonic(newDataLabel, bundle.getString("CubeUpdate.General.NewSource.control.label"));
        sourcePanel.add((Component)newDataLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        sourcePanel.add((Component)this.newSourceTable, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.selectSource = new JButton();
        this.selectSource.setName("UpdateSourcetable");
        this.selectSource.setToolTipText(bundle.getString("CubeUpdate.General.Select.Source.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.selectSource, bundle.getString("CubeUpdate.General.Select.Source.action.label"));
        this.selectSource.addActionListener(new BrowseButtonListener());
        sourcePanel.add((Component)this.selectSource, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (this.isStar) {
            this.addData = new JCheckBox();
            this.addData.setName("updateAddData");
            VisualUtilities.setButtonTextAndMnemonic(this.addData, bundle.getString("CubeUpdate.General.AddData.checkbox.label"));
            this.addData.addActionListener(new AddDataListener());
            sourcePanel.add((Component)this.addData, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 5, 0), 0, 0));
        }
        JLabel currentDrillLabel = new JLabel();
        currentDrillLabel.setName("currentdrilllabel");
        this.currentDrillTable = new WATextField();
        this.currentDrillTable.setBehavior(2);
        this.currentDrillTable.setName("currentDrillTable");
        currentDrillLabel.setLabelFor((Component)this.currentDrillTable);
        VisualUtilities.setLabelTextAndMnemonic(currentDrillLabel, bundle.getString("CubeUpdate.General.CurrentDrill.control.label"));
        sourcePanel.add((Component)currentDrillLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(25, 5, 5, 5), 0, 0));
        sourcePanel.add((Component)this.currentDrillTable, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(25, 5, 5, 5), 0, 0));
        JLabel newDrillLabel = new JLabel();
        newDrillLabel.setName("newDrilllabel");
        this.newDrillTable = new WATextField();
        this.newDrillTable.setName("newDrillTable");
        newDrillLabel.setLabelFor((Component)this.newDrillTable);
        this.newDrillTable.setEditable(false);
        VisualUtilities.setLabelTextAndMnemonic(newDrillLabel, bundle.getString("CubeUpdate.General.NewDrill.control.label"));
        sourcePanel.add((Component)newDrillLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        sourcePanel.add((Component)this.newDrillTable, new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.selectDrill = new JButton();
        this.selectDrill.setName("UpdateDrilltable");
        this.selectDrill.setToolTipText(bundle.getString("CubeUpdate.General.Select.Drillthrough.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.selectDrill, bundle.getString("CubeUpdate.General.Select.Drillthrough.action.label"));
        this.selectDrill.addActionListener(new BrowseButtonListener());
        sourcePanel.add((Component)this.selectDrill, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(sourcePanel, new GridBagConstraints(0, 3, 3, 5, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this.isStar) {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            JLabel missingKeysLabel = new JLabel(bundle.getString("CubeUpdate.General.MissingKeys.groupbox.title"));
            this.error = new JRadioButton();
            this.error.setActionCommand("ERROR");
            this.error.setName("StarOptionsTabErrorRadio");
            VisualUtilities.setButtonTextAndMnemonic(this.error, bundle.getString("CubeUpdate.General.KeyError.radio.label"));
            this.terse = new JRadioButton();
            this.terse.setActionCommand("TERSE");
            this.terse.setName("StarOptionsTabTerseRadio");
            VisualUtilities.setButtonTextAndMnemonic(this.terse, bundle.getString("CubeUpdate.General.Terse.radio.label"));
            panel.add((Component)missingKeysLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)this.error, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 25, 0, 5), 0, 0));
            panel.add((Component)this.terse, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 25, 0, 5), 0, 0));
            this.verbose = new JRadioButton();
            this.verbose.setActionCommand("VERBOSE");
            this.verbose.setName("StarOptionsTabVerboseRadio");
            VisualUtilities.setButtonTextAndMnemonic(this.verbose, bundle.getString("CubeUpdate.General.Verbose.radio.label"));
            panel.add((Component)this.verbose, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 25, 5, 5), 0, 0));
            this.missingKeys = new ButtonGroup();
            this.missingKeys.add(this.error);
            this.error.setSelected(true);
            this.missingKeys.add(this.terse);
            this.missingKeys.add(this.verbose);
            this.add(panel, new GridBagConstraints(0, 8, 2, 3, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.advancedOptions = new JButton();
        this.advancedOptions.setName("UpdateGlobalOptions");
        this.advancedOptions.setToolTipText(bundle.getString("CubeUpdate.General.Advanced.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.advancedOptions, bundle.getString("CubeUpdate.General.Advanced.action.label"));
        this.advancedOptions.addActionListener(new globalOptionsListener());
        this.add(this.advancedOptions, new GridBagConstraints(0, 11, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.olapCube.getTableSet().removeFromMetadataListener();
        super.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        try {
            this.dataModel.setName(this.cubeName.getText());
            this.dataModel.setOLAPSchema(this.olapSchema.getSelectedOLAPSchema());
            if (this.isStar && this.addData.isSelected() && !this.selectedTable) {
                MessageUtil.displayMessage((String)bundle.getString("CubeUpdate.General.AddDataButNoTable.txt"), (int)0);
                return false;
            }
            this.dataModel.verifyNameSchemaFolder();
            this.dataModel.verifySource();
            if (this.isStar) {
                if (this.error.isSelected()) {
                    this.dataModel.setHandleMissingKeys("ERROR");
                } else if (this.terse.isSelected()) {
                    this.dataModel.setHandleMissingKeys("TERSE");
                } else if (this.verbose.isSelected()) {
                    this.dataModel.setHandleMissingKeys("VERBOSE");
                }
            }
        }
        catch (OLAPException oERROR) {
            ExceptionHandler.handleException((Exception)((Object)oERROR));
            return false;
        }
        return true;
    }

    private boolean isObjectInComboBox(String text) {
        boolean found = false;
        ComboBoxModel comboBoxDataModel = this.newSourceTable.getModel();
        for (int i = 0; i < comboBoxDataModel.getSize(); ++i) {
            if (!text.equals(comboBoxDataModel.getElementAt(i))) continue;
            found = true;
            break;
        }
        return found;
    }

    private class SelectFolderButtonsListener
    implements ActionListener {
        private SelectFolderButtonsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(null, Workspace.getWorkspace().getUserContext(), null, true);
                panel.setSelectionMode(BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY);
                panel.setMultiSelectionEnabled(false);
                RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog((Frame)Workspace.getWorkspace(), bundle.getString("CubeUpdate.General.SelectFolder.window.title"), true, 2, (BaseRemoteFileSelectorPanel)panel);
                dialog.setAllowNonExistentSelections(false);
                dialog.setVisible(true);
                if (!panel.isCancelled()) {
                    try {
                        String path;
                        PathUrl pathUrl;
                        List lreturnedItems = new ArrayList();
                        lreturnedItems = panel.getReturnedInformation(true);
                        if (lreturnedItems != null && !lreturnedItems.isEmpty() && (pathUrl = new PathUrl(path = lreturnedItems.get(0).toString())) != null) {
                            MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), pathUrl);
                            CubeUpdateGeneralTab.this.folder = (Tree)metadataObject.getRepositoryEntity();
                            MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                            if (CubeUpdateGeneralTab.this.folder != null) {
                                String pathFolder = mdUtil.getObjectPath((MdObjectStore)CubeUpdateGeneralTab.this.folder.getObjectStore(), (PrimaryType)CubeUpdateGeneralTab.this.folder, false);
                                CubeUpdateGeneralTab.this.repositoryFolder.setText(pathFolder);
                                CubeUpdateGeneralTab.this.dataModel.setFolder(CubeUpdateGeneralTab.this.folder);
                            }
                        }
                    }
                    catch (MdException e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                    catch (RemoteException e) {
                        ExceptionHandler.handleException((Exception)e);
                    }
                    catch (ServiceException e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                }
            }
        }
    }

    private class AddDataListener
    implements ActionListener {
        private AddDataListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CubeUpdateGeneralTab.this.newSourceTable.removeActionListener((ActionListener)CubeUpdateGeneralTab.this.sourceTableListener);
            if (CubeUpdateGeneralTab.this.addData.isSelected()) {
                CubeUpdateGeneralTab.this.newSourceTable.setEnabled(true);
                CubeUpdateGeneralTab.this.selectSource.setEnabled(true);
                if (CubeUpdateGeneralTab.this.backUpTable != null) {
                    CubeUpdateGeneralTab.this.newSourceTable.setSelectedItem((Object)CubeUpdateGeneralTab.this.backUpTable);
                } else {
                    boolean found = CubeUpdateGeneralTab.this.isObjectInComboBox(bundle.getString("CubeUpdate.General.NewSourceInitialValue.txt"));
                    if (!found) {
                        CubeUpdateGeneralTab.this.newSourceTable.addItem((Object)bundle.getString("CubeUpdate.General.NewSourceInitialValue.txt"));
                    }
                    CubeUpdateGeneralTab.this.newSourceTable.setSelectedItem((Object)bundle.getString("CubeUpdate.General.NewSourceInitialValue.txt"));
                }
            } else {
                CubeUpdateGeneralTab.this.newSourceTable.setEnabled(false);
                CubeUpdateGeneralTab.this.selectSource.setEnabled(false);
                boolean found = CubeUpdateGeneralTab.this.isObjectInComboBox(bundle.getString("Common.None.txt"));
                if (!found) {
                    CubeUpdateGeneralTab.this.newSourceTable.addItem((Object)bundle.getString("Common.None.txt"));
                }
                CubeUpdateGeneralTab.this.newSourceTable.setSelectedItem((Object)bundle.getString("Common.None.txt"));
            }
            CubeUpdateGeneralTab.this.newSourceTable.addActionListener((ActionListener)CubeUpdateGeneralTab.this.sourceTableListener);
        }
    }

    private class globalOptionsListener
    implements ActionListener {
        private globalOptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                if (CubeUpdateGeneralTab.this.originalIndexSortSize == null) {
                    CubeUpdateGeneralTab.this.originalIndexSortSize = CubeUpdateGeneralTab.this.olapCube.getPerformanceOptionIndexSortSize();
                }
                if (CubeUpdateGeneralTab.this.originalConcurrent == null) {
                    CubeUpdateGeneralTab.this.originalConcurrent = CubeUpdateGeneralTab.this.olapCube.getPerformanceOptionConcurrent();
                }
                if (CubeUpdateGeneralTab.this.originalMaxThreads == null) {
                    CubeUpdateGeneralTab.this.originalMaxThreads = CubeUpdateGeneralTab.this.olapCube.getPerformanceOptionMaxThreads();
                }
                GeneralAdvancedDialog optionsDialog = new GeneralAdvancedDialog(CubeUpdateGeneralTab.this.olapCube, CubeUpdateGeneralTab.this.originalIndexSortSize, CubeUpdateGeneralTab.this.originalConcurrent, CubeUpdateGeneralTab.this.originalMaxThreads);
                optionsDialog.show();
            }
            catch (OLAPException oERROR) {
                ExceptionHandler.handleException((Exception)((Object)oERROR));
            }
        }
    }

    private class BrowseButtonListener
    implements ActionListener {
        private BrowseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                String windowTitle;
                boolean inputDataSource = true;
                if (event.getSource().equals(CubeUpdateGeneralTab.this.selectSource)) {
                    windowTitle = bundle.getString("CubeUpdate.SelectTable.window.title");
                } else {
                    inputDataSource = false;
                    windowTitle = bundle.getString("CubeUpdate.SelectDrillTable.window.title");
                }
                CubeUpdateTableDialog browseDialog = new CubeUpdateTableDialog((Dialog)((Object)CubeUpdateGeneralTab.this.parent), windowTitle, CubeUpdateGeneralTab.this.dataModel, inputDataSource);
                browseDialog.show();
                if (browseDialog.getReturnValue() == 2) {
                    return;
                }
                PhysicalTable currentlySelectedTable = browseDialog.getTable();
                try {
                    if (currentlySelectedTable != null) {
                        if (inputDataSource) {
                            String tableName = CubeUpdateGeneralTab.this.dataModel.getUpdateTableName();
                            CubeUpdateGeneralTab.this.parent.addWizardData(tableName, CubeUpdateGeneralTab.this.dataModel.getUpdateTable());
                            CubeUpdateGeneralTab.this.parent.addWizardData(tableName + "OPTIONS", CubeUpdateGeneralTab.this.dataModel.getUpdateTableOptions());
                            CubeUpdateGeneralTab.this.newSourceTable.removeActionListener((ActionListener)CubeUpdateGeneralTab.this.sourceTableListener);
                            CubeUpdateGeneralTab.this.newSourceTable.removeAllItems();
                            CubeUpdateGeneralTab.this.newSourceTable.addItems(CubeUpdateGeneralTab.this.itemsInCombo);
                            if (!CubeUpdateGeneralTab.this.itemsInCombo.contains(tableName)) {
                                CubeUpdateGeneralTab.this.newSourceTable.addItem((Object)tableName);
                            }
                            CubeUpdateGeneralTab.this.newSourceTable.setSelectedItem((Object)tableName);
                            CubeUpdateGeneralTab.this.newSourceTable.addActionListener((ActionListener)CubeUpdateGeneralTab.this.sourceTableListener);
                            CubeUpdateGeneralTab.this.selectedTable = true;
                            CubeUpdateGeneralTab.this.backUpTable = tableName;
                        } else {
                            CubeUpdateGeneralTab.this.newDrillTable.setText(CubeUpdateGeneralTab.this.dataModel.getDrillTableName());
                        }
                    } else if (inputDataSource) {
                        if (CubeUpdateGeneralTab.this.isStar) {
                            CubeUpdateGeneralTab.this.newSourceTable.setSelectedItem((Object)bundle.getString("Common.None.txt"));
                        } else {
                            CubeUpdateGeneralTab.this.newSourceTable.setSelectedItem((Object)bundle.getString("CubeUpdate.General.NewSourceInitialValue.txt"));
                        }
                    } else {
                        String nameOfCurrentTable = CubeUpdateGeneralTab.this.dataModel.getDrillTableName();
                        String nameOfOldTable = CubeUpdateGeneralTab.this.currentDrillTable.getText();
                        if (nameOfOldTable != null && !nameOfOldTable.equals(nameOfCurrentTable)) {
                            CubeUpdateGeneralTab.this.newDrillTable.setText(CubeUpdateGeneralTab.this.dataModel.getDrillTableName());
                        } else {
                            CubeUpdateGeneralTab.this.newDrillTable.setText(" ");
                        }
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            }
        }
    }

    private class NewSourceTableListener
    implements ActionListener {
        private NewSourceTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String selected = (String)CubeUpdateGeneralTab.this.newSourceTable.getSelectedItem();
            if (selected != null && !selected.equals(bundle.getString("CubeUpdate.General.NewSourceInitialValue.txt")) && !selected.equals(bundle.getString("Common.None.txt"))) {
                CubeUpdateGeneralTab.this.backUpTable = (String)CubeUpdateGeneralTab.this.newSourceTable.getSelectedItem();
                try {
                    PhysicalTable table = (PhysicalTable)CubeUpdateGeneralTab.this.parent.getWizardData(CubeUpdateGeneralTab.this.backUpTable);
                    CubeUpdateGeneralTab.this.dataModel.setUpdateTable(table);
                    String options = (String)CubeUpdateGeneralTab.this.parent.getWizardData(CubeUpdateGeneralTab.this.backUpTable + "OPTIONS");
                    if (!ModelUtilities.isBlank((String)options)) {
                        CubeUpdateGeneralTab.this.dataModel.setUpdateTableOptions(options);
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
                CubeUpdateGeneralTab.this.selectedTable = true;
            } else {
                CubeUpdateGeneralTab.this.selectedTable = false;
            }
        }
    }
}

