/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AddDataModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.PhysicalTableSelector;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CubeUpdateDimensionsTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeUpdateDimensionsTab.class);
    private CollectionToListModelAdapter listModel;
    private CollectionToListModelAdapter listModelNON;
    private JList listNON;
    private JList list;
    private PhysicalTableSelector tree;
    private boolean initialized;
    private JRadioButton processMembers;
    private JRadioButton processAll;
    private JRadioButton processNone;
    private AddDataModel dataModel;
    private OLAPCube olapCube;
    private OLAPDimension lastSelected;
    private List allDimensions;
    private TableSet tableSet;
    private JLabel labelOption;
    private boolean isDetail;

    public CubeUpdateDimensionsTab(AddDataModel inputDataModel) {
        super(bundle.getString("CubeUpdate.Dimension.Dimensions.instructions.txt"));
        this.dataModel = inputDataModel;
        this.olapCube = this.dataModel.getOLAPCube();
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cube_update_dimensions");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    protected void initialize() {
        try {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                this.tableSet = this.olapCube.getTableSet();
                this.list.addListSelectionListener(new DimensionSelectionListener());
                this.list.setSelectionMode(0);
                if (!this.isDetail) {
                    this.tree.populateStore();
                    this.tree.moveDataToView();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                TreeSet sortDimensions = new TreeSet();
                this.allDimensions = this.dataModel.getUpdateableDimensions();
                if (this.allDimensions.isEmpty()) {
                    this.list.setEnabled(false);
                    this.list.setBackground(SystemColor.control);
                }
                int size = this.allDimensions.size();
                for (int j = 0; j < size; ++j) {
                    sortDimensions.add(this.allDimensions.get(j));
                }
                this.listModel.setModel(sortDimensions);
                List allDimensionsNON = this.dataModel.getNonUpdateableDimensions();
                if (!allDimensionsNON.isEmpty()) {
                    TreeSet sortDimensionsNON = new TreeSet();
                    int size2 = allDimensionsNON.size();
                    for (int j = 0; j < size2; ++j) {
                        sortDimensionsNON.add(allDimensionsNON.get(j));
                    }
                    this.listModelNON.setModel(sortDimensionsNON);
                }
                if (!sortDimensions.isEmpty()) {
                    this.list.setSelectedIndex(0);
                } else {
                    this.processMembers.setEnabled(false);
                    this.processAll.setEnabled(false);
                    if (!this.isDetail) {
                        this.processNone.setEnabled(false);
                    }
                }
                this.initialized = true;
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        catch (MdException mdError) {
            ExceptionHandler.handleException((Exception)((Object)new OLAPException(mdError.getLocalizedMessage(), (Throwable)mdError, 12)));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!this.initialized) {
            this.initialize();
        }
        return true;
    }

    private void _layoutWidgets() {
        try {
            this.tableSet = this.olapCube.getTableSet();
            if (this.tableSet.isLoadDetailTable()) {
                this.isDetail = true;
            }
            JPanel listboxPanel = new JPanel();
            listboxPanel.setLayout(new GridBagLayout());
            this.listModel = new CollectionToListModelAdapter();
            this.list = new JList(this.listModel);
            JScrollPane scrollPane = new JScrollPane(this.list);
            scrollPane.setName("DimensionUpdate");
            JLabel labelBox = new JLabel();
            VisualUtilities.setLabelTextAndMnemonic(labelBox, bundle.getString("CubeUpdate.Dimension.dimensions.control.label"));
            labelBox.setLabelFor(this.list);
            scrollPane.setPreferredSize(new Dimension(150, 300));
            listboxPanel.add((Component)labelBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
            listboxPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            if (!this.dataModel.getNonUpdateableDimensions().isEmpty()) {
                this.listModelNON = new CollectionToListModelAdapter();
                this.listNON = new JList(this.listModelNON);
                JScrollPane scrollPaneNON = new JScrollPane(this.listNON);
                scrollPaneNON.setName("DimensionUpdateNON");
                JLabel labelBoxNON = new JLabel(bundle.getString("CubeUpdate.Dimension.NONUpdateable.dimensions.control.label"));
                labelBoxNON.setLabelFor(this.listNON);
                scrollPaneNON.setPreferredSize(new Dimension(150, 100));
                scrollPaneNON.setEnabled(false);
                listboxPanel.add((Component)labelBoxNON, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
                listboxPanel.add((Component)scrollPaneNON, new GridBagConstraints(0, 5, 1, 3, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            }
            this.add(listboxPanel, new GridBagConstraints(0, 0, 1, 6, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.labelOption = new JLabel();
            this.labelOption.setText(bundle.formatString("CubeUpdate.Dimension.Options.fmt.title", (Object)" "));
            this.add(this.labelOption, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            JPanel updateProcess = new JPanel();
            updateProcess.setLayout(new GridBagLayout());
            updateProcess.setBorder(new TitledBorder(bundle.getString("CubeUpdate.Dimension.UpdateProcess.groupbox.title")));
            this.processMembers = new JRadioButton();
            VisualUtilities.setButtonTextAndMnemonic(this.processMembers, bundle.getString("CubeUpdate.Dimension.NewMembersOnly.radio.label"));
            this.processAll = new JRadioButton();
            VisualUtilities.setButtonTextAndMnemonic(this.processAll, bundle.getString("CubeUpdate.Dimension.MembersAndMemberProperties.radio.label"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.processMembers);
            buttonGroup.add(this.processAll);
            this.processMembers.setName("ProcessMembers");
            this.processAll.setName("ProcessAll");
            updateProcess.add((Component)this.processMembers, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            updateProcess.add((Component)this.processAll, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            if (!this.isDetail) {
                this.processNone = new JRadioButton();
                this.processNone.setName("ProcessNone");
                VisualUtilities.setButtonTextAndMnemonic(this.processNone, bundle.getString("CubeUpdate.Dimension.NoProcess.radio.label"));
                buttonGroup.add(this.processNone);
                updateProcess.add((Component)this.processNone, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            }
            this.add(updateProcess, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            if (!this.isDetail) {
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                boolean mls = this.olapCube.getLanguageSet().isCubeMultipleLanguageSupported();
                this.tree = this.dataModel.getUpdateableDimensions().isEmpty() ? new PhysicalTableSelector((AbstractOLAPModel)this.olapCube, 1, true, true, mls, false, false) : new PhysicalTableSelector((AbstractOLAPModel)this.olapCube, 1, true, true, mls, false, false);
                this.tree.setName("DimensionTablesSelection");
                panel.setBorder(new TitledBorder(bundle.getString("CubeUpdate.Dimension.SelectDimension.groupbox.title")));
                panel.add((Component)((Object)this.tree), new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 10), 0, 0));
                this.add(panel, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    public void saveSettingsAndCleanUp() {
        if (this.tree != null) {
            this.tree.saveSettingsAndCleanUp();
        }
    }

    public boolean validateData() {
        OLAPDimension dimension = (OLAPDimension)this.list.getSelectedValue();
        if (this.isDetail) {
            if (this.processMembers.isSelected()) {
                dimension.setUpdateOption("MEMBERS");
            } else if (this.processAll.isSelected()) {
                dimension.setUpdateOption("MEMBERS_AND_PROPERTIES");
            }
        } else {
            PhysicalTable previousTable = null;
            try {
                if (dimension != null && dimension.isUpdateable()) {
                    PhysicalTable updateTable = this.tree.getSelectedTable();
                    if (updateTable == null) {
                        MessageUtil.displayMessage((String)bundle.getString("CubeUpdate.Dimensions.NoAddTableError.txt"));
                        return false;
                    }
                    previousTable = dimension.getAddDataTable();
                    dimension.setAddDataTable(updateTable);
                    this.dataModel.verifyDimensionSource(dimension);
                    dimension.setAddDataTableOptions(this.tree.getOptions());
                    if (this.processMembers.isSelected()) {
                        dimension.setUpdateOption("MEMBERS");
                    } else if (this.processAll.isSelected()) {
                        dimension.setUpdateOption("MEMBERS_AND_PROPERTIES");
                    } else {
                        dimension.setUpdateOption("OFF");
                    }
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                try {
                    dimension.setAddDataTable(previousTable);
                    this.setUpNewSelection();
                    return false;
                }
                catch (OLAPException olapError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            }
        }
        return true;
    }

    private void setUpNewSelection() {
        try {
            OLAPDimension dimension;
            this.lastSelected = dimension = (OLAPDimension)this.list.getSelectedValue();
            String dimensionUpdate = dimension.getUpdateOption();
            if (!this.isDetail) {
                String tableName = this.dataModel.getUpdateTableName();
                if (!ModelUtilities.isBlank((String)tableName)) {
                    if (dimensionUpdate == null || dimensionUpdate.equals("MEMBERS")) {
                        this.processMembers.setSelected(true);
                    } else if (dimensionUpdate.equals("MEMBERS_AND_PROPERTIES")) {
                        this.processAll.setSelected(true);
                    } else {
                        this.processNone.setSelected(true);
                    }
                } else if (dimensionUpdate == null || dimensionUpdate.equals("OFF")) {
                    this.processNone.setSelected(true);
                } else if (dimensionUpdate.equals("MEMBERS_AND_PROPERTIES")) {
                    this.processAll.setSelected(true);
                } else {
                    this.processMembers.setSelected(true);
                }
                PhysicalTable sourceTable = dimension.getAddDataTable();
                this.tree.clearTreeSelections();
                this.tree.initializeSelectedTable(sourceTable);
                this.tree.setOptions(dimension.getAddDataTableOptions());
                this.tree.populateStore();
                this.tree.moveDataToView();
            } else if (dimensionUpdate == null || dimensionUpdate.equals("MEMBERS")) {
                this.processMembers.setSelected(true);
            } else {
                this.processAll.setSelected(true);
            }
            String dimensionName = dimension.getName();
            this.labelOption.setText(bundle.formatString("CubeUpdate.Dimension.Options.fmt.title", (Object)dimensionName));
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        catch (MdException mdError) {
            ExceptionHandler.handleException((Exception)((Object)new OLAPException(mdError.getLocalizedMessage(), 12)));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    class DimensionSelectionListener
    implements ListSelectionListener {
        DimensionSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (CubeUpdateDimensionsTab.this.isDetail) {
                if (CubeUpdateDimensionsTab.this.lastSelected != null) {
                    if (CubeUpdateDimensionsTab.this.processMembers.isSelected()) {
                        CubeUpdateDimensionsTab.this.lastSelected.setUpdateOption("MEMBERS");
                    } else if (CubeUpdateDimensionsTab.this.processAll.isSelected()) {
                        CubeUpdateDimensionsTab.this.lastSelected.setUpdateOption("MEMBERS_AND_PROPERTIES");
                    }
                }
                CubeUpdateDimensionsTab.this.setUpNewSelection();
            } else {
                PhysicalTable previousTable = null;
                try {
                    PhysicalTable updateTable = CubeUpdateDimensionsTab.this.tree.getSelectedTable();
                    if (CubeUpdateDimensionsTab.this.lastSelected != null) {
                        previousTable = CubeUpdateDimensionsTab.this.lastSelected.getAddDataTable();
                        CubeUpdateDimensionsTab.this.lastSelected.setAddDataTable(updateTable);
                        CubeUpdateDimensionsTab.this.dataModel.verifyDimensionSource(CubeUpdateDimensionsTab.this.lastSelected);
                        if (CubeUpdateDimensionsTab.this.processMembers.isSelected()) {
                            CubeUpdateDimensionsTab.this.lastSelected.setUpdateOption("MEMBERS");
                        } else if (CubeUpdateDimensionsTab.this.processAll.isSelected()) {
                            CubeUpdateDimensionsTab.this.lastSelected.setUpdateOption("MEMBERS_AND_PROPERTIES");
                        } else {
                            CubeUpdateDimensionsTab.this.lastSelected.setUpdateOption("OFF");
                        }
                    }
                    CubeUpdateDimensionsTab.this.setUpNewSelection();
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                    try {
                        CubeUpdateDimensionsTab.this.lastSelected.setAddDataTable(previousTable);
                        CubeUpdateDimensionsTab.this.setUpNewSelection();
                    }
                    catch (OLAPException olapError) {
                        ExceptionHandler.handleException((Exception)((Object)olapError));
                    }
                }
            }
        }
    }
}

