/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.AggregationPreviewLevelsPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class CubeCoalesceTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeCoalesceTab.class);
    private DefaultTreeModel available;
    private DefaultListModel selected;
    private OLAPCube olapCube;
    private JTree aggrSelector;
    private boolean initialized;
    private List listOfAggregations;
    private List selectedAggregations;
    private Map racksPerAggregation;
    private AggregationPreviewLevelsPanel displayLevels;
    private List aggrsDisplayed;

    public CubeCoalesceTab(OLAPCube CM, Map inRacksPerAggregation) {
        super(bundle.getString("CubeUpdateDesigner.Coalesce.instructions.txt"));
        this.olapCube = CM;
        this.racksPerAggregation = inRacksPerAggregation;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("coalesce_aggregations");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public String createFinishString() {
        StringBuffer finishString = null;
        AggregationSet aggregationSet = this.olapCube.getAggregationSet();
        try {
            finishString = aggregationSet.generateCoalesceCode(true);
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
            return "";
        }
        return finishString.toString();
    }

    protected void initialize() {
        DefaultMutableTreeNode aggrNode;
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.available.getRoot();
        Object[] keys = this.racksPerAggregation.keySet().toArray();
        Arrays.sort(keys, Collections.reverseOrder());
        int keySize = keys.length;
        for (int i = 0; i < keySize; ++i) {
            String rackNumber = (String)keys[i];
            aggrNode = new DefaultMutableTreeNode(bundle.formatString("CubeCoalesce.RackLabelNode.fmt.txt", (Object)rackNumber));
            rootNode.add(aggrNode);
            aggrNode.setAllowsChildren(true);
            List aggrList = (List)this.racksPerAggregation.get(rackNumber);
            Collections.sort(aggrList);
            int aggrSize = aggrList.size();
            for (int t = 0; t < aggrSize; ++t) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(aggrList.get(t));
                childNode.setAllowsChildren(false);
                aggrNode.add(childNode);
            }
        }
        this.aggrSelector.expandPath(new TreePath(rootNode.getPath()));
        DefaultMutableTreeNode firstAggregation = rootNode.getNextNode();
        TreePath pathOfFirstAggregation = new TreePath(firstAggregation.getPath());
        this.aggrSelector.setSelectionPath(pathOfFirstAggregation);
        this.aggrSelector.setCellRenderer(new AvailableTreeCellRenderer());
        SelectedTreeListener treeListener = new SelectedTreeListener();
        this.aggrSelector.addTreeSelectionListener(treeListener);
        this.selectedAggregations = new ArrayList();
        this.aggrsDisplayed = new ArrayList();
        aggrNode = (DefaultMutableTreeNode)rootNode.getChildAt(0);
        this.aggrSelector.expandPath(new TreePath(aggrNode.getPath()));
        this.initialized = true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel && !this.initialized) {
            this.initialize();
        }
        return true;
    }

    private void _layoutWidgets() {
        this.aggrSelector = new JTree();
        JScrollPane scroll = new JScrollPane(this.aggrSelector);
        this.displayLevels = new AggregationPreviewLevelsPanel(bundle.getString("AggregationPreviewLevel.title"), true);
        this.aggrSelector.setToolTipText(bundle.getString("CubeUpdate.Coalesce.DualSelector.ToolTip.txt"));
        JLabel label = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(label, bundle.getString("CubeCoalesce.DualListbox.leftlistbox.txt"));
        label.setLabelFor(this.aggrSelector);
        this.available = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.aggrSelector.setRootVisible(false);
        this.aggrSelector.setModel(this.available);
        this.aggrSelector.setName("AggregationTree");
        this.add(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add(scroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.displayLevels), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
    }

    protected class SelectedTreeListener
    implements TreeSelectionListener {
        protected SelectedTreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent tse) {
            TreePath[] selectedPath = CubeCoalesceTab.this.aggrSelector.getSelectionPaths();
            if (selectedPath == null) {
                return;
            }
            int size = selectedPath.length;
            for (int i = 0; i < size; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath[i].getLastPathComponent();
                if (node == null) continue;
                Object currentObject = node.getUserObject();
                CubeCoalesceTab.this.selectedAggregations.clear();
                if (!(currentObject instanceof OLAPAggregation) || CubeCoalesceTab.this.aggrsDisplayed.contains(currentObject)) continue;
                CubeCoalesceTab.this.selectedAggregations.add(currentObject);
                CubeCoalesceTab.this.aggrsDisplayed.add(currentObject);
            }
            if (!CubeCoalesceTab.this.selectedAggregations.isEmpty()) {
                CubeCoalesceTab.this.displayLevels.setSelectedAggregations(CubeCoalesceTab.this.selectedAggregations);
            }
        }
    }

    protected class AvailableTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        protected AvailableTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            return this;
        }
    }
}

