/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.PerformanceDefaultOptionsTab;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class CubeCoalesceSPDETab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeCoalesceSPDETab.class);
    private OLAPCube olapCube;
    private JTabbedPane tabber;
    private PerformanceDefaultOptionsTab globalPanel;
    private WAPropertyTab currentTab;

    public CubeCoalesceSPDETab(OLAPCube CM) {
        super(bundle.getString("CubeUpdate.SPDE.Options.instructions.txt"));
        this.olapCube = CM;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("coalesce_perform_option");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        return this.currentTab.validateData();
    }

    public void onNext() {
        for (int i = 0; i < this.tabber.getTabCount(); ++i) {
            WAPropertyTab tab = (WAPropertyTab)this.tabber.getComponentAt(i);
            tab.onParentOK();
        }
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.currentTab = (WAPropertyTab)this.tabber.getSelectedComponent();
        }
        return true;
    }

    private void _layoutWidgets() {
        ArrayList sharedOptions = new ArrayList();
        this.tabber = new JTabbedPane(1);
        this.add(this.tabber, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        try {
            Integer oSortSize = this.olapCube.getPerformanceOptionIndexSortSize();
            Integer oConcurrent = this.olapCube.getPerformanceOptionConcurrent();
            Integer oMaxThreads = this.olapCube.getPerformanceOptionMaxThreads();
            this.globalPanel = new PerformanceDefaultOptionsTab(this.olapCube, null, null, true, oSortSize, oConcurrent, oMaxThreads, sharedOptions, false);
            Border brdrOuter = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            Border brdrInner = this.globalPanel.getBorder();
            this.globalPanel.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
            this.tabber.addTab(bundle.getString("CoalesceSPDE.Default.tab.title"), (Component)((Object)this.globalPanel));
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }
}

