/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.update.CubeUpdateSaveProcOlapDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class CubeCoalesceFinishTab
extends WizardFinishTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeCoalesceFinishTab.class);
    private boolean initialized;
    private OLAPCube olapCube;
    private JButton saveProcCode;
    private WAWizardDialog parent;
    private WsAppServer server;
    private WsRunCode wsRunCode;

    public CubeCoalesceFinishTab(OLAPCube inputCube) {
        super(bundle.getString("CubeUpdate.Finish.groupbox.title"));
        this.olapCube = inputCube;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("coalesce_finish");
        this._layoutWidgets();
    }

    protected void initialize() {
        this.parent = (WAWizardDialog)this.getTopLevelAncestor();
        this.saveProcCode.setName("FinishSaveProcCode");
        this.saveProcCode.setToolTipText(bundle.getString("CubeDesigner.Finish.saveProcCode.tooltip.txt"));
        this.saveProcCode.addActionListener(new SaveButtonListener());
        this.initialized = true;
    }

    public boolean validateData() {
        this.parent.setCursor(Cursor.getPredefinedCursor(3));
        this.server = WsRunCode.getServer();
        this.parent.setCursor(Cursor.getPredefinedCursor(0));
        if (this.server != null) {
            this.wsRunCode = new WsRunCode(this.server);
            return !this.wsRunCode.hasSubmitError;
        }
        MessageUtil.displayMessage((String)bundle.getString("CubeUpdate.Finish.ServerNeeded.txt"));
        return false;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            super.doDataExchange(bSaveToModel);
            if (!this.initialized) {
                this.initialize();
            }
        } else {
            String str1 = bundle.getString("CoalesceCubeProgressIndicator.Msg.Title.txt");
            String str2 = bundle.getString("CoalesceCubeProgressIndicator.Msg.Message.txt");
            if (this.server != null) {
                try {
                    AggregationSet aggregationSet = this.olapCube.getAggregationSet();
                    this.wsRunCode.executeCode(aggregationSet.generateCoalesceCode(false), str2, str1);
                    Vector paths = (Vector)this.parent.getWizardData("AGGREGATIONDATAPATHS");
                    if (paths != null) {
                        VisualUtilities.setAggregationDataPaths(paths);
                    }
                    if ((paths = (Vector)this.parent.getWizardData("AGGREGATIONINDEXPATHS")) != null) {
                        VisualUtilities.setAggregationIndexPaths(paths);
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("CubeUpdate.Finish.NoUpdate.txt"));
                this.cleanup();
                return false;
            }
            this.cleanup();
        }
        return true;
    }

    protected void _layoutWidgets() {
        Component component = this.getComponent(0);
        JScrollPane componentPanel = (JScrollPane)component;
        this.removeAll();
        componentPanel.setPreferredSize(new Dimension(300, 200));
        componentPanel.setName("FinishStringTextArea");
        this.add(componentPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel bottomLabel = new JLabel(bundle.getString("Coalesce.Finish.Instructions.txt"));
        this.add(bottomLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.saveProcCode = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.saveProcCode, bundle.getString("CubeDesigner.Finish.saveProcCode.txt"));
        this.add(this.saveProcCode, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 14, 2, new Insets(5, 5, 2, 0), 0, 0));
    }

    private void cleanup() {
        MdObjectStore objectStore = (MdObjectStore)this.parent.getWizardData("OBJECTSTORE");
        try {
            if (objectStore != null) {
                objectStore.dispose();
            }
            objectStore = null;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.parent.addWizardData("OBJECTSTORE", null);
        if (this.server != null) {
            this.wsRunCode.term();
        }
        this.server = null;
    }

    private final class SaveButtonListener
    implements ActionListener {
        private SaveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Workspace m_workspace = Workspace.getWorkspace();
            CubeUpdateSaveProcOlapDialog saveProcDialog = new CubeUpdateSaveProcOlapDialog(m_workspace, bundle.getString("SaveProcCode.Title.txt"), CubeCoalesceFinishTab.this.olapCube);
            saveProcDialog.show();
        }
    }
}

