/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.shareddims.visuals;

import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.shareddims.visuals.SharedDimLevelDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SharedDimLevelPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(SharedDimLevelPanel.class);
    private DualListSelector listbox;
    private DefaultListModel selectModel;
    private OLAPSharedDimension dimensionModel;
    private SharedDimensionTable dimTable;
    private SharedDimLevelDialog parent;
    private TreeSet sortColumns;
    private CollectionToListModelAdapter availModel;

    public SharedDimLevelPanel(OLAPSharedDimension inDimensionModel) {
        this.dimensionModel = inDimensionModel;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            try {
                this.parent = (SharedDimLevelDialog)((Object)this.getTopLevelAncestor());
                this.parent.setOKButton(false);
                this.dimTable = this.dimensionModel.getSharedDimensionTable();
                OLAPList availableColumns = this.dimTable.getColumns();
                for (int ii = 0; ii < availableColumns.size(); ++ii) {
                    this.sortColumns.add(availableColumns.get(ii));
                }
                JList availList = (JList)this.listbox.getSourceComponent();
                if (this.sortColumns.size() > 0) {
                    this.availModel.refresh();
                    availList.setSelectedIndex(0);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        } else {
            String dimensionSort = this.dimensionModel.getSortOrder();
            String dimensionType = this.dimensionModel.getType();
            int listSize = this.selectModel.size();
            try {
                for (int ii = 0; ii < listSize; ++ii) {
                    OLAPColumn columnObject = (OLAPColumn)this.selectModel.getElementAt(ii);
                    String columnName = columnObject.getSASColumnName();
                    OLAPLevel levelModel = this.dimensionModel.createOLAPLevel(columnObject);
                    String label = columnObject.getDescription();
                    if (ModelUtilities.isBlank((String)label)) {
                        label = columnName;
                    }
                    levelModel.setDesc(label);
                    levelModel.setSortOrder(dimensionSort);
                    levelModel.setFormat(columnObject.getSASFormat());
                    int levelType = 1;
                    if (!dimensionType.equals("STANDARD")) {
                        levelType = 8192;
                    }
                    levelModel.setType(levelType);
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        return true;
    }

    private void _layoutWidgets() {
        this.listbox = new DualListSelector();
        this.sortColumns = new TreeSet();
        this.availModel = new CollectionToListModelAdapter();
        this.listbox.setSourceCellRenderer((ListCellRenderer)new ColumnListCellRenderer());
        this.listbox.setTargetCellRenderer((ListCellRenderer)new ColumnListCellRenderer());
        this.selectModel = new DefaultListModel();
        this.selectModel.addListDataListener(new SelectionModelListener());
        this.listbox.setPreferredSize(new Dimension(650, 300));
        this.listbox.setDragAndDropEnabled(false);
        this.listbox.setModel((ListModel)this.availModel);
        this.availModel.setModel((Collection)this.sortColumns);
        this.listbox.setTargetModel((ListModel)this.selectModel);
        this.listbox.setTransferAllControlsVisible(true);
        this.listbox.setName("LevelsListbox");
        VisualUtilities.setDualSelectorTextAndMnemonic((BaseDualSelector)this.listbox, bundle.getString("SharedDimLevel.AvailableColumns.control.label"), bundle.getString("SharedDimLevel.SelectedColumns.control.label"));
        this.add((Component)this.listbox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 10), 0, 0));
    }

    public boolean validateData() {
        int numberoflevels = this.selectModel.size();
        if (numberoflevels < 1) {
            MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.NoLevelsDefined.txt"), (int)2);
            return false;
        }
        return true;
    }

    class SelectionModelListener
    implements ListDataListener {
        SelectionModelListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (SharedDimLevelPanel.this.selectModel.size() < 1) {
                SharedDimLevelPanel.this.parent.setOKButton(false);
            } else {
                SharedDimLevelPanel.this.parent.setOKButton(true);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            if (SharedDimLevelPanel.this.selectModel.size() < 1) {
                SharedDimLevelPanel.this.parent.setOKButton(false);
            } else {
                SharedDimLevelPanel.this.parent.setOKButton(true);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            if (SharedDimLevelPanel.this.selectModel.size() < 1) {
                SharedDimLevelPanel.this.parent.setOKButton(false);
            } else {
                SharedDimLevelPanel.this.parent.setOKButton(true);
            }
        }
    }

    class ColumnListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        ColumnListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            ImageIcon icon = null;
            OLAPColumn column = (OLAPColumn)value;
            String typeOfColumn = column.getSASColumnType();
            icon = typeOfColumn.equalsIgnoreCase("N") ? bundle.getImageIcon("Common.NumericType.image") : bundle.getImageIcon("Common.CharacterType.image");
            this.setIcon(icon);
            return this;
        }
    }
}

