/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.shareddims.visuals;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.visuals.CubeMemberPropertiesAddDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.shareddims.visuals.SharedDimDesigner;
import com.sas.olapadmin.shareddims.visuals.SharedDimDimensionRenameDialog;
import com.sas.olapadmin.shareddims.visuals.SharedDimGISMapDialog;
import com.sas.olapadmin.shareddims.visuals.SharedDimHierDetailsDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.CubeButtons;
import com.sas.olapadmin.utilities.studio.StructureTreeCellRenderer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SharedDimHierTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(SharedDimHierTab.class);
    private OLAPSharedDimension dimensionModel;
    private CubeButtons buttons;
    private WAComboBox defaultHierarchyBox;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private JButton addButton;
    private JButton deleteButton;
    private JButton modifyButton;
    private JButton memberPropertyButton;
    private JButton mapButton;
    private OLAPList availableHiers;
    private boolean initialized;
    private StructureTreeCellRenderer renderer;
    private String blank;
    private HierarchySelectionListener hierarchySelectionListener;
    private DefaultBoxActionListener defaultActionListener;
    private OLAPHierarchy currentDefaultHierarchy;
    private SharedDimDesigner parent;
    private OLAPObjectNode root;
    private List sortedHierarchy;
    private List sortedMemberProperty;

    public SharedDimHierTab(OLAPSharedDimension indimension) {
        this.dimensionModel = indimension;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("shared_dim_hierarchy");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            String typeOfDim = this.dimensionModel.getType();
            if (!typeOfDim.equals("GEO")) {
                this.mapButton.setEnabled(false);
            } else {
                this.mapButton.setEnabled(true);
            }
            if (!this.initialized) {
                this.initialize();
            } else {
                try {
                    if (this.parent.getWizardData("LEVELSCHANGED") == "1") {
                        OLAPObjectNode firstNode;
                        this.availableHiers = this.dimensionModel.getHierarchies();
                        this.tree.removeTreeSelectionListener(this.hierarchySelectionListener);
                        int hierarchySize = this.availableHiers.size();
                        this.defaultHierarchyBox.removeAllItems();
                        if (this.availableHiers.isEmpty()) {
                            this.defaultHierarchyBox.setEnabled(false);
                        }
                        this.sortedHierarchy.clear();
                        this.sortedHierarchy.addAll(this.availableHiers);
                        Collections.sort(this.sortedHierarchy);
                        this.root.removeAllChildren();
                        for (int i = 0; i < hierarchySize; ++i) {
                            OLAPHierarchy hierarchy = (OLAPHierarchy)this.sortedHierarchy.get(i);
                            OLAPObjectNode hierarchyNode = new OLAPObjectNode((AbstractOLAPModel)hierarchy);
                            this.root.add(hierarchyNode);
                            OLAPList levels = hierarchy.getLevels();
                            for (int k = 0; k < levels.size(); ++k) {
                                OLAPLevel level = (OLAPLevel)levels.get(k);
                                OLAPObjectNode levelNode = new OLAPObjectNode((AbstractOLAPModel)level);
                                hierarchyNode.add(levelNode);
                                levelNode.setParent(hierarchyNode);
                                OLAPList memberProperties = level.getOLAPProperties();
                                this.sortedMemberProperty.clear();
                                this.sortedMemberProperty.addAll(memberProperties);
                                Collections.sort(memberProperties);
                                int sizeMP = memberProperties.size();
                                for (int t = 0; t < sizeMP; ++t) {
                                    OLAPMemberProperty member = (OLAPMemberProperty)this.sortedMemberProperty.get(t);
                                    OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)member);
                                    memberPropertyNode.setAllowsChildren(false);
                                    levelNode.add(memberPropertyNode);
                                    memberPropertyNode.setParent(levelNode);
                                }
                            }
                        }
                        this.treeModel.reload();
                        int count = this.treeModel.getChildCount(this.root);
                        if (count > 0 && (firstNode = (OLAPObjectNode)this.treeModel.getChild(this.root, 0)) != null) {
                            this.expandAll(this.tree, new TreePath(firstNode.getPath()));
                        }
                        this.defaultHierarchyBox.addItems((List)this.availableHiers);
                        if (count < 1) {
                            this.currentDefaultHierarchy = null;
                        }
                        if (this.currentDefaultHierarchy != null) {
                            this.defaultHierarchyBox.setSelectedItem((Object)this.currentDefaultHierarchy);
                        }
                        this.setButtonsState();
                        this.tree.addTreeSelectionListener(this.hierarchySelectionListener);
                        this.parent.addWizardData("LEVELSCHANGED", "0");
                    }
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        }
        return true;
    }

    protected void initialize() {
        try {
            int sizeOfHierarchies;
            this.parent = (SharedDimDesigner)((Object)this.getTopLevelAncestor());
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            String dimensionName = (String)parent.getWizardData("DIMENSIONNAME");
            this.setDescription(bundle.formatString("SharedDimDesigner.Hierarchy.instruct.fmt", (Object)dimensionName));
            this.blank = "               ";
            this.sortedHierarchy = new ArrayList();
            this.sortedMemberProperty = new ArrayList();
            this.hierarchySelectionListener = new HierarchySelectionListener();
            this.tree.addTreeSelectionListener(this.hierarchySelectionListener);
            this.defaultActionListener = new DefaultBoxActionListener();
            this.addButton.addActionListener(new AddButtonListener());
            this.addButton.setToolTipText(bundle.getString("CubeDesigner.Hierarchy.AddTip.txt"));
            this.modifyButton.addActionListener(new ModifyButtonlistener());
            this.deleteButton.addActionListener(new DeleteButtonListener());
            this.memberPropertyButton.addActionListener(new MemberPropertyButtonlistener());
            this.mapButton.addActionListener(new MapButtonListener());
            this.modifyButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.memberPropertyButton.setEnabled(false);
            this.availableHiers = this.dimensionModel.getHierarchies();
            if (this.availableHiers.size() < 1) {
                OLAPHierarchy defaultHierarchy = null;
                try {
                    defaultHierarchy = this.dimensionModel.createOLAPHierarchy();
                    List listOfLevels = (List)parent.getWizardData("ORDEROFLEVELS");
                    OLAPList listOfHierarchyLevels = defaultHierarchy.getLevels();
                    if (listOfLevels == null) {
                        listOfLevels = this.dimensionModel.getLevels();
                    }
                    int size = listOfLevels.size();
                    for (int i = 0; i < size; ++i) {
                        listOfHierarchyLevels.add(listOfLevels.get(i));
                    }
                    defaultHierarchy.verifyMaximumLevelsPerDefaultHierarchy();
                    defaultHierarchy.setName(dimensionName);
                    defaultHierarchy.setDesc(dimensionName);
                    defaultHierarchy.setAllMember(bundle.formatString("SharedDimDesigner.AllMember.fmt", (Object)dimensionName));
                    this.dimensionModel.setDefault(defaultHierarchy);
                }
                catch (OLAPException OLAPError) {
                    try {
                        if (defaultHierarchy != null) {
                            defaultHierarchy.delete();
                        }
                    }
                    catch (OLAPException OError) {
                        ExceptionHandler.handleException((Exception)((Object)OError));
                    }
                    ExceptionHandler.handleException((Exception)((Object)OLAPError));
                }
            }
            this.root = (OLAPObjectNode)this.treeModel.getRoot();
            this.defaultHierarchyBox.removeAllItems();
            if (this.availableHiers.isEmpty()) {
                this.defaultHierarchyBox.setEnabled(false);
            }
            if ((sizeOfHierarchies = this.availableHiers.size()) > 0) {
                OLAPObjectNode firstNode;
                this.currentDefaultHierarchy = (OLAPHierarchy)this.availableHiers.get(0);
                this.dimensionModel.setDefault(this.currentDefaultHierarchy);
                this.sortedHierarchy.clear();
                this.sortedHierarchy.addAll(this.availableHiers);
                Collections.sort(this.sortedHierarchy);
                for (int i = 0; i < sizeOfHierarchies; ++i) {
                    OLAPHierarchy hierarchy = (OLAPHierarchy)this.sortedHierarchy.get(i);
                    OLAPObjectNode hierarchyNode = new OLAPObjectNode((AbstractOLAPModel)hierarchy);
                    this.root.add(hierarchyNode);
                    OLAPList levels = hierarchy.getLevels();
                    for (int k = 0; k < levels.size(); ++k) {
                        OLAPLevel level = (OLAPLevel)levels.get(k);
                        OLAPObjectNode levelNode = new OLAPObjectNode((AbstractOLAPModel)level);
                        hierarchyNode.add(levelNode);
                        levelNode.setParent(hierarchyNode);
                        OLAPList memberProperties = level.getOLAPProperties();
                        this.sortedMemberProperty.clear();
                        this.sortedMemberProperty.addAll(memberProperties);
                        Collections.sort(this.sortedMemberProperty);
                        int sizeMP = memberProperties.size();
                        for (int t = 0; t < sizeMP; ++t) {
                            OLAPMemberProperty member = (OLAPMemberProperty)this.sortedMemberProperty.get(t);
                            OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)member);
                            levelNode.add(memberPropertyNode);
                            memberPropertyNode.setParent(levelNode);
                            memberPropertyNode.setAllowsChildren(false);
                        }
                    }
                }
                this.treeModel.reload();
                int count = this.treeModel.getChildCount(this.root);
                if (count > 0 && (firstNode = (OLAPObjectNode)this.treeModel.getChild(this.root, 0)) != null) {
                    this.expandAll(this.tree, new TreePath(firstNode.getPath()));
                }
                this.defaultHierarchyBox.addItems((List)this.availableHiers);
                if (this.currentDefaultHierarchy != null) {
                    this.defaultHierarchyBox.setSelectedItem((Object)this.currentDefaultHierarchy);
                }
                this.defaultHierarchyBox.addActionListener((ActionListener)this.defaultActionListener);
            } else {
                this.defaultHierarchyBox.addItem((Object)this.blank);
            }
            parent.addWizardData("LEVELSCHANGED", (Object)"0");
            this.initialized = true;
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public void _layoutWidgets() {
        JLabel defaultHierLabel = new JLabel();
        this.defaultHierarchyBox = new WAComboBox();
        this.defaultHierarchyBox.setPreferredSize(new Dimension(75, 25));
        this.defaultHierarchyBox.setName("DefaultHierarchyDropDownBox");
        Utilities.setLabelTextAndMnemonic((JLabel)defaultHierLabel, (String)bundle.getString("SharedDimDesigner.Hierarchy.default.control.label"));
        defaultHierLabel.setLabelFor((Component)this.defaultHierarchyBox);
        defaultHierLabel.setName("DefaultHierarchyLabelField");
        JPanel defaultHierPanel = new JPanel();
        defaultHierPanel.setLayout(new GridBagLayout());
        defaultHierPanel.add((Component)defaultHierLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        defaultHierPanel.add((Component)this.defaultHierarchyBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.buttons = new CubeButtons();
        this.addButton = this.buttons.getAddButton();
        VisualUtilities.setButtonTextAndMnemonic(this.addButton, bundle.getString("Common.addHierarchy.txt"));
        this.modifyButton = this.buttons.getModifyButton();
        this.deleteButton = this.buttons.getDeleteButton();
        this.mapButton = this.buttons.getApplyButton();
        VisualUtilities.setButtonTextAndMnemonic(this.mapButton, bundle.getString("SharedDimDesigner.GISMaps.control.label"));
        this.mapButton.setToolTipText(bundle.getString("SharedDimDesigner.GISMaps.action.label.tip"));
        this.memberPropertyButton = this.buttons.getResetButton();
        VisualUtilities.setButtonTextAndMnemonic(this.memberPropertyButton, bundle.getString("SharedDimDesigner.Buttons.AddMemberProperty.control.label"));
        this.memberPropertyButton.setToolTipText(bundle.getString("SharedDimDesigner.Hierarchy.MemberPropertyButton.tip"));
        this.buttons.removeDefaultButton();
        this.treeModel = new DefaultTreeModel(new OLAPObjectNode(" "));
        this.tree = new JTree(this.treeModel);
        this.renderer = new StructureTreeCellRenderer();
        this.tree.addFocusListener(new TreeFocusListener());
        this.tree.setCellRenderer(this.renderer);
        this.tree.setRootVisible(false);
        JLabel labelListBox = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)labelListBox, (String)bundle.getString("SharedDimDesigner.Hierarchy.level.control.label"));
        labelListBox.setLabelFor(this.tree);
        this.addButton = this.buttons.getAddButton();
        JScrollPane topPanel = new JScrollPane(this.tree);
        this.tree.setShowsRootHandles(true);
        topPanel.setPreferredSize(new Dimension(250, 200));
        JPanel hierarchyList = new JPanel();
        hierarchyList.setLayout(new GridBagLayout());
        hierarchyList.add((Component)labelListBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        hierarchyList.add((Component)topPanel, new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(defaultHierPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(hierarchyList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)((Object)this.buttons), new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 12, 2, new Insets(24, 5, 0, 5), 0, 0));
    }

    private void setButtonsState() {
        TreePath[] selectedObjectPaths = this.tree.getSelectionPaths();
        if (selectedObjectPaths != null) {
            int size = selectedObjectPaths.length;
            if (size == 1) {
                OLAPObjectNode node = (OLAPObjectNode)selectedObjectPaths[0].getLastPathComponent();
                Object nextObject = node.getUserObject();
                if (nextObject instanceof OLAPHierarchy) {
                    this.modifyButton.setEnabled(true);
                    this.deleteButton.setEnabled(true);
                    this.memberPropertyButton.setEnabled(false);
                } else if (nextObject instanceof OLAPLevel) {
                    this.modifyButton.setEnabled(false);
                    this.deleteButton.setEnabled(true);
                    this.memberPropertyButton.setEnabled(true);
                } else if (nextObject instanceof OLAPMemberProperty) {
                    this.modifyButton.setEnabled(true);
                    this.deleteButton.setEnabled(true);
                    this.memberPropertyButton.setEnabled(false);
                }
            } else {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.deleteButton.setEnabled(true);
                this.memberPropertyButton.setEnabled(false);
            }
        } else {
            this.modifyButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.memberPropertyButton.setEnabled(false);
        }
    }

    public boolean validateData() {
        OLAPList listOfHierarchies = null;
        try {
            listOfHierarchies = this.dimensionModel.getHierarchies();
            this.dimensionModel.verifyHierarchyList();
        }
        catch (OLAPException OLAPError) {
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        int numberofhiers = listOfHierarchies.size();
        String dimensionType = this.dimensionModel.getType();
        if (numberofhiers > 0) {
            try {
                this.dimensionModel.verifyAllLevelsUsed();
            }
            catch (OLAPException OLAPError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        numberofhiers = listOfHierarchies.size();
        OLAPHierarchy nextHierarchy = null;
        try {
            if (dimensionType.equals("TIME")) {
                for (int ii = 0; ii < numberofhiers; ++ii) {
                    nextHierarchy = (OLAPHierarchy)listOfHierarchies.get(ii);
                    nextHierarchy.verifyHierarchyTimeDrillOrder();
                }
            }
        }
        catch (OLAPException OLAPError) {
            try {
                boolean found = false;
                if (nextHierarchy != null) {
                    nextHierarchy.orderTimeLevels();
                }
                nextHierarchy.verifyHierarchyTimeDrillOrder();
            }
            catch (OLAPException oError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        if (listOfHierarchies.size() == 1) {
            OLAPHierarchy isdefault = (OLAPHierarchy)listOfHierarchies.get(0);
            String name = isdefault.getName();
            String newHierarchyName = null;
            boolean levelNameIsFound = false;
            OLAPList listOfLevels = null;
            try {
                listOfLevels = this.dimensionModel.getLevels();
            }
            catch (OLAPException OLAPError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            String dimensionName = this.dimensionModel.getName();
            int i = 0;
            int size = listOfLevels.size();
            while (i < size & !levelNameIsFound) {
                OLAPLevel nextLevel = (OLAPLevel)listOfLevels.get(i);
                String levelName = nextLevel.getName();
                if (levelName.equalsIgnoreCase(dimensionName)) {
                    levelNameIsFound = true;
                }
                ++i;
            }
            if (levelNameIsFound) {
                Workspace m_workspace = Workspace.getWorkspace();
                SharedDimDimensionRenameDialog renameDialog = new SharedDimDimensionRenameDialog(m_workspace, bundle.getString("SharedDimDesigner.RenameDimension.Title.txt"), this.dimensionModel);
                renameDialog.show();
                newHierarchyName = renameDialog.getDimensionName();
                if (newHierarchyName == null) {
                    return false;
                }
                isdefault.setName(newHierarchyName);
                OLAPObjectNode hierarchyNode = this.findNode((DefaultMutableTreeNode)this.treeModel.getRoot(), (AbstractOLAPModel)isdefault);
                if (hierarchyNode != null) {
                    this.treeModel.reload(hierarchyNode);
                }
            } else {
                if (!name.equalsIgnoreCase(dimensionName)) {
                    MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.Hierarchy.Rename.Hierarchy.txt"));
                }
                newHierarchyName = dimensionName;
                isdefault.setName(newHierarchyName);
                OLAPObjectNode hierarchyNode = this.findNode((DefaultMutableTreeNode)this.treeModel.getRoot(), (AbstractOLAPModel)isdefault);
                if (hierarchyNode != null) {
                    this.treeModel.reload(hierarchyNode);
                }
                this.defaultHierarchyBox.repaint();
            }
            String hierarchyCaption = isdefault.getDesc();
            if (hierarchyCaption.equals(isdefault.getName())) {
                isdefault.setDesc(newHierarchyName);
            }
            if (levelNameIsFound) {
                this.dimensionModel.setName(newHierarchyName);
            }
            try {
                String checkForOldName = bundle.formatString("SharedDimDesigner.AllMember.fmt", (Object)name);
                if (checkForOldName.equalsIgnoreCase(isdefault.getAllMember())) {
                    isdefault.setAllMember(bundle.formatString("SharedDimDesigner.AllMember.fmt", (Object)newHierarchyName));
                }
                if (this.availableHiers == null) {
                    this.availableHiers = this.dimensionModel.getHierarchies();
                    if (this.currentDefaultHierarchy == null) {
                        this.currentDefaultHierarchy = (OLAPHierarchy)this.availableHiers.get(0);
                    }
                }
                this.dimensionModel.setDefault(this.currentDefaultHierarchy);
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        try {
            this.dimensionModel.getHierarchies().addDefaultHierarchy(this.dimensionModel.getDefault());
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return true;
    }

    private void expandAll(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    private OLAPObjectNode findNode(DefaultMutableTreeNode node, AbstractOLAPModel object) {
        if (node == null) {
            return null;
        }
        int numChildNodes = node.getChildCount();
        OLAPObjectNode foundNode = null;
        for (int i = 0; i < numChildNodes && foundNode == null; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            OLAPObjectNode simpleChildNode = (OLAPObjectNode)childNode;
            AbstractOLAPModel checkObject = (AbstractOLAPModel)simpleChildNode.getUserObject();
            if (!checkObject.equals(object)) continue;
            foundNode = simpleChildNode;
        }
        return foundNode;
    }

    public class TreeFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            int rowcount;
            if (SharedDimHierTab.this.tree.getMaxSelectionRow() < 0 && (rowcount = SharedDimHierTab.this.tree.getRowCount()) > 0) {
                SharedDimHierTab.this.tree.setSelectionRow(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class OLAPObjectNode
    extends DefaultMutableTreeNode
    implements Comparable {
        private static final long serialVersionUID = 1L;

        OLAPObjectNode(AbstractOLAPModel inputObject) {
            this.userObject = inputObject;
        }

        OLAPObjectNode(String inputObject) {
            this.userObject = inputObject;
        }

        @Override
        public String toString() {
            String objectName = null;
            Object object = this.userObject;
            if (object instanceof String) {
                objectName = (String)object;
            } else {
                AbstractOLAPModel olapObject = (AbstractOLAPModel)this.userObject;
                if (this.userObject instanceof AbstractOLAPModel) {
                    objectName = olapObject.getName();
                }
            }
            return objectName;
        }

        public int compareTo(Object obj) {
            int compnum = this.toString().compareToIgnoreCase(obj.toString());
            return compnum;
        }
    }

    private final class ModifyButtonlistener
    implements ActionListener {
        private ModifyButtonlistener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TreePath selectedPath = SharedDimHierTab.this.tree.getSelectionPath();
            DefaultMutableTreeNode objectNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
            Object object = objectNode.getUserObject();
            if (object instanceof OLAPLevel) {
                OLAPObjectNode parentNode = (OLAPObjectNode)objectNode.getParent();
                OLAPHierarchy hierarchy = (OLAPHierarchy)parentNode.getUserObject();
                SharedDimHierDetailsDialog hierdialog = new SharedDimHierDetailsDialog((Dialog)((Object)SharedDimHierTab.this.parent), bundle.getString("SharedDimDesigner.Hierarchy.Define.txt"), (OLAPDimension)SharedDimHierTab.this.dimensionModel, hierarchy);
                hierdialog.show();
            } else if (object instanceof OLAPHierarchy) {
                try {
                    SharedDimHierTab.this.defaultHierarchyBox.removeActionListener((ActionListener)SharedDimHierTab.this.defaultActionListener);
                    OLAPHierarchy hierarchy = (OLAPHierarchy)object;
                    SharedDimHierDetailsDialog hierdialog = new SharedDimHierDetailsDialog((Dialog)((Object)SharedDimHierTab.this.parent), bundle.getString("SharedDimDesigner.Hierarchy.Define.txt"), (OLAPDimension)SharedDimHierTab.this.dimensionModel, hierarchy);
                    hierdialog.show();
                    objectNode.removeAllChildren();
                    SharedDimHierTab.this.sortedHierarchy.clear();
                    OLAPList levels = hierarchy.getLevels();
                    for (int k = 0; k < levels.size(); ++k) {
                        OLAPLevel level = (OLAPLevel)levels.get(k);
                        OLAPObjectNode levelNode = new OLAPObjectNode((AbstractOLAPModel)level);
                        SharedDimHierTab.this.treeModel.insertNodeInto(levelNode, objectNode, k);
                        levelNode.setParent(objectNode);
                        OLAPList memberProperties = level.getOLAPProperties();
                        SharedDimHierTab.this.sortedMemberProperty.clear();
                        SharedDimHierTab.this.sortedMemberProperty.addAll(memberProperties);
                        Collections.sort(memberProperties);
                        int sizeMP = memberProperties.size();
                        for (int t = 0; t < sizeMP; ++t) {
                            OLAPMemberProperty member = (OLAPMemberProperty)SharedDimHierTab.this.sortedMemberProperty.get(t);
                            OLAPList listOfMPHierarchies = member.getHierarchies();
                            if (!listOfMPHierarchies.contains(hierarchy)) continue;
                            OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)member);
                            memberPropertyNode.setAllowsChildren(false);
                            SharedDimHierTab.this.treeModel.insertNodeInto(memberPropertyNode, levelNode, levelNode.getChildCount());
                            memberPropertyNode.setParent(levelNode);
                        }
                    }
                    SharedDimHierTab.this.treeModel.reload(objectNode);
                    SharedDimHierTab.this.defaultHierarchyBox.removeAllItems();
                    SharedDimHierTab.this.defaultHierarchyBox.addItems((List)SharedDimHierTab.this.availableHiers);
                    SharedDimHierTab.this.defaultHierarchyBox.setSelectedItem((Object)SharedDimHierTab.this.currentDefaultHierarchy);
                    SharedDimHierTab.this.defaultHierarchyBox.addActionListener((ActionListener)SharedDimHierTab.this.defaultActionListener);
                    SharedDimHierTab.this.expandAll(SharedDimHierTab.this.tree, new TreePath(objectNode));
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            } else if (object instanceof OLAPMemberProperty) {
                try {
                    OLAPMemberProperty memproperty = (OLAPMemberProperty)object;
                    String oldName = memproperty.getName();
                    WAStandardDialog m_parent = (WAStandardDialog)SharedDimHierTab.this.getTopLevelAncestor();
                    OLAPLevel level = memproperty.getAssociatedLevel();
                    ArrayList oldHierarchies = new ArrayList();
                    oldHierarchies.addAll(memproperty.getHierarchies());
                    CubeMemberPropertiesAddDialog memberPDialog = null;
                    OLAPSharedDimension dimension = level.getOwningSharedDimension();
                    OLAPList columnList = null;
                    SharedDimensionTable table = dimension.getSharedDimensionTable();
                    if (table != null) {
                        columnList = table.getColumns();
                    }
                    memberPDialog = new CubeMemberPropertiesAddDialog((Dialog)m_parent, bundle.getString("SharedDimDesigner.MemberProperty.window.title"), SharedDimHierTab.this.dimensionModel, memproperty, (List)level.getHierarchies(), (List)columnList, level);
                    memberPDialog.show();
                    String newName = memproperty.getName();
                    if (memberPDialog.getReturnValue() == 1) {
                        int i;
                        OLAPObjectNode parentNode = (OLAPObjectNode)objectNode.getParent();
                        OLAPLevel levelObject = (OLAPLevel)parentNode.getUserObject();
                        OLAPList memberPropertyHierarchies = memproperty.getHierarchies();
                        int size = oldHierarchies.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            OLAPObjectNode levelNode;
                            OLAPObjectNode hierarchyNode;
                            OLAPHierarchy checkHierarchy = (OLAPHierarchy)oldHierarchies.get(i2);
                            if (memberPropertyHierarchies.contains(checkHierarchy) || (hierarchyNode = SharedDimHierTab.this.findNode((DefaultMutableTreeNode)SharedDimHierTab.this.treeModel.getRoot(), (AbstractOLAPModel)checkHierarchy)) == null || (levelNode = SharedDimHierTab.this.findNode(hierarchyNode, (AbstractOLAPModel)levelObject)) == null) continue;
                            OLAPObjectNode findMemberPropertyNode = SharedDimHierTab.this.findNode(levelNode, (AbstractOLAPModel)memproperty);
                            SharedDimHierTab.this.treeModel.removeNodeFromParent(findMemberPropertyNode);
                        }
                        ArrayList<OLAPObjectNode> levelNodes = new ArrayList<OLAPObjectNode>();
                        int size2 = memberPropertyHierarchies.size();
                        for (i = 0; i < size2; ++i) {
                            OLAPObjectNode findLevelNode;
                            OLAPHierarchy hierarchy = (OLAPHierarchy)memberPropertyHierarchies.get(i);
                            OLAPObjectNode hierarchyNode = SharedDimHierTab.this.findNode((DefaultMutableTreeNode)SharedDimHierTab.this.treeModel.getRoot(), (AbstractOLAPModel)hierarchy);
                            if (hierarchyNode == null || (findLevelNode = SharedDimHierTab.this.findNode(hierarchyNode, (AbstractOLAPModel)levelObject)) == null) continue;
                            levelNodes.add(findLevelNode);
                        }
                        size2 = levelNodes.size();
                        for (i = 0; i < size2; ++i) {
                            OLAPObjectNode node = (OLAPObjectNode)levelNodes.get(i);
                            int count = SharedDimHierTab.this.treeModel.getChildCount(node);
                            for (int t = count - 1; t > -1; --t) {
                                OLAPObjectNode nextNode = (OLAPObjectNode)SharedDimHierTab.this.treeModel.getChild(node, t);
                                SharedDimHierTab.this.treeModel.removeNodeFromParent(nextNode);
                            }
                            OLAPList listOfMemberProperties = level.getOLAPProperties();
                            SharedDimHierTab.this.sortedMemberProperty.clear();
                            SharedDimHierTab.this.sortedMemberProperty.addAll(listOfMemberProperties);
                            Collections.sort(SharedDimHierTab.this.sortedMemberProperty);
                            int sizeLevel = SharedDimHierTab.this.sortedMemberProperty.size();
                            for (int t = 0; t < sizeLevel; ++t) {
                                OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)((OLAPMemberProperty)SharedDimHierTab.this.sortedMemberProperty.get(t)));
                                memberPropertyNode.setAllowsChildren(false);
                                SharedDimHierTab.this.treeModel.insertNodeInto(memberPropertyNode, node, t);
                            }
                        }
                        SharedDimHierTab.this.tree.expandPath(selectedPath);
                        SharedDimHierTab.this.tree.setSelectionPath(selectedPath);
                        if (SharedDimHierTab.this.tree.getSelectionCount() == 0) {
                            SharedDimHierTab.this.modifyButton.setEnabled(false);
                            SharedDimHierTab.this.deleteButton.setEnabled(false);
                        }
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            }
        }
    }

    private final class MemberPropertyButtonlistener
    implements ActionListener {
        private MemberPropertyButtonlistener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            OLAPMemberPropertySet propertySet = SharedDimHierTab.this.dimensionModel.getOLAPMemberPropertySet();
            TreePath selectedPath = SharedDimHierTab.this.tree.getSelectionPath();
            OLAPObjectNode levelNode = (OLAPObjectNode)selectedPath.getLastPathComponent();
            OLAPLevel level = (OLAPLevel)levelNode.getUserObject();
            OLAPMemberProperty memproperty = null;
            try {
                memproperty = propertySet.createOLAPMemberProperty();
                WAStandardDialog m_parent = (WAStandardDialog)SharedDimHierTab.this.getTopLevelAncestor();
                CubeMemberPropertiesAddDialog memberPDialog = null;
                OLAPSharedDimension dimension = level.getOwningSharedDimension();
                OLAPList columnList = null;
                SharedDimensionTable table = dimension.getSharedDimensionTable();
                if (table != null) {
                    columnList = table.getColumns();
                }
                memberPDialog = new CubeMemberPropertiesAddDialog((Dialog)m_parent, bundle.getString("SharedDimDesigner.MemberProperty.window.title"), SharedDimHierTab.this.dimensionModel, memproperty, (List)level.getHierarchies(), (List)columnList, level);
                memberPDialog.show();
                if (memberPDialog.getReturnValue() == 1) {
                    int i;
                    OLAPLevel levelObject = (OLAPLevel)levelNode.getUserObject();
                    OLAPList memberPropertyHierarchies = memproperty.getHierarchies();
                    ArrayList<OLAPObjectNode> levelNodes = new ArrayList<OLAPObjectNode>();
                    int size = memberPropertyHierarchies.size();
                    for (i = 0; i < size; ++i) {
                        OLAPObjectNode findLevelNode;
                        OLAPHierarchy hierarchy = (OLAPHierarchy)memberPropertyHierarchies.get(i);
                        OLAPObjectNode hierarchyNode = SharedDimHierTab.this.findNode((DefaultMutableTreeNode)SharedDimHierTab.this.treeModel.getRoot(), (AbstractOLAPModel)hierarchy);
                        if (hierarchyNode == null || (findLevelNode = SharedDimHierTab.this.findNode(hierarchyNode, (AbstractOLAPModel)levelObject)) == null) continue;
                        levelNodes.add(findLevelNode);
                    }
                    size = levelNodes.size();
                    for (i = 0; i < size; ++i) {
                        OLAPObjectNode node = (OLAPObjectNode)levelNodes.get(i);
                        int count = SharedDimHierTab.this.treeModel.getChildCount(node);
                        for (int t = count - 1; t > -1; --t) {
                            OLAPObjectNode nextNode = (OLAPObjectNode)SharedDimHierTab.this.treeModel.getChild(node, t);
                            SharedDimHierTab.this.treeModel.removeNodeFromParent(nextNode);
                        }
                        OLAPList listOfMemberProperties = level.getOLAPProperties();
                        SharedDimHierTab.this.sortedMemberProperty.clear();
                        SharedDimHierTab.this.sortedMemberProperty.addAll(listOfMemberProperties);
                        Collections.sort(SharedDimHierTab.this.sortedMemberProperty);
                        int sizeLevel = SharedDimHierTab.this.sortedMemberProperty.size();
                        for (int t = 0; t < sizeLevel; ++t) {
                            OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)((OLAPMemberProperty)SharedDimHierTab.this.sortedMemberProperty.get(t)));
                            memberPropertyNode.setAllowsChildren(false);
                            SharedDimHierTab.this.treeModel.insertNodeInto(memberPropertyNode, node, t);
                        }
                    }
                    SharedDimHierTab.this.tree.expandPath(selectedPath);
                } else {
                    memproperty.delete();
                }
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
                return;
            }
        }
    }

    public class MapButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String name = SharedDimHierTab.this.dimensionModel.getName();
            SharedDimGISMapDialog dialog = new SharedDimGISMapDialog(Workspace.getWorkspace(), bundle.formatString("SharedDimDesigner.GISMaps.Title.fmt.txt", (Object)name), SharedDimHierTab.this.dimensionModel);
            dialog.show();
        }
    }

    private final class DeleteButtonListener
    implements ActionListener {
        private DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                TreePath[] selectedPath = SharedDimHierTab.this.tree.getSelectionPaths();
                int choice = 0;
                int size = selectedPath.length;
                if (size == 1) {
                    OLAPObjectNode objectNode = (OLAPObjectNode)selectedPath[0].getLastPathComponent();
                    AbstractOLAPModel object = (AbstractOLAPModel)objectNode.getUserObject();
                    String deleteTitle = null;
                    if (object instanceof OLAPHierarchy) {
                        OLAPHierarchy defaultHierarchy = SharedDimHierTab.this.dimensionModel.getDefault();
                        OLAPHierarchy hierarchy = (OLAPHierarchy)object;
                        if (hierarchy != null && !hierarchy.equals(defaultHierarchy)) {
                            deleteTitle = bundle.getString("SharedDimDesigner.DeleteHierarchy.window.title");
                        }
                    } else if (object instanceof OLAPLevel) {
                        deleteTitle = bundle.getString("SharedDimDesigner.DeleteLevel.window.title");
                    } else if (object instanceof OLAPMemberProperty) {
                        deleteTitle = bundle.getString("SharedDimDesigner.DeleteMemberProperty.window.title");
                    }
                    if (deleteTitle != null) {
                        choice = MessageUtil.displayMessage((String)bundle.formatString("SharedDimDesigner.Delete.Message.fmt.txt", (Object)object.getName()), (String)deleteTitle, (int)1, (int)0);
                    }
                } else if (size > 1) {
                    choice = MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.DeleteDimensions.txt"), (String)bundle.getString("SharedDimDesigner.Delete.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    for (int i = size - 1; i >= 0; --i) {
                        OLAPObjectNode objectNode = (OLAPObjectNode)selectedPath[i].getLastPathComponent();
                        Object object = objectNode.getUserObject();
                        if (object instanceof OLAPLevel) {
                            OLAPLevel level = (OLAPLevel)object;
                            OLAPObjectNode hierarchyNode = (OLAPObjectNode)objectNode.getParent();
                            OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchyNode.getUserObject();
                            OLAPList listOfLevels = hierarchy.getLevels();
                            if (listOfLevels.size() == 1) {
                                choice = MessageUtil.displayMessage((String)bundle.formatString("SharedDimDesigner.DimensionPanel.RemoveLastLevelInHierarchy.fmt.txt", (Object)level.getName()), (String)bundle.getString("SharedDimDesigner.DeleteLevel.window.title"), (int)1, (int)0);
                                if (choice != 0) continue;
                                SharedDimHierTab.this.treeModel.removeNodeFromParent(objectNode);
                                SharedDimHierTab.this.treeModel.removeNodeFromParent(hierarchyNode);
                                SharedDimHierTab.this.defaultHierarchyBox.removeItem((Object)hierarchy);
                                hierarchy.delete();
                                continue;
                            }
                            listOfLevels.remove((Object)level);
                            SharedDimHierTab.this.treeModel.removeNodeFromParent(objectNode);
                            continue;
                        }
                        if (object instanceof OLAPHierarchy) {
                            OLAPHierarchy hierarchy = (OLAPHierarchy)object;
                            if (hierarchy != null && hierarchy.equals(SharedDimHierTab.this.currentDefaultHierarchy)) {
                                choice = MessageUtil.displayMessage((String)bundle.formatString("SharedDimDesigner.Delete.DefaultHierarchy.fmt.txt", (Object)hierarchy.getName()), (String)bundle.getString("SharedDimDesigner.DeleteDefaultHierarchy.window.title"), (int)1, (int)0);
                                if (choice != 0) continue;
                                SharedDimHierTab.this.defaultHierarchyBox.removeItem((Object)hierarchy);
                                hierarchy.delete();
                                SharedDimHierTab.this.treeModel.removeNodeFromParent(objectNode);
                                continue;
                            }
                            SharedDimHierTab.this.defaultHierarchyBox.removeItem((Object)hierarchy);
                            hierarchy.delete();
                            SharedDimHierTab.this.treeModel.removeNodeFromParent(objectNode);
                            continue;
                        }
                        if (!(object instanceof OLAPMemberProperty)) continue;
                        OLAPMemberProperty memberProperty = (OLAPMemberProperty)object;
                        OLAPColumn levelLayer = memberProperty.getAssociatedLevel().getMapLayer();
                        if (memberProperty.getName().equalsIgnoreCase("SAS_SPATIAL_ID") && levelLayer != null) {
                            MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.MemberProperty.NoDelete.txt"), (int)0);
                            continue;
                        }
                        OLAPList memberPropertyHierarchies = memberProperty.getHierarchies();
                        ArrayList<OLAPObjectNode> memberPropertyNodes = new ArrayList<OLAPObjectNode>();
                        OLAPLevel level = memberProperty.getAssociatedLevel();
                        int sizehiers = memberPropertyHierarchies.size();
                        for (int t = 0; t < sizehiers; ++t) {
                            OLAPObjectNode findMemberNode;
                            OLAPObjectNode findLevelNode;
                            OLAPHierarchy hierarchy = (OLAPHierarchy)memberPropertyHierarchies.get(t);
                            OLAPObjectNode hierarchyNode = SharedDimHierTab.this.findNode((DefaultMutableTreeNode)SharedDimHierTab.this.treeModel.getRoot(), (AbstractOLAPModel)hierarchy);
                            if (hierarchyNode == null || (findLevelNode = SharedDimHierTab.this.findNode(hierarchyNode, (AbstractOLAPModel)level)) == null || (findMemberNode = SharedDimHierTab.this.findNode(findLevelNode, (AbstractOLAPModel)memberProperty)) == null) continue;
                            memberPropertyNodes.add(findMemberNode);
                        }
                        int sizeLevels = memberPropertyNodes.size();
                        for (int a = 0; a < sizeLevels; ++a) {
                            OLAPObjectNode node = (OLAPObjectNode)memberPropertyNodes.get(a);
                            SharedDimHierTab.this.treeModel.removeNodeFromParent(node);
                        }
                        memberProperty.delete();
                    }
                    SharedDimHierTab.this.setButtonsState();
                    OLAPList listOfhierarchies = SharedDimHierTab.this.dimensionModel.getHierarchies();
                    if (listOfhierarchies.size() == 0) {
                        SharedDimHierTab.this.parent.setFinishExportEnabled(false);
                    }
                }
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
    }

    private final class AddButtonListener
    implements ActionListener {
        private AddButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ArrayList sortHierarchy = new ArrayList();
            OLAPHierarchy hierarchy = null;
            try {
                hierarchy = SharedDimHierTab.this.dimensionModel.createOLAPHierarchy();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            SharedDimHierDetailsDialog hierdialog = new SharedDimHierDetailsDialog((Dialog)((Object)SharedDimHierTab.this.parent), bundle.getString("SharedDimDesigner.Hierarchy.Define.txt"), (OLAPDimension)SharedDimHierTab.this.dimensionModel, hierarchy);
            hierdialog.show();
            try {
                int ok = hierdialog.getReturnValue();
                if (ok == 1) {
                    SharedDimHierTab.this.defaultHierarchyBox.removeActionListener((ActionListener)SharedDimHierTab.this.defaultActionListener);
                    SharedDimHierTab.this.defaultHierarchyBox.setEnabled(true);
                    SharedDimHierTab.this.tree.removeTreeSelectionListener(SharedDimHierTab.this.hierarchySelectionListener);
                    SharedDimHierTab.this.availableHiers = SharedDimHierTab.this.dimensionModel.getHierarchies();
                    sortHierarchy.addAll(SharedDimHierTab.this.availableHiers);
                    Collections.sort(sortHierarchy);
                    int whereIsIt = sortHierarchy.indexOf(hierarchy);
                    OLAPObjectNode hierarchyNode = new OLAPObjectNode((AbstractOLAPModel)hierarchy);
                    SharedDimHierTab.this.treeModel.insertNodeInto(hierarchyNode, SharedDimHierTab.this.root, whereIsIt);
                    OLAPList levels = hierarchy.getLevels();
                    for (int k = 0; k < levels.size(); ++k) {
                        OLAPLevel level = (OLAPLevel)levels.get(k);
                        OLAPObjectNode levelNode = new OLAPObjectNode((AbstractOLAPModel)level);
                        hierarchyNode.add(levelNode);
                        levelNode.setParent(hierarchyNode);
                        OLAPList memberProperties = level.getOLAPProperties();
                        SharedDimHierTab.this.sortedMemberProperty.clear();
                        SharedDimHierTab.this.sortedMemberProperty.addAll(memberProperties);
                        Collections.sort(SharedDimHierTab.this.sortedMemberProperty);
                        int sizeMP = SharedDimHierTab.this.sortedMemberProperty.size();
                        for (int t = 0; t < sizeMP; ++t) {
                            OLAPMemberProperty member = (OLAPMemberProperty)SharedDimHierTab.this.sortedMemberProperty.get(t);
                            OLAPList listOfMPHierarchies = member.getHierarchies();
                            if (!listOfMPHierarchies.contains(hierarchy)) continue;
                            OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)member);
                            memberPropertyNode.setAllowsChildren(false);
                            SharedDimHierTab.this.treeModel.insertNodeInto(memberPropertyNode, levelNode, levelNode.getChildCount());
                            memberPropertyNode.setParent(levelNode);
                        }
                    }
                    SharedDimHierTab.this.treeModel.reload(hierarchyNode);
                    SharedDimHierTab.this.expandAll(SharedDimHierTab.this.tree, new TreePath(hierarchyNode.getPath()));
                    SharedDimHierTab.this.defaultHierarchyBox.removeAllItems();
                    SharedDimHierTab.this.defaultHierarchyBox.addItems((List)SharedDimHierTab.this.availableHiers);
                    if (SharedDimHierTab.this.currentDefaultHierarchy == null) {
                        SharedDimHierTab.this.defaultHierarchyBox.setSelectedItem((Object)hierarchy);
                        SharedDimHierTab.this.currentDefaultHierarchy = hierarchy;
                    } else {
                        SharedDimHierTab.this.defaultHierarchyBox.setSelectedItem((Object)SharedDimHierTab.this.currentDefaultHierarchy);
                    }
                    SharedDimHierTab.this.defaultHierarchyBox.addActionListener((ActionListener)SharedDimHierTab.this.defaultActionListener);
                    SharedDimHierTab.this.tree.addTreeSelectionListener(SharedDimHierTab.this.hierarchySelectionListener);
                    SharedDimHierTab.this.parent.setFinishExportEnabled(true);
                } else {
                    hierarchy.delete();
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
    }

    private class DefaultBoxActionListener
    implements ActionListener {
        private DefaultBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (SharedDimHierTab.this.defaultHierarchyBox.getSelectedItem() != SharedDimHierTab.this.blank) {
                OLAPHierarchy newDefault = (OLAPHierarchy)SharedDimHierTab.this.defaultHierarchyBox.getSelectedItem();
                if (newDefault != null && !newDefault.equals(SharedDimHierTab.this.currentDefaultHierarchy)) {
                    SharedDimHierTab.this.dimensionModel.setDefault(newDefault);
                    SharedDimHierTab.this.currentDefaultHierarchy = newDefault;
                }
            } else if (SharedDimHierTab.this.currentDefaultHierarchy != null) {
                SharedDimHierTab.this.defaultHierarchyBox.setSelectedItem((Object)SharedDimHierTab.this.currentDefaultHierarchy);
            }
        }
    }

    class HierarchySelectionListener
    implements TreeSelectionListener {
        HierarchySelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            SharedDimHierTab.this.setButtonsState();
        }
    }
}

