/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.shareddims.visuals;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.shareddims.visuals.SharedDimDesigner;
import com.sas.olapadmin.shareddims.visuals.SharedDimGeneralAdvancedDialog;
import com.sas.olapadmin.shareddims.visuals.SharedDimSelectTableDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.olapadmin.utilities.studio.ChangeOLAPSchemaPanel;
import com.sas.olapadmin.utilities.studio.OLAPSchemaNewButton;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class SharedDimGeneralTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(SharedDimGeneralTab.class);
    private JButton advanced;
    private WATextField inp_dimtable;
    private JButton selectTable;
    private WAComboBox inp_dimkey;
    private WATextField inp_dimName;
    private WATextField inp_dimdescription;
    private WAComboBox inp_dimtype;
    private WAComboBox inp_dimsortorder;
    private WATextArea inp_dimnotes;
    private JCheckBox update;
    private JScrollPane ScrollNotes;
    private OLAPSharedDimension dimensionModel;
    private boolean initialized;
    private List dimColumns;
    private SharedDimensionTable selectedTable;
    private String modifyname;
    private boolean modifyMode;
    private OLAPColumn dimensionKey;
    private DimensionSet dimensionSet;
    private TableSet tableSet;
    private OLAPColumn backUpDimensionKey;
    private String backUpDimTableName;
    private ChangeOLAPSchemaPanel olapSchemas;
    private Vector dimPaths;
    private WAComboBox inputDimensionPath;
    private JButton browse;
    private WATextField repositoryFolder;
    private JButton browseFolder;
    private Tree folder;
    private OLAPSchema originalSchema;
    private Tree originalFolder;
    private OLAPSchemaNewButton olapSchemaNewButton;

    public SharedDimGeneralTab(OLAPSharedDimension inDimension) {
        super(bundle.getString("SharedDimDesigner.Top.txt"));
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("shared_dim_general");
        this.dimensionModel = inDimension;
        this.dimensionSet = this.dimensionModel.getDimensionSet();
        this.tableSet = this.dimensionModel.getTableSet();
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            if (!this.initialized) {
                this.initialize();
            }
        } else {
            String description_input = this.inp_dimdescription.getText();
            String dimName = this.dimensionModel.getName();
            if (ModelUtilities.isBlank((String)description_input)) {
                this.dimensionModel.setDesc(dimName);
            } else if (this.modifyMode && description_input.equals(this.modifyname)) {
                this.dimensionModel.setDesc(dimName);
            } else {
                this.dimensionModel.setDesc(description_input);
            }
            this.dimensionModel.setNotes(this.inp_dimnotes.getText());
            try {
                if (!this.update.isSelected()) {
                    this.dimensionModel.setUpdateable("1");
                } else {
                    this.dimensionModel.setUpdateable("0");
                }
            }
            catch (OLAPException oError) {
                return ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        return true;
    }

    public String createFinishString() {
        String infoString = null;
        try {
            infoString = this.dimensionModel.generateCodeLongForm().toString();
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        return infoString;
    }

    protected void initialize() {
        try {
            this.tableSet.addToMetadataListener();
            this.inp_dimtype.addItem((Object)"STANDARD");
            this.inp_dimtype.addItem((Object)"GEO");
            this.inp_dimtype.addItem((Object)"TIME");
            this.inp_dimtype.addActionListener((ActionListener)new DimensionTypeListener());
            this.inp_dimsortorder.addItem((Object)bundle.getString("SharedDimDesigner.General.dimsortascending.txt"));
            this.inp_dimsortorder.addItem((Object)bundle.getString("SharedDimDesigner.General.dimsortdescending.txt"));
            this.inp_dimsortorder.addItem((Object)bundle.getString("SharedDimDesigner.General.dimsortascformatted.txt"));
            this.inp_dimsortorder.addItem((Object)bundle.getString("SharedDimDesigner.General.dimsortdescformatted.txt"));
            this.inp_dimsortorder.addItem((Object)bundle.getString("SharedDimDesigner.General.dimsortdsorder.txt"));
            AdvancedListener advanceButton = new AdvancedListener();
            this.advanced.addActionListener(advanceButton);
            String updateable = this.dimensionModel.getUpdateable();
            if (updateable == null || updateable.equals("0")) {
                this.update.setSelected(true);
            } else {
                this.update.setSelected(false);
            }
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            this.modifyname = this.dimensionModel.getName();
            parent.addWizardData("ORIGINALDIMNAME", (Object)this.modifyname);
            if (!this.dimensionModel.isNewObject()) {
                String dimPath;
                this.modifyMode = true;
                this.inp_dimName.setText(this.modifyname);
                this.inp_dimtype.setSelectedItem((Object)this.dimensionModel.getType());
                this.inp_dimsortorder.setSelectedIndex(this.dimensionSet.getDisplaySort(this.dimensionModel.getSortOrder()));
                this.inp_dimdescription.setText(this.dimensionModel.getDesc());
                this.inp_dimnotes.setText(this.dimensionModel.getNotes());
                SharedDimensionTable dimensionTable = this.dimensionModel.getSharedDimensionTable();
                if (dimensionTable != null) {
                    String nameOfTable;
                    this.selectedTable = dimensionTable;
                    this.backUpDimTableName = nameOfTable = ModelUtilities.generateTableName((PhysicalTable)dimensionTable.getTable());
                    this.inp_dimtable.setText(nameOfTable);
                    this.backUpDimensionKey = this.dimensionKey = this.dimensionModel.getDimensionKey();
                    this.dimColumns = dimensionTable.getColumns();
                    int size = this.dimColumns.size();
                    for (int t = 0; t < size; ++t) {
                        this.inp_dimkey.addItem(this.dimColumns.get(t));
                    }
                    if (this.dimensionKey != null) {
                        this.inp_dimkey.setSelectedItem((Object)this.dimensionKey);
                    }
                }
                this.inp_dimkey.setEnabled(true);
                this.inp_dimtable.setEnabled(true);
                String uniqueName = this.dimensionModel.getUniqueName();
                if (!ModelUtilities.isBlank((String)uniqueName)) {
                    this.inputDimensionPath.setEnabled(false);
                    this.browse.setEnabled(false);
                }
                this.folder = this.dimensionModel.getFolder();
                if (this.originalFolder == null) {
                    this.originalFolder = this.folder;
                }
                if (this.folder != null) {
                    MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                    String pathURL = mdUtil.getObjectPath((MdObjectStore)this.folder.getObjectStore(), (PrimaryType)this.folder, false);
                    this.repositoryFolder.setText(pathURL);
                }
                if (this.originalSchema == null) {
                    this.originalSchema = this.dimensionModel.getAssociatedOLAPSchema();
                }
                if (this.originalSchema != null && !ModelUtilities.canWrite((String)"OLAPSchema", (CMetadata)this.originalSchema)) {
                    this.olapSchemas.setEnabled(false);
                    this.olapSchemaNewButton.setEnabled(false);
                }
                if ((dimPath = this.dimensionModel.getPath()) != null && !this.dimPaths.contains(dimPath)) {
                    this.dimPaths.add(0, dimPath);
                    if (this.dimPaths.size() > 5) {
                        this.dimPaths.remove(5);
                    }
                }
                this.inputDimensionPath.setSelectedItem((Object)dimPath);
            } else {
                this.folder = (Tree)parent.getWizardData("GROUP");
                if (this.folder == null) {
                    try {
                        this.folder = ModelUtilities.getDefaultFolder((OLAPSchema)this.dimensionModel.getAssociatedOLAPSchema(), (MdObjectStore)this.dimensionModel.getObjectStore());
                    }
                    catch (OLAPException e) {
                        this.folder = null;
                    }
                }
                if (this.folder != null) {
                    try {
                        MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                        String pathURL = mdUtil.getObjectPath((MdObjectStore)this.folder.getObjectStore(), (PrimaryType)this.folder, false);
                        this.repositoryFolder.setText(pathURL);
                    }
                    catch (MdException mdError) {
                        ExceptionHandler.handleException((Exception)((Object)mdError));
                    }
                    catch (RemoteException re) {
                        ExceptionHandler.handleException((Exception)re);
                    }
                }
                if (!this.dimPaths.isEmpty()) {
                    this.inputDimensionPath.setSelectedItem(this.dimPaths.get(0));
                }
            }
            this.browseFolder.addActionListener(new SelectFolderButtonsListener());
            this.selectTable.addActionListener(new SelectTableListener());
            this.browse.addActionListener(new BrowseButtonListener());
            this.initialized = true;
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        catch (MdException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (OLAPException OLAPError) {
            ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
    }

    protected void layoutWidgets() {
        JLabel label_dimName = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(label_dimName, bundle.getString("SharedDimDesigner.General.name.control.label"));
        this.inp_dimName = new WATextField(15);
        this.inp_dimName.setMaxCharacters(60);
        label_dimName.setName("DimensionNameLabel");
        this.inp_dimName.setName("DimensionName");
        this.inp_dimName.setToolTipText(bundle.getString("SharedDimDesigner.General.ToolTip.name.tip"));
        JLabel label_dimdescription = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(label_dimdescription, bundle.getString("SharedDimDesigner.General.caption.control.label"));
        this.inp_dimdescription = new WATextField(15);
        this.inp_dimdescription.setMaxCharacters(256);
        this.inp_dimdescription.setToolTipText(bundle.getString("SharedDimDesigner.General.ToolTip.caption.tip"));
        label_dimdescription.setName("DimensionDescriptionLabel");
        this.inp_dimdescription.setName("DimensionDescription");
        this.inp_dimdescription.setPreferredSize(new Dimension(65, 20));
        JLabel label_dimnotes = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(label_dimnotes, bundle.getString("SharedDimDesigner.General.description.control.label"));
        this.inp_dimnotes = new WATextArea(2, 1);
        this.inp_dimnotes.setLineWrap(true);
        this.inp_dimnotes.setWrapStyleWord(true);
        this.ScrollNotes = new JScrollPane((Component)this.inp_dimnotes);
        this.inp_dimnotes.setToolTipText(bundle.getString("SharedDimDesigner.General.ToolTip.description.tip"));
        label_dimnotes.setName("DimensionNotesLabel");
        ArrayList<OLAPSharedDimension> dims = new ArrayList<OLAPSharedDimension>();
        dims.add(this.dimensionModel);
        this.olapSchemas = new ChangeOLAPSchemaPanel(dims.toArray());
        JLabel olapschemaLabel = new JLabel();
        olapschemaLabel.setName("dimOlapschemaLabel");
        olapschemaLabel.setLabelFor((Component)((Object)this.olapSchemas));
        VisualUtilities.setLabelTextAndMnemonic(olapschemaLabel, bundle.getString("SharedDimDesigner.General.OLAPSchema.control.label"));
        this.olapSchemaNewButton = new OLAPSchemaNewButton(this.olapSchemas, (AbstractOLAPModel)this.dimensionModel);
        JLabel labelFolder = new JLabel();
        this.repositoryFolder = new WATextField();
        this.repositoryFolder.setPreferredSize(new Dimension(0, this.repositoryFolder.getPreferredSize().height));
        this.repositoryFolder.setBehavior(2);
        this.repositoryFolder.setName("dimRepositoryFolder");
        this.repositoryFolder.setToolTipText(bundle.getString("SharedDimDesigner.General.FolderLocation.tip"));
        labelFolder.setName("dimRepositoryFolder");
        labelFolder.setLabelFor((Component)this.repositoryFolder);
        VisualUtilities.setLabelTextAndMnemonic(labelFolder, bundle.getString("SharedDimDesigner.General.Location.control.label"));
        this.browseFolder = new JButton();
        this.browseFolder.setName("newshareddimrepositoryfolder");
        VisualUtilities.setButtonTextAndMnemonic(this.browseFolder, bundle.getString("SharedDimDesigner.General.SelectLocation.control.label"));
        this.browseFolder.setToolTipText(bundle.getString("SharedDimDesigner.General.browseToolTip.tip"));
        JLabel labelDimensionPath = new JLabel();
        this.dimPaths = VisualUtilities.getSharedDimPaths();
        this.inputDimensionPath = new WAComboBox(this.dimPaths.toArray());
        this.inputDimensionPath.setName("cubePathField");
        labelDimensionPath.setName("cubePathLabel");
        labelDimensionPath.setLabelFor((Component)this.inputDimensionPath);
        this.inputDimensionPath.setToolTipText(bundle.getString("SharedDimDesigner.General.PhysicalPath.tip"));
        VisualUtilities.setLabelTextAndMnemonic(labelDimensionPath, bundle.getString("SharedDimDesigner.General.PhyscialPath.control.label"));
        this.browse = new JButton();
        this.browse.setName("browseButton");
        VisualUtilities.setButtonTextAndMnemonic(this.browse, bundle.getString("SharedDimDesigner.General.browsePath.control.label"));
        this.browse.setToolTipText(bundle.getString("SharedDimDesigner.General.browseToolTip.tip"));
        this.inputDimensionPath.setEditable(true);
        JLabel label_dimtype = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(label_dimtype, bundle.getString("SharedDimDesigner.General.type.control.label"));
        this.inp_dimtype = new WAComboBox();
        this.inp_dimtype.setToolTipText(bundle.getString("SharedDimDesigner.General.ToolTip.type.tip"));
        label_dimtype.setName("DimensionTypeLabel");
        this.inp_dimtype.setName("DimensionType");
        JLabel label_dimsortorder = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(label_dimsortorder, bundle.getString("SharedDimDesigner.General.sortorder.control.label"));
        this.inp_dimsortorder = new WAComboBox();
        this.inp_dimsortorder.setToolTipText(bundle.getString("SharedDimDesigner.General.ToolTip.sort.tip"));
        label_dimsortorder.setName("DimensionSortOrderLabel");
        this.inp_dimsortorder.setName("DimensionSortOrder");
        label_dimName.setLabelFor((Component)this.inp_dimName);
        label_dimdescription.setLabelFor((Component)this.inp_dimdescription);
        label_dimnotes.setLabelFor((Component)this.inp_dimnotes);
        label_dimtype.setLabelFor((Component)this.inp_dimtype);
        label_dimsortorder.setLabelFor((Component)this.inp_dimsortorder);
        this.advanced = new JButton();
        this.advanced.setName("GeneralAdvanced");
        this.advanced.setToolTipText(bundle.getString("SharedDimDesigner.General.Advanced.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.advanced, bundle.getString("SharedDimDesigner.General.Advanced.control.label"));
        this.update = new JCheckBox();
        this.update.setName("SharedDimGeneralNoUpdate");
        VisualUtilities.setButtonTextAndMnemonic(this.update, bundle.getString("SharedDimDesigner.General.allowUpdate.checkbox.label"));
        WAPanel generalPanel = new WAPanel();
        generalPanel.setLayout((LayoutManager)new GridBagLayout());
        generalPanel.add((Component)label_dimName, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)this.inp_dimName, (Object)new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)label_dimdescription, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)this.inp_dimdescription, (Object)new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)label_dimnotes, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)this.ScrollNotes, (Object)new GridBagConstraints(1, 2, 3, 2, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)label_dimtype, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)this.inp_dimtype, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)label_dimsortorder, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)this.inp_dimsortorder, (Object)new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        generalPanel.add((Component)this.update, (Object)new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)generalPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        WAPanel locationPanel = new WAPanel();
        locationPanel.setLayout((LayoutManager)new GridBagLayout());
        TitledBorder titledBorder1 = new TitledBorder("");
        locationPanel.setBorder((Border)titledBorder1);
        locationPanel.add((Component)olapschemaLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        locationPanel.add((Component)((Object)this.olapSchemas), (Object)new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        locationPanel.add((Component)this.olapSchemaNewButton, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        locationPanel.add((Component)labelFolder, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        locationPanel.add((Component)this.repositoryFolder, (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        locationPanel.add((Component)this.browseFolder, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        locationPanel.add((Component)labelDimensionPath, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        locationPanel.add((Component)this.inputDimensionPath, (Object)new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        locationPanel.add((Component)this.browse, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)locationPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        WAPanel tablePanel = new WAPanel();
        tablePanel.setLayout((LayoutManager)new GridBagLayout());
        tablePanel.setBorder((Border)titledBorder1);
        JLabel dimensionTableLabel = new JLabel();
        dimensionTableLabel.setName("dimensiontablelabel");
        this.inp_dimtable = new WATextField();
        this.inp_dimtable.setBehavior(2);
        this.inp_dimtable.setName("dimensionTable");
        dimensionTableLabel.setLabelFor((Component)this.inp_dimtable);
        VisualUtilities.setLabelTextAndMnemonic(dimensionTableLabel, bundle.getString("SharedDimDesigner.General.table.control.label"));
        this.inp_dimtable.setToolTipText(bundle.getString("SharedDimDesigner.General.ToolTip.dimtable.tip"));
        JLabel label_dimkey = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(label_dimkey, bundle.getString("SharedDimDesigner.General.key.control.label"));
        this.inp_dimkey = new WAComboBox();
        this.inp_dimkey.setPreferredSize(new Dimension(65, 20));
        label_dimkey.setName("DimensionKeyLabel");
        this.inp_dimkey.setName("DimensionKey");
        this.inp_dimkey.setToolTipText(bundle.getString("SharedDimDesigner.General.ToolTip.dimkey.tip"));
        label_dimkey.setLabelFor((Component)this.inp_dimkey);
        this.selectTable = new JButton();
        this.selectTable.setName("selectTable");
        VisualUtilities.setButtonTextAndMnemonic(this.selectTable, bundle.getString("SharedDimDesigner.General.SelectTable.control.label"));
        this.selectTable.setToolTipText(bundle.getString("SharedDimDesigner.General.SelectDimTable.tip"));
        tablePanel.add((Component)dimensionTableLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        tablePanel.add((Component)this.inp_dimtable, (Object)new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        tablePanel.add((Component)this.selectTable, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        tablePanel.add((Component)label_dimkey, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        tablePanel.add((Component)this.inp_dimkey, (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)tablePanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.advanced, new GridBagConstraints(2, 11, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 0, 5), 0, 0));
    }

    public boolean validateData() {
        OLAPSchema newSchema;
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        try {
            if (this.folder != null && this.folder != this.originalFolder) {
                this.dimensionModel.setFolder(this.folder);
                this.dimensionModel.verifyFolder();
            }
            if (this.folder == null) {
                this.folder = this.dimensionModel.getFolder();
                if (this.folder != null) {
                    try {
                        MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                        String pathURL = mdUtil.getObjectPath((MdObjectStore)this.folder.getObjectStore(), (PrimaryType)this.folder, false);
                        this.repositoryFolder.setText(pathURL);
                    }
                    catch (MdException mdError) {
                        ExceptionHandler.handleException((Exception)((Object)mdError));
                    }
                    catch (RemoteException re) {
                        ExceptionHandler.handleException((Exception)re);
                    }
                }
            }
        }
        catch (OLAPException error) {
            return ExceptionHandler.handleException((Exception)((Object)error));
        }
        boolean changedSchema = (newSchema = this.olapSchemas.getSelectedOLAPSchema()) != this.originalSchema;
        try {
            if (changedSchema) {
                this.dimensionModel.setAssociatedOLAPSchema(newSchema);
                this.dimensionModel.verifyOLAPSchema();
            }
        }
        catch (OLAPException error) {
            if (this.originalSchema != null) {
                this.dimensionModel.setAssociatedOLAPSchema(this.originalSchema);
            }
            return ExceptionHandler.handleException((Exception)((Object)error));
        }
        String dimName = this.inp_dimName.getText().trim();
        this.dimensionModel.setName(dimName);
        try {
            this.dimensionModel.verifyName();
        }
        catch (OLAPException OLAPError) {
            if (this.modifyname != null) {
                this.dimensionModel.setName(this.modifyname);
            }
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        String originalPath = null;
        try {
            originalPath = this.dimensionModel.getPath();
            this.dimensionModel.setPath((String)this.inputDimensionPath.getSelectedItem());
            this.dimensionModel.verifyPath();
        }
        catch (OLAPException error) {
            this.dimensionModel.setPath(originalPath);
            return ExceptionHandler.handleException((Exception)((Object)error));
        }
        String procSort = this.dimensionSet.getProcSort(this.inp_dimsortorder.getSelectedIndex());
        this.dimensionModel.setSortOrder(procSort);
        Object dimensionKey = this.inp_dimkey.getSelectedItem();
        if (dimensionKey instanceof OLAPColumn) {
            this.dimensionModel.setDimensionKey((OLAPColumn)dimensionKey);
        }
        try {
            this.dimensionModel.verifyStarSchemaTable();
            this.dimensionModel.verifyStarSchemaKey();
        }
        catch (OLAPException OLAPError) {
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        String type_input = (String)this.inp_dimtype.getSelectedItem();
        if (!type_input.equals(this.dimensionModel.getType())) {
            this.dimensionModel.setType(type_input);
        }
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.addWizardData("DIMENSIONNAME", (Object)this.dimensionModel.getName());
        return true;
    }

    private class DimensionTypeListener
    implements ActionListener {
        private DimensionTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SharedDimGeneralTab.this.dimensionModel.setType(SharedDimGeneralTab.this.inp_dimtype.getSelectedItem().toString());
        }
    }

    private class AdvancedListener
    implements ActionListener {
        private AdvancedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SharedDimGeneralAdvancedDialog advancedDialog = new SharedDimGeneralAdvancedDialog(SharedDimGeneralTab.this.dimensionModel);
            advancedDialog.show();
        }
    }

    private class BrowseButtonListener
    implements ActionListener {
        private BrowseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                boolean dimPath = event.getSource().equals(SharedDimGeneralTab.this.browse);
                WAWizardDialog parent = (WAWizardDialog)SharedDimGeneralTab.this.getTopLevelAncestor();
                parent.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer appserver = WsRunCode.getServer();
                if (appserver != null) {
                    try {
                        appserver.openSASCodeSession();
                    }
                    catch (WsAppServerFailException e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                    String windowTitle = bundle.getString("SharedDimDesigner.BrowsePath.window.title");
                    String path = "";
                    parent.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        String inpath = SharedDimGeneralTab.this.inputDimensionPath.getText();
                        if (!Utilities.isBlank((String)inpath) && !inpath.endsWith("/")) {
                            inpath = inpath + "/";
                        }
                        path = appserver.promptForDirectory(windowTitle, inpath, null, false);
                    }
                    catch (GenericError e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                    catch (WsAppServerFailException e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                    if (!Utilities.isBlank((String)path)) {
                        SharedDimGeneralTab.this.inputDimensionPath.setSelectedItem((Object)path);
                    }
                    appserver.closeSASCodeSession();
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.General.NoBrowse.txt"));
                }
            }
        }
    }

    private class SelectTableListener
    implements ActionListener {
        private SelectTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                try {
                    SharedDimDesigner parent = (SharedDimDesigner)((Object)SharedDimGeneralTab.this.getTopLevelAncestor());
                    SharedDimSelectTableDialog browseDialog = new SharedDimSelectTableDialog((Dialog)((Object)parent), bundle.getString("SharedDimSelectTable.DimensionTables.top.txt"), SharedDimGeneralTab.this.dimensionModel);
                    browseDialog.setResizable(true);
                    browseDialog.show();
                    if (browseDialog.getReturnValue() == 1) {
                        SharedDimGeneralTab.this.selectedTable = SharedDimGeneralTab.this.dimensionModel.getSharedDimensionTable();
                        String selectedTableName = ModelUtilities.generateTableName((PhysicalTable)SharedDimGeneralTab.this.selectedTable.getTable());
                        SharedDimGeneralTab.this.inp_dimtable.setText(selectedTableName);
                        OLAPColumn column = SharedDimGeneralTab.this.dimensionModel.getDimensionKey();
                        if (SharedDimGeneralTab.this.backUpDimTableName == null || !SharedDimGeneralTab.this.backUpDimTableName.equals(selectedTableName)) {
                            parent.addWizardData("TABLECHANGED", "YES");
                            OLAPColumn newColumn = null;
                            if (column != null) {
                                newColumn = SharedDimGeneralTab.this.selectedTable.getColumn(column.getSASColumnName());
                            }
                            SharedDimGeneralTab.this.inp_dimkey.removeAllItems();
                            SharedDimGeneralTab.this.dimColumns = (List)SharedDimGeneralTab.this.selectedTable.getColumns();
                            SharedDimGeneralTab.this.inp_dimkey.addItem((Object)" ");
                            int size = SharedDimGeneralTab.this.dimColumns.size();
                            for (int i = 0; i < size; ++i) {
                                SharedDimGeneralTab.this.inp_dimkey.addItem(SharedDimGeneralTab.this.dimColumns.get(i));
                            }
                            if (newColumn == null) {
                                SharedDimGeneralTab.this.inp_dimkey.setSelectedIndex(0);
                                SharedDimGeneralTab.this.dimensionModel.setDimensionKey(null);
                            } else {
                                SharedDimGeneralTab.this.dimensionModel.setDimensionKey(newColumn);
                                SharedDimGeneralTab.this.inp_dimkey.setSelectedItem((Object)newColumn);
                            }
                            parent.addWizardData("ORIGINALTABLEDELETED", "YES");
                            SharedDimGeneralTab.this.backUpDimTableName = selectedTableName;
                            if (SharedDimGeneralTab.this.dimensionModel.getLevels().size() < 1) {
                                parent.setFinishExportEnabled(false);
                            }
                        } else {
                            parent.addWizardData("ORIGINALTABLEDELETED", "NO");
                        }
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            }
        }
    }

    private class SelectFolderButtonsListener
    implements ActionListener {
        private SelectFolderButtonsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                try {
                    PathUrl pathUrl;
                    ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                    String sPathWithType = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)SharedDimGeneralTab.this.folder.getObjectStore(), (PrimaryType)SharedDimGeneralTab.this.folder, true);
                    PathUrl m_pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)sPathWithType);
                    SimpleObjectImpl oSimple = null;
                    if (SharedDimGeneralTab.this.dimensionModel != null && !SharedDimGeneralTab.this.dimensionModel.isNewObject()) {
                        oSimple = new SimpleObjectImpl(SharedDimGeneralTab.this.modifyname, SharedDimGeneralTab.this.dimensionModel.getFQID(), "SharedDimension", "SharedDimension");
                    }
                    SimpleObject[] aObjects = null;
                    if (oSimple != null) {
                        aObjects = new SimpleObject[]{oSimple};
                    }
                    String sInitialPath = null;
                    if (m_pathUrl != null) {
                        sInitialPath = m_pathUrl.toString();
                    }
                    if ((pathUrl = WsMetadataUtil.promptForPathUrl((String)sInitialPath, (boolean)false, (SimpleObject[])aObjects)) != null) {
                        MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), pathUrl);
                        SharedDimGeneralTab.this.folder = (Tree)metadataObject.getRepositoryEntity();
                        MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                        if (SharedDimGeneralTab.this.folder != null) {
                            String pathFolder = mdUtil.getObjectPath((MdObjectStore)SharedDimGeneralTab.this.folder.getObjectStore(), (PrimaryType)SharedDimGeneralTab.this.folder, false);
                            SharedDimGeneralTab.this.repositoryFolder.setText(pathFolder);
                        }
                    }
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
                catch (MdException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
                catch (ServiceException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        }
    }
}

