/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.shareddims.visuals;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.OLAPDualListSelector;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.ListModel;

public class SharedDimGeneralLanguageTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(SharedDimGeneralLanguageTab.class);
    protected OLAPSharedDimension dimension;
    protected OLAPDualListSelector listbox;
    protected CollectionToListModelAdapter availModel;
    protected DefaultListModel selectModel;
    protected LanguageSet languageModel;
    protected Properties listOfCountries;
    protected List userSelectedCountries;
    protected boolean saveToCubeModel;
    protected String originalLocale;
    protected TableSet tableSet;
    private List currentLanguages;

    public SharedDimGeneralLanguageTab(OLAPSharedDimension inDimension) {
        this.dimension = inDimension;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cd_general_translation");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.tableSet = this.dimension.getTableSet();
            this.currentLanguages = new ArrayList();
            try {
                String countryName;
                this.languageModel = this.dimension.getLanguageSet();
                this.userSelectedCountries = this.languageModel.getSelectedLocales();
                this.listOfCountries = this.languageModel.getCountries();
                TreeSet<String> available = new TreeSet<String>((Comparator<String>)SASCollatorFactory.createCollator());
                for (String string : this.listOfCountries.keySet()) {
                    countryName = this.listOfCountries.getProperty(string.toUpperCase());
                    available.add(countryName);
                }
                if (this.userSelectedCountries != null) {
                    for (int i = 0; i < this.userSelectedCountries.size(); ++i) {
                        String string = (String)this.userSelectedCountries.get(i);
                        countryName = this.listOfCountries.getProperty(string.toUpperCase());
                        this.currentLanguages.add(countryName);
                        this.selectModel.addElement(countryName);
                        available.remove(countryName);
                    }
                }
                this.availModel.setModel(available);
                this.listbox.setModel((ListModel)this.availModel);
                this.listbox.setTargetModel(this.selectModel);
                if (this.selectModel.size() > 0) {
                    this.originalLocale = (String)this.selectModel.elementAt(0);
                }
                this.saveToCubeModel = true;
            }
            catch (OLAPException e) {
                return ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return true;
    }

    public void saveDataToModel() {
        if (this.saveToCubeModel) {
            if (this.userSelectedCountries != null) {
                this.userSelectedCountries.clear();
            }
            for (int t = 0; t < this.selectModel.size(); ++t) {
                String countryName = (String)this.selectModel.elementAt(t);
                String countryCode = this.languageModel.getLocale(countryName);
                this.userSelectedCountries.add(countryCode);
            }
        }
    }

    public void _layoutWidgets() {
        WATextArea m_instructions = new WATextArea();
        JLabel l = new JLabel();
        m_instructions.setFont(l.getFont());
        m_instructions.setColumns(30);
        m_instructions.setText(bundle.getString("SharedDimDesigner.TranslationPanel.instructions.txt"));
        m_instructions.setBehavior(1);
        m_instructions.setBackground((Color)SystemColor.control);
        m_instructions.setAutosize(true);
        this.add((Component)m_instructions, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.listbox = new OLAPDualListSelector(bundle.getString("SharedDimDesigner.DeleteLanguage.window.title"), bundle.getString("SharedDimDesigner.DeleteLanguages.window.title"), bundle.getString("SharedDimDesigner.DeleteLanguages.txt"), bundle.getString("SharedDimDesigner.DeleteAllLanguages.txt"));
        this.availModel = new CollectionToListModelAdapter();
        this.selectModel = new DefaultListModel();
        VisualUtilities.setDualSelectorTextAndMnemonic((BaseDualSelector)this.listbox, bundle.getString("SharedDimDesigner.DualListbox.leftlistbox.txt"), bundle.getString("SharedDimDesigner.DualListbox.rightlistbox.txt"));
        this.listbox.setCopyModeDuplicatesAllowed(false);
        this.listbox.setTargetControlsVisible(true);
        this.listbox.setTransferAllControlsVisible(true);
        this.listbox.setAlternatingMultipleButtonStyle(true);
        this.listbox.setDragAndDropEnabled(false);
        this.listbox.setToolTipText(bundle.getString("SharedDimDesigner.TranslationPanel.ToolTip.tip"));
        this.listbox.setName("TranslationListbox");
        this.add((Component)((Object)this.listbox), new GridBagConstraints(0, 1, 3, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        TreeSet available = (TreeSet)this.availModel.getModel();
        if (this.selectModel.size() == 1) {
            MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.TranslationPanel.OneLanguageSelected.txt"), (int)2);
            return false;
        }
        if (this.originalLocale != null && !this.selectModel.isEmpty()) {
            int option;
            if (available.contains(this.originalLocale) || this.selectModel.indexOf(this.originalLocale) != 0) {
                if (!this.dimension.isNewObject()) {
                    String errorMessage = bundle.formatString("SharedDimDesigner.General.Advanced.DefaultLocale.Edit.fmt", (Object)this.originalLocale);
                    MessageUtil.displayMessage((String)errorMessage);
                    return false;
                }
                String errorMessage = bundle.formatString("SharedDimDesigner.General.Advanced.DefaultLocale.Create.fmt", (Object)this.originalLocale);
                MessageUtil.displayMessage((String)errorMessage, (int)2, (int)2);
            } else if (this.originalLocale == null && !this.selectModel.isEmpty() && !this.dimension.isNewObject() && (option = MessageUtil.displayMessage((String)bundle.getString(""), (int)2, (int)0)) == 1) {
                return false;
            }
        }
        this.currentLanguages.clear();
        for (int t = 0; t < this.selectModel.size(); ++t) {
            String countryName = (String)this.selectModel.elementAt(t);
            this.currentLanguages.add(countryName);
        }
        return true;
    }

    public void onCancel() {
        if (this.userSelectedCountries == null || this.userSelectedCountries.size() < 1) {
            this.languageModel = null;
        }
    }
}

