/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.properties;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TableCollection;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.MLSCaptionTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.properties.StructureTableModel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.StructureTreeCellRenderer;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class StructurePanel
extends WAPanel
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(StructurePanel.class);
    private JTree tree;
    private JScrollPane blankpropView;
    private JSplitPane treePropPane;
    private OLAPCube olapCube;
    private WsTable propertiesTable;
    private StructureTableModel propertiesModel;
    private List namesList;
    private List valuesList;
    private JScrollPane propertiesView;
    private boolean initialized;

    public StructurePanel(OLAPCube inCube) {
        this.olapCube = inCube;
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel && !this.initialized) {
            this.initialized = true;
            this.createNodes();
            this.tree.expandRow(0);
            TreePath tp1 = this.tree.getPathForRow(1);
            TreePath tp2 = this.tree.getPathForRow(2);
            TreePath tp3 = this.tree.getPathForRow(3);
            TreePath tp4 = this.tree.getPathForRow(4);
            TreePath tp5 = this.tree.getPathForRow(5);
            this.tree.expandPath(tp1);
            this.tree.expandPath(tp2);
            this.tree.expandPath(tp3);
            this.tree.expandPath(tp4);
            this.tree.expandPath(tp5);
            this.tree.addTreeSelectionListener(new StructureTreeSelectionListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.namesList = new ArrayList();
            this.valuesList = new ArrayList();
        }
        return true;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.tree = new JTree(new DefaultMutableTreeNode(this.olapCube));
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new StructureTreeCellRenderer());
        this.tree.addFocusListener(this);
        this.tree.setName("tree");
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setPreferredSize(new Dimension(270, 300));
        treeView.setMinimumSize(new Dimension(100, 100));
        treeView.setName("treeView");
        this.blankpropView = new JScrollPane();
        this.blankpropView.setPreferredSize(new Dimension(270, 300));
        this.blankpropView.setName("blankpropView");
        this.treePropPane = new JSplitPane(1, treeView, this.blankpropView);
        this.treePropPane.setResizeWeight(0.25);
        this.treePropPane.setDividerLocation(150);
        this.treePropPane.setName("treePropPane");
        this.add(this.treePropPane, new GridBagConstraints(0, 0, 3, 4, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.propertiesModel = new StructureTableModel();
        this.propertiesTable = new WsTable((WsAbstractTableModel)this.propertiesModel);
        this.propertiesView = new JScrollPane((Component)this.propertiesTable);
        this.propertiesTable.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.propertiesTable.setRowHeaderVisible(false);
        this.propertiesTable.setAutoResizeMode(0);
        this.propertiesTable.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.propertiesTable.setEditableCellBackground(UIManager.getColor("TextField.background"));
        this.propertiesTable.setRowHeaderVisible(false);
        this.propertiesTable.setRowHoldingEnabled(false);
        this.propertiesTable.setColumnHidingEnabled(false);
        this.propertiesTable.setColumnHoldingEnabled(false);
        this.propertiesTable.setColumnsReorderable(false);
        this.propertiesTable.setSortingEnabled(false);
    }

    public boolean validateData() {
        return true;
    }

    public void createNodes() {
        try {
            DefaultMutableTreeNode node;
            DefaultMutableTreeNode top = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            DefaultMutableTreeNode dim_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Dimensions.Title.txt"));
            top.add(dim_branch);
            OLAPList allOLAPDimensions = this.olapCube.getDimensionSet().getCubeDimensions();
            allOLAPDimensions.sort();
            for (int j = 0; j < allOLAPDimensions.size(); ++j) {
                OLAPDimension olapDimension = (OLAPDimension)allOLAPDimensions.get(j);
                if (olapDimension.isMeasure()) continue;
                DefaultMutableTreeNode dimnode = new DefaultMutableTreeNode(olapDimension);
                dim_branch.add(dimnode);
                DefaultMutableTreeNode hier_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Hierarchies.Title.txt"));
                dimnode.add(hier_branch);
                OLAPList dim_hiers = olapDimension.getHierarchies();
                OLAPList sorted = new OLAPList(OLAPHierarchy.class);
                sorted.addAll((Collection)dim_hiers);
                sorted.sort();
                for (int m = 0; m < sorted.size(); ++m) {
                    OLAPHierarchy hierarchy = (OLAPHierarchy)sorted.get(m);
                    node = new DefaultMutableTreeNode(hierarchy);
                    node.setAllowsChildren(false);
                    hier_branch.add(node);
                }
                DefaultMutableTreeNode lev_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Levels.Title.txt"));
                dimnode.add(lev_branch);
                OLAPList dim_levels = olapDimension.getLevels();
                dim_levels.sort();
                for (int m = 0; m < dim_levels.size(); ++m) {
                    OLAPLevel level = (OLAPLevel)dim_levels.get(m);
                    DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(level);
                    lev_branch.add(node2);
                    OLAPList properties = level.getOLAPProperties();
                    properties.sort();
                    for (int n = 0; n < properties.size(); ++n) {
                        OLAPMemberProperty property = (OLAPMemberProperty)properties.get(n);
                        DefaultMutableTreeNode propertyNode = new DefaultMutableTreeNode(property);
                        node2.add(propertyNode);
                        propertyNode.setAllowsChildren(false);
                    }
                }
                DefaultMutableTreeNode cm_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.CalculatedMembers.Title.txt"));
                dimnode.add(cm_branch);
                OLAPList list = this.olapCube.getDefinedMemberSet().getCalculatedMembersByDimension(olapDimension);
                for (int n = 0; n < list.size(); ++n) {
                    OLAPDefinedMember member = (OLAPDefinedMember)list.get(n);
                    DefaultMutableTreeNode memberNode = new DefaultMutableTreeNode(member);
                    cm_branch.add(memberNode);
                    memberNode.setAllowsChildren(false);
                }
            }
            DefaultMutableTreeNode sdim_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.SharedDimensions.Title.txt"));
            top.add(sdim_branch);
            OLAPList allOLAPSharedDimensions = this.olapCube.getDimensionSet().getSharedDimensions();
            allOLAPSharedDimensions.sort();
            for (int j = 0; j < allOLAPSharedDimensions.size(); ++j) {
                OLAPSharedDimension olapSharedDimension = (OLAPSharedDimension)allOLAPSharedDimensions.get(j);
                if (olapSharedDimension.isMeasure()) continue;
                DefaultMutableTreeNode dimnode = new DefaultMutableTreeNode(olapSharedDimension);
                sdim_branch.add(dimnode);
                DefaultMutableTreeNode hier_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Hierarchies.Title.txt"));
                dimnode.add(hier_branch);
                OLAPList dim_hiers = olapSharedDimension.getHierarchies();
                OLAPList sorted = new OLAPList(OLAPHierarchy.class);
                sorted.addAll((Collection)dim_hiers);
                sorted.sort();
                for (int m = 0; m < sorted.size(); ++m) {
                    OLAPHierarchy hierarchy = (OLAPHierarchy)sorted.get(m);
                    DefaultMutableTreeNode node3 = new DefaultMutableTreeNode(hierarchy);
                    node3.setAllowsChildren(false);
                    hier_branch.add(node3);
                }
                DefaultMutableTreeNode lev_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Levels.Title.txt"));
                dimnode.add(lev_branch);
                OLAPList dim_levels = olapSharedDimension.getLevels();
                dim_levels.sort();
                for (int m = 0; m < dim_levels.size(); ++m) {
                    OLAPLevel level = (OLAPLevel)dim_levels.get(m);
                    DefaultMutableTreeNode node4 = new DefaultMutableTreeNode(level);
                    lev_branch.add(node4);
                    OLAPList properties = level.getOLAPProperties();
                    properties.sort();
                    for (int n = 0; n < properties.size(); ++n) {
                        OLAPMemberProperty property = (OLAPMemberProperty)properties.get(n);
                        DefaultMutableTreeNode propertyNode = new DefaultMutableTreeNode(property);
                        node4.add(propertyNode);
                        propertyNode.setAllowsChildren(false);
                    }
                }
                DefaultMutableTreeNode cm_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.CalculatedMembers.Title.txt"));
                dimnode.add(cm_branch);
                OLAPList list = this.olapCube.getDefinedMemberSet().getCalculatedMembersByDimension((OLAPDimension)olapSharedDimension);
                for (int n = 0; n < list.size(); ++n) {
                    OLAPDefinedMember member = (OLAPDefinedMember)list.get(n);
                    DefaultMutableTreeNode memberNode = new DefaultMutableTreeNode(member);
                    cm_branch.add(memberNode);
                    memberNode.setAllowsChildren(false);
                }
            }
            DefaultMutableTreeNode meas_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Measures.Title.txt"));
            top.add(meas_branch);
            OLAPList measures = this.olapCube.getMeasureSet().getMeasures();
            OLAPList calcMeasures = this.olapCube.getDefinedMemberSet().getCalculatedMeasures();
            ArrayList allMeasures = new ArrayList();
            allMeasures.addAll(measures);
            allMeasures.addAll(calcMeasures);
            Collections.sort(allMeasures);
            for (int p = 0; p < allMeasures.size(); ++p) {
                AbstractOLAPModel measure = (AbstractOLAPModel)allMeasures.get(p);
                node = new DefaultMutableTreeNode(measure);
                node.setAllowsChildren(false);
                meas_branch.add(node);
            }
            DefaultMutableTreeNode calcMember_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.NamedSets.Title.txt"));
            top.add(calcMember_branch);
            OLAPList allnamedsets = this.olapCube.getDefinedMemberSet().getNamedSets();
            allnamedsets.sort();
            for (int i = 0; i < allnamedsets.size(); ++i) {
                OLAPDefinedMember member = (OLAPDefinedMember)allnamedsets.get(i);
                DefaultMutableTreeNode node5 = new DefaultMutableTreeNode(member);
                node5.setAllowsChildren(false);
                calcMember_branch.add(node5);
            }
            DefaultMutableTreeNode aggr_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Aggregations.Title.txt"));
            top.add(aggr_branch);
            OLAPList userAggregations = this.olapCube.getAggregationSet().getAggregations();
            userAggregations.sort();
            for (int q = 0; q < userAggregations.size(); ++q) {
                OLAPAggregation aggregation = (OLAPAggregation)userAggregations.get(q);
                DefaultMutableTreeNode node6 = new DefaultMutableTreeNode(aggregation);
                node6.setAllowsChildren(false);
                aggr_branch.add(node6);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.tree.getMaxSelectionRow() < 0) {
            this.tree.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    class StructureTreeSelectionListener
    implements TreeSelectionListener {
        StructureTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent tse) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)StructurePanel.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object currentObject = node.getUserObject();
                StructurePanel.this.namesList.clear();
                StructurePanel.this.valuesList.clear();
                if (currentObject instanceof String) {
                    WsStringTableColumn column = (WsStringTableColumn)StructurePanel.this.propertiesModel.getColumn(1);
                    column.setName(bundle.getString("StructurePanel.Description.ColumnHeader.txt"));
                    StructurePanel.this.propertiesModel.fireTableStructureChanged();
                    this.displayFolderInformation(node);
                } else {
                    WsStringTableColumn column = (WsStringTableColumn)StructurePanel.this.propertiesModel.getColumn(1);
                    column.setName(bundle.getString("StructurePanel.Value.ColumnHeader.txt"));
                    StructurePanel.this.propertiesModel.fireTableStructureChanged();
                    if (currentObject instanceof OLAPSharedDimension) {
                        this.displaySharedDimensionInformation(currentObject);
                    } else if (currentObject instanceof OLAPDimension) {
                        this.displayDimensionInformation(currentObject);
                    } else if (currentObject instanceof OLAPLevel) {
                        this.displayLevelInformation(currentObject);
                    } else if (currentObject instanceof OLAPMemberProperty) {
                        this.displayMemberPropertyInformation(currentObject);
                    } else if (currentObject instanceof OLAPHierarchy) {
                        this.displayHierarchyInformation(currentObject);
                    } else if (currentObject instanceof OLAPMeasure) {
                        this.displayMeasureInformation(currentObject);
                    } else if (currentObject instanceof OLAPAggregation) {
                        this.displayAggregationInformation(currentObject);
                    } else if (currentObject instanceof OLAPDefinedMember) {
                        this.displayCalculatedMemberInformation(currentObject);
                    } else if (currentObject instanceof OLAPCube) {
                        this.displayCubeInformation();
                    }
                }
                StructurePanel.this.propertiesModel.setLists(StructurePanel.this.namesList, StructurePanel.this.valuesList);
                if (StructurePanel.this.namesList.size() > 0) {
                    StructurePanel.this.treePropPane.setRightComponent(StructurePanel.this.propertiesView);
                } else {
                    StructurePanel.this.treePropPane.setRightComponent(StructurePanel.this.blankpropView);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        private void displayAggregationInformation(Object currentObject) throws OLAPException {
            OLAPAggregation aggregation = (OLAPAggregation)currentObject;
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.Name.txt"));
            StructurePanel.this.valuesList.add(aggregation.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.Levels.txt"));
            OLAPList levels = aggregation.getLevels();
            String levelString = "[";
            int levelsSize = levels.size();
            for (int i = 0; i < levelsSize; ++i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                levelString = levelString + level.getName();
                if (i >= levelsSize - 1) continue;
                levelString = levelString + ",";
            }
            levelString = levelString + "]";
            StructurePanel.this.valuesList.add(levelString);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.AggregationTable.txt"));
            String tableName = "";
            AggregationTable table = aggregation.getAggregationTable();
            if (table != null) {
                try {
                    SASLibrary library = LibraryUtil.getLibrary((DataTable)table.getTable(), null);
                    tableName = library.getLibref() + "." + table.getSASTableName();
                }
                catch (MdException error) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)error, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            StructurePanel.this.valuesList.add(tableName);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.TableOptions.txt"));
            StructurePanel.this.valuesList.add(aggregation.getTableOptions());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.DataPath.txt"));
            StructurePanel.this.valuesList.add(aggregation.getPerformanceOptionDatapath());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.PartitionSize.txt"));
            Integer partsize = aggregation.getPerformanceOptionPartsize();
            if (partsize != null) {
                StructurePanel.this.valuesList.add(partsize.toString());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.Compress.txt"));
            Boolean compress = aggregation.getPerformanceOptionCompress();
            if (compress != null) {
                StructurePanel.this.valuesList.add(compress.toString());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.Index.txt"));
            Boolean index = aggregation.getPerformanceOptionIndex();
            if (index != null) {
                StructurePanel.this.valuesList.add(index.toString());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.IndexPath.txt"));
            StructurePanel.this.valuesList.add(aggregation.getPerformanceOptionIndexpath());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Aggregation.Segsize.txt"));
            Integer segsize = aggregation.getPerformanceOptionSegsize();
            if (segsize != null) {
                StructurePanel.this.valuesList.add(segsize.toString());
            } else {
                StructurePanel.this.valuesList.add("");
            }
        }

        private void displayCalculatedMemberInformation(Object currentObject) {
            OLAPDefinedMember member = (OLAPDefinedMember)currentObject;
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.CalculatedMember.Name.txt"));
            StructurePanel.this.valuesList.add(member.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.CalculatedMember.Formula.txt"));
            StructurePanel.this.valuesList.add(member.getExpression());
            if (member.getType().equals("Calculated Member")) {
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.CalculatedMember.Dimension.txt"));
                StructurePanel.this.valuesList.add(member.getDimensionName());
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.CalculatedMember.ParentMember.txt"));
                StructurePanel.this.valuesList.add(member.getParentMember());
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.CalculatedMember.OwningHierarchy.txt"));
                OLAPHierarchy hier = member.getParentHierarchy();
                if (hier != null) {
                    StructurePanel.this.valuesList.add(hier.getName());
                } else {
                    StructurePanel.this.valuesList.add("");
                }
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.CalculatedMember.AssoicatedLevel.txt"));
                OLAPLevel level = member.getParentLevel();
                if (level != null) {
                    StructurePanel.this.valuesList.add(level.getName());
                } else {
                    StructurePanel.this.valuesList.add("");
                }
            } else if (member.getType().equals("Named Set")) {
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.NamedSet.Hierarchies.txt"));
                OLAPList hiers = member.getParentHierarchies();
                String hierString = "";
                if (hiers != null && !hiers.isEmpty()) {
                    hierString = "[";
                    int hierSize = hiers.size();
                    if (hiers != null) {
                        for (int numHier = 0; numHier < hierSize; ++numHier) {
                            OLAPHierarchy hier = (OLAPHierarchy)hiers.get(numHier);
                            hierString = hierString + hier.getName();
                            if (numHier >= hierSize - 1) continue;
                            hierString = hierString + ", ";
                        }
                    }
                    hierString = hierString + "]";
                }
                StructurePanel.this.valuesList.add(hierString);
            }
        }

        private void displayCubeInformation() throws OLAPException {
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Nonupdateable.txt"));
            String value = bundle.getString("StructurePanel.Nonupdateable.Always.txt");
            String cubeUpdateValue = StructurePanel.this.olapCube.getUpdateableDimensions();
            String typeOfCube = StructurePanel.this.olapCube.getType();
            if (cubeUpdateValue != null && cubeUpdateValue.equals("1") || typeOfCube.equals("HOLAP")) {
                value = bundle.getString("StructurePanel.Nonupdateable.Never.txt");
            } else {
                OLAPList dimensionlist = StructurePanel.this.olapCube.getDimensionSet().getCubeDimensions();
                int count = 0;
                int size = dimensionlist.size();
                for (int i = 0; i < size; ++i) {
                    OLAPDimension currentDimension = (OLAPDimension)dimensionlist.get(i);
                    if (currentDimension.isUpdateable()) continue;
                    ++count;
                }
                if (!dimensionlist.isEmpty() && count == dimensionlist.size()) {
                    value = bundle.getString("StructurePanel.Nonupdateable.Never.txt");
                } else if (count > 0) {
                    value = bundle.getString("StructurePanel.Nonupdateable.Sometimes.txt");
                }
            }
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.SecuritySubset.txt"));
            if (StructurePanel.this.olapCube.getSecuritySubset().equals("YES")) {
                StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.SecuritySubset.No.txt"));
            } else {
                StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.SecuritySubset.Yes.txt"));
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.CharMissing.txt"));
            String emptyChar = StructurePanel.this.olapCube.getEmptyChar();
            value = emptyChar != null && ModelUtilities.isBlank((String)emptyChar) ? bundle.getString("StructurePanel.MissingMemberValues.Blank.txt") : (emptyChar != null ? emptyChar : bundle.getString("StructurePanel.NotSpecified.txt"));
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.NumMissing.txt"));
            String emptyNum = StructurePanel.this.olapCube.getEmptyNum();
            value = emptyNum != null && emptyNum.equals(".") ? bundle.getString("StructurePanel.MissingMemberValues.Period.txt") : (emptyNum != null ? emptyNum : bundle.getString("StructurePanel.NotSpecified.txt"));
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.FmtSearchPath.txt"));
            StructurePanel.this.valuesList.add(StructurePanel.this.olapCube.getFormatSearchOptions());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.SubmitSASCode.txt"));
            StructurePanel.this.valuesList.add(StructurePanel.this.olapCube.getSASCode());
            boolean isStar = StructurePanel.this.olapCube.getTableSet().isLoadStarSchema();
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.NwayCompact.txt"));
            value = "";
            if (isStar) {
                String temp = StructurePanel.this.olapCube.getCompact();
                value = temp != null && temp.equals("1") ? bundle.getString("StructurePanel.NwayCompact.Value_YES.txt") : bundle.getString("StructurePanel.NwayCompact.Value_NO.txt");
            }
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MissDimKeys.txt"));
            value = "";
            if (isStar) {
                String temp = StructurePanel.this.olapCube.getMissingDimensionKeys();
                if (temp == null) {
                    value = bundle.getString("StructurePanel.MissDimKeys.Error.txt");
                } else if (temp.equals("TERSE")) {
                    value = bundle.getString("StructurePanel.MissDimKeys.Terse.txt");
                } else if (temp.equals("VERBOSE")) {
                    value = bundle.getString("StructurePanel.MissDimKeys.Verbose.txt");
                } else if (temp.equals("ERROR")) {
                    value = bundle.getString("StructurePanel.MissDimKeys.Error.txt");
                }
            }
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.DimTableTrans.txt"));
            value = "";
            LanguageSet languageModel = StructurePanel.this.olapCube.getLanguageSet();
            List userSelectedCountries = languageModel.getSelectedLocales();
            if (userSelectedCountries != null) {
                Properties listOfCountries = languageModel.getCountries();
                for (int i = 0; i < userSelectedCountries.size(); ++i) {
                    String localeID = (String)userSelectedCountries.get(i);
                    String countryName = listOfCountries.getProperty(localeID.toUpperCase());
                    value = value + countryName;
                    if (i >= userSelectedCountries.size() - 1) continue;
                    value = value + ",";
                }
            }
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.IndexSortSize.txt"));
            Integer indexsortsize = StructurePanel.this.olapCube.getPerformanceOptionIndexSortSize();
            value = indexsortsize != null ? indexsortsize.toString() : "";
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MaxThreads.txt"));
            Integer maxThreads = StructurePanel.this.olapCube.getPerformanceOptionMaxThreads();
            value = maxThreads != null ? maxThreads.toString() : "";
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Concurrent.txt"));
            Integer concurrent = StructurePanel.this.olapCube.getPerformanceOptionConcurrent();
            value = concurrent != null ? concurrent.toString() : "";
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.DataPath.txt"));
            String dataPath = StructurePanel.this.olapCube.getPerformanceOptionDatapath();
            value = dataPath != null ? dataPath : "";
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Partsize.txt"));
            Integer partsize = StructurePanel.this.olapCube.getPerformanceOptionPartsize();
            value = partsize != null ? partsize.toString() : "";
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Compress.txt"));
            Boolean compress = StructurePanel.this.olapCube.getPerformanceOptionCompress();
            value = compress != null && compress != false ? bundle.getString("StructurePanel.Compress.Value_Yes.txt") : bundle.getString("StructurePanel.Compress.Value_No.txt");
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Index.txt"));
            Boolean index = StructurePanel.this.olapCube.getPerformanceOptionIndex();
            value = index != null && index == false ? bundle.getString("StructurePanel.Index.Value_No.txt") : bundle.getString("StructurePanel.Index.Value_Yes.txt");
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.IndexPath.txt"));
            String indexPath = StructurePanel.this.olapCube.getPerformanceOptionIndexpath();
            value = indexPath != null ? indexPath : "";
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Segsize.txt"));
            Integer segsize = StructurePanel.this.olapCube.getPerformanceOptionSegsize();
            value = segsize != null ? segsize.toString() : "";
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.IndexNumber.txt"));
            Integer indexnum = StructurePanel.this.olapCube.getPerformanceOptionAsyncIndexLimit();
            value = indexnum != null ? indexnum.toString() : "";
            StructurePanel.this.valuesList.add(value);
            LanguageSet languageSet = StructurePanel.this.olapCube.getLanguageSet();
            if (languageSet.isCubeMultipleLanguageSupported()) {
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Cube.MLSTable.txt"));
                String tableName = "";
                MLSCaptionTable mlsTable = StructurePanel.this.olapCube.getMLSCaptionTable();
                if (mlsTable != null) {
                    tableName = mlsTable.getSASTableName();
                    SASLibrary library = mlsTable.getSASLibrary();
                    try {
                        if (library != null) {
                            String libName = library.getLibref();
                            tableName = libName.trim() + "." + tableName;
                        }
                    }
                    catch (RemoteException e) {
                        Workspace.handleRemoteException((RemoteException)e);
                    }
                }
                StructurePanel.this.valuesList.add(tableName);
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Cube.MLSID.txt"));
                Integer id = StructurePanel.this.olapCube.getMLSID();
                if (id != null) {
                    StructurePanel.this.valuesList.add(id.toString());
                } else {
                    StructurePanel.this.valuesList.add("");
                }
            }
        }

        private void displayDimensionInformation(Object currentObject) throws OLAPException {
            OLAPDimension olapDimension = (OLAPDimension)currentObject;
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Nonupdateable.txt"));
            String isUpdateNewMembers = "";
            isUpdateNewMembers = olapDimension.isUpdateable() ? bundle.getString("StructurePanel.Nonupdateable.Yes.txt") : bundle.getString("StructurePanel.Nonupdateable.No.txt");
            StructurePanel.this.valuesList.add(isUpdateNewMembers);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Name.txt"));
            StructurePanel.this.valuesList.add(olapDimension.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Caption.txt"));
            StructurePanel.this.valuesList.add(olapDimension.getDesc());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Description.txt"));
            StructurePanel.this.valuesList.add(olapDimension.getNotes());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Type.txt"));
            StructurePanel.this.valuesList.add(olapDimension.getType());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.SortOrder.txt"));
            StructurePanel.this.valuesList.add(olapDimension.getSortOrder());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DimensionTable.txt"));
            String tableName = "";
            if (olapDimension.isStarDimension()) {
                DimensionTable table = olapDimension.getTable();
                try {
                    SASLibrary library = LibraryUtil.getLibrary((DataTable)table.getTable(), null);
                    tableName = library.getLibref() + "." + table.getSASTableName();
                }
                catch (MdException error) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)error, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            StructurePanel.this.valuesList.add(tableName);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.TableOptions.txt"));
            StructurePanel.this.valuesList.add(olapDimension.getTableOptions());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DimensionKey.txt"));
            OLAPColumn keyColumn = olapDimension.getDimensionKey();
            if (keyColumn != null) {
                StructurePanel.this.valuesList.add(keyColumn.getSASColumnName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DimensionFactKey.txt"));
            OLAPColumn factColumn = olapDimension.getFactKey();
            if (factColumn != null) {
                StructurePanel.this.valuesList.add(factColumn.getSASColumnName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Hierarchies.txt"));
            OLAPList hierarchies = olapDimension.getHierarchies();
            String hierString = "[";
            int hierSize = hierarchies.size();
            for (int i = 0; i < hierSize; ++i) {
                OLAPHierarchy hier = (OLAPHierarchy)hierarchies.get(i);
                hierString = hierString + hier.getName();
                if (i >= hierSize - 1) continue;
                hierString = hierString + ",";
            }
            hierString = hierString + "]";
            StructurePanel.this.valuesList.add(hierString);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DefaultHierarchy.txt"));
            OLAPHierarchy hier = olapDimension.getDefault();
            StructurePanel.this.valuesList.add(hier.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Levels.txt"));
            OLAPList levels = olapDimension.getLevels();
            String levelString = "[";
            int levelsSize = levels.size();
            for (int i = 0; i < levelsSize; ++i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                levelString = levelString + level.getName();
                if (i >= levelsSize - 1) continue;
                levelString = levelString + ",";
            }
            levelString = levelString + "]";
            StructurePanel.this.valuesList.add(levelString);
            ServerComponent server = olapDimension.getMapServer();
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.ESRIMapServer.txt"));
            try {
                if (server != null) {
                    StructurePanel.this.valuesList.add(server.getName());
                } else {
                    StructurePanel.this.valuesList.add("");
                }
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.ESRIMapService.txt"));
                TableCollection service = olapDimension.getMapService();
                if (service != null) {
                    StructurePanel.this.valuesList.add(service.getName());
                } else {
                    StructurePanel.this.valuesList.add("");
                }
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.IgnoreEmpty.control.label"));
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            String ignore = olapDimension.getIgnoreEmpty();
            String emptychar = olapDimension.getEmptyChar();
            String emptynum = olapDimension.getEmptyNum();
            if (ignore != null) {
                if (ignore.equals("1")) {
                    StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Dimension.IgnoreEmpty.Yes.txt"));
                    if (emptychar == null) {
                        emptychar = bundle.getString("StructurePanel.NotSpecified.txt");
                    }
                    if (emptynum == null) {
                        emptynum = bundle.getString("StructurePanel.NotSpecified.txt");
                    }
                }
            } else {
                OLAPCube cube;
                StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Dimension.IgnoreEmpty.No.txt"));
                if (emptychar != null && ModelUtilities.isBlank((String)emptychar)) {
                    emptychar = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt");
                }
                if (emptynum != null && emptynum.equals(".")) {
                    emptynum = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt");
                }
                if (emptychar == null) {
                    cube = olapDimension.getOwningCube();
                    String cubeEmptyChar = cube.getEmptyChar();
                    emptychar = cubeEmptyChar != null && ModelUtilities.isBlank((String)cubeEmptyChar) ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt")) : (cubeEmptyChar != null ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)cubeEmptyChar) : bundle.getString("StructurePanel.NotSpecified.txt"));
                }
                if (emptynum == null) {
                    cube = olapDimension.getOwningCube();
                    String cubeEmptyNum = cube.getEmptyNum();
                    emptynum = cubeEmptyNum != null && cubeEmptyNum.equals(".") ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt")) : (cubeEmptyNum != null ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)cubeEmptyNum) : bundle.getString("StructurePanel.NotSpecified.txt"));
                }
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.EmptyChar.control.label"));
            StructurePanel.this.valuesList.add(emptychar);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.EmptyNum.control.label"));
            StructurePanel.this.valuesList.add(emptynum);
            LanguageSet languageSet = StructurePanel.this.olapCube.getLanguageSet();
            if (languageSet.isCubeMultipleLanguageSupported()) {
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.MLSTable.txt"));
                String mlstableName = "";
                MLSCaptionTable mlsTable = olapDimension.getMLSCaptionTable();
                if (mlsTable == null) {
                    mlsTable = StructurePanel.this.olapCube.getMLSCaptionTable();
                }
                if (mlsTable != null) {
                    mlstableName = mlsTable.getSASTableName();
                    SASLibrary library = mlsTable.getSASLibrary();
                    try {
                        if (library != null) {
                            String libName = library.getLibref();
                            mlstableName = libName.trim() + "." + mlstableName;
                        }
                    }
                    catch (RemoteException e) {
                        Workspace.handleRemoteException((RemoteException)e);
                    }
                }
                StructurePanel.this.valuesList.add(mlstableName);
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.MLSID.txt"));
                Integer id = olapDimension.getMLSID();
                if (id != null) {
                    StructurePanel.this.valuesList.add(id.toString());
                } else {
                    StructurePanel.this.valuesList.add("");
                }
            }
        }

        private void displaySharedDimensionInformation(Object currentObject) throws OLAPException {
            OLAPSharedDimension olapSharedDimension = (OLAPSharedDimension)currentObject;
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Nonupdateable.txt"));
            String isUpdateNewMembers = "";
            isUpdateNewMembers = olapSharedDimension.isUpdateable() ? bundle.getString("StructurePanel.Nonupdateable.Yes.txt") : bundle.getString("StructurePanel.Nonupdateable.No.txt");
            StructurePanel.this.valuesList.add(isUpdateNewMembers);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Name.txt"));
            StructurePanel.this.valuesList.add(olapSharedDimension.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Caption.txt"));
            StructurePanel.this.valuesList.add(olapSharedDimension.getDesc());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Description.txt"));
            StructurePanel.this.valuesList.add(olapSharedDimension.getNotes());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Type.txt"));
            StructurePanel.this.valuesList.add(olapSharedDimension.getType());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.SortOrder.txt"));
            StructurePanel.this.valuesList.add(olapSharedDimension.getSortOrder());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DimensionTable.txt"));
            String tableName = "";
            SharedDimensionTable table = olapSharedDimension.getSharedDimensionTable();
            try {
                SASLibrary library = LibraryUtil.getLibrary((DataTable)table.getTable(), null);
                tableName = library.getLibref() + "." + table.getSASTableName();
            }
            catch (MdException error) {
                MessageUtil.displayMetadataExceptionMessage((MdException)error, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            StructurePanel.this.valuesList.add(tableName);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.TableOptions.txt"));
            StructurePanel.this.valuesList.add(olapSharedDimension.getTableOptions());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DimensionKey.txt"));
            OLAPColumn keyColumn = olapSharedDimension.getDimensionKey();
            if (keyColumn != null) {
                StructurePanel.this.valuesList.add(keyColumn.getSASColumnName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DimensionFactKey.txt"));
            OLAPColumn factColumn = olapSharedDimension.getSharedDimensionFactKey(StructurePanel.this.olapCube);
            if (factColumn != null) {
                StructurePanel.this.valuesList.add(factColumn.getSASColumnName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Hierarchies.txt"));
            OLAPList hierarchies = olapSharedDimension.getHierarchies();
            String hierString = "[";
            int hierSize = hierarchies.size();
            for (int i = 0; i < hierSize; ++i) {
                OLAPHierarchy hier = (OLAPHierarchy)hierarchies.get(i);
                hierString = hierString + hier.getName();
                if (i >= hierSize - 1) continue;
                hierString = hierString + ",";
            }
            hierString = hierString + "]";
            StructurePanel.this.valuesList.add(hierString);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DefaultHierarchy.txt"));
            OLAPHierarchy hier = olapSharedDimension.getDefault();
            StructurePanel.this.valuesList.add(hier.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Levels.txt"));
            OLAPList levels = olapSharedDimension.getLevels();
            String levelString = "[";
            int levelsSize = levels.size();
            for (int i = 0; i < levelsSize; ++i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                levelString = levelString + level.getName();
                if (i >= levelsSize - 1) continue;
                levelString = levelString + ",";
            }
            levelString = levelString + "]";
            StructurePanel.this.valuesList.add(levelString);
            ServerComponent server = olapSharedDimension.getMapServer();
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.ESRIMapServer.txt"));
            try {
                if (server != null) {
                    StructurePanel.this.valuesList.add(server.getName());
                } else {
                    StructurePanel.this.valuesList.add("");
                }
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.ESRIMapService.txt"));
                TableCollection service = olapSharedDimension.getMapService();
                if (service != null) {
                    StructurePanel.this.valuesList.add(service.getName());
                } else {
                    StructurePanel.this.valuesList.add("");
                }
                StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.IgnoreEmpty.control.label"));
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            String ignore = olapSharedDimension.getIgnoreEmpty();
            String emptychar = olapSharedDimension.getEmptyChar();
            String emptynum = olapSharedDimension.getEmptyNum();
            if (ignore != null) {
                if (ignore.equals("1")) {
                    StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Dimension.IgnoreEmpty.Yes.txt"));
                    if (emptychar == null) {
                        emptychar = bundle.getString("StructurePanel.NotSpecified.txt");
                    }
                    if (emptynum == null) {
                        emptynum = bundle.getString("StructurePanel.NotSpecified.txt");
                    }
                }
            } else {
                OLAPCube cube;
                StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Dimension.IgnoreEmpty.No.txt"));
                if (emptychar != null && ModelUtilities.isBlank((String)emptychar)) {
                    emptychar = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt");
                }
                if (emptynum != null && emptynum.equals(".")) {
                    emptynum = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt");
                }
                if (emptychar == null) {
                    cube = olapSharedDimension.getOwningCube();
                    String cubeEmptyChar = cube.getEmptyChar();
                    emptychar = cubeEmptyChar != null && ModelUtilities.isBlank((String)cubeEmptyChar) ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt")) : (cubeEmptyChar != null ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)cubeEmptyChar) : bundle.getString("StructurePanel.NotSpecified.txt"));
                }
                if (emptynum == null) {
                    cube = olapSharedDimension.getOwningCube();
                    String cubeEmptyNum = cube.getEmptyNum();
                    emptynum = cubeEmptyNum != null && cubeEmptyNum.equals(".") ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt")) : (cubeEmptyNum != null ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)cubeEmptyNum) : bundle.getString("StructurePanel.NotSpecified.txt"));
                }
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.EmptyChar.control.label"));
            StructurePanel.this.valuesList.add(emptychar);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.EmptyNum.control.label"));
            StructurePanel.this.valuesList.add(emptynum);
        }

        private void displayFolderInformation(DefaultMutableTreeNode node) {
            int numChildren = node.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                AbstractOLAPModel olapObj = (AbstractOLAPModel)child.getUserObject();
                StructurePanel.this.namesList.add(olapObj.getName());
                StructurePanel.this.valuesList.add(olapObj.getDesc());
            }
        }

        private void displayHierarchyInformation(Object currentObject) throws OLAPException {
            OLAPHierarchy hierarchy = (OLAPHierarchy)currentObject;
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Name.txt"));
            StructurePanel.this.valuesList.add(hierarchy.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Default.txt"));
            OLAPDimension parentDim = hierarchy.getDimension();
            OLAPHierarchy defaultHier = parentDim.getDefault();
            if (hierarchy.equals(defaultHier)) {
                StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Hierarchy.IsDefault.Yes.txt"));
            } else {
                StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Hierarchy.IsDefault.No.txt"));
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Caption.txt"));
            StructurePanel.this.valuesList.add(hierarchy.getDesc());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Description.txt"));
            StructurePanel.this.valuesList.add(hierarchy.getNotes());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Levels.txt"));
            OLAPList levels = hierarchy.getLevels();
            String levelString = "[";
            int levelsSize = levels.size();
            for (int i = 0; i < levelsSize; ++i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                levelString = levelString + level.getName();
                if (i >= levelsSize - 1) continue;
                levelString = levelString + ",";
            }
            levelString = levelString + "]";
            StructurePanel.this.valuesList.add(levelString);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.AllMember.txt"));
            StructurePanel.this.valuesList.add(hierarchy.getAllMember());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.MLSID.txt"));
            Integer id = hierarchy.getMLSID();
            if (id != null) {
                StructurePanel.this.valuesList.add(id.toString());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.AllMLSID.txt"));
            id = hierarchy.getAllMemberMLSID();
            if (id != null) {
                StructurePanel.this.valuesList.add(id.toString());
            } else {
                StructurePanel.this.valuesList.add("");
            }
        }

        private void displayLevelInformation(Object currentObject) throws OLAPException {
            OLAPLevel level = (OLAPLevel)currentObject;
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Name.txt"));
            StructurePanel.this.valuesList.add(level.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.InputColumn.txt"));
            StructurePanel.this.valuesList.add(level.getColumn().getSASColumnName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Caption.txt"));
            StructurePanel.this.valuesList.add(level.getDesc());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Description.txt"));
            StructurePanel.this.valuesList.add(level.getNotes());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Type.txt"));
            int levelType = level.getType();
            String typeValue = "";
            switch (levelType) {
                case 16: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypeyear.txt");
                    break;
                }
                case 32: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypehalfyear.txt");
                    break;
                }
                case 64: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypequarters.txt");
                    break;
                }
                case 128: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypemonths.txt");
                    break;
                }
                case 256: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypeweeks.txt");
                    break;
                }
                case 512: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypedays.txt");
                    break;
                }
                case 1024: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypehours.txt");
                    break;
                }
                case 2048: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypeminutes.txt");
                    break;
                }
                case 4096: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypeseconds.txt");
                }
            }
            StructurePanel.this.valuesList.add(typeValue);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.SortOrder.txt"));
            StructurePanel.this.valuesList.add(level.getSortOrder());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.IgnoreMissing.control.label"));
            String ignore = level.getIgnoreEmpty();
            String empty = level.getEmpty();
            String typeOfColumn = level.getColumn().getSASColumnType();
            if (ignore != null) {
                if (ignore.equals("1")) {
                    StructurePanel.this.valuesList.add(bundle.getString("Common.true.txt"));
                }
            } else {
                StructurePanel.this.valuesList.add(bundle.getString("Common.false.txt"));
                if (empty != null) {
                    if (typeOfColumn.equals("C") && ModelUtilities.isBlank((String)empty)) {
                        empty = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt");
                    } else if (typeOfColumn.equals("N") && empty.equals(".")) {
                        empty = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt");
                    }
                } else {
                    OLAPDimension dimension = level.getDimension();
                    OLAPCube cube = dimension.getOwningCube();
                    if (typeOfColumn.equals("C")) {
                        String dimEmptyChar = dimension.getEmptyChar();
                        if (dimEmptyChar != null && ModelUtilities.isBlank((String)dimEmptyChar)) {
                            empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt"));
                        } else if (dimEmptyChar != null) {
                            empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)dimEmptyChar);
                        } else if (dimEmptyChar == null) {
                            String dimIgnoreEmpty = dimension.getIgnoreEmpty();
                            if (dimIgnoreEmpty != null && dimIgnoreEmpty.equals("1")) {
                                empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.NotSpecified.txt"));
                            }
                        } else {
                            String cubeEmptyChar = cube.getEmptyChar();
                            empty = cubeEmptyChar != null && ModelUtilities.isBlank((String)cubeEmptyChar) ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt")) : (cubeEmptyChar != null ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)cubeEmptyChar) : bundle.getString("StructurePanel.NotSpecified.txt"));
                        }
                    } else {
                        String dimEmptyNum = dimension.getEmptyNum();
                        if (dimEmptyNum != null && dimEmptyNum.equals(".")) {
                            empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt"));
                        } else if (dimEmptyNum != null) {
                            empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)dimEmptyNum);
                        } else if (dimEmptyNum == null) {
                            String dimIgnoreEmpty = dimension.getIgnoreEmpty();
                            if (dimIgnoreEmpty != null && dimIgnoreEmpty.equals("1")) {
                                empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.NotSpecified.txt"));
                            }
                        } else {
                            String cubeEmptyNum = cube.getEmptyNum();
                            empty = cubeEmptyNum != null && ModelUtilities.isBlank((String)cubeEmptyNum) ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt")) : (cubeEmptyNum != null ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)cubeEmptyNum) : bundle.getString("StructurePanel.NotSpecified.txt"));
                        }
                    }
                }
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.MissingMember.control.label"));
            StructurePanel.this.valuesList.add(empty);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Format.txt"));
            StructurePanel.this.valuesList.add(level.getFormat());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.MapLayer.txt"));
            OLAPColumn column = level.getMapLayer();
            if (column != null) {
                StructurePanel.this.valuesList.add(column.getSASColumnName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.MapFieldId.txt"));
            Property fieldId = level.getMapFieldId();
            try {
                if (fieldId != null) {
                    StructurePanel.this.valuesList.add(fieldId.getName());
                } else {
                    StructurePanel.this.valuesList.add("");
                }
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.MLSID.txt"));
            Integer id = level.getMLSID();
            if (id != null) {
                StructurePanel.this.valuesList.add(id.toString());
            } else {
                StructurePanel.this.valuesList.add("");
            }
        }

        private void displayMeasureInformation(Object currentObject) throws OLAPException {
            OLAPMeasure measure = (OLAPMeasure)currentObject;
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.Name.txt"));
            StructurePanel.this.valuesList.add(measure.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.Caption.txt"));
            StructurePanel.this.valuesList.add(measure.getDesc());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.Description.txt"));
            StructurePanel.this.valuesList.add(measure.getNotes());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.Default.txt"));
            OLAPMeasure defaultMeasure = measure.getOwningCube().getMeasureSet().getDefaultMeasure();
            if (measure.equals(defaultMeasure)) {
                StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Measure.IsDefault.Yes.txt"));
            } else {
                StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Measure.IsDefault.No.txt"));
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.InputColumnName.txt"));
            OLAPColumn column = measure.getInputColumn();
            if (column != null) {
                StructurePanel.this.valuesList.add(column.getSASColumnName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.Statistic.txt"));
            Statistic stat = measure.getStatistic();
            if (stat != null) {
                StructurePanel.this.valuesList.add(stat.getName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.AnalysisGroup.txt"));
            StructurePanel.this.valuesList.add(measure.getGroupName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.Level.txt"));
            OLAPLevel level = measure.getLevel();
            if (level != null) {
                StructurePanel.this.valuesList.add(level.getName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.Hierarchy.txt"));
            OLAPHierarchy hier = measure.getHierarchy();
            if (hier != null) {
                StructurePanel.this.valuesList.add(hier.getName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.Format.txt"));
            StructurePanel.this.valuesList.add(measure.getSASFormat());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.Units.txt"));
            StructurePanel.this.valuesList.add(measure.getUnits());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.IncludeCalcMembers.txt"));
            if (measure.isNunique().booleanValue()) {
                if (measure.isIncludeCalculatedMembers()) {
                    StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Measure.IncludeCalcMembers_yes.txt"));
                } else {
                    StructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Measure.IncludeCalcMembers_no.txt"));
                }
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.Measure.MLSID.txt"));
            Integer id = measure.getMLSID();
            if (id != null) {
                StructurePanel.this.valuesList.add(id.toString());
            } else {
                StructurePanel.this.valuesList.add("");
            }
        }

        private void displayMemberPropertyInformation(Object currentObject) throws OLAPException {
            OLAPMemberProperty property = (OLAPMemberProperty)currentObject;
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Name.txt"));
            StructurePanel.this.valuesList.add(property.getName());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Caption.txt"));
            StructurePanel.this.valuesList.add(property.getDesc());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Description.txt"));
            StructurePanel.this.valuesList.add(property.getNotes());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.InputColumn.txt"));
            OLAPColumn column = property.getColumn();
            if (column != null) {
                StructurePanel.this.valuesList.add(column.getSASColumnName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Level.txt"));
            OLAPLevel level = property.getAssociatedLevel();
            if (level != null) {
                StructurePanel.this.valuesList.add(level.getName());
            } else {
                StructurePanel.this.valuesList.add("");
            }
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Hierarchy.txt"));
            OLAPList hierarchies = property.getHierarchies();
            String value = "[";
            int hierSize = hierarchies.size();
            for (int i = 0; i < hierSize; ++i) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(i);
                value = value + hierarchy.getName();
                if (i >= hierSize - 1) continue;
                value = value + ",";
            }
            value = value + "]";
            StructurePanel.this.valuesList.add(value);
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Format.txt"));
            StructurePanel.this.valuesList.add(property.getSASFormat());
            StructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.MLSID.txt"));
            Integer id = property.getMLSID();
            if (id != null) {
                StructurePanel.this.valuesList.add(id.toString());
            } else {
                StructurePanel.this.valuesList.add("");
            }
        }
    }
}

