/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.properties;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TableCollection;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.properties.SharedDimensionStructureTableModel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.StructureTreeCellRenderer;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SharedDimensionStructurePanel
extends WAPanel
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(SharedDimensionStructurePanel.class);
    private JTree tree;
    private JScrollPane blankpropView;
    private JSplitPane treePropPane;
    private OLAPSharedDimension olapDim;
    private WsTable propertiesTable;
    private SharedDimensionStructureTableModel propertiesModel;
    private List namesList;
    private List valuesList;
    private JScrollPane propertiesView;
    private boolean initialized;

    public SharedDimensionStructurePanel(OLAPSharedDimension inDim) {
        this.olapDim = inDim;
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel && !this.initialized) {
            this.initialized = true;
            this.createNodes();
            this.tree.expandRow(0);
            TreePath tp1 = this.tree.getPathForRow(1);
            TreePath tp2 = this.tree.getPathForRow(2);
            TreePath tp3 = this.tree.getPathForRow(3);
            TreePath tp4 = this.tree.getPathForRow(4);
            TreePath tp5 = this.tree.getPathForRow(5);
            this.tree.expandPath(tp1);
            this.tree.expandPath(tp2);
            this.tree.expandPath(tp3);
            this.tree.expandPath(tp4);
            this.tree.expandPath(tp5);
            this.tree.addTreeSelectionListener(new StructureTreeSelectionListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.namesList = new ArrayList();
            this.valuesList = new ArrayList();
        }
        return true;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.tree = new JTree(new DefaultMutableTreeNode(this.olapDim));
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new StructureTreeCellRenderer());
        this.tree.addFocusListener(this);
        this.tree.setName("tree");
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setPreferredSize(new Dimension(270, 300));
        treeView.setMinimumSize(new Dimension(100, 100));
        treeView.setName("treeView");
        this.blankpropView = new JScrollPane();
        this.blankpropView.setPreferredSize(new Dimension(270, 300));
        this.blankpropView.setName("blankpropView");
        this.treePropPane = new JSplitPane(1, treeView, this.blankpropView);
        this.treePropPane.setResizeWeight(0.25);
        this.treePropPane.setDividerLocation(150);
        this.treePropPane.setName("treePropPane");
        this.add(this.treePropPane, new GridBagConstraints(0, 0, 3, 4, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.propertiesModel = new SharedDimensionStructureTableModel();
        this.propertiesTable = new WsTable((WsAbstractTableModel)this.propertiesModel);
        this.propertiesView = new JScrollPane((Component)this.propertiesTable);
        this.propertiesTable.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.propertiesTable.setRowHeaderVisible(false);
        this.propertiesTable.setAutoResizeMode(0);
        this.propertiesTable.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.propertiesTable.setEditableCellBackground(UIManager.getColor("TextField.background"));
        this.propertiesTable.setRowHeaderVisible(false);
        this.propertiesTable.setRowHoldingEnabled(false);
        this.propertiesTable.setColumnHidingEnabled(false);
        this.propertiesTable.setColumnHoldingEnabled(false);
        this.propertiesTable.setColumnsReorderable(false);
        this.propertiesTable.setSortingEnabled(false);
    }

    public boolean validateData() {
        return true;
    }

    public void createNodes() {
        try {
            DefaultMutableTreeNode top = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            DefaultMutableTreeNode hier_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Hierarchies.Title.txt"));
            top.add(hier_branch);
            OLAPList dim_hiers = this.olapDim.getHierarchies();
            OLAPList sorted = new OLAPList(OLAPHierarchy.class);
            sorted.addAll((Collection)dim_hiers);
            sorted.sort();
            for (int m = 0; m < sorted.size(); ++m) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)sorted.get(m);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(hierarchy);
                node.setAllowsChildren(false);
                hier_branch.add(node);
            }
            DefaultMutableTreeNode lev_branch = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Levels.Title.txt"));
            top.add(lev_branch);
            OLAPList dim_levels = this.olapDim.getLevels();
            dim_levels.sort();
            for (int m = 0; m < dim_levels.size(); ++m) {
                OLAPLevel level = (OLAPLevel)dim_levels.get(m);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(level);
                lev_branch.add(node);
                OLAPList properties = level.getOLAPProperties();
                properties.sort();
                for (int n = 0; n < properties.size(); ++n) {
                    OLAPMemberProperty property = (OLAPMemberProperty)properties.get(n);
                    DefaultMutableTreeNode propertyNode = new DefaultMutableTreeNode(property);
                    node.add(propertyNode);
                    propertyNode.setAllowsChildren(false);
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.tree.getMaxSelectionRow() < 0) {
            this.tree.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    class StructureTreeSelectionListener
    implements TreeSelectionListener {
        StructureTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent tse) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)SharedDimensionStructurePanel.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object currentObject = node.getUserObject();
                SharedDimensionStructurePanel.this.namesList.clear();
                SharedDimensionStructurePanel.this.valuesList.clear();
                if (currentObject instanceof String) {
                    WsStringTableColumn column = (WsStringTableColumn)SharedDimensionStructurePanel.this.propertiesModel.getColumn(1);
                    column.setName(bundle.getString("StructurePanel.Description.ColumnHeader.txt"));
                    SharedDimensionStructurePanel.this.propertiesModel.fireTableStructureChanged();
                    this.displayFolderInformation(node);
                } else {
                    WsStringTableColumn column = (WsStringTableColumn)SharedDimensionStructurePanel.this.propertiesModel.getColumn(1);
                    column.setName(bundle.getString("StructurePanel.Value.ColumnHeader.txt"));
                    SharedDimensionStructurePanel.this.propertiesModel.fireTableStructureChanged();
                    if (currentObject instanceof OLAPDimension) {
                        this.displayDimensionInformation(currentObject);
                    } else if (currentObject instanceof OLAPLevel) {
                        this.displayLevelInformation(currentObject);
                    } else if (currentObject instanceof OLAPMemberProperty) {
                        this.displayMemberPropertyInformation(currentObject);
                    } else if (currentObject instanceof OLAPHierarchy) {
                        this.displayHierarchyInformation(currentObject);
                    }
                }
                SharedDimensionStructurePanel.this.propertiesModel.setLists(SharedDimensionStructurePanel.this.namesList, SharedDimensionStructurePanel.this.valuesList);
                if (SharedDimensionStructurePanel.this.namesList.size() > 0) {
                    SharedDimensionStructurePanel.this.treePropPane.setRightComponent(SharedDimensionStructurePanel.this.propertiesView);
                } else {
                    SharedDimensionStructurePanel.this.treePropPane.setRightComponent(SharedDimensionStructurePanel.this.blankpropView);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        private void displayDimensionInformation(Object currentObject) throws OLAPException {
            OLAPSharedDimension olapDimension = (OLAPSharedDimension)currentObject;
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Nonupdateable.txt"));
            String isUpdateNewMembers = "";
            isUpdateNewMembers = olapDimension.isUpdateable() ? bundle.getString("StructurePanel.Nonupdateable.Yes.txt") : bundle.getString("StructurePanel.Nonupdateable.No.txt");
            SharedDimensionStructurePanel.this.valuesList.add(isUpdateNewMembers);
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Name.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(olapDimension.getName());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Caption.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(olapDimension.getDesc());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Description.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(olapDimension.getNotes());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Type.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(olapDimension.getType());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.SortOrder.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(olapDimension.getSortOrder());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DimensionTable.txt"));
            String tableName = "";
            SharedDimensionTable table = olapDimension.getSharedDimensionTable();
            try {
                if (table != null) {
                    SASLibrary library = LibraryUtil.getLibrary((DataTable)table.getTable(), null);
                    tableName = library != null ? library.getLibref() + "." + table.getSASTableName() : table.getSASTableName();
                    SharedDimensionStructurePanel.this.valuesList.add(tableName);
                } else {
                    SharedDimensionStructurePanel.this.valuesList.add("");
                }
                SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DimensionKey.txt"));
                OLAPColumn keyColumn = null;
                if (table != null) {
                    keyColumn = olapDimension.getDimensionKey();
                }
                if (keyColumn != null) {
                    SharedDimensionStructurePanel.this.valuesList.add(keyColumn.getSASColumnName());
                } else {
                    SharedDimensionStructurePanel.this.valuesList.add("");
                }
            }
            catch (MdException error) {
                MessageUtil.displayMetadataExceptionMessage((MdException)error, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.DimTableTrans.txt"));
            String value = "";
            LanguageSet languageModel = SharedDimensionStructurePanel.this.olapDim.getLanguageSet();
            List userSelectedCountries = languageModel.getSelectedLocales();
            if (userSelectedCountries != null) {
                Properties listOfCountries = languageModel.getCountries();
                for (int i = 0; i < userSelectedCountries.size(); ++i) {
                    String localeID = (String)userSelectedCountries.get(i);
                    String countryName = listOfCountries.getProperty(localeID.toUpperCase());
                    value = value + countryName;
                    if (i >= userSelectedCountries.size() - 1) continue;
                    value = value + ",";
                }
            }
            SharedDimensionStructurePanel.this.valuesList.add(value);
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.TableOptions.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(olapDimension.getTableOptions());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Hierarchies.txt"));
            OLAPList hierarchies = olapDimension.getHierarchies();
            String hierString = "[";
            int hierSize = hierarchies.size();
            for (int i = 0; i < hierSize; ++i) {
                OLAPHierarchy hier = (OLAPHierarchy)hierarchies.get(i);
                hierString = hierString + hier.getName();
                if (i >= hierSize - 1) continue;
                hierString = hierString + ",";
            }
            hierString = hierString + "]";
            SharedDimensionStructurePanel.this.valuesList.add(hierString);
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.DefaultHierarchy.txt"));
            OLAPHierarchy hier = olapDimension.getDefault();
            SharedDimensionStructurePanel.this.valuesList.add(hier.getName());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.Levels.txt"));
            OLAPList levels = olapDimension.getLevels();
            String levelString = "[";
            int levelsSize = levels.size();
            for (int i = 0; i < levelsSize; ++i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                levelString = levelString + level.getName();
                if (i >= levelsSize - 1) continue;
                levelString = levelString + ",";
            }
            levelString = levelString + "]";
            SharedDimensionStructurePanel.this.valuesList.add(levelString);
            ServerComponent server = olapDimension.getMapServer();
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.ESRIMapServer.txt"));
            try {
                if (server != null) {
                    SharedDimensionStructurePanel.this.valuesList.add(server.getName());
                } else {
                    SharedDimensionStructurePanel.this.valuesList.add("");
                }
                SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.ESRIMapService.txt"));
                TableCollection service = olapDimension.getMapService();
                if (service != null) {
                    SharedDimensionStructurePanel.this.valuesList.add(service.getName());
                } else {
                    SharedDimensionStructurePanel.this.valuesList.add("");
                }
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            String emptychar = olapDimension.getEmptyChar();
            String emptynum = olapDimension.getEmptyNum();
            if (emptychar != null && ModelUtilities.isBlank((String)emptychar)) {
                emptychar = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt");
            }
            if (emptynum != null && emptynum.equals(".")) {
                emptynum = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt");
            }
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.EmptyChar.control.label"));
            SharedDimensionStructurePanel.this.valuesList.add(emptychar);
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Dimension.EmptyNum.control.label"));
            SharedDimensionStructurePanel.this.valuesList.add(emptynum);
        }

        private void displayFolderInformation(DefaultMutableTreeNode node) {
            int numChildren = node.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                AbstractOLAPModel olapObj = (AbstractOLAPModel)child.getUserObject();
                SharedDimensionStructurePanel.this.namesList.add(olapObj.getName());
                SharedDimensionStructurePanel.this.valuesList.add(olapObj.getDesc());
            }
        }

        private void displayHierarchyInformation(Object currentObject) throws OLAPException {
            OLAPHierarchy hierarchy = (OLAPHierarchy)currentObject;
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Name.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(hierarchy.getName());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Default.txt"));
            OLAPDimension parentDim = hierarchy.getDimension();
            OLAPHierarchy defaultHier = parentDim.getDefault();
            if (hierarchy.equals(defaultHier)) {
                SharedDimensionStructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Hierarchy.IsDefault.Yes.txt"));
            } else {
                SharedDimensionStructurePanel.this.valuesList.add(bundle.getString("StructurePanel.Hierarchy.IsDefault.No.txt"));
            }
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Caption.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(hierarchy.getDesc());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Description.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(hierarchy.getNotes());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.Levels.txt"));
            OLAPList levels = hierarchy.getLevels();
            String levelString = "[";
            int levelsSize = levels.size();
            for (int i = 0; i < levelsSize; ++i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                levelString = levelString + level.getName();
                if (i >= levelsSize - 1) continue;
                levelString = levelString + ",";
            }
            levelString = levelString + "]";
            SharedDimensionStructurePanel.this.valuesList.add(levelString);
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Hierarchy.AllMember.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(hierarchy.getAllMember());
        }

        private void displayLevelInformation(Object currentObject) throws OLAPException {
            OLAPLevel level = (OLAPLevel)currentObject;
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Name.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(level.getName());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.InputColumn.txt"));
            OLAPColumn col = level.getColumn();
            if (col != null) {
                SharedDimensionStructurePanel.this.valuesList.add(col.getSASColumnName());
            } else {
                SharedDimensionStructurePanel.this.valuesList.add("");
            }
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Caption.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(level.getDesc());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Description.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(level.getNotes());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Type.txt"));
            int levelType = level.getType();
            String typeValue = "";
            switch (levelType) {
                case 16: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypeyear.txt");
                    break;
                }
                case 32: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypehalfyear.txt");
                    break;
                }
                case 64: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypequarters.txt");
                    break;
                }
                case 128: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypemonths.txt");
                    break;
                }
                case 256: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypeweeks.txt");
                    break;
                }
                case 512: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypedays.txt");
                    break;
                }
                case 1024: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypehours.txt");
                    break;
                }
                case 2048: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypeminutes.txt");
                    break;
                }
                case 4096: {
                    typeValue = bundle.getString("StructurePanel.Level.dimleveltypeseconds.txt");
                }
            }
            SharedDimensionStructurePanel.this.valuesList.add(typeValue);
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.SortOrder.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(level.getSortOrder());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.IgnoreMissing.control.label"));
            String ignore = level.getIgnoreEmpty();
            String empty = level.getEmpty();
            if (ignore != null) {
                if (ignore.equals("1")) {
                    SharedDimensionStructurePanel.this.valuesList.add(bundle.getString("Common.true.txt"));
                }
            } else {
                SharedDimensionStructurePanel.this.valuesList.add(bundle.getString("Common.false.txt"));
                if (col != null) {
                    String dimIgnoreEmpty;
                    String typeOfColumn = level.getColumn().getSASColumnType();
                    if (empty != null) {
                        if (typeOfColumn.equals("C") && ModelUtilities.isBlank((String)empty)) {
                            empty = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt");
                        } else if (typeOfColumn.equals("N") && empty.equals(".")) {
                            empty = bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt");
                        }
                    } else if (typeOfColumn.equals("C")) {
                        String dimEmptyChar = SharedDimensionStructurePanel.this.olapDim.getEmptyChar();
                        if (dimEmptyChar != null && ModelUtilities.isBlank((String)dimEmptyChar)) {
                            empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt"));
                        } else if (dimEmptyChar != null) {
                            empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)dimEmptyChar);
                        } else if (dimEmptyChar == null) {
                            dimIgnoreEmpty = SharedDimensionStructurePanel.this.olapDim.getIgnoreEmpty();
                            if (dimIgnoreEmpty != null && dimIgnoreEmpty.equals("1")) {
                                empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.NotSpecified.txt"));
                            }
                        } else {
                            String cubeEmptyChar = SharedDimensionStructurePanel.this.olapDim.getEmptyChar();
                            empty = cubeEmptyChar != null && ModelUtilities.isBlank((String)cubeEmptyChar) ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Blank.txt")) : (cubeEmptyChar != null ? bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)cubeEmptyChar) : bundle.getString("StructurePanel.NotSpecified.txt"));
                        }
                    } else {
                        String dimEmptyNum = SharedDimensionStructurePanel.this.olapDim.getEmptyNum();
                        if (dimEmptyNum != null && dimEmptyNum.equals(".")) {
                            empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.Dimension.MissingMemberValues.Period.txt"));
                        } else if (dimEmptyNum != null) {
                            empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)dimEmptyNum);
                        } else if (dimEmptyNum == null && (dimIgnoreEmpty = SharedDimensionStructurePanel.this.olapDim.getIgnoreEmpty()) != null && dimIgnoreEmpty.equals("1")) {
                            empty = bundle.formatString("StructurePanel.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("StructurePanel.NotSpecified.txt"));
                        }
                    }
                }
            }
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.MissingMember.control.label"));
            SharedDimensionStructurePanel.this.valuesList.add(empty);
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.Format.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(level.getFormat());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.MapLayer.txt"));
            OLAPColumn column = level.getMapLayer();
            if (column != null) {
                SharedDimensionStructurePanel.this.valuesList.add(column.getSASColumnName());
            } else {
                SharedDimensionStructurePanel.this.valuesList.add("");
            }
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.Level.MapFieldId.txt"));
            Property fieldId = level.getMapFieldId();
            try {
                if (fieldId != null) {
                    SharedDimensionStructurePanel.this.valuesList.add(fieldId.getName());
                } else {
                    SharedDimensionStructurePanel.this.valuesList.add("");
                }
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
        }

        private void displayMemberPropertyInformation(Object currentObject) throws OLAPException {
            OLAPMemberProperty property = (OLAPMemberProperty)currentObject;
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Name.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(property.getName());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Caption.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(property.getDesc());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Description.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(property.getNotes());
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.InputColumn.txt"));
            OLAPColumn column = property.getColumn();
            if (column != null) {
                SharedDimensionStructurePanel.this.valuesList.add(column.getSASColumnName());
            } else {
                SharedDimensionStructurePanel.this.valuesList.add("");
            }
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Level.txt"));
            OLAPLevel level = property.getAssociatedLevel();
            if (level != null) {
                SharedDimensionStructurePanel.this.valuesList.add(level.getName());
            } else {
                SharedDimensionStructurePanel.this.valuesList.add("");
            }
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Hierarchy.txt"));
            OLAPList hierarchies = property.getHierarchies();
            String value = "[";
            int hierSize = hierarchies.size();
            for (int i = 0; i < hierSize; ++i) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(i);
                value = value + hierarchy.getName();
                if (i >= hierSize - 1) continue;
                value = value + ",";
            }
            value = value + "]";
            SharedDimensionStructurePanel.this.valuesList.add(value);
            SharedDimensionStructurePanel.this.namesList.add(bundle.getString("StructurePanel.MemberProperty.Format.txt"));
            SharedDimensionStructurePanel.this.valuesList.add(property.getSASFormat());
        }
    }
}

