/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.properties;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.actions.PropertiesAction;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class SharedDimensionPropertiesOptionsPanel
extends WAPanel {
    private static final long serialVersionUID = 889413885433470942L;
    protected static WAdminResource bundle = new WAdminResource(SharedDimensionPropertiesOptionsPanel.class);
    private JLabel schemaLabel;
    private WATextField schemaValue;
    private JLabel pathLabel;
    private WATextField pathValue;
    private String schemaName;
    private String path;
    private WAPanel inputPanel;
    private JLabel tableLibraryLabel;
    private WATextField tableLibraryValue;
    private JLabel inputTableLabel;
    private WATextField inputTableValue;
    private JButton propertiesButton;
    private JLabel optionsLabel;
    private WATextArea optionsValue;
    private WATextArea dimFolderField;
    private ActionListener tablePropertiesListener;
    private OLAPSharedDimension olapDim;
    private SharedDimensionTable table;
    private String tableName;
    private String libraryName;
    private String tableOptions;
    private String dimFolder;

    public SharedDimensionPropertiesOptionsPanel(OLAPSharedDimension dim) {
        this.olapDim = dim;
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.schemaLabel = new JLabel(bundle.getString("Properties.Location.OLAPSchema.txt"));
        this.schemaValue = new WATextField();
        this.schemaLabel.setLabelFor((Component)this.schemaValue);
        this.pathLabel = new JLabel(bundle.getString("Properties.Location.SharedDimensionPath.txt"));
        this.pathValue = new WATextField();
        this.pathLabel.setLabelFor((Component)this.pathValue);
        this.dimFolderField = new WATextArea();
        JLabel l = new JLabel();
        this.dimFolderField.setFont(l.getFont());
        this.dimFolderField.setBehavior(1);
        this.dimFolderField.setBackground((Color)SystemColor.control);
        this.dimFolderField.setAutosize(true);
        this.inputPanel = new WAPanel();
        this.inputPanel.setLayout((LayoutManager)new GridBagLayout());
        this.inputPanel.setEditable(false);
        this.inputPanel.setBorder((Border)BorderFactory.createTitledBorder(bundle.getString("Properties.Input.InputTitleBorder.txt")));
        this.tableLibraryLabel = new JLabel(bundle.getString("Properties.Input.Library.txt"));
        this.inputTableLabel = new JLabel(bundle.getString("Properties.Input.Table.txt"));
        this.tableLibraryValue = new WATextField();
        this.tableLibraryLabel.setLabelFor((Component)this.tableLibraryValue);
        this.inputTableValue = new WATextField();
        this.inputTableLabel.setLabelFor((Component)this.inputTableValue);
        this.optionsLabel = new JLabel(bundle.getString("Properties.Input.TableOptions.txt"));
        this.optionsValue = new WATextArea();
        this.optionsValue.setFont(l.getFont());
        JScrollPane optionsScrollPane = new JScrollPane((Component)this.optionsValue);
        this.optionsLabel.setLabelFor((Component)this.optionsValue);
        this.optionsValue.setBehavior(2);
        this.propertiesButton = new JButton();
        this.propertiesButton.setEnabled(false);
        VisualUtilities.setButtonTextAndMnemonic(this.propertiesButton, bundle.getString("Properties.Input.Properties.txt"));
        this.tablePropertiesListener = new cTablePropertiesListener();
        this.propertiesButton.addActionListener(this.tablePropertiesListener);
        this.setEditable(false);
        WAPanel locationPanel = new WAPanel();
        locationPanel.setLayout((LayoutManager)new GridBagLayout());
        locationPanel.setBorder((Border)BorderFactory.createTitledBorder(bundle.getString("Properties.SharedDim.Options.StoragePanel.txt")));
        locationPanel.add((Component)this.schemaLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        locationPanel.add((Component)this.schemaValue, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
        locationPanel.add((Component)this.pathLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        locationPanel.add((Component)this.pathValue, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        locationPanel.add((Component)this.dimFolderField, (Object)new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)locationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.inputPanel.add((Component)this.tableLibraryLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.tableLibraryValue, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.inputPanel.add((Component)this.inputTableLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.inputTableValue, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.inputPanel.add((Component)this.propertiesButton, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.inputPanel.add((Component)this.optionsLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.inputPanel.add((Component)optionsScrollPane, (Object)new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.inputPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
        JLabel dummy = new JLabel("  ");
        this.add(dummy, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.schemaValue.setEditable(bEditable);
        this.pathValue.setEditable(bEditable);
        this.inputTableValue.setEditable(bEditable);
        this.tableLibraryValue.setEditable(bEditable);
        this.optionsValue.setEditable(bEditable);
        this.optionsValue.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.schemaValue.setText(this.schemaName);
        this.pathValue.setText(this.path);
        if (this.olapDim.physicallyExists()) {
            this.dimFolderField.setText(bundle.formatString("Properties.Location.DimFolderExists.fmt.txt", (Object)this.dimFolder, (Object)this.path));
        } else {
            this.dimFolderField.setText(bundle.getString("Properties.Location.DimFolderNotExist.txt"));
        }
        this.inputTableValue.setText(this.tableName);
        this.tableLibraryValue.setText(this.libraryName);
        this.optionsValue.setText(this.tableOptions);
    }

    public void populateStore() throws MdException, RemoteException {
        try {
            OLAPSchema olapSchema = this.olapDim.getAssociatedOLAPSchema();
            if (olapSchema != null) {
                this.schemaName = olapSchema.getName();
            }
            this.path = this.olapDim.getPath();
            this.table = this.olapDim.getSharedDimensionTable();
            SASLibrary library = null;
            if (this.table != null) {
                this.tableName = this.table.toString();
                library = this.table.getSASLibrary();
                this.propertiesButton.setEnabled(true);
            }
            if (library != null) {
                this.libraryName = library.getName();
            }
            this.tableOptions = this.olapDim.getTableOptions();
            this.dimFolder = this.olapDim.getDimFolder();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    protected class cTablePropertiesListener
    implements ActionListener {
        protected cTablePropertiesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PhysicalTable phystable = SharedDimensionPropertiesOptionsPanel.this.table.getTable();
            try {
                SimpleObjectImpl obj = new SimpleObjectImpl(phystable.getName(), phystable.getFQID(), phystable.getCMetadataType(), phystable.getPublicType());
                PropertiesAction.showTablePropertySheet((Window)Workspace.getWorkspace(), (SimpleObject)obj, false);
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
        }
    }
}

