/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.properties;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.Tree;
import com.sas.util.Comparator;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class SharedDimensionCubesTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private SharedDimension currentSharedDimension;
    private WsTable cubesTable;
    private CubesTableModel cubesModel;
    private static final WAdminResource bundle = new WAdminResource(SharedDimensionCubesTab.class);

    public SharedDimensionCubesTab(CMetadata sharedDimension) {
        this.currentSharedDimension = (SharedDimension)sharedDimension;
        this.setHelpProduct("shared");
        this.setHelpTopic("prop_shared_cubes");
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            AssociationList cubesList = null;
            try {
                cubesList = this.currentSharedDimension.getCubes();
                Collections.sort(cubesList, new ComparableCube());
                this.cubesModel.setCubes((List)cubesList);
                this.cubesModel.moveDataToModel();
            }
            catch (MdException MdError) {
                MessageUtil.displayMetadataExceptionMessage((MdException)MdError, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return true;
    }

    private void _layoutWidgets() {
        this.cubesModel = new CubesTableModel();
        this.cubesTable = new WsTable((WsAbstractTableModel)this.cubesModel);
        JLabel nameLabel = new JLabel(bundle.getString("SharedDimensionCubesTab.cubes.label"));
        JScrollPane cubesView = new JScrollPane((Component)this.cubesTable);
        this.setLayout(new GridBagLayout());
        this.add(nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(cubesView, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private class CubesTableModel
    extends WsAbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int TOTAL_COLS = 3;
        private static final int TOTAL_HIDDEN_COLS = 0;
        private static final int NAME = 0;
        private static final int LOCATION = 1;
        private static final int SCHEMA = 2;
        List cubes;

        public CubesTableModel() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("SharedDimensionCubes.name.txt"), 150, 100);
            this.m_aColumns[0].setEditable(false);
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("SharedDimensionCubes.location.txt"), 250, 256);
            this.m_aColumns[1].setEditable(false);
            this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("SharedDimensionCubes.olapschema.txt"), 150, 100);
            this.m_aColumns[2].setEditable(false);
        }

        public int getColumnCount() {
            return 3;
        }

        public int getHiddenColumnCount() {
            return 0;
        }

        public void populateStore() throws MdException, RemoteException {
        }

        public void setCubes(List cubesList) {
            this.cubes = cubesList;
        }

        public void moveDataToModel() throws MdException, RemoteException {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            nRows = this.cubes.size();
            for (int i = 0; i < nRows; ++i) {
                Cube cube = (Cube)this.cubes.get(i);
                ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
                alRow.add(0, cube.getName());
                AssociationList trees = cube.getTrees();
                if (trees != null) {
                    Tree oTree = (Tree)cube.getTrees().get(0);
                    String sPath = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)oTree.getObjectStore(), (PrimaryType)oTree, false);
                    alRow.add(1, sPath);
                }
                alRow.add(2, cube.getAssociatedOLAPSchema().getName());
                this.m_lData.add(alRow);
            }
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }
    }

    public class ComparableCube
    implements Comparator {
        private String name;

        public String toString() {
            return this.name;
        }

        public int compare(Object first, Object second) {
            return first.toString().compareToIgnoreCase(second.toString());
        }
    }
}

