/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.properties;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.properties.GenerationsTableModel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class GenerationPropertyPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(GenerationPropertyPanel.class);
    private WsTable generationTable;
    private GenerationsTableModel generationModel;
    private OLAPCube olapCube;

    public GenerationPropertyPanel(OLAPCube olapcube) {
        this.olapCube = olapcube;
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.generationModel = new GenerationsTableModel(this.olapCube.getName());
        this.generationTable = new WsTable((WsAbstractTableModel)this.generationModel);
        JLabel cubeNameLabel = new JLabel(bundle.formatString("GenerationsPanel.SelectedCube.control.label", (Object)this.olapCube.getName()));
        JScrollPane generationView = new JScrollPane((Component)this.generationTable);
        generationView.setPreferredSize(new Dimension(550, 350));
        generationView.setMinimumSize(new Dimension(100, 100));
        this.generationTable.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.generationTable.setAutoResizeMode(0);
        this.generationTable.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.generationTable.setEditableCellBackground(UIManager.getColor("TextField.background"));
        this.generationTable.setRowHeaderVisible(true);
        this.generationTable.setRowHoldingEnabled(false);
        this.generationTable.setColumnHidingEnabled(false);
        this.generationTable.setColumnHoldingEnabled(false);
        this.generationTable.setColumnsReorderable(true);
        this.generationTable.setSortingEnabled(true);
        this.generationTable.setRowSelectionAllowed(true);
        this.generationTable.setCellSelectionEnabled(false);
        this.add(cubeNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(generationView, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        try {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                List listOfGenerations = this.olapCube.getGenerations();
                ArrayList<String> namesList = new ArrayList<String>();
                ArrayList<String> descriptionList = new ArrayList<String>();
                ArrayList<String> createdList = new ArrayList<String>();
                ArrayList<String> modifiedList = new ArrayList<String>();
                ArrayList<String> listOfRacks = new ArrayList<String>();
                int size = listOfGenerations.size();
                for (int i = 0; i < size; ++i) {
                    Cube cube = (Cube)listOfGenerations.get(i);
                    namesList.add(cube.getName());
                    descriptionList.add(cube.getDesc());
                    listOfRacks.add(ModelUtilities.getRackCountForCube((Cube)cube));
                    createdList.add(cube.getMetadataCreated());
                    modifiedList.add(cube.getMetadataUpdated());
                }
                this.generationModel.setLists(namesList, descriptionList, listOfRacks, createdList, modifiedList);
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }
}

