/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.OLAPDualListSelector;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class SortingPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(SortingPanel.class);
    static int UPDATE_ALWAYS = 1;
    static int UPDATE_NEVER = 0;
    static int UPDATE_SOMETIMES = 2;
    static int BIG5HAN = 0;
    static int DIRECT = 1;
    static int GB2132HAN = 2;
    static int PHONEBOOK = 3;
    static int PINYIN = 4;
    static int POSIX = 5;
    static int STROKE = 6;
    static int TRADITIONAL = 7;
    static int localeIndex;
    protected List dimensions;
    protected WsAbstractAction addAction;
    protected WsAbstractAction deleteAction;
    protected WsAbstractAction addMemberPropertyAction;
    protected WsAbstractAction modifyAction;
    protected WsAbstractAction renameAction;
    protected WsAbstractAction sharedDimAction;
    public JCheckBox skipMissingChar;
    public JCheckBox skipMissingNum;
    private OLAPCube cubeModel;
    private WAComboBox dropDownCollation;
    private WAComboBox dropDownLocale;
    protected OLAPDualListSelector listbox;
    protected CollectionToListModelAdapter availModel;
    protected DefaultListModel selectModel;
    protected LanguageSet languageModel;
    protected Properties listOfCountries;
    protected List userSelectedCountries;
    protected boolean saveToCubeModel;
    private String originalLocale;
    private String locale;
    private String collation;
    private String originalCollation;
    private boolean isCube;
    private OLAPSharedDimension sharedDimension;

    public SortingPanel(AbstractOLAPModel inputObject) {
        if (inputObject instanceof OLAPCube) {
            this.cubeModel = (OLAPCube)inputObject;
            this.isCube = true;
        } else {
            this.sharedDimension = (OLAPSharedDimension)inputObject;
        }
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
        this.initialize();
    }

    public boolean validateData() {
        try {
            String currentLocale;
            OLAPList listOfShared = null;
            String currentCollation = (String)this.dropDownCollation.getSelectedItem();
            if (currentCollation.equals(bundle.getString("Common.Default.Item.txt"))) {
                currentCollation = null;
            }
            if ((currentLocale = (String)this.dropDownLocale.getSelectedItem()).equals(bundle.getString("Common.Default.Item.txt"))) {
                currentLocale = null;
            }
            String countryCode = this.languageModel.getLocale(currentLocale);
            if (this.isCube) {
                listOfShared = this.cubeModel.getDimensionSet().getSharedDimensions();
            }
            if (this.originalCollation != null && !this.originalCollation.equalsIgnoreCase(currentCollation) || this.originalLocale != null && !this.originalLocale.equalsIgnoreCase(countryCode) || this.originalCollation == null && currentCollation != null || this.originalLocale == null && currentLocale != null) {
                int choice;
                boolean checkPhysicalCubes;
                if (this.isCube && !listOfShared.isEmpty()) {
                    int choice2 = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.SortingTab.ChangeValuesCube.warning.txt"), (int)1, (int)0);
                    if (choice2 == 1) {
                        return false;
                    }
                    int size = listOfShared.size();
                    for (int i = 0; i < size; ++i) {
                        OLAPSharedDimension dimension = (OLAPSharedDimension)listOfShared.get(i);
                        String dimCollation = dimension.getCollation();
                        String dimLocale = dimension.getLocale();
                        if (!(dimCollation != null && !dimCollation.equalsIgnoreCase(currentCollation) || dimLocale != null && !dimLocale.equalsIgnoreCase(countryCode) || dimCollation == null && currentCollation != null) && (dimLocale != null || currentLocale == null)) continue;
                        dimension.deleteFromCube();
                    }
                } else if (!this.isCube && (checkPhysicalCubes = this.sharedDimension.isPhysicalAndMetadataCubesExist()) && (choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.SortingTab.ChangeValuesDimension.warning.txt"), (int)1, (int)0)) == 1) {
                    return false;
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    public void saveDataToCubeModel() {
        try {
            String currentLocale;
            String currentCollation = (String)this.dropDownCollation.getSelectedItem();
            if (currentCollation.equals(bundle.getString("Common.Default.Item.txt"))) {
                currentCollation = null;
            }
            if ((currentLocale = (String)this.dropDownLocale.getSelectedItem()).equals(bundle.getString("Common.Default.Item.txt"))) {
                currentLocale = null;
            }
            String countryCode = this.languageModel.getLocale(currentLocale);
            if (this.isCube) {
                this.cubeModel.setCollation(currentCollation);
                if (currentLocale != null) {
                    this.cubeModel.setLocale(countryCode);
                } else {
                    this.cubeModel.setLocale(currentLocale);
                }
            } else {
                this.sharedDimension.setCollation(currentCollation);
                if (currentLocale != null) {
                    this.sharedDimension.setLocale(countryCode);
                } else {
                    this.sharedDimension.setLocale(currentLocale);
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    protected void initialize() {
        try {
            Object[] collationItems = new String[]{"BIG5HAN", "DIRECT", "GB2132HAN", "PHONEBOOK", "PINYIN", "POSIX", "STROKE", "TRADITIONAL"};
            this.dropDownCollation.addItem((Object)bundle.getString("Common.Default.Item.txt"));
            this.dropDownCollation.addItems(collationItems);
            this.collation = this.isCube ? this.cubeModel.getCollation() : this.sharedDimension.getCollation();
            this.originalCollation = this.collation;
            if (this.collation != null) {
                this.dropDownCollation.setSelectedItem((Object)this.collation);
            }
            this.languageModel = this.isCube ? this.cubeModel.getLanguageSet() : this.sharedDimension.getLanguageSet();
            this.userSelectedCountries = this.languageModel.getSelectedLocales();
            Properties countryList = this.languageModel.getCountries();
            ArrayList sortedList = new ArrayList();
            TreeSet<String> available = new TreeSet<String>((Comparator<String>)SASCollatorFactory.createCollator());
            for (String string : countryList.keySet()) {
                String countryName = countryList.getProperty(string.toUpperCase());
                available.add(countryName);
            }
            sortedList.addAll(available);
            this.dropDownLocale.addItem((Object)bundle.getString("Common.Default.Item.txt"));
            this.dropDownLocale.addItems(sortedList);
            this.locale = this.isCube ? this.cubeModel.getLocale() : this.sharedDimension.getLocale();
            if (this.locale != null) {
                String displayedLocale = this.languageModel.getCountry(this.locale);
                this.dropDownLocale.setSelectedItem((Object)displayedLocale);
                this.originalLocale = this.locale;
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    private void _layoutWidgets() {
        Dimension comboboxSize = new Dimension(180, 20);
        JLabel collationType = new JLabel(bundle.getString("CubeDesigner.SortingTab.collation.control.label"));
        this.add(collationType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.dropDownCollation = new WAComboBox();
        this.add((Component)this.dropDownCollation, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        JLabel Locale2 = new JLabel(bundle.getString("CubeDesigner.SortingTab.locale.control.label"));
        this.add(Locale2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.dropDownLocale = new WAComboBox();
        this.dropDownLocale.setPreferredSize(comboboxSize);
        this.add((Component)this.dropDownLocale, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
    }

    public void onCancel() {
        if (this.userSelectedCountries == null || this.userSelectedCountries.size() < 1) {
            this.languageModel = null;
        }
    }
}

