/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.MapLoadTableOLAPMemberPropertiesTableModel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;

public class MapLoadTableOLAPMemberPropertiesPanel
extends WAPropertyTab
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(MapLoadTableOLAPMemberPropertiesPanel.class);
    private WsTable detailsTable;
    private MapLoadTableOLAPMemberPropertiesTableModel tableModel;
    private OLAPMemberPropertySet propertySet;
    private PhysicalTable mappedTable;
    private boolean initialized;

    public MapLoadTableOLAPMemberPropertiesPanel(OLAPMemberPropertySet inputPropertySet, PhysicalTable inputMappedTable) {
        this.propertySet = inputPropertySet;
        this.mappedTable = inputMappedTable;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
        this.initialized = false;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.initialize();
        }
        return true;
    }

    protected void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.detailsTable.getModel().addTableModelListener(this);
        }
        this.tableModel.populateStore();
        this.tableModel.moveDataToModel();
        if (this.tableModel.getRowCount() > 0) {
            this.detailsTable.selectCell(0, 0);
        }
    }

    protected void layoutWidgets() {
        try {
            this.tableModel = new MapLoadTableOLAPMemberPropertiesTableModel(this.propertySet, this.mappedTable);
            this.detailsTable = new WsTable((WsAbstractTableModel)this.tableModel);
            this.detailsTable.setSortingEnabled(false);
            this.detailsTable.setColumnHidingEnabled(false);
            this.detailsTable.setColumnsReorderable(false);
            this.detailsTable.setRowHoldingEnabled(false);
            this.detailsTable.setColumnHeaderPopupMenuEnabled(false);
            this.detailsTable.setOriginPopupMenuEnabled(false);
            this.detailsTable.setPopupMenuEnabled(false);
            this.detailsTable.setRowHeaderPopupMenuEnabled(false);
            this.detailsTable.setTablePopupMenuEnabled(false);
            this.detailsTable.setViewportPopupMenuEnabled(false);
            this.detailsTable.setToolTipText(bundle.getString("MapLoadTable.MemberPropertiesDetail.TableToolTip.txt"));
            this.detailsTable.setName("MeasuresDetailTable");
            this.detailsTable.setAutoResizeMode(0);
            JScrollPane topPanel = new JScrollPane((Component)this.detailsTable);
            topPanel.setPreferredSize(new Dimension(500, 200));
            this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
    }

    public boolean validateData() {
        TableCellEditor cellEditor = this.detailsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        return true;
    }

    public void onBack() {
        TableCellEditor cellEditor = this.detailsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    public void onNext() {
        TableCellEditor cellEditor = this.detailsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    void saveToModel() {
        for (int i = this.tableModel.getRowCount() - 1; i >= 0; --i) {
            OLAPMemberProperty property = (OLAPMemberProperty)this.tableModel.getValueAt(i, 0);
            String columnName = (String)this.tableModel.getValueAt(i, 1);
            Column column = null;
            if (!ModelUtilities.isBlank((String)columnName)) {
                column = this.tableModel.getColumn(columnName);
            }
            if (column == null) continue;
            OLAPCube owningCube = this.propertySet.getOwningCube();
            if (owningCube != null) {
                TableSet tableSet = owningCube.getTableSet();
                try {
                    LoadTable loadTable = tableSet.getLoadTable();
                    loadTable.mapOLAPMemberProperty(property, column);
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                continue;
            }
            OLAPSharedDimension dim = this.propertySet.getOwningSharedDimension();
            if (dim == null) continue;
            this.propertySet.mapMemberProperty(property, column);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }
}

